/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PaginationMeta
 */
@JsonPropertyOrder({
  PaginationMeta.JSON_PROPERTY_AFTER,
  PaginationMeta.JSON_PROPERTY_BEFORE,
  PaginationMeta.JSON_PROPERTY_LIMIT
})
@JsonTypeName("Pagination_Meta")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-08-28T15:28:04.834937+07:00[Asia/Bangkok]")
public class PaginationMeta {
  public static final String JSON_PROPERTY_AFTER = "after";
  private JsonNullable<String> after = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_BEFORE = "before";
  private JsonNullable<String> before = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LIMIT = "limit";
  private JsonNullable<Integer> limit = JsonNullable.<Integer>of(50);

  public PaginationMeta() { 
  }

  public PaginationMeta after(String after) {
    this.after = JsonNullable.<String>of(after);
    
    return this;
  }

   /**
   * &#x60;after&#x60; is a cursor used to identify the next page of results. If &#x60;meta.after&#x60; is null, then there are no more results to see.
   * @return after
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "g2wAAAACbQAAABBBZXJvbWlzdC1LaGFya2l2bQAAAB=", value = "`after` is a cursor used to identify the next page of results. If `meta.after` is null, then there are no more results to see.")
  @JsonIgnore

  public String getAfter() {
        return after.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getAfter_JsonNullable() {
    return after;
  }
  
  @JsonProperty(JSON_PROPERTY_AFTER)
  public void setAfter_JsonNullable(JsonNullable<String> after) {
    this.after = after;
  }

  public void setAfter(String after) {
    this.after = JsonNullable.<String>of(after);
  }


  public PaginationMeta before(String before) {
    this.before = JsonNullable.<String>of(before);
    
    return this;
  }

   /**
   * &#x60;before&#x60; is a cursor used to identify the previous page of results.
   * @return before
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "`before` is a cursor used to identify the previous page of results.")
  @JsonIgnore

  public String getBefore() {
        return before.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getBefore_JsonNullable() {
    return before;
  }
  
  @JsonProperty(JSON_PROPERTY_BEFORE)
  public void setBefore_JsonNullable(JsonNullable<String> before) {
    this.before = before;
  }

  public void setBefore(String before) {
    this.before = JsonNullable.<String>of(before);
  }


  public PaginationMeta limit(Integer limit) {
    this.limit = JsonNullable.<Integer>of(limit);
    
    return this;
  }

   /**
   * The limit of entries returned on each page.
   * minimum: 1
   * maximum: 200
   * @return limit
  **/
  @javax.annotation.Nullable
 @Min(1) @Max(200)  @ApiModelProperty(example = "50", value = "The limit of entries returned on each page.")
  @JsonIgnore

  public Integer getLimit() {
        return limit.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Integer> getLimit_JsonNullable() {
    return limit;
  }
  
  @JsonProperty(JSON_PROPERTY_LIMIT)
  public void setLimit_JsonNullable(JsonNullable<Integer> limit) {
    this.limit = limit;
  }

  public void setLimit(Integer limit) {
    this.limit = JsonNullable.<Integer>of(limit);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaginationMeta paginationMeta = (PaginationMeta) o;
    return equalsNullable(this.after, paginationMeta.after) &&
        equalsNullable(this.before, paginationMeta.before) &&
        equalsNullable(this.limit, paginationMeta.limit);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(after), hashCodeNullable(before), hashCodeNullable(limit));
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaginationMeta {\n");
    sb.append("    after: ").append(toIndentedString(after)).append("\n");
    sb.append("    before: ").append(toIndentedString(before)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

