/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata about a city. This will only be provided where the `type` is `city`.")
@JsonPropertyOrder(value={"iata_code", "iata_country_code", "id", "name"})
@JsonTypeName(value="City_2")
public class City2 {
    public static final String JSON_PROPERTY_IATA_CODE = "iata_code";
    private String iataCode;
    public static final String JSON_PROPERTY_IATA_COUNTRY_CODE = "iata_country_code";
    private String iataCountryCode;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public City2 iataCode(String iataCode) {
        this.iataCode = iataCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="NYC", value="The three-character IATA code for the city")
    @JsonProperty(value="iata_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIataCode() {
        return this.iataCode;
    }

    @JsonProperty(value="iata_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIataCode(String iataCode) {
        this.iataCode = iataCode;
    }

    public City2 iataCountryCode(String iataCountryCode) {
        this.iataCountryCode = iataCountryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", value="The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code for the country where the city is located")
    @JsonProperty(value="iata_country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIataCountryCode() {
        return this.iataCountryCode;
    }

    @JsonProperty(value="iata_country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIataCountryCode(String iataCountryCode) {
        this.iataCountryCode = iataCountryCode;
    }

    public City2 id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="cit_nyc_us", value="Duffel's unique identifier for the city")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public City2 name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="New York", value="The name of the city")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        City2 city2 = (City2)o;
        return Objects.equals(this.iataCode, city2.iataCode) && Objects.equals(this.iataCountryCode, city2.iataCountryCode) && Objects.equals(this.id, city2.id) && Objects.equals(this.name, city2.name);
    }

    public int hashCode() {
        return Objects.hash(this.iataCode, this.iataCountryCode, this.id, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class City2 {\n");
        sb.append("    iataCode: ").append(this.toIndentedString(this.iataCode)).append("\n");
        sb.append("    iataCountryCode: ").append(this.toIndentedString(this.iataCountryCode)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

