/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.LoyaltyProgrammeAccount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(description="A passenger specified by their age")
@JsonPropertyOrder(value={"age", "family_name", "given_name", "loyalty_programme_accounts"})
@JsonTypeName(value="Offer_Request_Body_Passenger_With_Age")
public class OfferRequestBodyPassengerWithAge {
    public static final String JSON_PROPERTY_AGE = "age";
    private Integer age;
    public static final String JSON_PROPERTY_FAMILY_NAME = "family_name";
    private String familyName;
    public static final String JSON_PROPERTY_GIVEN_NAME = "given_name";
    private String givenName;
    public static final String JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS = "loyalty_programme_accounts";
    private List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts = null;

    public OfferRequestBodyPassengerWithAge age(Integer age) {
        this.age = age;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @Max(value=130L)
    @ApiModelProperty(example="14", required=true, value="The age of the passenger on the `departure_date` of the final slice. e.g. if you a searching for a round trip and the passenger is 15 years old at the time of the outbound flight, but they then have their birthday and are 16 years old for the inbound flight, you must set the age to 16. You should specify an `age` for passengers who are under 18 years old. A passenger can have only a type or an age, but not both.")
    @JsonProperty(value="age")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) @Max(value=130L) Integer getAge() {
        return this.age;
    }

    @JsonProperty(value="age")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAge(Integer age) {
        this.age = age;
    }

    public OfferRequestBodyPassengerWithAge familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Earhart", value="The passenger's family name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `\u00c6`, `\u00e6`, `\u0132`, `\u0133`, `\u0152`, `\u0153`, `\u00de`, and `\u00f0`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
    @JsonProperty(value="family_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFamilyName() {
        return this.familyName;
    }

    @JsonProperty(value="family_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public OfferRequestBodyPassengerWithAge givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Amelia", value="The passenger's given name. Only `space`, `-`, `'`, and letters from the [`ASCII`](https://www.unicode.org/charts/PDF/U0000.pdf), [`Latin-1 Supplement`](https://www.unicode.org/charts/PDF/U0080.pdf) and [`Latin Extended-A`](https://www.unicode.org/charts/PDF/U0100.pdf) (with the exceptions of `\u00c6`, `\u00e6`, `\u0132`, `\u0133`, `\u0152`, `\u0153`, `\u00de`, and `\u00f0`) Unicode charts are accepted. All other characters will result in a validation error. The minimum length is 1 character, and the maximum is 20 characters.  This is only required if you're also including __Loyalty Programme Accounts__. ")
    @JsonProperty(value="given_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGivenName() {
        return this.givenName;
    }

    @JsonProperty(value="given_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public OfferRequestBodyPassengerWithAge loyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
        this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
        return this;
    }

    public OfferRequestBodyPassengerWithAge addLoyaltyProgrammeAccountsItem(LoyaltyProgrammeAccount loyaltyProgrammeAccountsItem) {
        if (this.loyaltyProgrammeAccounts == null) {
            this.loyaltyProgrammeAccounts = new ArrayList<LoyaltyProgrammeAccount>();
        }
        this.loyaltyProgrammeAccounts.add(loyaltyProgrammeAccountsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The __Loyalty Programme Accounts__ for this passenger")
    @JsonProperty(value="loyalty_programme_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LoyaltyProgrammeAccount> getLoyaltyProgrammeAccounts() {
        return this.loyaltyProgrammeAccounts;
    }

    @JsonProperty(value="loyalty_programme_accounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLoyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
        this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRequestBodyPassengerWithAge offerRequestBodyPassengerWithAge = (OfferRequestBodyPassengerWithAge)o;
        return Objects.equals(this.age, offerRequestBodyPassengerWithAge.age) && Objects.equals(this.familyName, offerRequestBodyPassengerWithAge.familyName) && Objects.equals(this.givenName, offerRequestBodyPassengerWithAge.givenName) && Objects.equals(this.loyaltyProgrammeAccounts, offerRequestBodyPassengerWithAge.loyaltyProgrammeAccounts);
    }

    public int hashCode() {
        return Objects.hash(this.age, this.familyName, this.givenName, this.loyaltyProgrammeAccounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferRequestBodyPassengerWithAge {\n");
        sb.append("    age: ").append(this.toIndentedString(this.age)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    loyaltyProgrammeAccounts: ").append(this.toIndentedString(this.loyaltyProgrammeAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

