/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OfferRequestSliceDestination;
import com.duffel.sdk.model.OfferRequestSliceOrigin;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"departure_date", "destination", "destination_type", "origin", "origin_type"})
@JsonTypeName(value="Offer_Request_Slice")
public class OfferRequestSlice {
    public static final String JSON_PROPERTY_DEPARTURE_DATE = "departure_date";
    private LocalDate departureDate;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private OfferRequestSliceDestination destination;
    public static final String JSON_PROPERTY_DESTINATION_TYPE = "destination_type";
    private DestinationTypeEnum destinationType;
    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private OfferRequestSliceOrigin origin;
    public static final String JSON_PROPERTY_ORIGIN_TYPE = "origin_type";
    private OriginTypeEnum originType;

    public OfferRequestSlice departureDate(LocalDate departureDate) {
        this.departureDate = departureDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Apr 24 07:00:00 ICT 2020", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the passengers want to depart")
    @JsonProperty(value="departure_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDepartureDate() {
        return this.departureDate;
    }

    @JsonProperty(value="departure_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDepartureDate(LocalDate departureDate) {
        this.departureDate = departureDate;
    }

    public OfferRequestSlice destination(OfferRequestSliceDestination destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferRequestSliceDestination getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestination(OfferRequestSliceDestination destination) {
        this.destination = destination;
    }

    public OfferRequestSlice destinationType(DestinationTypeEnum destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="airport", value="The type of the destination")
    @JsonProperty(value="destination_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DestinationTypeEnum getDestinationType() {
        return this.destinationType;
    }

    @JsonProperty(value="destination_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationType(DestinationTypeEnum destinationType) {
        this.destinationType = destinationType;
    }

    public OfferRequestSlice origin(OfferRequestSliceOrigin origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferRequestSliceOrigin getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrigin(OfferRequestSliceOrigin origin) {
        this.origin = origin;
    }

    public OfferRequestSlice originType(OriginTypeEnum originType) {
        this.originType = originType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="airport", value="The type of the origin")
    @JsonProperty(value="origin_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OriginTypeEnum getOriginType() {
        return this.originType;
    }

    @JsonProperty(value="origin_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginType(OriginTypeEnum originType) {
        this.originType = originType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRequestSlice offerRequestSlice = (OfferRequestSlice)o;
        return Objects.equals(this.departureDate, offerRequestSlice.departureDate) && Objects.equals(this.destination, offerRequestSlice.destination) && Objects.equals((Object)this.destinationType, (Object)offerRequestSlice.destinationType) && Objects.equals(this.origin, offerRequestSlice.origin) && Objects.equals((Object)this.originType, (Object)offerRequestSlice.originType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.departureDate, this.destination, this.destinationType, this.origin, this.originType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferRequestSlice {\n");
        sb.append("    departureDate: ").append(this.toIndentedString(this.departureDate)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    destinationType: ").append(this.toIndentedString((Object)this.destinationType)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    originType: ").append(this.toIndentedString((Object)this.originType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DestinationTypeEnum {
        AIRPORT("airport"),
        CITY("city");

        private String value;

        private DestinationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DestinationTypeEnum fromValue(String value) {
            for (DestinationTypeEnum b : DestinationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OriginTypeEnum {
        AIRPORT("airport"),
        CITY("city");

        private String value;

        private OriginTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OriginTypeEnum fromValue(String value) {
            for (OriginTypeEnum b : OriginTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

