/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OfferSliceSegmentAircraft;
import com.duffel.sdk.model.OfferSliceSegmentDestination;
import com.duffel.sdk.model.OfferSliceSegmentMarketingCarrier;
import com.duffel.sdk.model.OfferSliceSegmentOperatingCarrier;
import com.duffel.sdk.model.OfferSliceSegmentOrigin;
import com.duffel.sdk.model.OfferSliceSegmentPassenger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"aircraft", "arriving_at", "departing_at", "destination", "destination_terminal", "distance", "duration", "id", "marketing_carrier", "marketing_carrier_flight_number", "operating_carrier", "operating_carrier_flight_number", "origin", "origin_terminal", "passengers"})
@JsonTypeName(value="Offer_Slice_Segment")
public class OfferSliceSegment {
    public static final String JSON_PROPERTY_AIRCRAFT = "aircraft";
    private OfferSliceSegmentAircraft aircraft;
    public static final String JSON_PROPERTY_ARRIVING_AT = "arriving_at";
    private OffsetDateTime arrivingAt;
    public static final String JSON_PROPERTY_DEPARTING_AT = "departing_at";
    private OffsetDateTime departingAt;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private OfferSliceSegmentDestination destination;
    public static final String JSON_PROPERTY_DESTINATION_TERMINAL = "destination_terminal";
    private JsonNullable<String> destinationTerminal = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DISTANCE = "distance";
    private JsonNullable<String> distance = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DURATION = "duration";
    private JsonNullable<String> duration = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_MARKETING_CARRIER = "marketing_carrier";
    private OfferSliceSegmentMarketingCarrier marketingCarrier;
    public static final String JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER = "marketing_carrier_flight_number";
    private String marketingCarrierFlightNumber;
    public static final String JSON_PROPERTY_OPERATING_CARRIER = "operating_carrier";
    private OfferSliceSegmentOperatingCarrier operatingCarrier;
    public static final String JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER = "operating_carrier_flight_number";
    private JsonNullable<String> operatingCarrierFlightNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private OfferSliceSegmentOrigin origin;
    public static final String JSON_PROPERTY_ORIGIN_TERMINAL = "origin_terminal";
    private JsonNullable<String> originTerminal = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PASSENGERS = "passengers";
    private List<OfferSliceSegmentPassenger> passengers = null;

    public OfferSliceSegment aircraft(OfferSliceSegmentAircraft aircraft) {
        this.aircraft = aircraft;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="aircraft")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferSliceSegmentAircraft getAircraft() {
        return this.aircraft;
    }

    @JsonProperty(value="aircraft")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAircraft(OfferSliceSegmentAircraft aircraft) {
        this.aircraft = aircraft;
    }

    public OfferSliceSegment arrivingAt(OffsetDateTime arrivingAt) {
        this.arrivingAt = arrivingAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to arrive, in the destination airport timezone (see `destination.timezone`)")
    @JsonProperty(value="arriving_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getArrivingAt() {
        return this.arrivingAt;
    }

    @JsonProperty(value="arriving_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArrivingAt(OffsetDateTime arrivingAt) {
        this.arrivingAt = arrivingAt;
    }

    public OfferSliceSegment departingAt(OffsetDateTime departingAt) {
        this.departingAt = departingAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to depart, in the origin airport timezone (see `origin.timezone`)")
    @JsonProperty(value="departing_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDepartingAt() {
        return this.departingAt;
    }

    @JsonProperty(value="departing_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDepartingAt(OffsetDateTime departingAt) {
        this.departingAt = departingAt;
    }

    public OfferSliceSegment destination(OfferSliceSegmentDestination destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferSliceSegmentDestination getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestination(OfferSliceSegmentDestination destination) {
        this.destination = destination;
    }

    public OfferSliceSegment destinationTerminal(String destinationTerminal) {
        this.destinationTerminal = JsonNullable.of((Object)destinationTerminal);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="5", value="The terminal at the `destination` airport where the segment is scheduled to arrive")
    @JsonIgnore
    public String getDestinationTerminal() {
        return (String)this.destinationTerminal.orElse(null);
    }

    @JsonProperty(value="destination_terminal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDestinationTerminal_JsonNullable() {
        return this.destinationTerminal;
    }

    @JsonProperty(value="destination_terminal")
    public void setDestinationTerminal_JsonNullable(JsonNullable<String> destinationTerminal) {
        this.destinationTerminal = destinationTerminal;
    }

    public void setDestinationTerminal(String destinationTerminal) {
        this.destinationTerminal = JsonNullable.of((Object)destinationTerminal);
    }

    public OfferSliceSegment distance(String distance) {
        this.distance = JsonNullable.of((Object)distance);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="424.2", value="The distance of the segment in kilometres")
    @JsonIgnore
    public String getDistance() {
        return (String)this.distance.orElse(null);
    }

    @JsonProperty(value="distance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDistance_JsonNullable() {
        return this.distance;
    }

    @JsonProperty(value="distance")
    public void setDistance_JsonNullable(JsonNullable<String> distance) {
        this.distance = distance;
    }

    public void setDistance(String distance) {
        this.distance = JsonNullable.of((Object)distance);
    }

    public OfferSliceSegment duration(String duration) {
        this.duration = JsonNullable.of((Object)duration);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PT02H26M", value="The duration of the segment, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration")
    @JsonIgnore
    public String getDuration() {
        return (String)this.duration.orElse(null);
    }

    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDuration_JsonNullable() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration_JsonNullable(JsonNullable<String> duration) {
        this.duration = duration;
    }

    public void setDuration(String duration) {
        this.duration = JsonNullable.of((Object)duration);
    }

    public OfferSliceSegment id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="seg_00009htYpSCXrwaB9Dn456", value="Duffel's unique identifier for the segment. It identifies the segment of an offer (i.e. the same segment across offers will have different `id`s).")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public OfferSliceSegment marketingCarrier(OfferSliceSegmentMarketingCarrier marketingCarrier) {
        this.marketingCarrier = marketingCarrier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="marketing_carrier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferSliceSegmentMarketingCarrier getMarketingCarrier() {
        return this.marketingCarrier;
    }

    @JsonProperty(value="marketing_carrier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarketingCarrier(OfferSliceSegmentMarketingCarrier marketingCarrier) {
        this.marketingCarrier = marketingCarrier;
    }

    public OfferSliceSegment marketingCarrierFlightNumber(String marketingCarrierFlightNumber) {
        this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1234", value="The flight number assigned by the marketing carrier")
    @JsonProperty(value="marketing_carrier_flight_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMarketingCarrierFlightNumber() {
        return this.marketingCarrierFlightNumber;
    }

    @JsonProperty(value="marketing_carrier_flight_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarketingCarrierFlightNumber(String marketingCarrierFlightNumber) {
        this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
    }

    public OfferSliceSegment operatingCarrier(OfferSliceSegmentOperatingCarrier operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="operating_carrier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferSliceSegmentOperatingCarrier getOperatingCarrier() {
        return this.operatingCarrier;
    }

    @JsonProperty(value="operating_carrier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperatingCarrier(OfferSliceSegmentOperatingCarrier operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    public OfferSliceSegment operatingCarrierFlightNumber(String operatingCarrierFlightNumber) {
        this.operatingCarrierFlightNumber = JsonNullable.of((Object)operatingCarrierFlightNumber);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4321", value="The flight number assigned by the operating carrier. This may not be present, in which case you should display the `marketing_carrier`'s information and the `marketing_carrier_flight_number`, and simply state the name of the `operating_carrier`.")
    @JsonIgnore
    public String getOperatingCarrierFlightNumber() {
        return (String)this.operatingCarrierFlightNumber.orElse(null);
    }

    @JsonProperty(value="operating_carrier_flight_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getOperatingCarrierFlightNumber_JsonNullable() {
        return this.operatingCarrierFlightNumber;
    }

    @JsonProperty(value="operating_carrier_flight_number")
    public void setOperatingCarrierFlightNumber_JsonNullable(JsonNullable<String> operatingCarrierFlightNumber) {
        this.operatingCarrierFlightNumber = operatingCarrierFlightNumber;
    }

    public void setOperatingCarrierFlightNumber(String operatingCarrierFlightNumber) {
        this.operatingCarrierFlightNumber = JsonNullable.of((Object)operatingCarrierFlightNumber);
    }

    public OfferSliceSegment origin(OfferSliceSegmentOrigin origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferSliceSegmentOrigin getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrigin(OfferSliceSegmentOrigin origin) {
        this.origin = origin;
    }

    public OfferSliceSegment originTerminal(String originTerminal) {
        this.originTerminal = JsonNullable.of((Object)originTerminal);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="B", value="The terminal at the `origin` airport from which the segment is scheduled to depart")
    @JsonIgnore
    public String getOriginTerminal() {
        return (String)this.originTerminal.orElse(null);
    }

    @JsonProperty(value="origin_terminal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getOriginTerminal_JsonNullable() {
        return this.originTerminal;
    }

    @JsonProperty(value="origin_terminal")
    public void setOriginTerminal_JsonNullable(JsonNullable<String> originTerminal) {
        this.originTerminal = originTerminal;
    }

    public void setOriginTerminal(String originTerminal) {
        this.originTerminal = JsonNullable.of((Object)originTerminal);
    }

    public OfferSliceSegment passengers(List<OfferSliceSegmentPassenger> passengers) {
        this.passengers = passengers;
        return this;
    }

    public OfferSliceSegment addPassengersItem(OfferSliceSegmentPassenger passengersItem) {
        if (this.passengers == null) {
            this.passengers = new ArrayList<OfferSliceSegmentPassenger>();
        }
        this.passengers.add(passengersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Additional segment-specific information about the passengers included in the offer (e.g. their baggage allowance and the cabin class they will be travelling in)")
    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<OfferSliceSegmentPassenger> getPassengers() {
        return this.passengers;
    }

    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassengers(List<OfferSliceSegmentPassenger> passengers) {
        this.passengers = passengers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferSliceSegment offerSliceSegment = (OfferSliceSegment)o;
        return Objects.equals(this.aircraft, offerSliceSegment.aircraft) && Objects.equals(this.arrivingAt, offerSliceSegment.arrivingAt) && Objects.equals(this.departingAt, offerSliceSegment.departingAt) && Objects.equals(this.destination, offerSliceSegment.destination) && OfferSliceSegment.equalsNullable(this.destinationTerminal, offerSliceSegment.destinationTerminal) && OfferSliceSegment.equalsNullable(this.distance, offerSliceSegment.distance) && OfferSliceSegment.equalsNullable(this.duration, offerSliceSegment.duration) && Objects.equals(this.id, offerSliceSegment.id) && Objects.equals(this.marketingCarrier, offerSliceSegment.marketingCarrier) && Objects.equals(this.marketingCarrierFlightNumber, offerSliceSegment.marketingCarrierFlightNumber) && Objects.equals(this.operatingCarrier, offerSliceSegment.operatingCarrier) && OfferSliceSegment.equalsNullable(this.operatingCarrierFlightNumber, offerSliceSegment.operatingCarrierFlightNumber) && Objects.equals(this.origin, offerSliceSegment.origin) && OfferSliceSegment.equalsNullable(this.originTerminal, offerSliceSegment.originTerminal) && Objects.equals(this.passengers, offerSliceSegment.passengers);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.aircraft, this.arrivingAt, this.departingAt, this.destination, OfferSliceSegment.hashCodeNullable(this.destinationTerminal), OfferSliceSegment.hashCodeNullable(this.distance), OfferSliceSegment.hashCodeNullable(this.duration), this.id, this.marketingCarrier, this.marketingCarrierFlightNumber, this.operatingCarrier, OfferSliceSegment.hashCodeNullable(this.operatingCarrierFlightNumber), this.origin, OfferSliceSegment.hashCodeNullable(this.originTerminal), this.passengers);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferSliceSegment {\n");
        sb.append("    aircraft: ").append(this.toIndentedString(this.aircraft)).append("\n");
        sb.append("    arrivingAt: ").append(this.toIndentedString(this.arrivingAt)).append("\n");
        sb.append("    departingAt: ").append(this.toIndentedString(this.departingAt)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    destinationTerminal: ").append(this.toIndentedString(this.destinationTerminal)).append("\n");
        sb.append("    distance: ").append(this.toIndentedString(this.distance)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    marketingCarrier: ").append(this.toIndentedString(this.marketingCarrier)).append("\n");
        sb.append("    marketingCarrierFlightNumber: ").append(this.toIndentedString(this.marketingCarrierFlightNumber)).append("\n");
        sb.append("    operatingCarrier: ").append(this.toIndentedString(this.operatingCarrier)).append("\n");
        sb.append("    operatingCarrierFlightNumber: ").append(this.toIndentedString(this.operatingCarrierFlightNumber)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("    originTerminal: ").append(this.toIndentedString(this.originTerminal)).append("\n");
        sb.append("    passengers: ").append(this.toIndentedString(this.passengers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

