/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.SliceSegmentPassengerBaggage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"baggages", "cabin_class", "cabin_class_marketing_name", "fare_basis_code", "passenger_id"})
@JsonTypeName(value="Offer_Slice_Segment_Passenger")
public class OfferSliceSegmentPassenger {
    public static final String JSON_PROPERTY_BAGGAGES = "baggages";
    private List<SliceSegmentPassengerBaggage> baggages = null;
    public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
    private CabinClassEnum cabinClass;
    public static final String JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME = "cabin_class_marketing_name";
    private String cabinClassMarketingName;
    public static final String JSON_PROPERTY_FARE_BASIS_CODE = "fare_basis_code";
    private JsonNullable<String> fareBasisCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PASSENGER_ID = "passenger_id";
    private String passengerId;

    public OfferSliceSegmentPassenger baggages(List<SliceSegmentPassengerBaggage> baggages) {
        this.baggages = baggages;
        return this;
    }

    public OfferSliceSegmentPassenger addBaggagesItem(SliceSegmentPassengerBaggage baggagesItem) {
        if (this.baggages == null) {
            this.baggages = new ArrayList<SliceSegmentPassengerBaggage>();
        }
        this.baggages.add(baggagesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The baggage allowances for the passenger on this segment included in the offer. Some airlines may allow additional baggage to be booked as a service - see the offer's `available_services`.")
    @JsonProperty(value="baggages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SliceSegmentPassengerBaggage> getBaggages() {
        return this.baggages;
    }

    @JsonProperty(value="baggages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaggages(List<SliceSegmentPassengerBaggage> baggages) {
        this.baggages = baggages;
    }

    public OfferSliceSegmentPassenger cabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="economy", value="The cabin class that the passenger will travel in on this segment")
    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CabinClassEnum getCabinClass() {
        return this.cabinClass;
    }

    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
    }

    public OfferSliceSegmentPassenger cabinClassMarketingName(String cabinClassMarketingName) {
        this.cabinClassMarketingName = cabinClassMarketingName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Economy Basic", value="The name that the marketing carrier uses to market this cabin class")
    @JsonProperty(value="cabin_class_marketing_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCabinClassMarketingName() {
        return this.cabinClassMarketingName;
    }

    @JsonProperty(value="cabin_class_marketing_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCabinClassMarketingName(String cabinClassMarketingName) {
        this.cabinClassMarketingName = cabinClassMarketingName;
    }

    public OfferSliceSegmentPassenger fareBasisCode(String fareBasisCode) {
        this.fareBasisCode = JsonNullable.of((Object)fareBasisCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="OXZ0RO", value="The airline's alphanumeric code for the fare that the passenger is using to travel. Where this is `null`, it means that either the fare basis code is not available or the airline does not use fare basis codes.")
    @JsonIgnore
    public String getFareBasisCode() {
        return (String)this.fareBasisCode.orElse(null);
    }

    @JsonProperty(value="fare_basis_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFareBasisCode_JsonNullable() {
        return this.fareBasisCode;
    }

    @JsonProperty(value="fare_basis_code")
    public void setFareBasisCode_JsonNullable(JsonNullable<String> fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = JsonNullable.of((Object)fareBasisCode);
    }

    public OfferSliceSegmentPassenger passengerId(String passengerId) {
        this.passengerId = passengerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="passenger_0", value="The identifier for the passenger. You may have specified this ID yourself when creating the offer request, or otherwise, Duffel will have generated its own random ID.")
    @JsonProperty(value="passenger_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassengerId() {
        return this.passengerId;
    }

    @JsonProperty(value="passenger_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassengerId(String passengerId) {
        this.passengerId = passengerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferSliceSegmentPassenger offerSliceSegmentPassenger = (OfferSliceSegmentPassenger)o;
        return Objects.equals(this.baggages, offerSliceSegmentPassenger.baggages) && Objects.equals((Object)this.cabinClass, (Object)offerSliceSegmentPassenger.cabinClass) && Objects.equals(this.cabinClassMarketingName, offerSliceSegmentPassenger.cabinClassMarketingName) && OfferSliceSegmentPassenger.equalsNullable(this.fareBasisCode, offerSliceSegmentPassenger.fareBasisCode) && Objects.equals(this.passengerId, offerSliceSegmentPassenger.passengerId);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baggages, this.cabinClass, this.cabinClassMarketingName, OfferSliceSegmentPassenger.hashCodeNullable(this.fareBasisCode), this.passengerId});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferSliceSegmentPassenger {\n");
        sb.append("    baggages: ").append(this.toIndentedString(this.baggages)).append("\n");
        sb.append("    cabinClass: ").append(this.toIndentedString((Object)this.cabinClass)).append("\n");
        sb.append("    cabinClassMarketingName: ").append(this.toIndentedString(this.cabinClassMarketingName)).append("\n");
        sb.append("    fareBasisCode: ").append(this.toIndentedString(this.fareBasisCode)).append("\n");
        sb.append("    passengerId: ").append(this.toIndentedString(this.passengerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CabinClassEnum {
        FIRST("first"),
        BUSINESS("business"),
        PREMIUM_ECONOMY("premium_economy"),
        ECONOMY("economy");

        private String value;

        private CabinClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CabinClassEnum fromValue(String value) {
            for (CabinClassEnum b : CabinClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

