/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="The search criteria for a slice to be added")
@JsonPropertyOrder(value={"cabin_class", "departure_date", "destination", "origin"})
@JsonTypeName(value="Order_Change_Request_Body_slices_add_inner")
public class OrderChangeRequestBodySlicesAddInner {
    public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
    private CabinClassEnum cabinClass;
    public static final String JSON_PROPERTY_DEPARTURE_DATE = "departure_date";
    private LocalDate departureDate;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private String destination;
    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private String origin;

    public OrderChangeRequestBodySlicesAddInner cabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="economy", value="The cabin that the passengers want to travel in")
    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CabinClassEnum getCabinClass() {
        return this.cabinClass;
    }

    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
    }

    public OrderChangeRequestBodySlicesAddInner departureDate(LocalDate departureDate) {
        this.departureDate = departureDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="Fri Apr 24 07:00:00 ICT 2020", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the passengers want to depart")
    @JsonProperty(value="departure_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDepartureDate() {
        return this.departureDate;
    }

    @JsonProperty(value="departure_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDepartureDate(LocalDate departureDate) {
        this.departureDate = departureDate;
    }

    public OrderChangeRequestBodySlicesAddInner destination(String destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="JFK", value="The 3-letter IATA code for the city or airport where this slice ends")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestination(String destination) {
        this.destination = destination;
    }

    public OrderChangeRequestBodySlicesAddInner origin(String origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LHR", value="The 3-letter IATA code for the city or airport where this slice starts")
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrigin() {
        return this.origin;
    }

    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderChangeRequestBodySlicesAddInner orderChangeRequestBodySlicesAddInner = (OrderChangeRequestBodySlicesAddInner)o;
        return Objects.equals((Object)this.cabinClass, (Object)orderChangeRequestBodySlicesAddInner.cabinClass) && Objects.equals(this.departureDate, orderChangeRequestBodySlicesAddInner.departureDate) && Objects.equals(this.destination, orderChangeRequestBodySlicesAddInner.destination) && Objects.equals(this.origin, orderChangeRequestBodySlicesAddInner.origin);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cabinClass, this.departureDate, this.destination, this.origin});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderChangeRequestBodySlicesAddInner {\n");
        sb.append("    cabinClass: ").append(this.toIndentedString((Object)this.cabinClass)).append("\n");
        sb.append("    departureDate: ").append(this.toIndentedString(this.departureDate)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString(this.origin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CabinClassEnum {
        FIRST("first"),
        BUSINESS("business"),
        PREMIUM_ECONOMY("premium_economy"),
        ECONOMY("economy");

        private String value;

        private CabinClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CabinClassEnum fromValue(String value) {
            for (CabinClassEnum b : CabinClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

