/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.LoyaltyProgrammeAccount;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"born_on", "email", "family_name", "gender", "given_name", "id", "infant_passenger_id", "loyalty_programme_accounts", "phone_number", "title", "type"})
@JsonTypeName(value="Order_Passenger")
public class OrderPassenger {
    public static final String JSON_PROPERTY_BORN_ON = "born_on";
    private LocalDate bornOn;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FAMILY_NAME = "family_name";
    private String familyName;
    public static final String JSON_PROPERTY_GENDER = "gender";
    private GenderEnum gender;
    public static final String JSON_PROPERTY_GIVEN_NAME = "given_name";
    private String givenName;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INFANT_PASSENGER_ID = "infant_passenger_id";
    private String infantPassengerId;
    public static final String JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS = "loyalty_programme_accounts";
    private List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts = new ArrayList<LoyaltyProgrammeAccount>();
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phone_number";
    private String phoneNumber;
    public static final String JSON_PROPERTY_TITLE = "title";
    private TitleEnum title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public OrderPassenger bornOn(LocalDate bornOn) {
        this.bornOn = bornOn;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Fri Jul 24 07:00:00 ICT 1987", required=true, value="The passenger's date of birth")
    @JsonProperty(value="born_on")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getBornOn() {
        return this.bornOn;
    }

    @JsonProperty(value="born_on")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBornOn(LocalDate bornOn) {
        this.bornOn = bornOn;
    }

    public OrderPassenger email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="amelia@duffel.com", required=true, value="The passenger's email address. Note that this data may differ from the airline's records if it was updated directly with the airline since the order was created. ")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public OrderPassenger familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Earhart", required=true, value="The passenger's family name")
    @JsonProperty(value="family_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFamilyName() {
        return this.familyName;
    }

    @JsonProperty(value="family_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public OrderPassenger gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="f", required=true, value="The passenger's gender")
    @JsonProperty(value="gender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GenderEnum getGender() {
        return this.gender;
    }

    @JsonProperty(value="gender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public OrderPassenger givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="Amelia", required=true, value="The passenger's given name")
    @JsonProperty(value="given_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGivenName() {
        return this.givenName;
    }

    @JsonProperty(value="given_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public OrderPassenger id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="pas_00009hj8USM7Ncg31cBCLL", required=true, value="The `id` of the passenger, returned when the [offer request](/docs/api/offer-requests) was created")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public OrderPassenger infantPassengerId(String infantPassengerId) {
        this.infantPassengerId = infantPassengerId;
        return this;
    }

    @Nullable
    @NotNull
    @ApiModelProperty(example="pas_00009hj8USM8Ncg32aTGHL", required=true, value="The `id` of the infant associated with this passenger")
    @JsonProperty(value="infant_passenger_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInfantPassengerId() {
        return this.infantPassengerId;
    }

    @JsonProperty(value="infant_passenger_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInfantPassengerId(String infantPassengerId) {
        this.infantPassengerId = infantPassengerId;
    }

    public OrderPassenger loyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
        this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
        return this;
    }

    public OrderPassenger addLoyaltyProgrammeAccountsItem(LoyaltyProgrammeAccount loyaltyProgrammeAccountsItem) {
        this.loyaltyProgrammeAccounts.add(loyaltyProgrammeAccountsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The __Loyalty Programme Accounts__ for this passenger")
    @JsonProperty(value="loyalty_programme_accounts")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<LoyaltyProgrammeAccount> getLoyaltyProgrammeAccounts() {
        return this.loyaltyProgrammeAccounts;
    }

    @JsonProperty(value="loyalty_programme_accounts")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLoyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
        this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
    }

    public OrderPassenger phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="+442080160509", required=true, value="The passenger's phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) (international) format. Note that this data may differ from the airline's records if it was updated directly with the airline since the order was created. ")
    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public OrderPassenger title(TitleEnum title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="mrs", required=true, value="The passenger's title")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TitleEnum getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTitle(TitleEnum title) {
        this.title = title;
    }

    public OrderPassenger type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="adult", required=true, value="The type of the passenger")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderPassenger orderPassenger = (OrderPassenger)o;
        return Objects.equals(this.bornOn, orderPassenger.bornOn) && Objects.equals(this.email, orderPassenger.email) && Objects.equals(this.familyName, orderPassenger.familyName) && Objects.equals((Object)this.gender, (Object)orderPassenger.gender) && Objects.equals(this.givenName, orderPassenger.givenName) && Objects.equals(this.id, orderPassenger.id) && Objects.equals(this.infantPassengerId, orderPassenger.infantPassengerId) && Objects.equals(this.loyaltyProgrammeAccounts, orderPassenger.loyaltyProgrammeAccounts) && Objects.equals(this.phoneNumber, orderPassenger.phoneNumber) && Objects.equals((Object)this.title, (Object)orderPassenger.title) && Objects.equals((Object)this.type, (Object)orderPassenger.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bornOn, this.email, this.familyName, this.gender, this.givenName, this.id, this.infantPassengerId, this.loyaltyProgrammeAccounts, this.phoneNumber, this.title, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderPassenger {\n");
        sb.append("    bornOn: ").append(this.toIndentedString(this.bornOn)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    infantPassengerId: ").append(this.toIndentedString(this.infantPassengerId)).append("\n");
        sb.append("    loyaltyProgrammeAccounts: ").append(this.toIndentedString(this.loyaltyProgrammeAccounts)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        M("m"),
        F("f");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String value) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TitleEnum {
        MR("mr"),
        MS("ms"),
        MRS("mrs"),
        MISS("miss"),
        DR("dr");

        private String value;

        private TitleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TitleEnum fromValue(String value) {
            for (TitleEnum b : TitleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ADULT("adult"),
        CHILD("child"),
        INFANT_WITHOUT_SEAT("infant_without_seat");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

