/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonPropertyOrder(value={"expires_on", "issuing_country_code", "type", "unique_identifier"})
@JsonTypeName(value="Order_Request_Passenger_Identity_Document")
public class OrderRequestPassengerIdentityDocument {
    public static final String JSON_PROPERTY_EXPIRES_ON = "expires_on";
    private LocalDate expiresOn;
    public static final String JSON_PROPERTY_ISSUING_COUNTRY_CODE = "issuing_country_code";
    private String issuingCountryCode;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_UNIQUE_IDENTIFIER = "unique_identifier";
    private String uniqueIdentifier;

    public OrderRequestPassengerIdentityDocument expiresOn(LocalDate expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Fri Apr 25 07:00:00 ICT 2025", required=true, value="The date on which the identity document expires")
    @JsonProperty(value="expires_on")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getExpiresOn() {
        return this.expiresOn;
    }

    @JsonProperty(value="expires_on")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpiresOn(LocalDate expiresOn) {
        this.expiresOn = expiresOn;
    }

    public OrderRequestPassengerIdentityDocument issuingCountryCode(String issuingCountryCode) {
        this.issuingCountryCode = issuingCountryCode;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="GB", required=true, value="The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code of the country that issued this identity document")
    @JsonProperty(value="issuing_country_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIssuingCountryCode() {
        return this.issuingCountryCode;
    }

    @JsonProperty(value="issuing_country_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuingCountryCode(String issuingCountryCode) {
        this.issuingCountryCode = issuingCountryCode;
    }

    public OrderRequestPassengerIdentityDocument type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="passport", required=true, value="The type of the identity document. Currently, the only supported type is `passport`. This must be one of the `allowed_passenger_identity_document_types` on the offer.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public OrderRequestPassengerIdentityDocument uniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="19KL56147", required=true, value="The unique identifier of the identity document. We currently only support passport so this would be the passport number.")
    @JsonProperty(value="unique_identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @JsonProperty(value="unique_identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderRequestPassengerIdentityDocument orderRequestPassengerIdentityDocument = (OrderRequestPassengerIdentityDocument)o;
        return Objects.equals(this.expiresOn, orderRequestPassengerIdentityDocument.expiresOn) && Objects.equals(this.issuingCountryCode, orderRequestPassengerIdentityDocument.issuingCountryCode) && Objects.equals(this.type, orderRequestPassengerIdentityDocument.type) && Objects.equals(this.uniqueIdentifier, orderRequestPassengerIdentityDocument.uniqueIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.expiresOn, this.issuingCountryCode, this.type, this.uniqueIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderRequestPassengerIdentityDocument {\n");
        sb.append("    expiresOn: ").append(this.toIndentedString(this.expiresOn)).append("\n");
        sb.append("    issuingCountryCode: ").append(this.toIndentedString(this.issuingCountryCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    uniqueIdentifier: ").append(this.toIndentedString(this.uniqueIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

