/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="A __Refund__ is used to refund money to a customer for part or all of a __Payment Intent__.  You can issue multiple __Refund__s from the same __Payment Intent__. ")
@JsonPropertyOrder(value={"amount", "arrival", "created_at", "currency", "destination", "id", "live_mode", "net_amount", "net_currency", "payment_intent_id", "status", "updated_at"})
public class Refund {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_ARRIVAL = "arrival";
    private String arrival;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private DestinationEnum destination;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
    private Boolean liveMode;
    public static final String JSON_PROPERTY_NET_AMOUNT = "net_amount";
    private String netAmount;
    public static final String JSON_PROPERTY_NET_CURRENCY = "net_currency";
    private String netCurrency;
    public static final String JSON_PROPERTY_PAYMENT_INTENT_ID = "payment_intent_id";
    private String paymentIntentId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    public Refund amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="300.10", value="The amount of the __Payment Intent__ that will be refunded to the customer ")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Refund arrival(String arrival) {
        this.arrival = arrival;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Credit approximately 5-10 business days later, depending upon the bank.", value="When the refund is expected to arrive in the **destination**")
    @JsonProperty(value="arrival")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArrival() {
        return this.arrival;
    }

    @JsonProperty(value="arrival")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArrival(String arrival) {
        this.arrival = arrival;
    }

    public Refund createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2020-04-11T15:48:11.642Z", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Refund__ was created")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Refund currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GBP", value="The currency of the `amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.   It will always match the currency of the __Payment Intent__. ")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Refund destination(DestinationEnum destination) {
        this.destination = destination;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="original_form_of_payment", value="Where the __Refund__ amount will be sent to")
    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DestinationEnum getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestination(DestinationEnum destination) {
        this.destination = destination;
    }

    public Refund id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ref_00009hthhsUZ8W4LxQgkjo", value="Duffel's unique identifier for the __Refund__")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Refund liveMode(Boolean liveMode) {
        this.liveMode = liveMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the __Refund__ was created in live mode. This field will be set to `true` if the __Refund__ was created in live mode, or `false` if it was created in test mode. ")
    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLiveMode() {
        return this.liveMode;
    }

    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    public Refund netAmount(String netAmount) {
        this.netAmount = netAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="300.10", value="The amount deducted from your __Balance__ to cover the __Refund__ `amount` ")
    @JsonProperty(value="net_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetAmount() {
        return this.netAmount;
    }

    @JsonProperty(value="net_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetAmount(String netAmount) {
        this.netAmount = netAmount;
    }

    public Refund netCurrency(String netCurrency) {
        this.netCurrency = netCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GBP", value="The currency of the `net_amount`, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code.  This currency will match your __Balance__ currency. ")
    @JsonProperty(value="net_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetCurrency() {
        return this.netCurrency;
    }

    @JsonProperty(value="net_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetCurrency(String netCurrency) {
        this.netCurrency = netCurrency;
    }

    public Refund paymentIntentId(String paymentIntentId) {
        this.paymentIntentId = paymentIntentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="pit_00009hthhsUZ8W4LxQgkjo", value="Duffel's unique identifier for the __Payment Intent__ that the __Refund__ is for")
    @JsonProperty(value="payment_intent_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentIntentId() {
        return this.paymentIntentId;
    }

    @JsonProperty(value="payment_intent_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentIntentId(String paymentIntentId) {
        this.paymentIntentId = paymentIntentId;
    }

    public Refund status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="succeeded", value="The status of the __Refund__.  **Succeeded**: The refund is on its way to the **destination**.  **Pending**: The __Refund__ could not be processed immediately, and is pending processing.  **Failed**: A refund can fail if the customer\u2019s bank or card issuer has been unable to process it correctly (e.g., a closed bank account or a problem with the card). The bank returns the refunded amount to us and we add it back to your __Balance__. This process can take up to 30 days from the post date. ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Refund updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2020-04-11T15:48:11.642Z", value="The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the __Refund__ was updated")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Refund refund = (Refund)o;
        return Objects.equals(this.amount, refund.amount) && Objects.equals(this.arrival, refund.arrival) && Objects.equals(this.createdAt, refund.createdAt) && Objects.equals(this.currency, refund.currency) && Objects.equals((Object)this.destination, (Object)refund.destination) && Objects.equals(this.id, refund.id) && Objects.equals(this.liveMode, refund.liveMode) && Objects.equals(this.netAmount, refund.netAmount) && Objects.equals(this.netCurrency, refund.netCurrency) && Objects.equals(this.paymentIntentId, refund.paymentIntentId) && Objects.equals((Object)this.status, (Object)refund.status) && Objects.equals(this.updatedAt, refund.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.arrival, this.createdAt, this.currency, this.destination, this.id, this.liveMode, this.netAmount, this.netCurrency, this.paymentIntentId, this.status, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Refund {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    arrival: ").append(this.toIndentedString(this.arrival)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString((Object)this.destination)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    liveMode: ").append(this.toIndentedString(this.liveMode)).append("\n");
        sb.append("    netAmount: ").append(this.toIndentedString(this.netAmount)).append("\n");
        sb.append("    netCurrency: ").append(this.toIndentedString(this.netCurrency)).append("\n");
        sb.append("    paymentIntentId: ").append(this.toIndentedString(this.paymentIntentId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DestinationEnum {
        ORIGINAL_FORM_OF_PAYMENT("original_form_of_payment");

        private String value;

        private DestinationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DestinationEnum fromValue(String value) {
            for (DestinationEnum b : DestinationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        SUCCEEDED("succeeded"),
        PENDING("pending"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

