package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.CreateOfferRequestRequest;
import com.duffel.sdk.model.GetOfferRequestById200Response;
import com.duffel.sdk.model.GetOfferRequests200Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OfferRequestsApi {
    private ApiClient apiClient;

    public OfferRequestsApi() {
        this(new ApiClient());
    }

    @Autowired
    public OfferRequestsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create an offer request
     * To search for flights, you&#39;ll need to create an __offer request__. An offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__.  Each offer represents a set of flights you can buy from an airline at a particular price that meet your search criteria.  Inside the offers, you&#39;ll see your slices, but now each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param returnOffers When set to &#x60;true&#x60;, the offer request resource returned will include _all_ the &#x60;offer&#x60;s returned by the airlines. If set to &#x60;false&#x60;, the offer request resource won&#39;t include any &#x60;offer&#x60;s. To retrieve the associated offers later, use the [List Offers](/docs/api/offers/get-offers) endpoint, specifying the &#x60;offer_request_id&#x60;. You should use this option if you want to take advantage of the pagination, sorting and filtering that the [List Offers](/docs/api/offers/get-offers) endpoint provides. 
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createOfferRequestRequestCreation(String accept, String duffelVersion, String acceptEncoding, String contentType, Boolean returnOffers, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        Object postBody = createOfferRequestRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createOfferRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createOfferRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "return_offers", returnOffers));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "supplier_timeout", supplierTimeout));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (contentType != null)
        headerParams.add("Content-Type", apiClient.parameterToString(contentType));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/offer_requests", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create an offer request
     * To search for flights, you&#39;ll need to create an __offer request__. An offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__.  Each offer represents a set of flights you can buy from an airline at a particular price that meet your search criteria.  Inside the offers, you&#39;ll see your slices, but now each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param returnOffers When set to &#x60;true&#x60;, the offer request resource returned will include _all_ the &#x60;offer&#x60;s returned by the airlines. If set to &#x60;false&#x60;, the offer request resource won&#39;t include any &#x60;offer&#x60;s. To retrieve the associated offers later, use the [List Offers](/docs/api/offers/get-offers) endpoint, specifying the &#x60;offer_request_id&#x60;. You should use this option if you want to take advantage of the pagination, sorting and filtering that the [List Offers](/docs/api/offers/get-offers) endpoint provides. 
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> createOfferRequest(String accept, String duffelVersion, String acceptEncoding, String contentType, Boolean returnOffers, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return createOfferRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, returnOffers, supplierTimeout, createOfferRequestRequest).bodyToMono(localVarReturnType);
    }

    /**
     * Create an offer request
     * To search for flights, you&#39;ll need to create an __offer request__. An offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__.  Each offer represents a set of flights you can buy from an airline at a particular price that meet your search criteria.  Inside the offers, you&#39;ll see your slices, but now each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param returnOffers When set to &#x60;true&#x60;, the offer request resource returned will include _all_ the &#x60;offer&#x60;s returned by the airlines. If set to &#x60;false&#x60;, the offer request resource won&#39;t include any &#x60;offer&#x60;s. To retrieve the associated offers later, use the [List Offers](/docs/api/offers/get-offers) endpoint, specifying the &#x60;offer_request_id&#x60;. You should use this option if you want to take advantage of the pagination, sorting and filtering that the [List Offers](/docs/api/offers/get-offers) endpoint provides. 
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return ResponseEntity&lt;GetOfferRequestById200Response&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GetOfferRequestById200Response>> createOfferRequestWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String contentType, Boolean returnOffers, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return createOfferRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, returnOffers, supplierTimeout, createOfferRequestRequest).toEntity(localVarReturnType);
    }

    /**
     * Create an offer request
     * To search for flights, you&#39;ll need to create an __offer request__. An offer request describes the passengers and where and when they want to travel (in the form of a list of __slices__). It may also include additional filters (e.g. a particular cabin to travel in).  We&#39;ll send your search to a range of airlines, and return your offer request back to you with a series of __offers__.  Each offer represents a set of flights you can buy from an airline at a particular price that meet your search criteria.  Inside the offers, you&#39;ll see your slices, but now each slice will also include a list of one or more specific flights (called __segments__) that the airline is *offering* to get the passengers where they want to go.  When presenting offers to your customers, you should always show the full name of the operating carrier of each segment (&#x60;slices[].segments[].operating_carrier.name&#x60;). This must be displayed prominently on the first screen where the offer is presented in order to comply with [US regulations](https://www.ecfr.gov/cgi-bin/text-idx?SID&#x3D;8e736a5c813a737a5c2f6700a4c9006d&amp;mc&#x3D;true&amp;node&#x3D;pt14.4.257&amp;rgn&#x3D;div5). 
     * <p><b>200</b> - An offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param contentType All request bodies sent to the API should be in JSON format. A &#x60;Content-Type&#x60; header is required whenever you&#39;re sending a request body (i.e. for POST and PUT requests).
     * @param returnOffers When set to &#x60;true&#x60;, the offer request resource returned will include _all_ the &#x60;offer&#x60;s returned by the airlines. If set to &#x60;false&#x60;, the offer request resource won&#39;t include any &#x60;offer&#x60;s. To retrieve the associated offers later, use the [List Offers](/docs/api/offers/get-offers) endpoint, specifying the &#x60;offer_request_id&#x60;. You should use this option if you want to take advantage of the pagination, sorting and filtering that the [List Offers](/docs/api/offers/get-offers) endpoint provides. 
     * @param supplierTimeout The maximum amount of time in milliseconds to wait for each airline to respond. This timeout only applies to the [response time](/docs/api/overview/response-times) of the call to the airline and doesn&#39;t include additional overhead added by Duffel. Value should be between 2 seconds and 60 seconds. Any values outside the range will be ignored and the default &#x60;supplier_timeout&#x60; will be used. If a value is set, the response will only include offers from airlines that returned within the given time. If a value is not set, the response will only include offers from airlines that returned within the default &#x60;supplier_timeout&#x60; value of 20 seconds. We recommend setting &#x60;supplier_timeout&#x60; lower than the timeout on the request sent to Duffel API as that will allow us to respond with the offers we received before your request times out with an empty response. 
     * @param createOfferRequestRequest The createOfferRequestRequest parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createOfferRequestWithResponseSpec(String accept, String duffelVersion, String acceptEncoding, String contentType, Boolean returnOffers, Integer supplierTimeout, CreateOfferRequestRequest createOfferRequestRequest) throws WebClientResponseException {
        return createOfferRequestRequestCreation(accept, duffelVersion, acceptEncoding, contentType, returnOffers, supplierTimeout, createOfferRequestRequest);
    }
    /**
     * Get a single offer request
     * Retrieves an offer request by its ID
     * <p><b>200</b> - A single offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOfferRequestByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOfferRequestById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return apiClient.invokeAPI("/air/offer_requests/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single offer request
     * Retrieves an offer request by its ID
     * <p><b>200</b> - A single offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOfferRequestById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequestById200Response> getOfferRequestById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getOfferRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    /**
     * Get a single offer request
     * Retrieves an offer request by its ID
     * <p><b>200</b> - A single offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ResponseEntity&lt;GetOfferRequestById200Response&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GetOfferRequestById200Response>> getOfferRequestByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequestById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequestById200Response>() {};
        return getOfferRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }

    /**
     * Get a single offer request
     * Retrieves an offer request by its ID
     * <p><b>200</b> - A single offer request
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getOfferRequestByIdWithResponseSpec(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        return getOfferRequestByIdRequestCreation(accept, duffelVersion, id, acceptEncoding);
    }
    /**
     * List offer requests
     * Retrieves a paginated list of your offer requests. The results may be returned in any order.
     * <p><b>200</b> - A paginated list of offer requests
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @return GetOfferRequests200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOfferRequestsRequestCreation(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOfferRequests", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOfferRequests", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferRequests200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequests200Response>() {};
        return apiClient.invokeAPI("/air/offer_requests", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List offer requests
     * Retrieves a paginated list of your offer requests. The results may be returned in any order.
     * <p><b>200</b> - A paginated list of offer requests
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @return GetOfferRequests200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferRequests200Response> getOfferRequests(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequests200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequests200Response>() {};
        return getOfferRequestsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit).bodyToMono(localVarReturnType);
    }

    /**
     * List offer requests
     * Retrieves a paginated list of your offer requests. The results may be returned in any order.
     * <p><b>200</b> - A paginated list of offer requests
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @return ResponseEntity&lt;GetOfferRequests200Response&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GetOfferRequests200Response>> getOfferRequestsWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferRequests200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferRequests200Response>() {};
        return getOfferRequestsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit).toEntity(localVarReturnType);
    }

    /**
     * List offer requests
     * Retrieves a paginated list of your offer requests. The results may be returned in any order.
     * <p><b>200</b> - A paginated list of offer requests
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getOfferRequestsWithResponseSpec(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        return getOfferRequestsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit);
    }
}
