package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.GetOfferById200Response;
import com.duffel.sdk.model.GetOffers200Response;
import com.duffel.sdk.model.UpdateOfferPassengerById200Response;
import com.duffel.sdk.model.UpdateOfferPassengerByIdRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OffersApi {
    private ApiClient apiClient;

    public OffersApi() {
        this(new ApiClient());
    }

    @Autowired
    public OffersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get a single offer
     * You should use this API to get the complete, up-to-date information about an offer. This endpoint **does not** guarantee that the offer will be available at the time of booking.  Due to limitations in airlines&#39; systems, you may see changes to the offer (e.g a changed &#x60;total_amount&#x60;). Additionally, you may receive information that may have not been included in the original offer such as baggage allowances.  Optionally, you can request information about additional &#x60;available_services&#x60; that you can book with this offer by specifying the &#x60;return_available_services&#x60; query parameter. 
     * <p><b>200</b> - A single offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param returnAvailableServices When set to &#x60;true&#x60;, the offer resource returned will include all the &#x60;available_services&#x60; returned by the airline. If set to false, the offer resource won&#39;t include any &#x60;available_services&#x60;. 
     * @return GetOfferById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOfferByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "return_available_services", returnAvailableServices));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferById200Response>() {};
        return apiClient.invokeAPI("/air/offers/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single offer
     * You should use this API to get the complete, up-to-date information about an offer. This endpoint **does not** guarantee that the offer will be available at the time of booking.  Due to limitations in airlines&#39; systems, you may see changes to the offer (e.g a changed &#x60;total_amount&#x60;). Additionally, you may receive information that may have not been included in the original offer such as baggage allowances.  Optionally, you can request information about additional &#x60;available_services&#x60; that you can book with this offer by specifying the &#x60;return_available_services&#x60; query parameter. 
     * <p><b>200</b> - A single offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param returnAvailableServices When set to &#x60;true&#x60;, the offer resource returned will include all the &#x60;available_services&#x60; returned by the airline. If set to false, the offer resource won&#39;t include any &#x60;available_services&#x60;. 
     * @return GetOfferById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOfferById200Response> getOfferById(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferById200Response>() {};
        return getOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, returnAvailableServices).bodyToMono(localVarReturnType);
    }

    /**
     * Get a single offer
     * You should use this API to get the complete, up-to-date information about an offer. This endpoint **does not** guarantee that the offer will be available at the time of booking.  Due to limitations in airlines&#39; systems, you may see changes to the offer (e.g a changed &#x60;total_amount&#x60;). Additionally, you may receive information that may have not been included in the original offer such as baggage allowances.  Optionally, you can request information about additional &#x60;available_services&#x60; that you can book with this offer by specifying the &#x60;return_available_services&#x60; query parameter. 
     * <p><b>200</b> - A single offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param returnAvailableServices When set to &#x60;true&#x60;, the offer resource returned will include all the &#x60;available_services&#x60; returned by the airline. If set to false, the offer resource won&#39;t include any &#x60;available_services&#x60;. 
     * @return ResponseEntity&lt;GetOfferById200Response&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GetOfferById200Response>> getOfferByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        ParameterizedTypeReference<GetOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOfferById200Response>() {};
        return getOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, returnAvailableServices).toEntity(localVarReturnType);
    }

    /**
     * Get a single offer
     * You should use this API to get the complete, up-to-date information about an offer. This endpoint **does not** guarantee that the offer will be available at the time of booking.  Due to limitations in airlines&#39; systems, you may see changes to the offer (e.g a changed &#x60;total_amount&#x60;). Additionally, you may receive information that may have not been included in the original offer such as baggage allowances.  Optionally, you can request information about additional &#x60;available_services&#x60; that you can book with this offer by specifying the &#x60;return_available_services&#x60; query parameter. 
     * <p><b>200</b> - A single offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param returnAvailableServices When set to &#x60;true&#x60;, the offer resource returned will include all the &#x60;available_services&#x60; returned by the airline. If set to false, the offer resource won&#39;t include any &#x60;available_services&#x60;. 
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getOfferByIdWithResponseSpec(String accept, String duffelVersion, String id, String acceptEncoding, Boolean returnAvailableServices) throws WebClientResponseException {
        return getOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, returnAvailableServices);
    }
    /**
     * List offers
     * Retrieves a list of offers for a given offer request specified by its ID. Unless you specify a &#x60;sort&#x60; parameter, the results may be returned in any order.  This endpoint does not return the complete, up-to-date information on each offer. The [Get a single offer](/docs/api/offers/get-offer-by-id) endpoint should be called for a given offer in order to get complete and up-to-date information. 
     * <p><b>200</b> - A paginated list of offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerRequestId Duffel&#39;s unique identifier for the offer request, returned when it was created 
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return GetOffers200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOffersRequestCreation(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOffers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOffers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'offerRequestId' is set
        if (offerRequestId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerRequestId' when calling getOffers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "offer_request_id", offerRequestId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "sort", sort));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "max_connections", maxConnections));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOffers200Response> localVarReturnType = new ParameterizedTypeReference<GetOffers200Response>() {};
        return apiClient.invokeAPI("/air/offers", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List offers
     * Retrieves a list of offers for a given offer request specified by its ID. Unless you specify a &#x60;sort&#x60; parameter, the results may be returned in any order.  This endpoint does not return the complete, up-to-date information on each offer. The [Get a single offer](/docs/api/offers/get-offer-by-id) endpoint should be called for a given offer in order to get complete and up-to-date information. 
     * <p><b>200</b> - A paginated list of offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerRequestId Duffel&#39;s unique identifier for the offer request, returned when it was created 
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return GetOffers200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOffers200Response> getOffers(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOffers200Response> localVarReturnType = new ParameterizedTypeReference<GetOffers200Response>() {};
        return getOffersRequestCreation(accept, duffelVersion, offerRequestId, acceptEncoding, after, before, limit, sort, maxConnections).bodyToMono(localVarReturnType);
    }

    /**
     * List offers
     * Retrieves a list of offers for a given offer request specified by its ID. Unless you specify a &#x60;sort&#x60; parameter, the results may be returned in any order.  This endpoint does not return the complete, up-to-date information on each offer. The [Get a single offer](/docs/api/offers/get-offer-by-id) endpoint should be called for a given offer in order to get complete and up-to-date information. 
     * <p><b>200</b> - A paginated list of offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerRequestId Duffel&#39;s unique identifier for the offer request, returned when it was created 
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return ResponseEntity&lt;GetOffers200Response&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GetOffers200Response>> getOffersWithHttpInfo(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOffers200Response> localVarReturnType = new ParameterizedTypeReference<GetOffers200Response>() {};
        return getOffersRequestCreation(accept, duffelVersion, offerRequestId, acceptEncoding, after, before, limit, sort, maxConnections).toEntity(localVarReturnType);
    }

    /**
     * List offers
     * Retrieves a list of offers for a given offer request specified by its ID. Unless you specify a &#x60;sort&#x60; parameter, the results may be returned in any order.  This endpoint does not return the complete, up-to-date information on each offer. The [Get a single offer](/docs/api/offers/get-offer-by-id) endpoint should be called for a given offer in order to get complete and up-to-date information. 
     * <p><b>200</b> - A paginated list of offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerRequestId Duffel&#39;s unique identifier for the offer request, returned when it was created 
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getOffersWithResponseSpec(String accept, String duffelVersion, String offerRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        return getOffersRequestCreation(accept, duffelVersion, offerRequestId, acceptEncoding, after, before, limit, sort, maxConnections);
    }
    /**
     * Update a single offer passenger
     * Some offer passenger fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single offer passenger
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId Duffel&#39;s unique identifier for the __Offer__
     * @param offerPassengerId Duffel&#39;s unique identifier for the __Offer Passenger__
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOfferPassengerByIdRequest The updateOfferPassengerByIdRequest parameter
     * @return UpdateOfferPassengerById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateOfferPassengerByIdRequestCreation(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        Object postBody = updateOfferPassengerByIdRequest;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'offerId' is set
        if (offerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerId' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'offerPassengerId' is set
        if (offerPassengerId == null) {
            throw new WebClientResponseException("Missing the required parameter 'offerPassengerId' when calling updateOfferPassengerById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("offer_id", offerId);
        pathParams.put("offer_passenger_id", offerPassengerId);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<UpdateOfferPassengerById200Response> localVarReturnType = new ParameterizedTypeReference<UpdateOfferPassengerById200Response>() {};
        return apiClient.invokeAPI("/air/offers/{offer_id}/passengers/{offer_passenger_id}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a single offer passenger
     * Some offer passenger fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single offer passenger
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId Duffel&#39;s unique identifier for the __Offer__
     * @param offerPassengerId Duffel&#39;s unique identifier for the __Offer Passenger__
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOfferPassengerByIdRequest The updateOfferPassengerByIdRequest parameter
     * @return UpdateOfferPassengerById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateOfferPassengerById200Response> updateOfferPassengerById(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateOfferPassengerById200Response> localVarReturnType = new ParameterizedTypeReference<UpdateOfferPassengerById200Response>() {};
        return updateOfferPassengerByIdRequestCreation(accept, duffelVersion, offerId, offerPassengerId, acceptEncoding, updateOfferPassengerByIdRequest).bodyToMono(localVarReturnType);
    }

    /**
     * Update a single offer passenger
     * Some offer passenger fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single offer passenger
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId Duffel&#39;s unique identifier for the __Offer__
     * @param offerPassengerId Duffel&#39;s unique identifier for the __Offer Passenger__
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOfferPassengerByIdRequest The updateOfferPassengerByIdRequest parameter
     * @return ResponseEntity&lt;UpdateOfferPassengerById200Response&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpdateOfferPassengerById200Response>> updateOfferPassengerByIdWithHttpInfo(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateOfferPassengerById200Response> localVarReturnType = new ParameterizedTypeReference<UpdateOfferPassengerById200Response>() {};
        return updateOfferPassengerByIdRequestCreation(accept, duffelVersion, offerId, offerPassengerId, acceptEncoding, updateOfferPassengerByIdRequest).toEntity(localVarReturnType);
    }

    /**
     * Update a single offer passenger
     * Some offer passenger fields are updateable. Each field that can be updated is detailed in the request object. 
     * <p><b>200</b> - A single offer passenger
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param offerId Duffel&#39;s unique identifier for the __Offer__
     * @param offerPassengerId Duffel&#39;s unique identifier for the __Offer Passenger__
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param updateOfferPassengerByIdRequest The updateOfferPassengerByIdRequest parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateOfferPassengerByIdWithResponseSpec(String accept, String duffelVersion, String offerId, String offerPassengerId, String acceptEncoding, UpdateOfferPassengerByIdRequest updateOfferPassengerByIdRequest) throws WebClientResponseException {
        return updateOfferPassengerByIdRequestCreation(accept, duffelVersion, offerId, offerPassengerId, acceptEncoding, updateOfferPassengerByIdRequest);
    }
}
