package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;

import com.duffel.sdk.model.GetOrderChangeOfferById200Response;
import com.duffel.sdk.model.GetOrderChangeOffersByOrderChangeRequestId200Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OrderChangeOffersApi {
    private ApiClient apiClient;

    public OrderChangeOffersApi() {
        this(new ApiClient());
    }

    @Autowired
    public OrderChangeOffersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get a single order change offer
     * Retrieves an order change offer by its ID
     * <p><b>200</b> - A single order change offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderChangeOfferById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderChangeOfferByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderChangeOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderChangeOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOrderChangeOfferById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("id", id);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderChangeOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOfferById200Response>() {};
        return apiClient.invokeAPI("/air/order_change_offers/{id}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get a single order change offer
     * Retrieves an order change offer by its ID
     * <p><b>200</b> - A single order change offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return GetOrderChangeOfferById200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderChangeOfferById200Response> getOrderChangeOfferById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOfferById200Response>() {};
        return getOrderChangeOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono(localVarReturnType);
    }

    /**
     * Get a single order change offer
     * Retrieves an order change offer by its ID
     * <p><b>200</b> - A single order change offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ResponseEntity&lt;GetOrderChangeOfferById200Response&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GetOrderChangeOfferById200Response>> getOrderChangeOfferByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeOfferById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOfferById200Response>() {};
        return getOrderChangeOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity(localVarReturnType);
    }

    /**
     * Get a single order change offer
     * Retrieves an order change offer by its ID
     * <p><b>200</b> - A single order change offer
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param id Duffel&#39;s unique identifier for the order change offer
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getOrderChangeOfferByIdWithResponseSpec(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        return getOrderChangeOfferByIdRequestCreation(accept, duffelVersion, id, acceptEncoding);
    }
    /**
     * List order change offers
     * Returns a list of order change offers for a given order change requestID
     * <p><b>200</b> - A paginated list of order change offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param orderChangeRequestId Duffel&#39;s unique identifier for the order change request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;change_total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-change_total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return GetOrderChangeOffersByOrderChangeRequestId200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getOrderChangeOffersByOrderChangeRequestIdRequestCreation(String accept, String duffelVersion, String orderChangeRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'accept' is set
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderChangeOffersByOrderChangeRequestId", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'duffelVersion' is set
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderChangeOffersByOrderChangeRequestId", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'orderChangeRequestId' is set
        if (orderChangeRequestId == null) {
            throw new WebClientResponseException("Missing the required parameter 'orderChangeRequestId' when calling getOrderChangeOffersByOrderChangeRequestId", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "order_change_request_id", orderChangeRequestId));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "sort", sort));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "max_connections", maxConnections));

        if (acceptEncoding != null)
        headerParams.add("Accept-Encoding", apiClient.parameterToString(acceptEncoding));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        if (duffelVersion != null)
        headerParams.add("Duffel-Version", apiClient.parameterToString(duffelVersion));
        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "bearerAuth" };

        ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response>() {};
        return apiClient.invokeAPI("/air/order_change_offers", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List order change offers
     * Returns a list of order change offers for a given order change requestID
     * <p><b>200</b> - A paginated list of order change offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param orderChangeRequestId Duffel&#39;s unique identifier for the order change request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;change_total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-change_total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return GetOrderChangeOffersByOrderChangeRequestId200Response
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GetOrderChangeOffersByOrderChangeRequestId200Response> getOrderChangeOffersByOrderChangeRequestId(String accept, String duffelVersion, String orderChangeRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response>() {};
        return getOrderChangeOffersByOrderChangeRequestIdRequestCreation(accept, duffelVersion, orderChangeRequestId, acceptEncoding, after, before, limit, sort, maxConnections).bodyToMono(localVarReturnType);
    }

    /**
     * List order change offers
     * Returns a list of order change offers for a given order change requestID
     * <p><b>200</b> - A paginated list of order change offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param orderChangeRequestId Duffel&#39;s unique identifier for the order change request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;change_total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-change_total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return ResponseEntity&lt;GetOrderChangeOffersByOrderChangeRequestId200Response&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GetOrderChangeOffersByOrderChangeRequestId200Response>> getOrderChangeOffersByOrderChangeRequestIdWithHttpInfo(String accept, String duffelVersion, String orderChangeRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderChangeOffersByOrderChangeRequestId200Response>() {};
        return getOrderChangeOffersByOrderChangeRequestIdRequestCreation(accept, duffelVersion, orderChangeRequestId, acceptEncoding, after, before, limit, sort, maxConnections).toEntity(localVarReturnType);
    }

    /**
     * List order change offers
     * Returns a list of order change offers for a given order change requestID
     * <p><b>200</b> - A paginated list of order change offers
     * @param accept All responses from the API are in JSON format with UTF-8 encoding. An &#x60;Accept&#x60; header is required with every request.
     * @param duffelVersion You&#39;ll need to send a &#x60;Duffel-Version&#x60; header with each request so we know which version of the API you want to use. Currently, the only available API version is &#x60;beta&#x60;.
     * @param orderChangeRequestId Duffel&#39;s unique identifier for the order change request
     * @param acceptEncoding We recommend enabling compression for responses returned by the API, since they can be very large. To enable compression, send an &#x60;Accept-Encoding&#x60; header. You&#39;ll need to configure your HTTP client to decompress responses. Most clients will have this functionality built-in.
     * @param after A cursor pointing to the previous page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param before A cursor pointing to the next page of records. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param limit The maximum number of records to return per page. Defaults to &#x60;50&#x60;.  May be set to any integer between &#x60;1&#x60; and &#x60;200&#x60;. For more information on how to paginate through records, see the [Pagination](/docs/api/overview/pagination) section. 
     * @param sort By default, the offers will be returned sorted by ID in ascending order. This parameter allows you to sort the list of offers by &#x60;change_total_amount&#x60; or &#x60;total_duration&#x60;. By default the sorting order will be ascending, if you wish to sort in descending order a &#x60;-&#x60; will need to be prepended to the sorting attribute (i.e: &#x60;-change_total_amount&#x60;). 
     * @param maxConnections Allows to filter the offers list by the maximum number of connections in a given offer. e.g. a return flight with three flights outbound and a direct inbound flight would be filtered out if &#x60;max_connections&#x3D;1&#x60; was passed. 
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getOrderChangeOffersByOrderChangeRequestIdWithResponseSpec(String accept, String duffelVersion, String orderChangeRequestId, String acceptEncoding, String after, String before, Integer limit, String sort, Integer maxConnections) throws WebClientResponseException {
        return getOrderChangeOffersByOrderChangeRequestIdRequestCreation(accept, duffelVersion, orderChangeRequestId, acceptEncoding, after, before, limit, sort, maxConnections);
    }
}
