/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.CreateOrderRequestDataPaymentsInner;
import com.duffel.sdk.model.OrderRequestPassenger;
import com.duffel.sdk.model.OrderRequestService;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateOrderRequestData
 */
@JsonPropertyOrder({
  CreateOrderRequestData.JSON_PROPERTY_METADATA,
  CreateOrderRequestData.JSON_PROPERTY_PASSENGERS,
  CreateOrderRequestData.JSON_PROPERTY_PAYMENTS,
  CreateOrderRequestData.JSON_PROPERTY_SELECTED_OFFERS,
  CreateOrderRequestData.JSON_PROPERTY_SERVICES,
  CreateOrderRequestData.JSON_PROPERTY_TYPE
})
@JsonTypeName("createOrder_request_data")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class CreateOrderRequestData {
  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Object metadata;

  public static final String JSON_PROPERTY_PASSENGERS = "passengers";
  private List<OrderRequestPassenger> passengers = new ArrayList<>();

  public static final String JSON_PROPERTY_PAYMENTS = "payments";
  private List<CreateOrderRequestDataPaymentsInner> payments = new ArrayList<>();

  public static final String JSON_PROPERTY_SELECTED_OFFERS = "selected_offers";
  private List<String> selectedOffers = new ArrayList<>();

  public static final String JSON_PROPERTY_SERVICES = "services";
  private List<OrderRequestService> services;

  /**
   * The type of order. You can only use &#x60;hold&#x60; with offers where &#x60;payment_requirements.requires_instant_payment&#x60; is &#x60;false&#x60;.  When booking an offer with type &#x60;hold&#x60;, do not specify &#x60;payments&#x60; or &#x60;services&#x60; keys. 
   */
  public enum TypeEnum {
    INSTANT("instant"),
    
    HOLD("hold");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public CreateOrderRequestData() {
  }

  public CreateOrderRequestData metadata(Object metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Metadata contains a set of key-value pairs that you can attach to an object. It can be useful for storing additional information about the object, in a structured format. Duffel does not use this information. You should not store sensitive information in this field.  The metadata is a collection of key-value pairs, both of which are strings. You can store a maximum of 50 key-value pairs, where each key has a maximum length of 40 characters and each value has a maximum length of 500 characters.  Keys must only contain numbers, letters, dashes, or underscores. 
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  public CreateOrderRequestData passengers(List<OrderRequestPassenger> passengers) {
    
    this.passengers = passengers;
    return this;
  }

  public CreateOrderRequestData addPassengersItem(OrderRequestPassenger passengersItem) {
    if (this.passengers == null) {
      this.passengers = new ArrayList<>();
    }
    this.passengers.add(passengersItem);
    return this;
  }

   /**
   * The personal details of the passengers, expanding on the information initially provided when creating the offer request
   * @return passengers
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OrderRequestPassenger> getPassengers() {
    return passengers;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPassengers(List<OrderRequestPassenger> passengers) {
    this.passengers = passengers;
  }


  public CreateOrderRequestData payments(List<CreateOrderRequestDataPaymentsInner> payments) {
    
    this.payments = payments;
    return this;
  }

  public CreateOrderRequestData addPaymentsItem(CreateOrderRequestDataPaymentsInner paymentsItem) {
    if (this.payments == null) {
      this.payments = new ArrayList<>();
    }
    this.payments.add(paymentsItem);
    return this;
  }

   /**
   * The payment details to use to pay for the order. This key should be omitted when the order’s &#x60;type&#x60; is &#x60;hold&#x60;.
   * @return payments
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<CreateOrderRequestDataPaymentsInner> getPayments() {
    return payments;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayments(List<CreateOrderRequestDataPaymentsInner> payments) {
    this.payments = payments;
  }


  public CreateOrderRequestData selectedOffers(List<String> selectedOffers) {
    
    this.selectedOffers = selectedOffers;
    return this;
  }

  public CreateOrderRequestData addSelectedOffersItem(String selectedOffersItem) {
    if (this.selectedOffers == null) {
      this.selectedOffers = new ArrayList<>();
    }
    this.selectedOffers.add(selectedOffersItem);
    return this;
  }

   /**
   * The &#x60;id&#x60;s of the offers you want to book. You must specify an array containing exactly one selected offer.  Note that you can only book one offer per offer request. 
   * @return selectedOffers
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SELECTED_OFFERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getSelectedOffers() {
    return selectedOffers;
  }


  @JsonProperty(JSON_PROPERTY_SELECTED_OFFERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSelectedOffers(List<String> selectedOffers) {
    this.selectedOffers = selectedOffers;
  }


  public CreateOrderRequestData services(List<OrderRequestService> services) {
    
    this.services = services;
    return this;
  }

  public CreateOrderRequestData addServicesItem(OrderRequestService servicesItem) {
    if (this.services == null) {
      this.services = new ArrayList<>();
    }
    this.services.add(servicesItem);
    return this;
  }

   /**
   * The services you want to book along with the first selected offer. This key should be omitted when the order’s type is &#x60;hold&#x60;, as we do not support services for &#x60;hold&#x60; orders yet.
   * @return services
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderRequestService> getServices() {
    return services;
  }


  @JsonProperty(JSON_PROPERTY_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setServices(List<OrderRequestService> services) {
    this.services = services;
  }


  public CreateOrderRequestData type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of order. You can only use &#x60;hold&#x60; with offers where &#x60;payment_requirements.requires_instant_payment&#x60; is &#x60;false&#x60;.  When booking an offer with type &#x60;hold&#x60;, do not specify &#x60;payments&#x60; or &#x60;services&#x60; keys. 
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateOrderRequestData createOrderRequestData = (CreateOrderRequestData) o;
    return Objects.equals(this.metadata, createOrderRequestData.metadata) &&
        Objects.equals(this.passengers, createOrderRequestData.passengers) &&
        Objects.equals(this.payments, createOrderRequestData.payments) &&
        Objects.equals(this.selectedOffers, createOrderRequestData.selectedOffers) &&
        Objects.equals(this.services, createOrderRequestData.services) &&
        Objects.equals(this.type, createOrderRequestData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metadata, passengers, payments, selectedOffers, services, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateOrderRequestData {\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    passengers: ").append(toIndentedString(passengers)).append("\n");
    sb.append("    payments: ").append(toIndentedString(payments)).append("\n");
    sb.append("    selectedOffers: ").append(toIndentedString(selectedOffers)).append("\n");
    sb.append("    services: ").append(toIndentedString(services)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

