/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferConditions1;
import com.duffel.sdk.model.OfferIndexOwner;
import com.duffel.sdk.model.OfferIndexPaymentRequirements;
import com.duffel.sdk.model.OfferPassenger;
import com.duffel.sdk.model.OfferService;
import com.duffel.sdk.model.OfferSlice;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Offer
 */
@JsonPropertyOrder({
  Offer.JSON_PROPERTY_ALLOWED_PASSENGER_IDENTITY_DOCUMENT_TYPES,
  Offer.JSON_PROPERTY_AVAILABLE_SERVICES,
  Offer.JSON_PROPERTY_BASE_AMOUNT,
  Offer.JSON_PROPERTY_BASE_CURRENCY,
  Offer.JSON_PROPERTY_CONDITIONS,
  Offer.JSON_PROPERTY_CREATED_AT,
  Offer.JSON_PROPERTY_EXPIRES_AT,
  Offer.JSON_PROPERTY_ID,
  Offer.JSON_PROPERTY_LIVE_MODE,
  Offer.JSON_PROPERTY_OWNER,
  Offer.JSON_PROPERTY_PARTIAL,
  Offer.JSON_PROPERTY_PASSENGER_IDENTITY_DOCUMENTS_REQUIRED,
  Offer.JSON_PROPERTY_PASSENGERS,
  Offer.JSON_PROPERTY_PAYMENT_REQUIREMENTS,
  Offer.JSON_PROPERTY_SLICES,
  Offer.JSON_PROPERTY_TAX_AMOUNT,
  Offer.JSON_PROPERTY_TAX_CURRENCY,
  Offer.JSON_PROPERTY_TOTAL_AMOUNT,
  Offer.JSON_PROPERTY_TOTAL_CURRENCY,
  Offer.JSON_PROPERTY_TOTAL_EMISSIONS_KG,
  Offer.JSON_PROPERTY_UPDATED_AT
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class Offer {
  /**
   * Gets or Sets allowedPassengerIdentityDocumentTypes
   */
  public enum AllowedPassengerIdentityDocumentTypesEnum {
    PASSPORT("passport");

    private String value;

    AllowedPassengerIdentityDocumentTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AllowedPassengerIdentityDocumentTypesEnum fromValue(String value) {
      for (AllowedPassengerIdentityDocumentTypesEnum b : AllowedPassengerIdentityDocumentTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ALLOWED_PASSENGER_IDENTITY_DOCUMENT_TYPES = "allowed_passenger_identity_document_types";
  private List<AllowedPassengerIdentityDocumentTypesEnum> allowedPassengerIdentityDocumentTypes;

  public static final String JSON_PROPERTY_AVAILABLE_SERVICES = "available_services";
  private List<OfferService> availableServices;

  public static final String JSON_PROPERTY_BASE_AMOUNT = "base_amount";
  private String baseAmount;

  public static final String JSON_PROPERTY_BASE_CURRENCY = "base_currency";
  private String baseCurrency;

  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private OfferConditions1 conditions;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private java.time.LocalDateTime createdAt;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
  private java.time.LocalDateTime expiresAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private OfferIndexOwner owner;

  public static final String JSON_PROPERTY_PARTIAL = "partial";
  private Boolean partial;

  public static final String JSON_PROPERTY_PASSENGER_IDENTITY_DOCUMENTS_REQUIRED = "passenger_identity_documents_required";
  private Boolean passengerIdentityDocumentsRequired;

  public static final String JSON_PROPERTY_PASSENGERS = "passengers";
  private List<OfferPassenger> passengers;

  public static final String JSON_PROPERTY_PAYMENT_REQUIREMENTS = "payment_requirements";
  private OfferIndexPaymentRequirements paymentRequirements;

  public static final String JSON_PROPERTY_SLICES = "slices";
  private List<OfferSlice> slices;

  public static final String JSON_PROPERTY_TAX_AMOUNT = "tax_amount";
  private JsonNullable<String> taxAmount = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TAX_CURRENCY = "tax_currency";
  private JsonNullable<String> taxCurrency = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
  private String totalAmount;

  public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
  private String totalCurrency;

  public static final String JSON_PROPERTY_TOTAL_EMISSIONS_KG = "total_emissions_kg";
  private String totalEmissionsKg;

  public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
  private java.time.LocalDateTime updatedAt;

  public Offer() {
  }

  public Offer allowedPassengerIdentityDocumentTypes(List<AllowedPassengerIdentityDocumentTypesEnum> allowedPassengerIdentityDocumentTypes) {
    
    this.allowedPassengerIdentityDocumentTypes = allowedPassengerIdentityDocumentTypes;
    return this;
  }

  public Offer addAllowedPassengerIdentityDocumentTypesItem(AllowedPassengerIdentityDocumentTypesEnum allowedPassengerIdentityDocumentTypesItem) {
    if (this.allowedPassengerIdentityDocumentTypes == null) {
      this.allowedPassengerIdentityDocumentTypes = new ArrayList<>();
    }
    this.allowedPassengerIdentityDocumentTypes.add(allowedPassengerIdentityDocumentTypesItem);
    return this;
  }

   /**
   * The types of identity documents that may be provided for the passengers when creating an order based on this offer. Currently, the only supported type is &#x60;passport&#x60;. If this is &#x60;[]&#x60;, then you must not provide identity documents.
   * @return allowedPassengerIdentityDocumentTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALLOWED_PASSENGER_IDENTITY_DOCUMENT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AllowedPassengerIdentityDocumentTypesEnum> getAllowedPassengerIdentityDocumentTypes() {
    return allowedPassengerIdentityDocumentTypes;
  }


  @JsonProperty(JSON_PROPERTY_ALLOWED_PASSENGER_IDENTITY_DOCUMENT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowedPassengerIdentityDocumentTypes(List<AllowedPassengerIdentityDocumentTypesEnum> allowedPassengerIdentityDocumentTypes) {
    this.allowedPassengerIdentityDocumentTypes = allowedPassengerIdentityDocumentTypes;
  }


  public Offer availableServices(List<OfferService> availableServices) {
    
    this.availableServices = availableServices;
    return this;
  }

  public Offer addAvailableServicesItem(OfferService availableServicesItem) {
    if (this.availableServices == null) {
      this.availableServices = new ArrayList<>();
    }
    this.availableServices.add(availableServicesItem);
    return this;
  }

   /**
   * The services that can be booked along with the offer but are not included by default, for example an additional checked bag. This field is only returned in the [Get single offer](/docs/api/offers/get-offer-by-id) endpoint. When there are no services available, or we don&#39;t support services for the airline, this list will be empty. If you want to know which airlines we support services for, please get in touch with the Duffel support team at &lt;help@duffel.com&gt;.
   * @return availableServices
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AVAILABLE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferService> getAvailableServices() {
    return availableServices;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_SERVICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableServices(List<OfferService> availableServices) {
    this.availableServices = availableServices;
  }


  public Offer baseAmount(String baseAmount) {
    
    this.baseAmount = baseAmount;
    return this;
  }

   /**
   * The base price of the offer for all passengers, excluding taxes. It does not include the base amount of any service(s) that might be booked with the offer.
   * @return baseAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBaseAmount() {
    return baseAmount;
  }


  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseAmount(String baseAmount) {
    this.baseAmount = baseAmount;
  }


  public Offer baseCurrency(String baseCurrency) {
    
    this.baseCurrency = baseCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;base_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return baseCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BASE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBaseCurrency() {
    return baseCurrency;
  }


  @JsonProperty(JSON_PROPERTY_BASE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseCurrency(String baseCurrency) {
    this.baseCurrency = baseCurrency;
  }


  public Offer conditions(OfferConditions1 conditions) {
    
    this.conditions = conditions;
    return this;
  }

   /**
   * Get conditions
   * @return conditions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferConditions1 getConditions() {
    return conditions;
  }


  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConditions(OfferConditions1 conditions) {
    this.conditions = conditions;
  }


  public Offer createdAt(java.time.LocalDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was created
   * @return createdAt
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(java.time.LocalDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Offer expiresAt(java.time.LocalDateTime expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime expiry of the offer before which the traveller should use this offer to create an order. After this time the offer can no longer be used to create an order.
   * @return expiresAt
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(java.time.LocalDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }


  public Offer id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the offer
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public Offer liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the offer request was created in live mode. This field will be set to &#x60;true&#x60; if the offer request was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public Offer owner(OfferIndexOwner owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferIndexOwner getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(OfferIndexOwner owner) {
    this.owner = owner;
  }


  public Offer partial(Boolean partial) {
    
    this.partial = partial;
    return this;
  }

   /**
   * Partial offers are a new concept we&#39;re introducing as a part of a new multi-step search flow that we&#39;re currently experimenting with. A partial offer can&#39;t be booked directly, but it can be combined with other partial offers to form a full offer. Partial offers are only ever returned through the multi-step search flow. So there&#39;s no need to add any handling to deal with partial offers if you&#39;re using the traditional &#x60;OfferRequest&#x60; search flow to create offers. 
   * @return partial
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PARTIAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPartial() {
    return partial;
  }


  @JsonProperty(JSON_PROPERTY_PARTIAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartial(Boolean partial) {
    this.partial = partial;
  }


  public Offer passengerIdentityDocumentsRequired(Boolean passengerIdentityDocumentsRequired) {
    
    this.passengerIdentityDocumentsRequired = passengerIdentityDocumentsRequired;
    return this;
  }

   /**
   * Whether identity documents must be provided for each of the passengers when creating an order based on this offer. If this is &#x60;true&#x60;, you must provide an identity document for every passenger.
   * @return passengerIdentityDocumentsRequired
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PASSENGER_IDENTITY_DOCUMENTS_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPassengerIdentityDocumentsRequired() {
    return passengerIdentityDocumentsRequired;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGER_IDENTITY_DOCUMENTS_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengerIdentityDocumentsRequired(Boolean passengerIdentityDocumentsRequired) {
    this.passengerIdentityDocumentsRequired = passengerIdentityDocumentsRequired;
  }


  public Offer passengers(List<OfferPassenger> passengers) {
    
    this.passengers = passengers;
    return this;
  }

  public Offer addPassengersItem(OfferPassenger passengersItem) {
    if (this.passengers == null) {
      this.passengers = new ArrayList<>();
    }
    this.passengers.add(passengersItem);
    return this;
  }

   /**
   * The passengers included in the offer
   * @return passengers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferPassenger> getPassengers() {
    return passengers;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengers(List<OfferPassenger> passengers) {
    this.passengers = passengers;
  }


  public Offer paymentRequirements(OfferIndexPaymentRequirements paymentRequirements) {
    
    this.paymentRequirements = paymentRequirements;
    return this;
  }

   /**
   * Get paymentRequirements
   * @return paymentRequirements
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIREMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OfferIndexPaymentRequirements getPaymentRequirements() {
    return paymentRequirements;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIREMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentRequirements(OfferIndexPaymentRequirements paymentRequirements) {
    this.paymentRequirements = paymentRequirements;
  }


  public Offer slices(List<OfferSlice> slices) {
    
    this.slices = slices;
    return this;
  }

  public Offer addSlicesItem(OfferSlice slicesItem) {
    if (this.slices == null) {
      this.slices = new ArrayList<>();
    }
    this.slices.add(slicesItem);
    return this;
  }

   /**
   * The [slices](/docs/api/overview/key-principles) that make up this offer. Each slice will include one or more [segments](/docs/api/overview/key-principles), the specific flights that the airline is offering to take the passengers from the slice&#39;s &#x60;origin&#x60; to its &#x60;destination&#x60;. [Partial](#offers-schema-partial) offers contain a single slice as each partial offer is for a particular slice of the journey.
   * @return slices
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferSlice> getSlices() {
    return slices;
  }


  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSlices(List<OfferSlice> slices) {
    this.slices = slices;
  }


  public Offer taxAmount(String taxAmount) {
    this.taxAmount = JsonNullable.<String>of(taxAmount);
    
    return this;
  }

   /**
   * The amount of tax payable on the offer for all passengers
   * @return taxAmount
  **/
  @jakarta.annotation.Nullable

  @JsonIgnore

  public String getTaxAmount() {
        return taxAmount.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TAX_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaxAmount_JsonNullable() {
    return taxAmount;
  }
  
  @JsonProperty(JSON_PROPERTY_TAX_AMOUNT)
  public void setTaxAmount_JsonNullable(JsonNullable<String> taxAmount) {
    this.taxAmount = taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = JsonNullable.<String>of(taxAmount);
  }


  public Offer taxCurrency(String taxCurrency) {
    this.taxCurrency = JsonNullable.<String>of(taxCurrency);
    
    return this;
  }

   /**
   * The currency of the &#x60;tax_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return taxCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonIgnore

  public String getTaxCurrency() {
        return taxCurrency.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_TAX_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getTaxCurrency_JsonNullable() {
    return taxCurrency;
  }
  
  @JsonProperty(JSON_PROPERTY_TAX_CURRENCY)
  public void setTaxCurrency_JsonNullable(JsonNullable<String> taxCurrency) {
    this.taxCurrency = taxCurrency;
  }

  public void setTaxCurrency(String taxCurrency) {
    this.taxCurrency = JsonNullable.<String>of(taxCurrency);
  }


  public Offer totalAmount(String totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * The total price of the offer for all passengers, including taxes. It does not include the total price of any service(s) that might be booked with the offer.
   * @return totalAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalAmount() {
    return totalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
  }


  public Offer totalCurrency(String totalCurrency) {
    
    this.totalCurrency = totalCurrency;
    return this;
  }

   /**
   * The currency of the &#x60;total_amount&#x60;, as an [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) currency code. It will match your organisation&#39;s billing currency unless you’re using Duffel as an accredited IATA agent, in which case it will be in the currency provided by the airline (which will usually be based on the country where your IATA agency is registered). 
   * @return totalCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalCurrency() {
    return totalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCurrency(String totalCurrency) {
    this.totalCurrency = totalCurrency;
  }


  public Offer totalEmissionsKg(String totalEmissionsKg) {
    
    this.totalEmissionsKg = totalEmissionsKg;
    return this;
  }

   /**
   * An estimate of the total carbon dioxide (CO₂) emissions when all of the passengers fly this offer&#39;s itinerary, measured in kilograms
   * @return totalEmissionsKg
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_EMISSIONS_KG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTotalEmissionsKg() {
    return totalEmissionsKg;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_EMISSIONS_KG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalEmissionsKg(String totalEmissionsKg) {
    this.totalEmissionsKg = totalEmissionsKg;
  }


  public Offer updatedAt(java.time.LocalDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer was last updated
   * @return updatedAt
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(java.time.LocalDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Offer offer = (Offer) o;
    return Objects.equals(this.allowedPassengerIdentityDocumentTypes, offer.allowedPassengerIdentityDocumentTypes) &&
        Objects.equals(this.availableServices, offer.availableServices) &&
        Objects.equals(this.baseAmount, offer.baseAmount) &&
        Objects.equals(this.baseCurrency, offer.baseCurrency) &&
        Objects.equals(this.conditions, offer.conditions) &&
        Objects.equals(this.createdAt, offer.createdAt) &&
        Objects.equals(this.expiresAt, offer.expiresAt) &&
        Objects.equals(this.id, offer.id) &&
        Objects.equals(this.liveMode, offer.liveMode) &&
        Objects.equals(this.owner, offer.owner) &&
        Objects.equals(this.partial, offer.partial) &&
        Objects.equals(this.passengerIdentityDocumentsRequired, offer.passengerIdentityDocumentsRequired) &&
        Objects.equals(this.passengers, offer.passengers) &&
        Objects.equals(this.paymentRequirements, offer.paymentRequirements) &&
        Objects.equals(this.slices, offer.slices) &&
        equalsNullable(this.taxAmount, offer.taxAmount) &&
        equalsNullable(this.taxCurrency, offer.taxCurrency) &&
        Objects.equals(this.totalAmount, offer.totalAmount) &&
        Objects.equals(this.totalCurrency, offer.totalCurrency) &&
        Objects.equals(this.totalEmissionsKg, offer.totalEmissionsKg) &&
        Objects.equals(this.updatedAt, offer.updatedAt);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowedPassengerIdentityDocumentTypes, availableServices, baseAmount, baseCurrency, conditions, createdAt, expiresAt, id, liveMode, owner, partial, passengerIdentityDocumentsRequired, passengers, paymentRequirements, slices, hashCodeNullable(taxAmount), hashCodeNullable(taxCurrency), totalAmount, totalCurrency, totalEmissionsKg, updatedAt);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Offer {\n");
    sb.append("    allowedPassengerIdentityDocumentTypes: ").append(toIndentedString(allowedPassengerIdentityDocumentTypes)).append("\n");
    sb.append("    availableServices: ").append(toIndentedString(availableServices)).append("\n");
    sb.append("    baseAmount: ").append(toIndentedString(baseAmount)).append("\n");
    sb.append("    baseCurrency: ").append(toIndentedString(baseCurrency)).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    partial: ").append(toIndentedString(partial)).append("\n");
    sb.append("    passengerIdentityDocumentsRequired: ").append(toIndentedString(passengerIdentityDocumentsRequired)).append("\n");
    sb.append("    passengers: ").append(toIndentedString(passengers)).append("\n");
    sb.append("    paymentRequirements: ").append(toIndentedString(paymentRequirements)).append("\n");
    sb.append("    slices: ").append(toIndentedString(slices)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    taxCurrency: ").append(toIndentedString(taxCurrency)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    totalCurrency: ").append(toIndentedString(totalCurrency)).append("\n");
    sb.append("    totalEmissionsKg: ").append(toIndentedString(totalEmissionsKg)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

