/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferIndexPaymentRequirements
 */
@JsonPropertyOrder({
  OfferIndexPaymentRequirements.JSON_PROPERTY_PAYMENT_REQUIRED_BY,
  OfferIndexPaymentRequirements.JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT,
  OfferIndexPaymentRequirements.JSON_PROPERTY_REQUIRES_INSTANT_PAYMENT
})
@JsonTypeName("Offer_Index_payment_requirements")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OfferIndexPaymentRequirements {
  public static final String JSON_PROPERTY_PAYMENT_REQUIRED_BY = "payment_required_by";
  private JsonNullable<java.time.LocalDateTime> paymentRequiredBy = JsonNullable.<java.time.LocalDateTime>undefined();

  public static final String JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT = "price_guarantee_expires_at";
  private JsonNullable<java.time.LocalDateTime> priceGuaranteeExpiresAt = JsonNullable.<java.time.LocalDateTime>undefined();

  public static final String JSON_PROPERTY_REQUIRES_INSTANT_PAYMENT = "requires_instant_payment";
  private Boolean requiresInstantPayment;

  public OfferIndexPaymentRequirements() {
  }

  public OfferIndexPaymentRequirements paymentRequiredBy(java.time.LocalDateTime paymentRequiredBy) {
    this.paymentRequiredBy = JsonNullable.<java.time.LocalDateTime>of(paymentRequiredBy);
    
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime by which you must pay for this offer. At this time, if still unpaid, the reserved space on the flight(s) will be released and you will have to create a new order. This will be &#x60;null&#x60; when the offer requires immediate payment - that is, when &#x60;requires_instant_payment&#x60; is &#x60;true&#x60;. 
   * @return paymentRequiredBy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonIgnore

  public java.time.LocalDateTime getPaymentRequiredBy() {
        return paymentRequiredBy.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIRED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<java.time.LocalDateTime> getPaymentRequiredBy_JsonNullable() {
    return paymentRequiredBy;
  }
  
  @JsonProperty(JSON_PROPERTY_PAYMENT_REQUIRED_BY)
  public void setPaymentRequiredBy_JsonNullable(JsonNullable<java.time.LocalDateTime> paymentRequiredBy) {
    this.paymentRequiredBy = paymentRequiredBy;
  }

  public void setPaymentRequiredBy(java.time.LocalDateTime paymentRequiredBy) {
    this.paymentRequiredBy = JsonNullable.<java.time.LocalDateTime>of(paymentRequiredBy);
  }


  public OfferIndexPaymentRequirements priceGuaranteeExpiresAt(java.time.LocalDateTime priceGuaranteeExpiresAt) {
    this.priceGuaranteeExpiresAt = JsonNullable.<java.time.LocalDateTime>of(priceGuaranteeExpiresAt);
    
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the price associated with the order will no longer be guaranteed by the airline and may change before payment. This will be &#x60;null&#x60; when &#x60;requires_instant_payment&#x60; is &#x60;true&#x60;. 
   * @return priceGuaranteeExpiresAt
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonIgnore

  public java.time.LocalDateTime getPriceGuaranteeExpiresAt() {
        return priceGuaranteeExpiresAt.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<java.time.LocalDateTime> getPriceGuaranteeExpiresAt_JsonNullable() {
    return priceGuaranteeExpiresAt;
  }
  
  @JsonProperty(JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT)
  public void setPriceGuaranteeExpiresAt_JsonNullable(JsonNullable<java.time.LocalDateTime> priceGuaranteeExpiresAt) {
    this.priceGuaranteeExpiresAt = priceGuaranteeExpiresAt;
  }

  public void setPriceGuaranteeExpiresAt(java.time.LocalDateTime priceGuaranteeExpiresAt) {
    this.priceGuaranteeExpiresAt = JsonNullable.<java.time.LocalDateTime>of(priceGuaranteeExpiresAt);
  }


  public OfferIndexPaymentRequirements requiresInstantPayment(Boolean requiresInstantPayment) {
    
    this.requiresInstantPayment = requiresInstantPayment;
    return this;
  }

   /**
   * When payment is required at the time of booking this will be &#x60;true&#x60; and &#x60;payment_required_by&#x60; and &#x60;price_guarantee_expires_at&#x60; will be &#x60;null&#x60;. When payment can be made at a time after booking, this will be &#x60;false&#x60; and the time limits on the payment will be provided in &#x60;payment_required_by&#x60; and &#x60;price_guarantee_expires_at&#x60;. 
   * @return requiresInstantPayment
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REQUIRES_INSTANT_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRequiresInstantPayment() {
    return requiresInstantPayment;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRES_INSTANT_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiresInstantPayment(Boolean requiresInstantPayment) {
    this.requiresInstantPayment = requiresInstantPayment;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferIndexPaymentRequirements offerIndexPaymentRequirements = (OfferIndexPaymentRequirements) o;
    return equalsNullable(this.paymentRequiredBy, offerIndexPaymentRequirements.paymentRequiredBy) &&
        equalsNullable(this.priceGuaranteeExpiresAt, offerIndexPaymentRequirements.priceGuaranteeExpiresAt) &&
        Objects.equals(this.requiresInstantPayment, offerIndexPaymentRequirements.requiresInstantPayment);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(paymentRequiredBy), hashCodeNullable(priceGuaranteeExpiresAt), requiresInstantPayment);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferIndexPaymentRequirements {\n");
    sb.append("    paymentRequiredBy: ").append(toIndentedString(paymentRequiredBy)).append("\n");
    sb.append("    priceGuaranteeExpiresAt: ").append(toIndentedString(priceGuaranteeExpiresAt)).append("\n");
    sb.append("    requiresInstantPayment: ").append(toIndentedString(requiresInstantPayment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

