/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A private fare for a specific airline. One of &#x60;corporate_code&#x60; or &#x60;tracking_reference&#x60; must be provided
 */
@JsonPropertyOrder({
  OfferRequestBodyPrivateFare.JSON_PROPERTY_CORPORATE_CODE,
  OfferRequestBodyPrivateFare.JSON_PROPERTY_TRACKING_REFERENCE
})
@JsonTypeName("Offer_Request_Body_Private_Fare")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OfferRequestBodyPrivateFare {
  public static final String JSON_PROPERTY_CORPORATE_CODE = "corporate_code";
  private String corporateCode;

  public static final String JSON_PROPERTY_TRACKING_REFERENCE = "tracking_reference";
  private String trackingReference;

  public OfferRequestBodyPrivateFare() {
  }

  public OfferRequestBodyPrivateFare corporateCode(String corporateCode) {
    
    this.corporateCode = corporateCode;
    return this;
  }

   /**
   * The corporate code provided to you by the airline.
   * @return corporateCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CORPORATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCorporateCode() {
    return corporateCode;
  }


  @JsonProperty(JSON_PROPERTY_CORPORATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCorporateCode(String corporateCode) {
    this.corporateCode = corporateCode;
  }


  public OfferRequestBodyPrivateFare trackingReference(String trackingReference) {
    
    this.trackingReference = trackingReference;
    return this;
  }

   /**
   * Tracking reference agreed with the airline. This value is to identify your business and is usually business number or agency id.
   * @return trackingReference
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRACKING_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTrackingReference() {
    return trackingReference;
  }


  @JsonProperty(JSON_PROPERTY_TRACKING_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTrackingReference(String trackingReference) {
    this.trackingReference = trackingReference;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferRequestBodyPrivateFare offerRequestBodyPrivateFare = (OfferRequestBodyPrivateFare) o;
    return Objects.equals(this.corporateCode, offerRequestBodyPrivateFare.corporateCode) &&
        Objects.equals(this.trackingReference, offerRequestBodyPrivateFare.trackingReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(corporateCode, trackingReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferRequestBodyPrivateFare {\n");
    sb.append("    corporateCode: ").append(toIndentedString(corporateCode)).append("\n");
    sb.append("    trackingReference: ").append(toIndentedString(trackingReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

