/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.Airport1;
import com.duffel.sdk.model.City2;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferRequestSliceDestination
 */
@JsonPropertyOrder({
  OfferRequestSliceDestination.JSON_PROPERTY_AIRPORTS,
  OfferRequestSliceDestination.JSON_PROPERTY_CITY,
  OfferRequestSliceDestination.JSON_PROPERTY_CITY_NAME,
  OfferRequestSliceDestination.JSON_PROPERTY_IATA_CITY_CODE,
  OfferRequestSliceDestination.JSON_PROPERTY_IATA_CODE,
  OfferRequestSliceDestination.JSON_PROPERTY_IATA_COUNTRY_CODE,
  OfferRequestSliceDestination.JSON_PROPERTY_ICAO_CODE,
  OfferRequestSliceDestination.JSON_PROPERTY_ID,
  OfferRequestSliceDestination.JSON_PROPERTY_LATITUDE,
  OfferRequestSliceDestination.JSON_PROPERTY_LONGITUDE,
  OfferRequestSliceDestination.JSON_PROPERTY_NAME,
  OfferRequestSliceDestination.JSON_PROPERTY_TIME_ZONE,
  OfferRequestSliceDestination.JSON_PROPERTY_TYPE
})
@JsonTypeName("Offer_Request_Slice_destination")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OfferRequestSliceDestination {
  public static final String JSON_PROPERTY_AIRPORTS = "airports";
  private JsonNullable<List<Airport1>> airports = JsonNullable.<List<Airport1>>undefined();

  public static final String JSON_PROPERTY_CITY = "city";
  private City2 city;

  public static final String JSON_PROPERTY_CITY_NAME = "city_name";
  private String cityName;

  public static final String JSON_PROPERTY_IATA_CITY_CODE = "iata_city_code";
  private String iataCityCode;

  public static final String JSON_PROPERTY_IATA_CODE = "iata_code";
  private String iataCode;

  public static final String JSON_PROPERTY_IATA_COUNTRY_CODE = "iata_country_code";
  private String iataCountryCode;

  public static final String JSON_PROPERTY_ICAO_CODE = "icao_code";
  private String icaoCode;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LATITUDE = "latitude";
  private Float latitude;

  public static final String JSON_PROPERTY_LONGITUDE = "longitude";
  private Float longitude;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TIME_ZONE = "time_zone";
  private String timeZone;

  /**
   * The type of the place
   */
  public enum TypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public OfferRequestSliceDestination() {
  }

  public OfferRequestSliceDestination airports(List<Airport1> airports) {
    this.airports = JsonNullable.<List<Airport1>>of(airports);
    
    return this;
  }

  public OfferRequestSliceDestination addAirportsItem(Airport1 airportsItem) {
    if (this.airports == null || !this.airports.isPresent()) {
      this.airports = JsonNullable.<List<Airport1>>of(new ArrayList<>());
    }
    try {
      this.airports.get().add(airportsItem);
    } catch (java.util.NoSuchElementException e) {
      // this can never happen, as we make sure above that the value is present
    }
    return this;
  }

   /**
   * The airports associated to a city. This will only be provided where the &#x60;type&#x60; is &#x60;city&#x60;.
   * @return airports
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonIgnore

  public List<Airport1> getAirports() {
        return airports.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_AIRPORTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<List<Airport1>> getAirports_JsonNullable() {
    return airports;
  }
  
  @JsonProperty(JSON_PROPERTY_AIRPORTS)
  public void setAirports_JsonNullable(JsonNullable<List<Airport1>> airports) {
    this.airports = airports;
  }

  public void setAirports(List<Airport1> airports) {
    this.airports = JsonNullable.<List<Airport1>>of(airports);
  }


  public OfferRequestSliceDestination city(City2 city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @jakarta.annotation.Nullable
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public City2 getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCity(City2 city) {
    this.city = city;
  }


  public OfferRequestSliceDestination cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * The name of the city (or cities separated by a &#x60;/&#x60;) where the airport is located
   * @return cityName
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public OfferRequestSliceDestination iataCityCode(String iataCityCode) {
    
    this.iataCityCode = iataCityCode;
    return this;
  }

   /**
   * The 3-letter IATA code for the city where the place is located. Only present for airports which are registered with IATA as belonging to a [metropolitan area](https://portal.iata.org/faq/articles/en_US/FAQ/How-do-I-create-a-new-Metropolitan-Area).
   * @return iataCityCode
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_IATA_CITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIataCityCode() {
    return iataCityCode;
  }


  @JsonProperty(JSON_PROPERTY_IATA_CITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIataCityCode(String iataCityCode) {
    this.iataCityCode = iataCityCode;
  }


  public OfferRequestSliceDestination iataCode(String iataCode) {
    
    this.iataCode = iataCode;
    return this;
  }

   /**
   * The 3-letter IATA code for the place
   * @return iataCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIataCode() {
    return iataCode;
  }


  @JsonProperty(JSON_PROPERTY_IATA_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIataCode(String iataCode) {
    this.iataCode = iataCode;
  }


  public OfferRequestSliceDestination iataCountryCode(String iataCountryCode) {
    
    this.iataCountryCode = iataCountryCode;
    return this;
  }

   /**
   * The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code for the country where the city is located
   * @return iataCountryCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IATA_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIataCountryCode() {
    return iataCountryCode;
  }


  @JsonProperty(JSON_PROPERTY_IATA_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIataCountryCode(String iataCountryCode) {
    this.iataCountryCode = iataCountryCode;
  }


  public OfferRequestSliceDestination icaoCode(String icaoCode) {
    
    this.icaoCode = icaoCode;
    return this;
  }

   /**
   * The four-character ICAO code for the airport
   * @return icaoCode
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_ICAO_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIcaoCode() {
    return icaoCode;
  }


  @JsonProperty(JSON_PROPERTY_ICAO_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIcaoCode(String icaoCode) {
    this.icaoCode = icaoCode;
  }


  public OfferRequestSliceDestination id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the place
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public OfferRequestSliceDestination latitude(Float latitude) {
    
    this.latitude = latitude;
    return this;
  }

   /**
   * The latitude position of the airport represented in [Decimal degrees](https://en.wikipedia.org/wiki/Decimal_degrees) with 6 decimal points with a range between -90° and 90°
   * @return latitude
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getLatitude() {
    return latitude;
  }


  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLatitude(Float latitude) {
    this.latitude = latitude;
  }


  public OfferRequestSliceDestination longitude(Float longitude) {
    
    this.longitude = longitude;
    return this;
  }

   /**
   * The longitude position of the airport represented in [Decimal degrees](https://en.wikipedia.org/wiki/Decimal_degrees) with 6 decimal points with a range between -180° and 180°
   * @return longitude
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getLongitude() {
    return longitude;
  }


  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLongitude(Float longitude) {
    this.longitude = longitude;
  }


  public OfferRequestSliceDestination name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the place
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public OfferRequestSliceDestination timeZone(String timeZone) {
    
    this.timeZone = timeZone;
    return this;
  }

   /**
   * The time zone of the airport, specified by name from the [tz database](https://en.wikipedia.org/wiki/Tz_database)
   * @return timeZone
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_TIME_ZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTimeZone() {
    return timeZone;
  }


  @JsonProperty(JSON_PROPERTY_TIME_ZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTimeZone(String timeZone) {
    this.timeZone = timeZone;
  }


  public OfferRequestSliceDestination type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the place
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferRequestSliceDestination offerRequestSliceDestination = (OfferRequestSliceDestination) o;
    return equalsNullable(this.airports, offerRequestSliceDestination.airports) &&
        Objects.equals(this.city, offerRequestSliceDestination.city) &&
        Objects.equals(this.cityName, offerRequestSliceDestination.cityName) &&
        Objects.equals(this.iataCityCode, offerRequestSliceDestination.iataCityCode) &&
        Objects.equals(this.iataCode, offerRequestSliceDestination.iataCode) &&
        Objects.equals(this.iataCountryCode, offerRequestSliceDestination.iataCountryCode) &&
        Objects.equals(this.icaoCode, offerRequestSliceDestination.icaoCode) &&
        Objects.equals(this.id, offerRequestSliceDestination.id) &&
        Objects.equals(this.latitude, offerRequestSliceDestination.latitude) &&
        Objects.equals(this.longitude, offerRequestSliceDestination.longitude) &&
        Objects.equals(this.name, offerRequestSliceDestination.name) &&
        Objects.equals(this.timeZone, offerRequestSliceDestination.timeZone) &&
        Objects.equals(this.type, offerRequestSliceDestination.type);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(hashCodeNullable(airports), city, cityName, iataCityCode, iataCode, iataCountryCode, icaoCode, id, latitude, longitude, name, timeZone, type);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferRequestSliceDestination {\n");
    sb.append("    airports: ").append(toIndentedString(airports)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    iataCityCode: ").append(toIndentedString(iataCityCode)).append("\n");
    sb.append("    iataCode: ").append(toIndentedString(iataCode)).append("\n");
    sb.append("    iataCountryCode: ").append(toIndentedString(iataCountryCode)).append("\n");
    sb.append("    icaoCode: ").append(toIndentedString(icaoCode)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    timeZone: ").append(toIndentedString(timeZone)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

