/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.SliceSegmentPassengerBaggage;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OfferSliceSegmentPassenger
 */
@JsonPropertyOrder({
  OfferSliceSegmentPassenger.JSON_PROPERTY_BAGGAGES,
  OfferSliceSegmentPassenger.JSON_PROPERTY_CABIN_CLASS,
  OfferSliceSegmentPassenger.JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME,
  OfferSliceSegmentPassenger.JSON_PROPERTY_FARE_BASIS_CODE,
  OfferSliceSegmentPassenger.JSON_PROPERTY_PASSENGER_ID
})
@JsonTypeName("Offer_Slice_Segment_Passenger")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OfferSliceSegmentPassenger {
  public static final String JSON_PROPERTY_BAGGAGES = "baggages";
  private List<SliceSegmentPassengerBaggage> baggages;

  /**
   * The cabin class that the passenger will travel in on this segment
   */
  public enum CabinClassEnum {
    FIRST("first"),
    
    BUSINESS("business"),
    
    PREMIUM_ECONOMY("premium_economy"),
    
    ECONOMY("economy");

    private String value;

    CabinClassEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CabinClassEnum fromValue(String value) {
      for (CabinClassEnum b : CabinClassEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
  private CabinClassEnum cabinClass;

  public static final String JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME = "cabin_class_marketing_name";
  private String cabinClassMarketingName;

  public static final String JSON_PROPERTY_FARE_BASIS_CODE = "fare_basis_code";
  private JsonNullable<String> fareBasisCode = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PASSENGER_ID = "passenger_id";
  private String passengerId;

  public OfferSliceSegmentPassenger() {
  }

  public OfferSliceSegmentPassenger baggages(List<SliceSegmentPassengerBaggage> baggages) {
    
    this.baggages = baggages;
    return this;
  }

  public OfferSliceSegmentPassenger addBaggagesItem(SliceSegmentPassengerBaggage baggagesItem) {
    if (this.baggages == null) {
      this.baggages = new ArrayList<>();
    }
    this.baggages.add(baggagesItem);
    return this;
  }

   /**
   * The baggage allowances for the passenger on this segment included in the offer. Some airlines may allow additional baggage to be booked as a service - see the offer&#39;s &#x60;available_services&#x60;.
   * @return baggages
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BAGGAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SliceSegmentPassengerBaggage> getBaggages() {
    return baggages;
  }


  @JsonProperty(JSON_PROPERTY_BAGGAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaggages(List<SliceSegmentPassengerBaggage> baggages) {
    this.baggages = baggages;
  }


  public OfferSliceSegmentPassenger cabinClass(CabinClassEnum cabinClass) {
    
    this.cabinClass = cabinClass;
    return this;
  }

   /**
   * The cabin class that the passenger will travel in on this segment
   * @return cabinClass
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CabinClassEnum getCabinClass() {
    return cabinClass;
  }


  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCabinClass(CabinClassEnum cabinClass) {
    this.cabinClass = cabinClass;
  }


  public OfferSliceSegmentPassenger cabinClassMarketingName(String cabinClassMarketingName) {
    
    this.cabinClassMarketingName = cabinClassMarketingName;
    return this;
  }

   /**
   * The name that the marketing carrier uses to market this cabin class
   * @return cabinClassMarketingName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCabinClassMarketingName() {
    return cabinClassMarketingName;
  }


  @JsonProperty(JSON_PROPERTY_CABIN_CLASS_MARKETING_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCabinClassMarketingName(String cabinClassMarketingName) {
    this.cabinClassMarketingName = cabinClassMarketingName;
  }


  public OfferSliceSegmentPassenger fareBasisCode(String fareBasisCode) {
    this.fareBasisCode = JsonNullable.<String>of(fareBasisCode);
    
    return this;
  }

   /**
   * The airline&#39;s alphanumeric code for the fare that the passenger is using to travel. Where this is &#x60;null&#x60;, it means that either the fare basis code is not available or the airline does not use fare basis codes.
   * @return fareBasisCode
  **/
  @jakarta.annotation.Nullable

  @JsonIgnore

  public String getFareBasisCode() {
        return fareBasisCode.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FARE_BASIS_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFareBasisCode_JsonNullable() {
    return fareBasisCode;
  }
  
  @JsonProperty(JSON_PROPERTY_FARE_BASIS_CODE)
  public void setFareBasisCode_JsonNullable(JsonNullable<String> fareBasisCode) {
    this.fareBasisCode = fareBasisCode;
  }

  public void setFareBasisCode(String fareBasisCode) {
    this.fareBasisCode = JsonNullable.<String>of(fareBasisCode);
  }


  public OfferSliceSegmentPassenger passengerId(String passengerId) {
    
    this.passengerId = passengerId;
    return this;
  }

   /**
   * The identifier for the passenger. You may have specified this ID yourself when creating the offer request, or otherwise, Duffel will have generated its own random ID.
   * @return passengerId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPassengerId() {
    return passengerId;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengerId(String passengerId) {
    this.passengerId = passengerId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OfferSliceSegmentPassenger offerSliceSegmentPassenger = (OfferSliceSegmentPassenger) o;
    return Objects.equals(this.baggages, offerSliceSegmentPassenger.baggages) &&
        Objects.equals(this.cabinClass, offerSliceSegmentPassenger.cabinClass) &&
        Objects.equals(this.cabinClassMarketingName, offerSliceSegmentPassenger.cabinClassMarketingName) &&
        equalsNullable(this.fareBasisCode, offerSliceSegmentPassenger.fareBasisCode) &&
        Objects.equals(this.passengerId, offerSliceSegmentPassenger.passengerId);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(baggages, cabinClass, cabinClassMarketingName, hashCodeNullable(fareBasisCode), passengerId);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OfferSliceSegmentPassenger {\n");
    sb.append("    baggages: ").append(toIndentedString(baggages)).append("\n");
    sb.append("    cabinClass: ").append(toIndentedString(cabinClass)).append("\n");
    sb.append("    cabinClassMarketingName: ").append(toIndentedString(cabinClassMarketingName)).append("\n");
    sb.append("    fareBasisCode: ").append(toIndentedString(fareBasisCode)).append("\n");
    sb.append("    passengerId: ").append(toIndentedString(passengerId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

