/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OrderChangeSlicesSliceSegmentsInner;
import com.duffel.sdk.model.Place1;
import com.duffel.sdk.model.Place2;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A slice that is being removed or added
 */
@JsonPropertyOrder({
  OrderChangeSlicesSlice.JSON_PROPERTY_DESTINATION,
  OrderChangeSlicesSlice.JSON_PROPERTY_DESTINATION_TYPE,
  OrderChangeSlicesSlice.JSON_PROPERTY_DURATION,
  OrderChangeSlicesSlice.JSON_PROPERTY_ID,
  OrderChangeSlicesSlice.JSON_PROPERTY_ORIGIN,
  OrderChangeSlicesSlice.JSON_PROPERTY_ORIGIN_TYPE,
  OrderChangeSlicesSlice.JSON_PROPERTY_SEGMENTS
})
@JsonTypeName("Order_Change_Slices_Slice")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OrderChangeSlicesSlice {
  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private Place1 destination;

  /**
   * The type of the destination
   */
  public enum DestinationTypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    DestinationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DestinationTypeEnum fromValue(String value) {
      for (DestinationTypeEnum b : DestinationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DESTINATION_TYPE = "destination_type";
  private DestinationTypeEnum destinationType;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private JsonNullable<String> duration = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private Place2 origin;

  /**
   * The type of the origin
   */
  public enum OriginTypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    OriginTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OriginTypeEnum fromValue(String value) {
      for (OriginTypeEnum b : OriginTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ORIGIN_TYPE = "origin_type";
  private OriginTypeEnum originType;

  public static final String JSON_PROPERTY_SEGMENTS = "segments";
  private List<OrderChangeSlicesSliceSegmentsInner> segments;

  public OrderChangeSlicesSlice() {
  }

  public OrderChangeSlicesSlice destination(Place1 destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Get destination
   * @return destination
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Place1 getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestination(Place1 destination) {
    this.destination = destination;
  }


  public OrderChangeSlicesSlice destinationType(DestinationTypeEnum destinationType) {
    
    this.destinationType = destinationType;
    return this;
  }

   /**
   * The type of the destination
   * @return destinationType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DestinationTypeEnum getDestinationType() {
    return destinationType;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationType(DestinationTypeEnum destinationType) {
    this.destinationType = destinationType;
  }


  public OrderChangeSlicesSlice duration(String duration) {
    this.duration = JsonNullable.<String>of(duration);
    
    return this;
  }

   /**
   * The duration of the slice, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration
   * @return duration
  **/
  @jakarta.annotation.Nullable

  @JsonIgnore

  public String getDuration() {
        return duration.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getDuration_JsonNullable() {
    return duration;
  }
  
  @JsonProperty(JSON_PROPERTY_DURATION)
  public void setDuration_JsonNullable(JsonNullable<String> duration) {
    this.duration = duration;
  }

  public void setDuration(String duration) {
    this.duration = JsonNullable.<String>of(duration);
  }


  public OrderChangeSlicesSlice id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the slice. It identifies the slice of an order (i.e. the same slice across orders will have different &#x60;id&#x60;s.
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderChangeSlicesSlice origin(Place2 origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * Get origin
   * @return origin
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Place2 getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(Place2 origin) {
    this.origin = origin;
  }


  public OrderChangeSlicesSlice originType(OriginTypeEnum originType) {
    
    this.originType = originType;
    return this;
  }

   /**
   * The type of the origin
   * @return originType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OriginTypeEnum getOriginType() {
    return originType;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginType(OriginTypeEnum originType) {
    this.originType = originType;
  }


  public OrderChangeSlicesSlice segments(List<OrderChangeSlicesSliceSegmentsInner> segments) {
    
    this.segments = segments;
    return this;
  }

  public OrderChangeSlicesSlice addSegmentsItem(OrderChangeSlicesSliceSegmentsInner segmentsItem) {
    if (this.segments == null) {
      this.segments = new ArrayList<>();
    }
    this.segments.add(segmentsItem);
    return this;
  }

   /**
   * The segments - that is, specific flights - that the airline is offering to get the passengers from the &#x60;origin&#x60; to the &#x60;destination&#x60;
   * @return segments
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SEGMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OrderChangeSlicesSliceSegmentsInner> getSegments() {
    return segments;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegments(List<OrderChangeSlicesSliceSegmentsInner> segments) {
    this.segments = segments;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderChangeSlicesSlice orderChangeSlicesSlice = (OrderChangeSlicesSlice) o;
    return Objects.equals(this.destination, orderChangeSlicesSlice.destination) &&
        Objects.equals(this.destinationType, orderChangeSlicesSlice.destinationType) &&
        equalsNullable(this.duration, orderChangeSlicesSlice.duration) &&
        Objects.equals(this.id, orderChangeSlicesSlice.id) &&
        Objects.equals(this.origin, orderChangeSlicesSlice.origin) &&
        Objects.equals(this.originType, orderChangeSlicesSlice.originType) &&
        Objects.equals(this.segments, orderChangeSlicesSlice.segments);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(destination, destinationType, hashCodeNullable(duration), id, origin, originType, segments);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderChangeSlicesSlice {\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    destinationType: ").append(toIndentedString(destinationType)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    originType: ").append(toIndentedString(originType)).append("\n");
    sb.append("    segments: ").append(toIndentedString(segments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

