/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.LoyaltyProgrammeAccount;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OrderPassenger
 */
@JsonPropertyOrder({
  OrderPassenger.JSON_PROPERTY_BORN_ON,
  OrderPassenger.JSON_PROPERTY_EMAIL,
  OrderPassenger.JSON_PROPERTY_FAMILY_NAME,
  OrderPassenger.JSON_PROPERTY_GENDER,
  OrderPassenger.JSON_PROPERTY_GIVEN_NAME,
  OrderPassenger.JSON_PROPERTY_ID,
  OrderPassenger.JSON_PROPERTY_INFANT_PASSENGER_ID,
  OrderPassenger.JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS,
  OrderPassenger.JSON_PROPERTY_PHONE_NUMBER,
  OrderPassenger.JSON_PROPERTY_TITLE,
  OrderPassenger.JSON_PROPERTY_TYPE
})
@JsonTypeName("Order_Passenger")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OrderPassenger {
  public static final String JSON_PROPERTY_BORN_ON = "born_on";
  private LocalDate bornOn;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_FAMILY_NAME = "family_name";
  private String familyName;

  /**
   * The passenger&#39;s gender
   */
  public enum GenderEnum {
    M("m"),
    
    F("f");

    private String value;

    GenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GenderEnum fromValue(String value) {
      for (GenderEnum b : GenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GENDER = "gender";
  private GenderEnum gender;

  public static final String JSON_PROPERTY_GIVEN_NAME = "given_name";
  private String givenName;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INFANT_PASSENGER_ID = "infant_passenger_id";
  private String infantPassengerId;

  public static final String JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS = "loyalty_programme_accounts";
  private List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts = new ArrayList<>();

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phone_number";
  private String phoneNumber;

  /**
   * The passenger&#39;s title
   */
  public enum TitleEnum {
    MR("mr"),
    
    MS("ms"),
    
    MRS("mrs"),
    
    MISS("miss"),
    
    DR("dr");

    private String value;

    TitleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TitleEnum fromValue(String value) {
      for (TitleEnum b : TitleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TITLE = "title";
  private TitleEnum title;

  /**
   * The type of the passenger
   */
  public enum TypeEnum {
    ADULT("adult"),
    
    CHILD("child"),
    
    INFANT_WITHOUT_SEAT("infant_without_seat");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public OrderPassenger() {
  }

  public OrderPassenger bornOn(LocalDate bornOn) {
    
    this.bornOn = bornOn;
    return this;
  }

   /**
   * The passenger&#39;s date of birth
   * @return bornOn
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BORN_ON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getBornOn() {
    return bornOn;
  }


  @JsonProperty(JSON_PROPERTY_BORN_ON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBornOn(LocalDate bornOn) {
    this.bornOn = bornOn;
  }


  public OrderPassenger email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * The passenger&#39;s email address. Note that this data may differ from the airline&#39;s records if it was updated directly with the airline since the order was created. 
   * @return email
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public OrderPassenger familyName(String familyName) {
    
    this.familyName = familyName;
    return this;
  }

   /**
   * The passenger&#39;s family name
   * @return familyName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FAMILY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFamilyName() {
    return familyName;
  }


  @JsonProperty(JSON_PROPERTY_FAMILY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFamilyName(String familyName) {
    this.familyName = familyName;
  }


  public OrderPassenger gender(GenderEnum gender) {
    
    this.gender = gender;
    return this;
  }

   /**
   * The passenger&#39;s gender
   * @return gender
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GenderEnum getGender() {
    return gender;
  }


  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGender(GenderEnum gender) {
    this.gender = gender;
  }


  public OrderPassenger givenName(String givenName) {
    
    this.givenName = givenName;
    return this;
  }

   /**
   * The passenger&#39;s given name
   * @return givenName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_GIVEN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGivenName() {
    return givenName;
  }


  @JsonProperty(JSON_PROPERTY_GIVEN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGivenName(String givenName) {
    this.givenName = givenName;
  }


  public OrderPassenger id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The &#x60;id&#x60; of the passenger, returned when the [offer request](/docs/api/offer-requests) was created
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderPassenger infantPassengerId(String infantPassengerId) {
    
    this.infantPassengerId = infantPassengerId;
    return this;
  }

   /**
   * The &#x60;id&#x60; of the infant associated with this passenger
   * @return infantPassengerId
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_INFANT_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInfantPassengerId() {
    return infantPassengerId;
  }


  @JsonProperty(JSON_PROPERTY_INFANT_PASSENGER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInfantPassengerId(String infantPassengerId) {
    this.infantPassengerId = infantPassengerId;
  }


  public OrderPassenger loyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
    
    this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
    return this;
  }

  public OrderPassenger addLoyaltyProgrammeAccountsItem(LoyaltyProgrammeAccount loyaltyProgrammeAccountsItem) {
    if (this.loyaltyProgrammeAccounts == null) {
      this.loyaltyProgrammeAccounts = new ArrayList<>();
    }
    this.loyaltyProgrammeAccounts.add(loyaltyProgrammeAccountsItem);
    return this;
  }

   /**
   * The __Loyalty Programme Accounts__ for this passenger
   * @return loyaltyProgrammeAccounts
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<LoyaltyProgrammeAccount> getLoyaltyProgrammeAccounts() {
    return loyaltyProgrammeAccounts;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAMME_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLoyaltyProgrammeAccounts(List<LoyaltyProgrammeAccount> loyaltyProgrammeAccounts) {
    this.loyaltyProgrammeAccounts = loyaltyProgrammeAccounts;
  }


  public OrderPassenger phoneNumber(String phoneNumber) {
    
    this.phoneNumber = phoneNumber;
    return this;
  }

   /**
   * The passenger&#39;s phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) (international) format. Note that this data may differ from the airline&#39;s records if it was updated directly with the airline since the order was created. 
   * @return phoneNumber
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPhoneNumber() {
    return phoneNumber;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }


  public OrderPassenger title(TitleEnum title) {
    
    this.title = title;
    return this;
  }

   /**
   * The passenger&#39;s title
   * @return title
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TitleEnum getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTitle(TitleEnum title) {
    this.title = title;
  }


  public OrderPassenger type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the passenger
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderPassenger orderPassenger = (OrderPassenger) o;
    return Objects.equals(this.bornOn, orderPassenger.bornOn) &&
        Objects.equals(this.email, orderPassenger.email) &&
        Objects.equals(this.familyName, orderPassenger.familyName) &&
        Objects.equals(this.gender, orderPassenger.gender) &&
        Objects.equals(this.givenName, orderPassenger.givenName) &&
        Objects.equals(this.id, orderPassenger.id) &&
        Objects.equals(this.infantPassengerId, orderPassenger.infantPassengerId) &&
        Objects.equals(this.loyaltyProgrammeAccounts, orderPassenger.loyaltyProgrammeAccounts) &&
        Objects.equals(this.phoneNumber, orderPassenger.phoneNumber) &&
        Objects.equals(this.title, orderPassenger.title) &&
        Objects.equals(this.type, orderPassenger.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bornOn, email, familyName, gender, givenName, id, infantPassengerId, loyaltyProgrammeAccounts, phoneNumber, title, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderPassenger {\n");
    sb.append("    bornOn: ").append(toIndentedString(bornOn)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    familyName: ").append(toIndentedString(familyName)).append("\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    givenName: ").append(toIndentedString(givenName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    infantPassengerId: ").append(toIndentedString(infantPassengerId)).append("\n");
    sb.append("    loyaltyProgrammeAccounts: ").append(toIndentedString(loyaltyProgrammeAccounts)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

