/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OrderRequestPassengerIdentityDocument
 */
@JsonPropertyOrder({
  OrderRequestPassengerIdentityDocument.JSON_PROPERTY_EXPIRES_ON,
  OrderRequestPassengerIdentityDocument.JSON_PROPERTY_ISSUING_COUNTRY_CODE,
  OrderRequestPassengerIdentityDocument.JSON_PROPERTY_TYPE,
  OrderRequestPassengerIdentityDocument.JSON_PROPERTY_UNIQUE_IDENTIFIER
})
@JsonTypeName("Order_Request_Passenger_Identity_Document")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OrderRequestPassengerIdentityDocument {
  public static final String JSON_PROPERTY_EXPIRES_ON = "expires_on";
  private LocalDate expiresOn;

  public static final String JSON_PROPERTY_ISSUING_COUNTRY_CODE = "issuing_country_code";
  private String issuingCountryCode;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_UNIQUE_IDENTIFIER = "unique_identifier";
  private String uniqueIdentifier;

  public OrderRequestPassengerIdentityDocument() {
  }

  public OrderRequestPassengerIdentityDocument expiresOn(LocalDate expiresOn) {
    
    this.expiresOn = expiresOn;
    return this;
  }

   /**
   * The date on which the identity document expires
   * @return expiresOn
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_EXPIRES_ON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getExpiresOn() {
    return expiresOn;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_ON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setExpiresOn(LocalDate expiresOn) {
    this.expiresOn = expiresOn;
  }


  public OrderRequestPassengerIdentityDocument issuingCountryCode(String issuingCountryCode) {
    
    this.issuingCountryCode = issuingCountryCode;
    return this;
  }

   /**
   * The [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) code of the country that issued this identity document
   * @return issuingCountryCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ISSUING_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIssuingCountryCode() {
    return issuingCountryCode;
  }


  @JsonProperty(JSON_PROPERTY_ISSUING_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIssuingCountryCode(String issuingCountryCode) {
    this.issuingCountryCode = issuingCountryCode;
  }


  public OrderRequestPassengerIdentityDocument type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the identity document. Currently, the only supported type is &#x60;passport&#x60;. This must be one of the &#x60;allowed_passenger_identity_document_types&#x60; on the offer.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(String type) {
    this.type = type;
  }


  public OrderRequestPassengerIdentityDocument uniqueIdentifier(String uniqueIdentifier) {
    
    this.uniqueIdentifier = uniqueIdentifier;
    return this;
  }

   /**
   * The unique identifier of the identity document. We currently only support passport so this would be the passport number.
   * @return uniqueIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_UNIQUE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUniqueIdentifier() {
    return uniqueIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_UNIQUE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUniqueIdentifier(String uniqueIdentifier) {
    this.uniqueIdentifier = uniqueIdentifier;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderRequestPassengerIdentityDocument orderRequestPassengerIdentityDocument = (OrderRequestPassengerIdentityDocument) o;
    return Objects.equals(this.expiresOn, orderRequestPassengerIdentityDocument.expiresOn) &&
        Objects.equals(this.issuingCountryCode, orderRequestPassengerIdentityDocument.issuingCountryCode) &&
        Objects.equals(this.type, orderRequestPassengerIdentityDocument.type) &&
        Objects.equals(this.uniqueIdentifier, orderRequestPassengerIdentityDocument.uniqueIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(expiresOn, issuingCountryCode, type, uniqueIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderRequestPassengerIdentityDocument {\n");
    sb.append("    expiresOn: ").append(toIndentedString(expiresOn)).append("\n");
    sb.append("    issuingCountryCode: ").append(toIndentedString(issuingCountryCode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    uniqueIdentifier: ").append(toIndentedString(uniqueIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

