/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OrderSliceConditions1;
import com.duffel.sdk.model.OrderSliceSegment;
import com.duffel.sdk.model.Place1;
import com.duffel.sdk.model.Place2;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OrderSlice
 */
@JsonPropertyOrder({
  OrderSlice.JSON_PROPERTY_CHANGEABLE,
  OrderSlice.JSON_PROPERTY_CONDITIONS,
  OrderSlice.JSON_PROPERTY_DESTINATION,
  OrderSlice.JSON_PROPERTY_DESTINATION_TYPE,
  OrderSlice.JSON_PROPERTY_DURATION,
  OrderSlice.JSON_PROPERTY_ID,
  OrderSlice.JSON_PROPERTY_ORIGIN,
  OrderSlice.JSON_PROPERTY_ORIGIN_TYPE,
  OrderSlice.JSON_PROPERTY_SEGMENTS
})
@JsonTypeName("Order_Slice")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OrderSlice {
  public static final String JSON_PROPERTY_CHANGEABLE = "changeable";
  private Boolean changeable;

  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private OrderSliceConditions1 conditions;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private Place1 destination;

  /**
   * The type of the destination
   */
  public enum DestinationTypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    DestinationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DestinationTypeEnum fromValue(String value) {
      for (DestinationTypeEnum b : DestinationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DESTINATION_TYPE = "destination_type";
  private DestinationTypeEnum destinationType;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private String duration;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private Place2 origin;

  /**
   * The type of the origin
   */
  public enum OriginTypeEnum {
    AIRPORT("airport"),
    
    CITY("city");

    private String value;

    OriginTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OriginTypeEnum fromValue(String value) {
      for (OriginTypeEnum b : OriginTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ORIGIN_TYPE = "origin_type";
  private OriginTypeEnum originType;

  public static final String JSON_PROPERTY_SEGMENTS = "segments";
  private List<OrderSliceSegment> segments = new ArrayList<>();

  public OrderSlice() {
  }

  public OrderSlice changeable(Boolean changeable) {
    
    this.changeable = changeable;
    return this;
  }

   /**
   * Whether this slice can be changed. This can only be &#x60;true&#x60; for paid orders. This field is deprecated and has been replaced with the [new &#x60;available_actions&#x60; field](https://duffel.com/docs/api/orders#orders-schema-available-actions) at the top-level __Order__ schema.
   * @return changeable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHANGEABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getChangeable() {
    return changeable;
  }


  @JsonProperty(JSON_PROPERTY_CHANGEABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChangeable(Boolean changeable) {
    this.changeable = changeable;
  }


  public OrderSlice conditions(OrderSliceConditions1 conditions) {
    
    this.conditions = conditions;
    return this;
  }

   /**
   * Get conditions
   * @return conditions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OrderSliceConditions1 getConditions() {
    return conditions;
  }


  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setConditions(OrderSliceConditions1 conditions) {
    this.conditions = conditions;
  }


  public OrderSlice destination(Place1 destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Get destination
   * @return destination
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Place1 getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDestination(Place1 destination) {
    this.destination = destination;
  }


  public OrderSlice destinationType(DestinationTypeEnum destinationType) {
    
    this.destinationType = destinationType;
    return this;
  }

   /**
   * The type of the destination
   * @return destinationType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DestinationTypeEnum getDestinationType() {
    return destinationType;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDestinationType(DestinationTypeEnum destinationType) {
    this.destinationType = destinationType;
  }


  public OrderSlice duration(String duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * The duration of the slice, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration
   * @return duration
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDuration() {
    return duration;
  }


  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDuration(String duration) {
    this.duration = duration;
  }


  public OrderSlice id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the slice. It identifies the slice of an order (i.e. the same slice across orders will have different &#x60;id&#x60;s.
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderSlice origin(Place2 origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * Get origin
   * @return origin
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Place2 getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOrigin(Place2 origin) {
    this.origin = origin;
  }


  public OrderSlice originType(OriginTypeEnum originType) {
    
    this.originType = originType;
    return this;
  }

   /**
   * The type of the origin
   * @return originType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OriginTypeEnum getOriginType() {
    return originType;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOriginType(OriginTypeEnum originType) {
    this.originType = originType;
  }


  public OrderSlice segments(List<OrderSliceSegment> segments) {
    
    this.segments = segments;
    return this;
  }

  public OrderSlice addSegmentsItem(OrderSliceSegment segmentsItem) {
    if (this.segments == null) {
      this.segments = new ArrayList<>();
    }
    this.segments.add(segmentsItem);
    return this;
  }

   /**
   * The segments - that is, specific flights - that the airline is offering to get the passengers from the &#x60;origin&#x60; to the &#x60;destination&#x60;
   * @return segments
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SEGMENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OrderSliceSegment> getSegments() {
    return segments;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSegments(List<OrderSliceSegment> segments) {
    this.segments = segments;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderSlice orderSlice = (OrderSlice) o;
    return Objects.equals(this.changeable, orderSlice.changeable) &&
        Objects.equals(this.conditions, orderSlice.conditions) &&
        Objects.equals(this.destination, orderSlice.destination) &&
        Objects.equals(this.destinationType, orderSlice.destinationType) &&
        Objects.equals(this.duration, orderSlice.duration) &&
        Objects.equals(this.id, orderSlice.id) &&
        Objects.equals(this.origin, orderSlice.origin) &&
        Objects.equals(this.originType, orderSlice.originType) &&
        Objects.equals(this.segments, orderSlice.segments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeable, conditions, destination, destinationType, duration, id, origin, originType, segments);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderSlice {\n");
    sb.append("    changeable: ").append(toIndentedString(changeable)).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    destinationType: ").append(toIndentedString(destinationType)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    originType: ").append(toIndentedString(originType)).append("\n");
    sb.append("    segments: ").append(toIndentedString(segments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

