/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.Aircraft1;
import com.duffel.sdk.model.Airline2;
import com.duffel.sdk.model.Airline3;
import com.duffel.sdk.model.Airport3;
import com.duffel.sdk.model.OrderChangeSlicesSliceSegmentsInnerDestination;
import com.duffel.sdk.model.OrderSliceSegmentPassenger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * OrderSliceSegment
 */
@JsonPropertyOrder({
  OrderSliceSegment.JSON_PROPERTY_AIRCRAFT,
  OrderSliceSegment.JSON_PROPERTY_ARRIVAL_DATETIME,
  OrderSliceSegment.JSON_PROPERTY_ARRIVAL_TERMINAL,
  OrderSliceSegment.JSON_PROPERTY_ARRIVING_AT,
  OrderSliceSegment.JSON_PROPERTY_DEPARTING_AT,
  OrderSliceSegment.JSON_PROPERTY_DEPARTURE_DATETIME,
  OrderSliceSegment.JSON_PROPERTY_DEPARTURE_TERMINAL,
  OrderSliceSegment.JSON_PROPERTY_DESTINATION,
  OrderSliceSegment.JSON_PROPERTY_DESTINATION_TERMINAL,
  OrderSliceSegment.JSON_PROPERTY_DISTANCE,
  OrderSliceSegment.JSON_PROPERTY_DURATION,
  OrderSliceSegment.JSON_PROPERTY_ID,
  OrderSliceSegment.JSON_PROPERTY_MARKETING_CARRIER,
  OrderSliceSegment.JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER,
  OrderSliceSegment.JSON_PROPERTY_OPERATING_CARRIER,
  OrderSliceSegment.JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER,
  OrderSliceSegment.JSON_PROPERTY_ORIGIN,
  OrderSliceSegment.JSON_PROPERTY_ORIGIN_TERMINAL,
  OrderSliceSegment.JSON_PROPERTY_PASSENGERS
})
@JsonTypeName("Order_Slice_Segment")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class OrderSliceSegment {
  public static final String JSON_PROPERTY_AIRCRAFT = "aircraft";
  private Aircraft1 aircraft;

  public static final String JSON_PROPERTY_ARRIVAL_DATETIME = "arrival_datetime";
  private String arrivalDatetime;

  public static final String JSON_PROPERTY_ARRIVAL_TERMINAL = "arrival_terminal";
  private String arrivalTerminal;

  public static final String JSON_PROPERTY_ARRIVING_AT = "arriving_at";
  private String arrivingAt;

  public static final String JSON_PROPERTY_DEPARTING_AT = "departing_at";
  private String departingAt;

  public static final String JSON_PROPERTY_DEPARTURE_DATETIME = "departure_datetime";
  private String departureDatetime;

  public static final String JSON_PROPERTY_DEPARTURE_TERMINAL = "departure_terminal";
  private String departureTerminal;

  public static final String JSON_PROPERTY_DESTINATION = "destination";
  private OrderChangeSlicesSliceSegmentsInnerDestination destination;

  public static final String JSON_PROPERTY_DESTINATION_TERMINAL = "destination_terminal";
  private String destinationTerminal;

  public static final String JSON_PROPERTY_DISTANCE = "distance";
  private String distance;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private String duration;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_MARKETING_CARRIER = "marketing_carrier";
  private Airline2 marketingCarrier;

  public static final String JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER = "marketing_carrier_flight_number";
  private String marketingCarrierFlightNumber;

  public static final String JSON_PROPERTY_OPERATING_CARRIER = "operating_carrier";
  private Airline3 operatingCarrier;

  public static final String JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER = "operating_carrier_flight_number";
  private String operatingCarrierFlightNumber;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private Airport3 origin;

  public static final String JSON_PROPERTY_ORIGIN_TERMINAL = "origin_terminal";
  private String originTerminal;

  public static final String JSON_PROPERTY_PASSENGERS = "passengers";
  private List<OrderSliceSegmentPassenger> passengers = new ArrayList<>();

  public OrderSliceSegment() {
  }

  public OrderSliceSegment aircraft(Aircraft1 aircraft) {
    
    this.aircraft = aircraft;
    return this;
  }

   /**
   * Get aircraft
   * @return aircraft
  **/
  @jakarta.annotation.Nullable
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_AIRCRAFT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Aircraft1 getAircraft() {
    return aircraft;
  }


  @JsonProperty(JSON_PROPERTY_AIRCRAFT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAircraft(Aircraft1 aircraft) {
    this.aircraft = aircraft;
  }


  public OrderSliceSegment arrivalDatetime(String arrivalDatetime) {
    
    this.arrivalDatetime = arrivalDatetime;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to arrive. You should use the &#x60;arriving_at&#x60; attribute instead of this attribute, as this will be removed in the next API version.
   * @return arrivalDatetime
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ARRIVAL_DATETIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getArrivalDatetime() {
    return arrivalDatetime;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_DATETIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setArrivalDatetime(String arrivalDatetime) {
    this.arrivalDatetime = arrivalDatetime;
  }


  public OrderSliceSegment arrivalTerminal(String arrivalTerminal) {
    
    this.arrivalTerminal = arrivalTerminal;
    return this;
  }

   /**
   * The terminal at the &#x60;destination&#x60; airport where the segment is scheduled to arrive. You should use the &#x60;destination_terminal&#x60; attribute instead of this attribute, as this will be removed in the next API version.
   * @return arrivalTerminal
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_ARRIVAL_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getArrivalTerminal() {
    return arrivalTerminal;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setArrivalTerminal(String arrivalTerminal) {
    this.arrivalTerminal = arrivalTerminal;
  }


  public OrderSliceSegment arrivingAt(String arrivingAt) {
    
    this.arrivingAt = arrivingAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to arrive, in the destination airport timezone (see &#x60;destination.timezone&#x60;)
   * @return arrivingAt
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ARRIVING_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getArrivingAt() {
    return arrivingAt;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVING_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setArrivingAt(String arrivingAt) {
    this.arrivingAt = arrivingAt;
  }


  public OrderSliceSegment departingAt(String departingAt) {
    
    this.departingAt = departingAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to depart, in the origin airport timezone (see &#x60;origin.timezone&#x60;)
   * @return departingAt
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DEPARTING_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDepartingAt() {
    return departingAt;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTING_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDepartingAt(String departingAt) {
    this.departingAt = departingAt;
  }


  public OrderSliceSegment departureDatetime(String departureDatetime) {
    
    this.departureDatetime = departureDatetime;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the segment is scheduled to depart. You should use the &#x60;departing_at&#x60; attribute instead of this attribute, as this will be removed in the next API version.
   * @return departureDatetime
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATETIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDepartureDatetime() {
    return departureDatetime;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DATETIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDepartureDatetime(String departureDatetime) {
    this.departureDatetime = departureDatetime;
  }


  public OrderSliceSegment departureTerminal(String departureTerminal) {
    
    this.departureTerminal = departureTerminal;
    return this;
  }

   /**
   * The terminal at the &#x60;origin&#x60; airport from which the segment is scheduled to depart. You should use the &#x60;origin_terminal&#x60; attribute instead of this attribute, as this will be removed in the next API version.
   * @return departureTerminal
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_DEPARTURE_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDepartureTerminal() {
    return departureTerminal;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDepartureTerminal(String departureTerminal) {
    this.departureTerminal = departureTerminal;
  }


  public OrderSliceSegment destination(OrderChangeSlicesSliceSegmentsInnerDestination destination) {
    
    this.destination = destination;
    return this;
  }

   /**
   * Get destination
   * @return destination
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OrderChangeSlicesSliceSegmentsInnerDestination getDestination() {
    return destination;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDestination(OrderChangeSlicesSliceSegmentsInnerDestination destination) {
    this.destination = destination;
  }


  public OrderSliceSegment destinationTerminal(String destinationTerminal) {
    
    this.destinationTerminal = destinationTerminal;
    return this;
  }

   /**
   * The terminal at the &#x60;destination&#x60; airport where the segment is scheduled to arrive
   * @return destinationTerminal
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESTINATION_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDestinationTerminal() {
    return destinationTerminal;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDestinationTerminal(String destinationTerminal) {
    this.destinationTerminal = destinationTerminal;
  }


  public OrderSliceSegment distance(String distance) {
    
    this.distance = distance;
    return this;
  }

   /**
   * The distance of the segment in kilometres
   * @return distance
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDistance() {
    return distance;
  }


  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDistance(String distance) {
    this.distance = distance;
  }


  public OrderSliceSegment duration(String duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * The duration of the segment, represented as a [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Durations) duration
   * @return duration
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDuration() {
    return duration;
  }


  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDuration(String duration) {
    this.duration = duration;
  }


  public OrderSliceSegment id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the segment. It identifies the segment of an order (i.e. the same segment across orders will have different &#x60;id&#x60;s.
   * @return id
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(String id) {
    this.id = id;
  }


  public OrderSliceSegment marketingCarrier(Airline2 marketingCarrier) {
    
    this.marketingCarrier = marketingCarrier;
    return this;
  }

   /**
   * Get marketingCarrier
   * @return marketingCarrier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Airline2 getMarketingCarrier() {
    return marketingCarrier;
  }


  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMarketingCarrier(Airline2 marketingCarrier) {
    this.marketingCarrier = marketingCarrier;
  }


  public OrderSliceSegment marketingCarrierFlightNumber(String marketingCarrierFlightNumber) {
    
    this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
    return this;
  }

   /**
   * The flight number assigned by the marketing carrier
   * @return marketingCarrierFlightNumber
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMarketingCarrierFlightNumber() {
    return marketingCarrierFlightNumber;
  }


  @JsonProperty(JSON_PROPERTY_MARKETING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMarketingCarrierFlightNumber(String marketingCarrierFlightNumber) {
    this.marketingCarrierFlightNumber = marketingCarrierFlightNumber;
  }


  public OrderSliceSegment operatingCarrier(Airline3 operatingCarrier) {
    
    this.operatingCarrier = operatingCarrier;
    return this;
  }

   /**
   * Get operatingCarrier
   * @return operatingCarrier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Airline3 getOperatingCarrier() {
    return operatingCarrier;
  }


  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOperatingCarrier(Airline3 operatingCarrier) {
    this.operatingCarrier = operatingCarrier;
  }


  public OrderSliceSegment operatingCarrierFlightNumber(String operatingCarrierFlightNumber) {
    
    this.operatingCarrierFlightNumber = operatingCarrierFlightNumber;
    return this;
  }

   /**
   * The flight number assigned by the operating carrier. This may not be present, in which case you should display the &#x60;marketing_carrier&#x60;&#39;s information and the &#x60;marketing_carrier_flight_number&#x60;, and simply state the name of the &#x60;operating_carrier&#x60;.
   * @return operatingCarrierFlightNumber
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOperatingCarrierFlightNumber() {
    return operatingCarrierFlightNumber;
  }


  @JsonProperty(JSON_PROPERTY_OPERATING_CARRIER_FLIGHT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOperatingCarrierFlightNumber(String operatingCarrierFlightNumber) {
    this.operatingCarrierFlightNumber = operatingCarrierFlightNumber;
  }


  public OrderSliceSegment origin(Airport3 origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * Get origin
   * @return origin
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Airport3 getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOrigin(Airport3 origin) {
    this.origin = origin;
  }


  public OrderSliceSegment originTerminal(String originTerminal) {
    
    this.originTerminal = originTerminal;
    return this;
  }

   /**
   * The terminal at the &#x60;origin&#x60; airport from which the segment is scheduled to depart
   * @return originTerminal
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_ORIGIN_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOriginTerminal() {
    return originTerminal;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN_TERMINAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOriginTerminal(String originTerminal) {
    this.originTerminal = originTerminal;
  }


  public OrderSliceSegment passengers(List<OrderSliceSegmentPassenger> passengers) {
    
    this.passengers = passengers;
    return this;
  }

  public OrderSliceSegment addPassengersItem(OrderSliceSegmentPassenger passengersItem) {
    if (this.passengers == null) {
      this.passengers = new ArrayList<>();
    }
    this.passengers.add(passengersItem);
    return this;
  }

   /**
   * Additional segment-specific information about the passengers included in the offer (e.g. their baggage allowance and the cabin class they will be travelling in)
   * @return passengers
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<OrderSliceSegmentPassenger> getPassengers() {
    return passengers;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPassengers(List<OrderSliceSegmentPassenger> passengers) {
    this.passengers = passengers;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderSliceSegment orderSliceSegment = (OrderSliceSegment) o;
    return Objects.equals(this.aircraft, orderSliceSegment.aircraft) &&
        Objects.equals(this.arrivalDatetime, orderSliceSegment.arrivalDatetime) &&
        Objects.equals(this.arrivalTerminal, orderSliceSegment.arrivalTerminal) &&
        Objects.equals(this.arrivingAt, orderSliceSegment.arrivingAt) &&
        Objects.equals(this.departingAt, orderSliceSegment.departingAt) &&
        Objects.equals(this.departureDatetime, orderSliceSegment.departureDatetime) &&
        Objects.equals(this.departureTerminal, orderSliceSegment.departureTerminal) &&
        Objects.equals(this.destination, orderSliceSegment.destination) &&
        Objects.equals(this.destinationTerminal, orderSliceSegment.destinationTerminal) &&
        Objects.equals(this.distance, orderSliceSegment.distance) &&
        Objects.equals(this.duration, orderSliceSegment.duration) &&
        Objects.equals(this.id, orderSliceSegment.id) &&
        Objects.equals(this.marketingCarrier, orderSliceSegment.marketingCarrier) &&
        Objects.equals(this.marketingCarrierFlightNumber, orderSliceSegment.marketingCarrierFlightNumber) &&
        Objects.equals(this.operatingCarrier, orderSliceSegment.operatingCarrier) &&
        Objects.equals(this.operatingCarrierFlightNumber, orderSliceSegment.operatingCarrierFlightNumber) &&
        Objects.equals(this.origin, orderSliceSegment.origin) &&
        Objects.equals(this.originTerminal, orderSliceSegment.originTerminal) &&
        Objects.equals(this.passengers, orderSliceSegment.passengers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(aircraft, arrivalDatetime, arrivalTerminal, arrivingAt, departingAt, departureDatetime, departureTerminal, destination, destinationTerminal, distance, duration, id, marketingCarrier, marketingCarrierFlightNumber, operatingCarrier, operatingCarrierFlightNumber, origin, originTerminal, passengers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderSliceSegment {\n");
    sb.append("    aircraft: ").append(toIndentedString(aircraft)).append("\n");
    sb.append("    arrivalDatetime: ").append(toIndentedString(arrivalDatetime)).append("\n");
    sb.append("    arrivalTerminal: ").append(toIndentedString(arrivalTerminal)).append("\n");
    sb.append("    arrivingAt: ").append(toIndentedString(arrivingAt)).append("\n");
    sb.append("    departingAt: ").append(toIndentedString(departingAt)).append("\n");
    sb.append("    departureDatetime: ").append(toIndentedString(departureDatetime)).append("\n");
    sb.append("    departureTerminal: ").append(toIndentedString(departureTerminal)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    destinationTerminal: ").append(toIndentedString(destinationTerminal)).append("\n");
    sb.append("    distance: ").append(toIndentedString(distance)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    marketingCarrier: ").append(toIndentedString(marketingCarrier)).append("\n");
    sb.append("    marketingCarrierFlightNumber: ").append(toIndentedString(marketingCarrierFlightNumber)).append("\n");
    sb.append("    operatingCarrier: ").append(toIndentedString(operatingCarrier)).append("\n");
    sb.append("    operatingCarrierFlightNumber: ").append(toIndentedString(operatingCarrierFlightNumber)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    originTerminal: ").append(toIndentedString(originTerminal)).append("\n");
    sb.append("    passengers: ").append(toIndentedString(passengers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

