/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.duffel.sdk.model.OfferIndex;
import com.duffel.sdk.model.OfferRequestPassenger;
import com.duffel.sdk.model.OfferRequestSlice;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PartialOfferRequest
 */
@JsonPropertyOrder({
  PartialOfferRequest.JSON_PROPERTY_CABIN_CLASS,
  PartialOfferRequest.JSON_PROPERTY_CREATED_AT,
  PartialOfferRequest.JSON_PROPERTY_ID,
  PartialOfferRequest.JSON_PROPERTY_LIVE_MODE,
  PartialOfferRequest.JSON_PROPERTY_OFFERS,
  PartialOfferRequest.JSON_PROPERTY_PASSENGERS,
  PartialOfferRequest.JSON_PROPERTY_SLICES
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class PartialOfferRequest {
  /**
   * The cabin that the passengers want to travel in
   */
  public enum CabinClassEnum {
    FIRST("first"),
    
    BUSINESS("business"),
    
    PREMIUM_ECONOMY("premium_economy"),
    
    ECONOMY("economy");

    private String value;

    CabinClassEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CabinClassEnum fromValue(String value) {
      for (CabinClassEnum b : CabinClassEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
  private CabinClassEnum cabinClass;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private java.time.LocalDateTime createdAt;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
  private Boolean liveMode;

  public static final String JSON_PROPERTY_OFFERS = "offers";
  private List<OfferIndex> offers;

  public static final String JSON_PROPERTY_PASSENGERS = "passengers";
  private List<OfferRequestPassenger> passengers;

  public static final String JSON_PROPERTY_SLICES = "slices";
  private List<OfferRequestSlice> slices;

  public PartialOfferRequest() {
  }

  public PartialOfferRequest cabinClass(CabinClassEnum cabinClass) {
    
    this.cabinClass = cabinClass;
    return this;
  }

   /**
   * The cabin that the passengers want to travel in
   * @return cabinClass
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CabinClassEnum getCabinClass() {
    return cabinClass;
  }


  @JsonProperty(JSON_PROPERTY_CABIN_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCabinClass(CabinClassEnum cabinClass) {
    this.cabinClass = cabinClass;
  }


  public PartialOfferRequest createdAt(java.time.LocalDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) datetime at which the offer request was created
   * @return createdAt
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(java.time.LocalDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public PartialOfferRequest id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Duffel&#39;s unique identifier for the offer request
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public PartialOfferRequest liveMode(Boolean liveMode) {
    
    this.liveMode = liveMode;
    return this;
  }

   /**
   * Whether the offer request was created in live mode. This field will be set to &#x60;true&#x60; if the offer request was created in live mode, or &#x60;false&#x60; if it was created in test mode.
   * @return liveMode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLiveMode() {
    return liveMode;
  }


  @JsonProperty(JSON_PROPERTY_LIVE_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLiveMode(Boolean liveMode) {
    this.liveMode = liveMode;
  }


  public PartialOfferRequest offers(List<OfferIndex> offers) {
    
    this.offers = offers;
    return this;
  }

  public PartialOfferRequest addOffersItem(OfferIndex offersItem) {
    if (this.offers == null) {
      this.offers = new ArrayList<>();
    }
    this.offers.add(offersItem);
    return this;
  }

   /**
   * The offers returned by the airlines
   * @return offers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferIndex> getOffers() {
    return offers;
  }


  @JsonProperty(JSON_PROPERTY_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOffers(List<OfferIndex> offers) {
    this.offers = offers;
  }


  public PartialOfferRequest passengers(List<OfferRequestPassenger> passengers) {
    
    this.passengers = passengers;
    return this;
  }

  public PartialOfferRequest addPassengersItem(OfferRequestPassenger passengersItem) {
    if (this.passengers == null) {
      this.passengers = new ArrayList<>();
    }
    this.passengers.add(passengersItem);
    return this;
  }

   /**
   * The passengers who want to travel
   * @return passengers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferRequestPassenger> getPassengers() {
    return passengers;
  }


  @JsonProperty(JSON_PROPERTY_PASSENGERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassengers(List<OfferRequestPassenger> passengers) {
    this.passengers = passengers;
  }


  public PartialOfferRequest slices(List<OfferRequestSlice> slices) {
    
    this.slices = slices;
    return this;
  }

  public PartialOfferRequest addSlicesItem(OfferRequestSlice slicesItem) {
    if (this.slices == null) {
      this.slices = new ArrayList<>();
    }
    this.slices.add(slicesItem);
    return this;
  }

   /**
   * The [slices](/docs/api/overview/key-principles) that make up this offer request. One-way journeys can be expressed using one slice, whereas return trips will need two.
   * @return slices
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OfferRequestSlice> getSlices() {
    return slices;
  }


  @JsonProperty(JSON_PROPERTY_SLICES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSlices(List<OfferRequestSlice> slices) {
    this.slices = slices;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PartialOfferRequest partialOfferRequest = (PartialOfferRequest) o;
    return Objects.equals(this.cabinClass, partialOfferRequest.cabinClass) &&
        Objects.equals(this.createdAt, partialOfferRequest.createdAt) &&
        Objects.equals(this.id, partialOfferRequest.id) &&
        Objects.equals(this.liveMode, partialOfferRequest.liveMode) &&
        Objects.equals(this.offers, partialOfferRequest.offers) &&
        Objects.equals(this.passengers, partialOfferRequest.passengers) &&
        Objects.equals(this.slices, partialOfferRequest.slices);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cabinClass, createdAt, id, liveMode, offers, passengers, slices);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PartialOfferRequest {\n");
    sb.append("    cabinClass: ").append(toIndentedString(cabinClass)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    liveMode: ").append(toIndentedString(liveMode)).append("\n");
    sb.append("    offers: ").append(toIndentedString(offers)).append("\n");
    sb.append("    passengers: ").append(toIndentedString(passengers)).append("\n");
    sb.append("    slices: ").append(toIndentedString(slices)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

