/*
 * Duffel
 * We offer the most powerful and intuitive tools for starting and growing a travel business. Search, book and manage flights across multiple airlines, through a single platform
 *
 * The version of the OpenAPI document: beta
 * Contact: hello@duffel.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.duffel.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * An object containing metadata about the service, like the designator of the  seat. 
 */
@JsonPropertyOrder({
  ServiceMetadataForASeat.JSON_PROPERTY_DESIGNATOR,
  ServiceMetadataForASeat.JSON_PROPERTY_DISCLOSURES,
  ServiceMetadataForASeat.JSON_PROPERTY_NAME
})
@JsonTypeName("Service_Metadata_for_a_Seat")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-16T15:26:22.356688490+07:00[Asia/Bangkok]")
public class ServiceMetadataForASeat {
  public static final String JSON_PROPERTY_DESIGNATOR = "designator";
  private String designator;

  public static final String JSON_PROPERTY_DISCLOSURES = "disclosures";
  private List<String> disclosures = new ArrayList<>();

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public ServiceMetadataForASeat() {
  }

  public ServiceMetadataForASeat designator(String designator) {
    
    this.designator = designator;
    return this;
  }

   /**
   * The designator used to uniquely identify the seat, usually made up of a  row number and a column letter 
   * @return designator
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDesignator() {
    return designator;
  }


  @JsonProperty(JSON_PROPERTY_DESIGNATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDesignator(String designator) {
    this.designator = designator;
  }


  public ServiceMetadataForASeat disclosures(List<String> disclosures) {
    
    this.disclosures = disclosures;
    return this;
  }

  public ServiceMetadataForASeat addDisclosuresItem(String disclosuresItem) {
    if (this.disclosures == null) {
      this.disclosures = new ArrayList<>();
    }
    this.disclosures.add(disclosuresItem);
    return this;
  }

   /**
   * Each disclosure is text, in English, provided by the airline that  describes the terms and conditions of this seat. We recommend showing  this in your user interface to make sure that customers understand any  restrictions and limitations. 
   * @return disclosures
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getDisclosures() {
    return disclosures;
  }


  @JsonProperty(JSON_PROPERTY_DISCLOSURES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisclosures(List<String> disclosures) {
    this.disclosures = disclosures;
  }


  public ServiceMetadataForASeat name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * A name which describes the type of seat, which you can display in your  user interface to help customers to understand its features 
   * @return name
  **/
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServiceMetadataForASeat serviceMetadataForASeat = (ServiceMetadataForASeat) o;
    return Objects.equals(this.designator, serviceMetadataForASeat.designator) &&
        Objects.equals(this.disclosures, serviceMetadataForASeat.disclosures) &&
        Objects.equals(this.name, serviceMetadataForASeat.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(designator, disclosures, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServiceMetadataForASeat {\n");
    sb.append("    designator: ").append(toIndentedString(designator)).append("\n");
    sb.append("    disclosures: ").append(toIndentedString(disclosures)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

