/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;
import com.duffel.sdk.model.GetAircraft200Response;
import com.duffel.sdk.model.GetAircraftById200Response;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class AircraftApi {
    private ApiClient apiClient;

    public AircraftApi() {
        this(new ApiClient());
    }

    @Autowired
    public AircraftApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec getAircraftRequestCreation(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getAircraft", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getAircraft", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetAircraft200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraft200Response>(this){};
        return this.apiClient.invokeAPI("/air/aircraft", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetAircraft200Response> getAircraft(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        ParameterizedTypeReference<GetAircraft200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraft200Response>(this){};
        return this.getAircraftRequestCreation(accept, duffelVersion, acceptEncoding, limit, before, after).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetAircraft200Response>> getAircraftWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        ParameterizedTypeReference<GetAircraft200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraft200Response>(this){};
        return this.getAircraftRequestCreation(accept, duffelVersion, acceptEncoding, limit, before, after).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAircraftWithResponseSpec(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        return this.getAircraftRequestCreation(accept, duffelVersion, acceptEncoding, limit, before, after);
    }

    private WebClient.ResponseSpec getAircraftByIdRequestCreation(String id) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getAircraftById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetAircraftById200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraftById200Response>(this){};
        return this.apiClient.invokeAPI("/air/aircraft/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetAircraftById200Response> getAircraftById(String id) throws WebClientResponseException {
        ParameterizedTypeReference<GetAircraftById200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraftById200Response>(this){};
        return this.getAircraftByIdRequestCreation(id).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetAircraftById200Response>> getAircraftByIdWithHttpInfo(String id) throws WebClientResponseException {
        ParameterizedTypeReference<GetAircraftById200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraftById200Response>(this){};
        return this.getAircraftByIdRequestCreation(id).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAircraftByIdWithResponseSpec(String id) throws WebClientResponseException {
        return this.getAircraftByIdRequestCreation(id);
    }
}

