/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;
import com.duffel.sdk.model.CreateOrderRequest;
import com.duffel.sdk.model.GetOrderById200Response;
import com.duffel.sdk.model.GetOrders200Response;
import com.duffel.sdk.model.GetOrdersArrivingAtParameter;
import com.duffel.sdk.model.GetOrdersCreatedAtParameter;
import com.duffel.sdk.model.GetOrdersDepartingAtParameter;
import com.duffel.sdk.model.UpdateOrderByIdRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class OrdersApi {
    private ApiClient apiClient;

    public OrdersApi() {
        this(new ApiClient());
    }

    @Autowired
    public OrdersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createOrderRequestCreation(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        CreateOrderRequest postBody = createOrderRequest;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createOrder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createOrder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (createOrderRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createOrderRequest' when calling createOrder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (contentType != null) {
            headerParams.add("Content-Type", this.apiClient.parameterToString(contentType));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>(this){};
        return this.apiClient.invokeAPI("/air/orders", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetOrderById200Response> createOrder(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>(this){};
        return this.createOrderRequestCreation(accept, duffelVersion, createOrderRequest, acceptEncoding, contentType).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderById200Response>> createOrderWithHttpInfo(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>(this){};
        return this.createOrderRequestCreation(accept, duffelVersion, createOrderRequest, acceptEncoding, contentType).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createOrderWithResponseSpec(String accept, String duffelVersion, CreateOrderRequest createOrderRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        return this.createOrderRequestCreation(accept, duffelVersion, createOrderRequest, acceptEncoding, contentType);
    }

    private WebClient.ResponseSpec getOrderByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>(this){};
        return this.apiClient.invokeAPI("/air/orders/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetOrderById200Response> getOrderById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>(this){};
        return this.getOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderById200Response>> getOrderByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>(this){};
        return this.getOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getOrderByIdWithResponseSpec(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        return this.getOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding);
    }

    private WebClient.ResponseSpec getOrdersRequestCreation(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getOrders", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getOrders", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "booking_reference", bookingReference));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "awaiting_payment", awaitingPayment));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "sort", sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "owner_id[]", ownerId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "origin_id[]", originId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "destination_id[]", destinationId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "departing_at", departingAt));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "arriving_at", arrivingAt));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "created_at", createdAt));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "passenger_name[]", passengerName));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "requires_action", requiresAction));
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetOrders200Response> localVarReturnType = new ParameterizedTypeReference<GetOrders200Response>(this){};
        return this.apiClient.invokeAPI("/air/orders", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetOrders200Response> getOrders(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrders200Response> localVarReturnType = new ParameterizedTypeReference<GetOrders200Response>(this){};
        return this.getOrdersRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, bookingReference, awaitingPayment, sort, ownerId, originId, destinationId, departingAt, arrivingAt, createdAt, passengerName, requiresAction).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrders200Response>> getOrdersWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrders200Response> localVarReturnType = new ParameterizedTypeReference<GetOrders200Response>(this){};
        return this.getOrdersRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, bookingReference, awaitingPayment, sort, ownerId, originId, destinationId, departingAt, arrivingAt, createdAt, passengerName, requiresAction).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getOrdersWithResponseSpec(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String bookingReference, Boolean awaitingPayment, String sort, List<String> ownerId, List<String> originId, List<String> destinationId, GetOrdersDepartingAtParameter departingAt, GetOrdersArrivingAtParameter arrivingAt, GetOrdersCreatedAtParameter createdAt, List<String> passengerName, Boolean requiresAction) throws WebClientResponseException {
        return this.getOrdersRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, bookingReference, awaitingPayment, sort, ownerId, originId, destinationId, departingAt, arrivingAt, createdAt, passengerName, requiresAction);
    }

    private WebClient.ResponseSpec updateOrderByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        UpdateOrderByIdRequest postBody = updateOrderByIdRequest;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling updateOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling updateOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling updateOrderById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>(this){};
        return this.apiClient.invokeAPI("/air/orders/{id}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetOrderById200Response> updateOrderById(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>(this){};
        return this.updateOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, updateOrderByIdRequest).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetOrderById200Response>> updateOrderByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        ParameterizedTypeReference<GetOrderById200Response> localVarReturnType = new ParameterizedTypeReference<GetOrderById200Response>(this){};
        return this.updateOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, updateOrderByIdRequest).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateOrderByIdWithResponseSpec(String accept, String duffelVersion, String id, String acceptEncoding, UpdateOrderByIdRequest updateOrderByIdRequest) throws WebClientResponseException {
        return this.updateOrderByIdRequestCreation(accept, duffelVersion, id, acceptEncoding, updateOrderByIdRequest);
    }
}

