/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;
import com.duffel.sdk.model.CreateRefundRequest;
import com.duffel.sdk.model.GetRefundById200Response;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class RefundsApi {
    private ApiClient apiClient;

    public RefundsApi() {
        this(new ApiClient());
    }

    @Autowired
    public RefundsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRefundRequestCreation(String accept, String duffelVersion, CreateRefundRequest createRefundRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        CreateRefundRequest postBody = createRefundRequest;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling createRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling createRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (createRefundRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'createRefundRequest' when calling createRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (contentType != null) {
            headerParams.add("Content-Type", this.apiClient.parameterToString(contentType));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetRefundById200Response> localVarReturnType = new ParameterizedTypeReference<GetRefundById200Response>(this){};
        return this.apiClient.invokeAPI("/payments/refunds", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetRefundById200Response> createRefund(String accept, String duffelVersion, CreateRefundRequest createRefundRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<GetRefundById200Response> localVarReturnType = new ParameterizedTypeReference<GetRefundById200Response>(this){};
        return this.createRefundRequestCreation(accept, duffelVersion, createRefundRequest, acceptEncoding, contentType).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetRefundById200Response>> createRefundWithHttpInfo(String accept, String duffelVersion, CreateRefundRequest createRefundRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<GetRefundById200Response> localVarReturnType = new ParameterizedTypeReference<GetRefundById200Response>(this){};
        return this.createRefundRequestCreation(accept, duffelVersion, createRefundRequest, acceptEncoding, contentType).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createRefundWithResponseSpec(String accept, String duffelVersion, CreateRefundRequest createRefundRequest, String acceptEncoding, String contentType) throws WebClientResponseException {
        return this.createRefundRequestCreation(accept, duffelVersion, createRefundRequest, acceptEncoding, contentType);
    }

    private WebClient.ResponseSpec getRefundByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getRefundById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getRefundById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getRefundById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetRefundById200Response> localVarReturnType = new ParameterizedTypeReference<GetRefundById200Response>(this){};
        return this.apiClient.invokeAPI("/payments/refunds/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetRefundById200Response> getRefundById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetRefundById200Response> localVarReturnType = new ParameterizedTypeReference<GetRefundById200Response>(this){};
        return this.getRefundByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetRefundById200Response>> getRefundByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetRefundById200Response> localVarReturnType = new ParameterizedTypeReference<GetRefundById200Response>(this){};
        return this.getRefundByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getRefundByIdWithResponseSpec(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        return this.getRefundByIdRequestCreation(accept, duffelVersion, id, acceptEncoding);
    }
}

