/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.api;

import com.duffel.sdk.invoker.ApiClient;
import com.duffel.sdk.model.GetAircraft200Response;
import com.duffel.sdk.model.GetAircraftById200Response;
import com.duffel.sdk.model.GetAirlineById200Response;
import com.duffel.sdk.model.GetAirlines200Response;
import com.duffel.sdk.model.GetAirportById200Response;
import com.duffel.sdk.model.GetAirports200Response;
import com.duffel.sdk.model.GetPlaceSuggestions200Response;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class SupportingResourcesApi {
    private ApiClient apiClient;

    public SupportingResourcesApi() {
        this(new ApiClient());
    }

    @Autowired
    public SupportingResourcesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec getAircraftRequestCreation(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getAircraft", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getAircraft", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetAircraft200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraft200Response>(this){};
        return this.apiClient.invokeAPI("/air/aircraft", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetAircraft200Response> getAircraft(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        ParameterizedTypeReference<GetAircraft200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraft200Response>(this){};
        return this.getAircraftRequestCreation(accept, duffelVersion, acceptEncoding, limit, before, after).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetAircraft200Response>> getAircraftWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        ParameterizedTypeReference<GetAircraft200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraft200Response>(this){};
        return this.getAircraftRequestCreation(accept, duffelVersion, acceptEncoding, limit, before, after).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAircraftWithResponseSpec(String accept, String duffelVersion, String acceptEncoding, Integer limit, String before, String after) throws WebClientResponseException {
        return this.getAircraftRequestCreation(accept, duffelVersion, acceptEncoding, limit, before, after);
    }

    private WebClient.ResponseSpec getAircraftByIdRequestCreation(String id) throws WebClientResponseException {
        Object postBody = null;
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getAircraftById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetAircraftById200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraftById200Response>(this){};
        return this.apiClient.invokeAPI("/air/aircraft/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetAircraftById200Response> getAircraftById(String id) throws WebClientResponseException {
        ParameterizedTypeReference<GetAircraftById200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraftById200Response>(this){};
        return this.getAircraftByIdRequestCreation(id).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetAircraftById200Response>> getAircraftByIdWithHttpInfo(String id) throws WebClientResponseException {
        ParameterizedTypeReference<GetAircraftById200Response> localVarReturnType = new ParameterizedTypeReference<GetAircraftById200Response>(this){};
        return this.getAircraftByIdRequestCreation(id).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAircraftByIdWithResponseSpec(String id) throws WebClientResponseException {
        return this.getAircraftByIdRequestCreation(id);
    }

    private WebClient.ResponseSpec getAirlineByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getAirlineById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getAirlineById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getAirlineById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetAirlineById200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlineById200Response>(this){};
        return this.apiClient.invokeAPI("/air/airlines/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetAirlineById200Response> getAirlineById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirlineById200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlineById200Response>(this){};
        return this.getAirlineByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetAirlineById200Response>> getAirlineByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirlineById200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlineById200Response>(this){};
        return this.getAirlineByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAirlineByIdWithResponseSpec(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        return this.getAirlineByIdRequestCreation(accept, duffelVersion, id, acceptEncoding);
    }

    private WebClient.ResponseSpec getAirlinesRequestCreation(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getAirlines", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getAirlines", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetAirlines200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlines200Response>(this){};
        return this.apiClient.invokeAPI("/air/airlines", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetAirlines200Response> getAirlines(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirlines200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlines200Response>(this){};
        return this.getAirlinesRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetAirlines200Response>> getAirlinesWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirlines200Response> localVarReturnType = new ParameterizedTypeReference<GetAirlines200Response>(this){};
        return this.getAirlinesRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAirlinesWithResponseSpec(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit) throws WebClientResponseException {
        return this.getAirlinesRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit);
    }

    private WebClient.ResponseSpec getAirportByIdRequestCreation(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getAirportById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getAirportById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (id == null) {
            throw new WebClientResponseException("Missing the required parameter 'id' when calling getAirportById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetAirportById200Response> localVarReturnType = new ParameterizedTypeReference<GetAirportById200Response>(this){};
        return this.apiClient.invokeAPI("/air/airports/{id}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetAirportById200Response> getAirportById(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirportById200Response> localVarReturnType = new ParameterizedTypeReference<GetAirportById200Response>(this){};
        return this.getAirportByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetAirportById200Response>> getAirportByIdWithHttpInfo(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirportById200Response> localVarReturnType = new ParameterizedTypeReference<GetAirportById200Response>(this){};
        return this.getAirportByIdRequestCreation(accept, duffelVersion, id, acceptEncoding).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAirportByIdWithResponseSpec(String accept, String duffelVersion, String id, String acceptEncoding) throws WebClientResponseException {
        return this.getAirportByIdRequestCreation(accept, duffelVersion, id, acceptEncoding);
    }

    private WebClient.ResponseSpec getAirportsRequestCreation(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String iataCountryCode) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getAirports", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getAirports", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "after", after));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "before", before));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "iata_country_code", iataCountryCode));
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetAirports200Response> localVarReturnType = new ParameterizedTypeReference<GetAirports200Response>(this){};
        return this.apiClient.invokeAPI("/air/airports", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetAirports200Response> getAirports(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String iataCountryCode) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirports200Response> localVarReturnType = new ParameterizedTypeReference<GetAirports200Response>(this){};
        return this.getAirportsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, iataCountryCode).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetAirports200Response>> getAirportsWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String iataCountryCode) throws WebClientResponseException {
        ParameterizedTypeReference<GetAirports200Response> localVarReturnType = new ParameterizedTypeReference<GetAirports200Response>(this){};
        return this.getAirportsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, iataCountryCode).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAirportsWithResponseSpec(String accept, String duffelVersion, String acceptEncoding, String after, String before, Integer limit, String iataCountryCode) throws WebClientResponseException {
        return this.getAirportsRequestCreation(accept, duffelVersion, acceptEncoding, after, before, limit, iataCountryCode);
    }

    private WebClient.ResponseSpec getPlaceSuggestionsRequestCreation(String accept, String duffelVersion, String acceptEncoding, String query) throws WebClientResponseException {
        Object postBody = null;
        if (accept == null) {
            throw new WebClientResponseException("Missing the required parameter 'accept' when calling getPlaceSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duffelVersion == null) {
            throw new WebClientResponseException("Missing the required parameter 'duffelVersion' when calling getPlaceSuggestions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "query", query));
        if (acceptEncoding != null) {
            headerParams.add("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        if (duffelVersion != null) {
            headerParams.add("Duffel-Version", this.apiClient.parameterToString(duffelVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        ParameterizedTypeReference<GetPlaceSuggestions200Response> localVarReturnType = new ParameterizedTypeReference<GetPlaceSuggestions200Response>(this){};
        return this.apiClient.invokeAPI("/places/suggestions", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GetPlaceSuggestions200Response> getPlaceSuggestions(String accept, String duffelVersion, String acceptEncoding, String query) throws WebClientResponseException {
        ParameterizedTypeReference<GetPlaceSuggestions200Response> localVarReturnType = new ParameterizedTypeReference<GetPlaceSuggestions200Response>(this){};
        return this.getPlaceSuggestionsRequestCreation(accept, duffelVersion, acceptEncoding, query).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GetPlaceSuggestions200Response>> getPlaceSuggestionsWithHttpInfo(String accept, String duffelVersion, String acceptEncoding, String query) throws WebClientResponseException {
        ParameterizedTypeReference<GetPlaceSuggestions200Response> localVarReturnType = new ParameterizedTypeReference<GetPlaceSuggestions200Response>(this){};
        return this.getPlaceSuggestionsRequestCreation(accept, duffelVersion, acceptEncoding, query).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getPlaceSuggestionsWithResponseSpec(String accept, String duffelVersion, String acceptEncoding, String query) throws WebClientResponseException {
        return this.getPlaceSuggestionsRequestCreation(accept, duffelVersion, acceptEncoding, query);
    }
}

