/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OfferRequestBodyPassengersInner;
import com.duffel.sdk.model.OfferRequestBodyPrivateFares;
import com.duffel.sdk.model.OfferRequestBodySlice;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"cabin_class", "max_connections", "passengers", "private_fares", "slices"})
@JsonTypeName(value="Offer_Request_Body")
public class OfferRequestBody {
    public static final String JSON_PROPERTY_CABIN_CLASS = "cabin_class";
    private CabinClassEnum cabinClass;
    public static final String JSON_PROPERTY_MAX_CONNECTIONS = "max_connections";
    private Integer maxConnections;
    public static final String JSON_PROPERTY_PASSENGERS = "passengers";
    private List<OfferRequestBodyPassengersInner> passengers = new ArrayList<OfferRequestBodyPassengersInner>();
    public static final String JSON_PROPERTY_PRIVATE_FARES = "private_fares";
    private OfferRequestBodyPrivateFares privateFares;
    public static final String JSON_PROPERTY_SLICES = "slices";
    private List<OfferRequestBodySlice> slices = new ArrayList<OfferRequestBodySlice>();

    public OfferRequestBody cabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
        return this;
    }

    @Nullable
    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CabinClassEnum getCabinClass() {
        return this.cabinClass;
    }

    @JsonProperty(value="cabin_class")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCabinClass(CabinClassEnum cabinClass) {
        this.cabinClass = cabinClass;
    }

    public OfferRequestBody maxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    @Nullable
    @JsonProperty(value="max_connections")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    @JsonProperty(value="max_connections")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public OfferRequestBody passengers(List<OfferRequestBodyPassengersInner> passengers) {
        this.passengers = passengers;
        return this;
    }

    public OfferRequestBody addPassengersItem(OfferRequestBodyPassengersInner passengersItem) {
        if (this.passengers == null) {
            this.passengers = new ArrayList<OfferRequestBodyPassengersInner>();
        }
        this.passengers.add(passengersItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OfferRequestBodyPassengersInner> getPassengers() {
        return this.passengers;
    }

    @JsonProperty(value="passengers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPassengers(List<OfferRequestBodyPassengersInner> passengers) {
        this.passengers = passengers;
    }

    public OfferRequestBody privateFares(OfferRequestBodyPrivateFares privateFares) {
        this.privateFares = privateFares;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="private_fares")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OfferRequestBodyPrivateFares getPrivateFares() {
        return this.privateFares;
    }

    @JsonProperty(value="private_fares")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrivateFares(OfferRequestBodyPrivateFares privateFares) {
        this.privateFares = privateFares;
    }

    public OfferRequestBody slices(List<OfferRequestBodySlice> slices) {
        this.slices = slices;
        return this;
    }

    public OfferRequestBody addSlicesItem(OfferRequestBodySlice slicesItem) {
        if (this.slices == null) {
            this.slices = new ArrayList<OfferRequestBodySlice>();
        }
        this.slices.add(slicesItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="slices")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<OfferRequestBodySlice> getSlices() {
        return this.slices;
    }

    @JsonProperty(value="slices")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSlices(List<OfferRequestBodySlice> slices) {
        this.slices = slices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRequestBody offerRequestBody = (OfferRequestBody)o;
        return Objects.equals((Object)this.cabinClass, (Object)offerRequestBody.cabinClass) && Objects.equals(this.maxConnections, offerRequestBody.maxConnections) && Objects.equals(this.passengers, offerRequestBody.passengers) && Objects.equals(this.privateFares, offerRequestBody.privateFares) && Objects.equals(this.slices, offerRequestBody.slices);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cabinClass, this.maxConnections, this.passengers, this.privateFares, this.slices});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferRequestBody {\n");
        sb.append("    cabinClass: ").append(this.toIndentedString((Object)this.cabinClass)).append("\n");
        sb.append("    maxConnections: ").append(this.toIndentedString(this.maxConnections)).append("\n");
        sb.append("    passengers: ").append(this.toIndentedString(this.passengers)).append("\n");
        sb.append("    privateFares: ").append(this.toIndentedString(this.privateFares)).append("\n");
        sb.append("    slices: ").append(this.toIndentedString(this.slices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CabinClassEnum {
        FIRST("first"),
        BUSINESS("business"),
        PREMIUM_ECONOMY("premium_economy"),
        ECONOMY("economy");

        private String value;

        private CabinClassEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CabinClassEnum fromValue(String value) {
            for (CabinClassEnum b : CabinClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

