/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"passenger_ids", "type", "unique_identifier"})
@JsonTypeName(value="Order_Document")
public class OrderDocument {
    public static final String JSON_PROPERTY_PASSENGER_IDS = "passenger_ids";
    private List<String> passengerIds;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_UNIQUE_IDENTIFIER = "unique_identifier";
    private String uniqueIdentifier;

    public OrderDocument passengerIds(List<String> passengerIds) {
        this.passengerIds = passengerIds;
        return this;
    }

    public OrderDocument addPassengerIdsItem(String passengerIdsItem) {
        if (this.passengerIds == null) {
            this.passengerIds = new ArrayList<String>();
        }
        this.passengerIds.add(passengerIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="passenger_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPassengerIds() {
        return this.passengerIds;
    }

    @JsonProperty(value="passenger_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassengerIds(List<String> passengerIds) {
        this.passengerIds = passengerIds;
    }

    public OrderDocument type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OrderDocument uniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="unique_identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @JsonProperty(value="unique_identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderDocument orderDocument = (OrderDocument)o;
        return Objects.equals(this.passengerIds, orderDocument.passengerIds) && Objects.equals((Object)this.type, (Object)orderDocument.type) && Objects.equals(this.uniqueIdentifier, orderDocument.uniqueIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.passengerIds, this.type, this.uniqueIdentifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderDocument {\n");
        sb.append("    passengerIds: ").append(this.toIndentedString(this.passengerIds)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    uniqueIdentifier: ").append(this.toIndentedString(this.uniqueIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        TICKET("electronic_ticket"),
        MISCELLANEOUS_DOCUMENT_ASSOCIATED("electronic_miscellaneous_document_associated"),
        MISCELLANEOUS_DOCUMENT_STANDALONE("electronic_miscellaneous_document_standalone");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

