/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"awaiting_payment", "payment_required_by", "price_guarantee_expires_at"})
public class OrderPaymentStatus {
    public static final String JSON_PROPERTY_AWAITING_PAYMENT = "awaiting_payment";
    private Boolean awaitingPayment;
    public static final String JSON_PROPERTY_PAYMENT_REQUIRED_BY = "payment_required_by";
    private JsonNullable<LocalDateTime> paymentRequiredBy = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PRICE_GUARANTEE_EXPIRES_AT = "price_guarantee_expires_at";
    private JsonNullable<LocalDateTime> priceGuaranteeExpiresAt = JsonNullable.undefined();

    public OrderPaymentStatus awaitingPayment(Boolean awaitingPayment) {
        this.awaitingPayment = awaitingPayment;
        return this;
    }

    @Nullable
    @JsonProperty(value="awaiting_payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAwaitingPayment() {
        return this.awaitingPayment;
    }

    @JsonProperty(value="awaiting_payment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwaitingPayment(Boolean awaitingPayment) {
        this.awaitingPayment = awaitingPayment;
    }

    public OrderPaymentStatus paymentRequiredBy(LocalDateTime paymentRequiredBy) {
        this.paymentRequiredBy = JsonNullable.of((Object)paymentRequiredBy);
        return this;
    }

    @Nullable
    @Valid
    @JsonIgnore
    public LocalDateTime getPaymentRequiredBy() {
        return (LocalDateTime)this.paymentRequiredBy.orElse(null);
    }

    @JsonProperty(value="payment_required_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LocalDateTime> getPaymentRequiredBy_JsonNullable() {
        return this.paymentRequiredBy;
    }

    @JsonProperty(value="payment_required_by")
    public void setPaymentRequiredBy_JsonNullable(JsonNullable<LocalDateTime> paymentRequiredBy) {
        this.paymentRequiredBy = paymentRequiredBy;
    }

    public void setPaymentRequiredBy(LocalDateTime paymentRequiredBy) {
        this.paymentRequiredBy = JsonNullable.of((Object)paymentRequiredBy);
    }

    public OrderPaymentStatus priceGuaranteeExpiresAt(LocalDateTime priceGuaranteeExpiresAt) {
        this.priceGuaranteeExpiresAt = JsonNullable.of((Object)priceGuaranteeExpiresAt);
        return this;
    }

    @Nullable
    @Valid
    @JsonIgnore
    public LocalDateTime getPriceGuaranteeExpiresAt() {
        return (LocalDateTime)this.priceGuaranteeExpiresAt.orElse(null);
    }

    @JsonProperty(value="price_guarantee_expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LocalDateTime> getPriceGuaranteeExpiresAt_JsonNullable() {
        return this.priceGuaranteeExpiresAt;
    }

    @JsonProperty(value="price_guarantee_expires_at")
    public void setPriceGuaranteeExpiresAt_JsonNullable(JsonNullable<LocalDateTime> priceGuaranteeExpiresAt) {
        this.priceGuaranteeExpiresAt = priceGuaranteeExpiresAt;
    }

    public void setPriceGuaranteeExpiresAt(LocalDateTime priceGuaranteeExpiresAt) {
        this.priceGuaranteeExpiresAt = JsonNullable.of((Object)priceGuaranteeExpiresAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderPaymentStatus orderPaymentStatus = (OrderPaymentStatus)o;
        return Objects.equals(this.awaitingPayment, orderPaymentStatus.awaitingPayment) && OrderPaymentStatus.equalsNullable(this.paymentRequiredBy, orderPaymentStatus.paymentRequiredBy) && OrderPaymentStatus.equalsNullable(this.priceGuaranteeExpiresAt, orderPaymentStatus.priceGuaranteeExpiresAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.awaitingPayment, OrderPaymentStatus.hashCodeNullable(this.paymentRequiredBy), OrderPaymentStatus.hashCodeNullable(this.priceGuaranteeExpiresAt));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderPaymentStatus {\n");
        sb.append("    awaitingPayment: ").append(this.toIndentedString(this.awaitingPayment)).append("\n");
        sb.append("    paymentRequiredBy: ").append(this.toIndentedString(this.paymentRequiredBy)).append("\n");
        sb.append("    priceGuaranteeExpiresAt: ").append(this.toIndentedString(this.priceGuaranteeExpiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

