/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OrderRequestPassengerIdentityDocument;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"born_on", "email", "family_name", "gender", "given_name", "id", "identity_documents", "infant_passenger_id", "phone_number", "title", "type"})
@JsonTypeName(value="Order_Request_Passenger")
public class OrderRequestPassenger {
    public static final String JSON_PROPERTY_BORN_ON = "born_on";
    private LocalDate bornOn;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FAMILY_NAME = "family_name";
    private String familyName;
    public static final String JSON_PROPERTY_GENDER = "gender";
    private GenderEnum gender;
    public static final String JSON_PROPERTY_GIVEN_NAME = "given_name";
    private String givenName;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IDENTITY_DOCUMENTS = "identity_documents";
    private JsonNullable<List<OrderRequestPassengerIdentityDocument>> identityDocuments = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INFANT_PASSENGER_ID = "infant_passenger_id";
    private String infantPassengerId;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phone_number";
    private String phoneNumber;
    public static final String JSON_PROPERTY_TITLE = "title";
    private TitleEnum title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private JsonNullable<TypeEnum> type = JsonNullable.undefined();

    public OrderRequestPassenger bornOn(LocalDate bornOn) {
        this.bornOn = bornOn;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="born_on")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getBornOn() {
        return this.bornOn;
    }

    @JsonProperty(value="born_on")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBornOn(LocalDate bornOn) {
        this.bornOn = bornOn;
    }

    public OrderRequestPassenger email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public OrderRequestPassenger familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="family_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFamilyName() {
        return this.familyName;
    }

    @JsonProperty(value="family_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public OrderRequestPassenger gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="gender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GenderEnum getGender() {
        return this.gender;
    }

    @JsonProperty(value="gender")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public OrderRequestPassenger givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="given_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGivenName() {
        return this.givenName;
    }

    @JsonProperty(value="given_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public OrderRequestPassenger id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public OrderRequestPassenger identityDocuments(List<OrderRequestPassengerIdentityDocument> identityDocuments) {
        this.identityDocuments = JsonNullable.of(identityDocuments);
        return this;
    }

    public OrderRequestPassenger addIdentityDocumentsItem(OrderRequestPassengerIdentityDocument identityDocumentsItem) {
        if (this.identityDocuments == null || !this.identityDocuments.isPresent()) {
            this.identityDocuments = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.identityDocuments.get()).add(identityDocumentsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @Valid
    @JsonIgnore
    public List<OrderRequestPassengerIdentityDocument> getIdentityDocuments() {
        return (List)this.identityDocuments.orElse(null);
    }

    @JsonProperty(value="identity_documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<OrderRequestPassengerIdentityDocument>> getIdentityDocuments_JsonNullable() {
        return this.identityDocuments;
    }

    @JsonProperty(value="identity_documents")
    public void setIdentityDocuments_JsonNullable(JsonNullable<List<OrderRequestPassengerIdentityDocument>> identityDocuments) {
        this.identityDocuments = identityDocuments;
    }

    public void setIdentityDocuments(List<OrderRequestPassengerIdentityDocument> identityDocuments) {
        this.identityDocuments = JsonNullable.of(identityDocuments);
    }

    public OrderRequestPassenger infantPassengerId(String infantPassengerId) {
        this.infantPassengerId = infantPassengerId;
        return this;
    }

    @Nullable
    @JsonProperty(value="infant_passenger_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInfantPassengerId() {
        return this.infantPassengerId;
    }

    @JsonProperty(value="infant_passenger_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInfantPassengerId(String infantPassengerId) {
        this.infantPassengerId = infantPassengerId;
    }

    public OrderRequestPassenger phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public OrderRequestPassenger title(TitleEnum title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TitleEnum getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTitle(TitleEnum title) {
        this.title = title;
    }

    public OrderRequestPassenger type(TypeEnum type) {
        this.type = JsonNullable.of((Object)((Object)type));
        return this;
    }

    @Nullable
    @JsonIgnore
    public TypeEnum getType() {
        return (TypeEnum)((Object)this.type.orElse(null));
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<TypeEnum> getType_JsonNullable() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType_JsonNullable(JsonNullable<TypeEnum> type) {
        this.type = type;
    }

    public void setType(TypeEnum type) {
        this.type = JsonNullable.of((Object)((Object)type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderRequestPassenger orderRequestPassenger = (OrderRequestPassenger)o;
        return Objects.equals(this.bornOn, orderRequestPassenger.bornOn) && Objects.equals(this.email, orderRequestPassenger.email) && Objects.equals(this.familyName, orderRequestPassenger.familyName) && Objects.equals((Object)this.gender, (Object)orderRequestPassenger.gender) && Objects.equals(this.givenName, orderRequestPassenger.givenName) && Objects.equals(this.id, orderRequestPassenger.id) && OrderRequestPassenger.equalsNullable(this.identityDocuments, orderRequestPassenger.identityDocuments) && Objects.equals(this.infantPassengerId, orderRequestPassenger.infantPassengerId) && Objects.equals(this.phoneNumber, orderRequestPassenger.phoneNumber) && Objects.equals((Object)this.title, (Object)orderRequestPassenger.title) && OrderRequestPassenger.equalsNullable(this.type, orderRequestPassenger.type);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bornOn, this.email, this.familyName, this.gender, this.givenName, this.id, OrderRequestPassenger.hashCodeNullable(this.identityDocuments), this.infantPassengerId, this.phoneNumber, this.title, OrderRequestPassenger.hashCodeNullable(this.type)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderRequestPassenger {\n");
        sb.append("    bornOn: ").append(this.toIndentedString(this.bornOn)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    identityDocuments: ").append(this.toIndentedString(this.identityDocuments)).append("\n");
        sb.append("    infantPassengerId: ").append(this.toIndentedString(this.infantPassengerId)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        M("m"),
        F("f");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String value) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TitleEnum {
        MR("mr"),
        MS("ms"),
        MRS("mrs"),
        MISS("miss"),
        DR("dr");

        private String value;

        private TitleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TitleEnum fromValue(String value) {
            for (TitleEnum b : TitleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        ADULT("adult"),
        CHILD("child"),
        INFANT_WITHOUT_SEAT("infant_without_seat");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

