/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.duffel.sdk.model.OrderServiceMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "metadata", "passenger_ids", "quantity", "segment_ids", "total_amount", "total_currency", "type"})
@JsonTypeName(value="Order_Service")
public class OrderService {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private OrderServiceMetadata metadata;
    public static final String JSON_PROPERTY_PASSENGER_IDS = "passenger_ids";
    private List<String> passengerIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity;
    public static final String JSON_PROPERTY_SEGMENT_IDS = "segment_ids";
    private List<String> segmentIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_TOTAL_AMOUNT = "total_amount";
    private String totalAmount;
    public static final String JSON_PROPERTY_TOTAL_CURRENCY = "total_currency";
    private String totalCurrency;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public OrderService id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(String id) {
        this.id = id;
    }

    public OrderService metadata(OrderServiceMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OrderServiceMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMetadata(OrderServiceMetadata metadata) {
        this.metadata = metadata;
    }

    public OrderService passengerIds(List<String> passengerIds) {
        this.passengerIds = passengerIds;
        return this;
    }

    public OrderService addPassengerIdsItem(String passengerIdsItem) {
        if (this.passengerIds == null) {
            this.passengerIds = new ArrayList<String>();
        }
        this.passengerIds.add(passengerIdsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="passenger_ids")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getPassengerIds() {
        return this.passengerIds;
    }

    @JsonProperty(value="passenger_ids")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPassengerIds(List<String> passengerIds) {
        this.passengerIds = passengerIds;
    }

    public OrderService quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public OrderService segmentIds(List<String> segmentIds) {
        this.segmentIds = segmentIds;
        return this;
    }

    public OrderService addSegmentIdsItem(String segmentIdsItem) {
        if (this.segmentIds == null) {
            this.segmentIds = new ArrayList<String>();
        }
        this.segmentIds.add(segmentIdsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="segment_ids")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSegmentIds() {
        return this.segmentIds;
    }

    @JsonProperty(value="segment_ids")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSegmentIds(List<String> segmentIds) {
        this.segmentIds = segmentIds;
    }

    public OrderService totalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="total_amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public OrderService totalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTotalCurrency() {
        return this.totalCurrency;
    }

    @JsonProperty(value="total_currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTotalCurrency(String totalCurrency) {
        this.totalCurrency = totalCurrency;
    }

    public OrderService type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderService orderService = (OrderService)o;
        return Objects.equals(this.id, orderService.id) && Objects.equals(this.metadata, orderService.metadata) && Objects.equals(this.passengerIds, orderService.passengerIds) && Objects.equals(this.quantity, orderService.quantity) && Objects.equals(this.segmentIds, orderService.segmentIds) && Objects.equals(this.totalAmount, orderService.totalAmount) && Objects.equals(this.totalCurrency, orderService.totalCurrency) && Objects.equals((Object)this.type, (Object)orderService.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.metadata, this.passengerIds, this.quantity, this.segmentIds, this.totalAmount, this.totalCurrency, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderService {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    passengerIds: ").append(this.toIndentedString(this.passengerIds)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    segmentIds: ").append(this.toIndentedString(this.segmentIds)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    totalCurrency: ").append(this.toIndentedString(this.totalCurrency)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        BAGGAGE("baggage"),
        SEAT("seat");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

