/*
 * Decompiled with CFR 0.152.
 */
package com.duffel.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"amount", "created_at", "currency", "id", "live_mode", "type"})
public class Payment {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private String amount;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private LocalDateTime createdAt;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private JsonNullable<String> currency = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LIVE_MODE = "live_mode";
    private Boolean liveMode;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public Payment amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Payment createdAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Payment currency(String currency) {
        this.currency = JsonNullable.of((Object)currency);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getCurrency() {
        return (String)this.currency.orElse(null);
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCurrency_JsonNullable() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    public void setCurrency_JsonNullable(JsonNullable<String> currency) {
        this.currency = currency;
    }

    public void setCurrency(String currency) {
        this.currency = JsonNullable.of((Object)currency);
    }

    public Payment id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Payment liveMode(Boolean liveMode) {
        this.liveMode = liveMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLiveMode() {
        return this.liveMode;
    }

    @JsonProperty(value="live_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    public Payment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.amount, payment.amount) && Objects.equals(this.createdAt, payment.createdAt) && Payment.equalsNullable(this.currency, payment.currency) && Objects.equals(this.id, payment.id) && Objects.equals(this.liveMode, payment.liveMode) && Objects.equals((Object)this.type, (Object)payment.type);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.createdAt, Payment.hashCodeNullable(this.currency), this.id, this.liveMode, this.type});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payment {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    liveMode: ").append(this.toIndentedString(this.liveMode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ARC_BSP_CASH("arc_bsp_cash"),
        BALANCE("balance");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

