/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](https://api.wink.travel/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](https://api.wink.travel/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](https://api.wink.travel/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](/docs?api=events): All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-06-28: v1 - Externalized channel manager API into its own API - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Events API These are admin-only endpoints that are used to uni-directionally communicate bookings emanating from the Inventory app. Once received, the booking will get forwarded to the correct channel manager.  # Intended Audience This document is intended for Wink developers who wish to understand our event system.  # Requirements - Valid Oauth2 token with admin-level scope.
 *
 * The version of the OpenAPI document: 20.3.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import travel.wink.sdk.events.model.BookingUserSpecifiedCurrencyTotal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * In case of LODGING, include daily rates
 */
@ApiModel(description = "In case of LODGING, include daily rates")
@JsonPropertyOrder({
  DailyRate.JSON_PROPERTY_DATE,
  DailyRate.JSON_PROPERTY_PRICE,
  DailyRate.JSON_PROPERTY_DISPLAY_PRICE,
  DailyRate.JSON_PROPERTY_SUPPLIER_PRICE,
  DailyRate.JSON_PROPERTY_INTERNAL_PRICE,
  DailyRate.JSON_PROPERTY_CAPTURE_PRICE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-01T17:00:52.890368+07:00[Asia/Bangkok]")
public class DailyRate {
  public static final String JSON_PROPERTY_DATE = "date";
  private OffsetDateTime date;

  public static final String JSON_PROPERTY_PRICE = "price";
  private BookingUserSpecifiedCurrencyTotal price;

  public static final String JSON_PROPERTY_DISPLAY_PRICE = "displayPrice";
  private BookingUserSpecifiedCurrencyTotal displayPrice;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE = "supplierPrice";
  private BookingUserSpecifiedCurrencyTotal supplierPrice;

  public static final String JSON_PROPERTY_INTERNAL_PRICE = "internalPrice";
  private BookingUserSpecifiedCurrencyTotal internalPrice;

  public static final String JSON_PROPERTY_CAPTURE_PRICE = "capturePrice";
  private BookingUserSpecifiedCurrencyTotal capturePrice;

  public DailyRate() { 
  }

  public DailyRate date(OffsetDateTime date) {
    
    this.date = date;
    return this;
  }

   /**
   * The date this rate is applicable for.
   * @return date
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "The date this rate is applicable for.")
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDate(OffsetDateTime date) {
    this.date = date;
  }


  public DailyRate price(BookingUserSpecifiedCurrencyTotal price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSpecifiedCurrencyTotal getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(BookingUserSpecifiedCurrencyTotal price) {
    this.price = price;
  }


  public DailyRate displayPrice(BookingUserSpecifiedCurrencyTotal displayPrice) {
    
    this.displayPrice = displayPrice;
    return this;
  }

   /**
   * Get displayPrice
   * @return displayPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSpecifiedCurrencyTotal getDisplayPrice() {
    return displayPrice;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPrice(BookingUserSpecifiedCurrencyTotal displayPrice) {
    this.displayPrice = displayPrice;
  }


  public DailyRate supplierPrice(BookingUserSpecifiedCurrencyTotal supplierPrice) {
    
    this.supplierPrice = supplierPrice;
    return this;
  }

   /**
   * Get supplierPrice
   * @return supplierPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSpecifiedCurrencyTotal getSupplierPrice() {
    return supplierPrice;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPrice(BookingUserSpecifiedCurrencyTotal supplierPrice) {
    this.supplierPrice = supplierPrice;
  }


  public DailyRate internalPrice(BookingUserSpecifiedCurrencyTotal internalPrice) {
    
    this.internalPrice = internalPrice;
    return this;
  }

   /**
   * Get internalPrice
   * @return internalPrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSpecifiedCurrencyTotal getInternalPrice() {
    return internalPrice;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPrice(BookingUserSpecifiedCurrencyTotal internalPrice) {
    this.internalPrice = internalPrice;
  }


  public DailyRate capturePrice(BookingUserSpecifiedCurrencyTotal capturePrice) {
    
    this.capturePrice = capturePrice;
    return this;
  }

   /**
   * Get capturePrice
   * @return capturePrice
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSpecifiedCurrencyTotal getCapturePrice() {
    return capturePrice;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePrice(BookingUserSpecifiedCurrencyTotal capturePrice) {
    this.capturePrice = capturePrice;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DailyRate dailyRate = (DailyRate) o;
    return Objects.equals(this.date, dailyRate.date) &&
        Objects.equals(this.price, dailyRate.price) &&
        Objects.equals(this.displayPrice, dailyRate.displayPrice) &&
        Objects.equals(this.supplierPrice, dailyRate.supplierPrice) &&
        Objects.equals(this.internalPrice, dailyRate.internalPrice) &&
        Objects.equals(this.capturePrice, dailyRate.capturePrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, price, displayPrice, supplierPrice, internalPrice, capturePrice);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DailyRate {\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    displayPrice: ").append(toIndentedString(displayPrice)).append("\n");
    sb.append("    supplierPrice: ").append(toIndentedString(supplierPrice)).append("\n");
    sb.append("    internalPrice: ").append(toIndentedString(internalPrice)).append("\n");
    sb.append("    capturePrice: ").append(toIndentedString(capturePrice)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

