/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](https://api.wink.travel/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](https://api.wink.travel/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](https://api.wink.travel/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Events](/docs?api=events): All APIs related to Integration events.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.payment-v`1`+json.  ## Release history - 2022-06-28: v1 - Externalized channel manager API into its own API - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Events API These are admin-only endpoints that are used to uni-directionally communicate bookings emanating from the Inventory app. Once received, the booking will get forwarded to the correct channel manager.  # Intended Audience This document is intended for Wink developers who wish to understand our event system.  # Requirements - Valid Oauth2 token with admin-level scope.
 *
 * The version of the OpenAPI document: 20.3.2-SNAPSHOT
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.events.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Social network
 */
@ApiModel(description = "Social network")
@JsonPropertyOrder({
  Social.JSON_PROPERTY_TYPE,
  Social.JSON_PROPERTY_LOCATION,
  Social.JSON_PROPERTY_ENABLED
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-01T17:00:52.890368+07:00[Asia/Bangkok]")
public class Social {
  /**
   * Type of social network.
   */
  public enum TypeEnum {
    FACEBOOK("FACEBOOK"),
    
    INSTAGRAM("INSTAGRAM"),
    
    SKYPE("SKYPE"),
    
    TRIP_ADVISOR("TRIP_ADVISOR"),
    
    TWITTER("TWITTER"),
    
    GOOGLE_PLUS("GOOGLE_PLUS"),
    
    WHATSAPP("WHATSAPP"),
    
    LINE("LINE"),
    
    WECHAT("WECHAT"),
    
    VIBER("VIBER"),
    
    SNAPCHAT("SNAPCHAT"),
    
    WEIBO("WEIBO"),
    
    RENREN("RENREN"),
    
    WEBSITE("WEBSITE"),
    
    QQ("QQ"),
    
    TIKTOK("TIKTOK");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private String location;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled;

  public Social() { 
  }

  public Social type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of social network.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type of social network.")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public Social location(String location) {
    
    this.location = location;
    return this;
  }

   /**
   * URL or social network identifier to social network profile
   * @return location
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "URL or social network identifier to social network profile")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(String location) {
    this.location = location;
  }


  public Social enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether social network is available for use.
   * @return enabled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether social network is available for use.")
  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Social social = (Social) o;
    return Objects.equals(this.type, social.type) &&
        Objects.equals(this.location, social.location) &&
        Objects.equals(this.enabled, social.enabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, location, enabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Social {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

