/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.events.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.events.model.Contact;
import travel.wink.sdk.events.model.PetInfoDto;

@ApiModel(description="Detailed customer information for this profile")
@JsonPropertyOrder(value={"gender", "birthDate", "maritalStatus", "childQuantity", "citizenship", "address1", "address2", "city", "postalCode", "country", "preferredCurrency", "language", "contactPerson", "physChallName", "petInfo"})
public class Personal {
    public static final String JSON_PROPERTY_GENDER = "gender";
    private GenderEnum gender;
    public static final String JSON_PROPERTY_BIRTH_DATE = "birthDate";
    private LocalDate birthDate;
    public static final String JSON_PROPERTY_MARITAL_STATUS = "maritalStatus";
    private MaritalStatusEnum maritalStatus;
    public static final String JSON_PROPERTY_CHILD_QUANTITY = "childQuantity";
    private Integer childQuantity;
    public static final String JSON_PROPERTY_CITIZENSHIP = "citizenship";
    private String citizenship;
    public static final String JSON_PROPERTY_ADDRESS1 = "address1";
    private String address1;
    public static final String JSON_PROPERTY_ADDRESS2 = "address2";
    private String address2;
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_PREFERRED_CURRENCY = "preferredCurrency";
    private String preferredCurrency;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_CONTACT_PERSON = "contactPerson";
    private List<Contact> contactPerson = null;
    public static final String JSON_PROPERTY_PHYS_CHALL_NAME = "physChallName";
    private List<String> physChallName = null;
    public static final String JSON_PROPERTY_PET_INFO = "petInfo";
    private List<PetInfoDto> petInfo = null;

    public Personal gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier the gender of the customer.")
    @JsonProperty(value="gender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GenderEnum getGender() {
        return this.gender;
    }

    @JsonProperty(value="gender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public Personal birthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.")
    @JsonProperty(value="birthDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    @JsonProperty(value="birthDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public Personal maritalStatus(MaritalStatusEnum maritalStatus) {
        this.maritalStatus = maritalStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Marital status of the traveler.")
    @JsonProperty(value="maritalStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MaritalStatusEnum getMaritalStatus() {
        return this.maritalStatus;
    }

    @JsonProperty(value="maritalStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaritalStatus(MaritalStatusEnum maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public Personal childQuantity(Integer childQuantity) {
        this.childQuantity = childQuantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of children of the customer.")
    @JsonProperty(value="childQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getChildQuantity() {
        return this.childQuantity;
    }

    @JsonProperty(value="childQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildQuantity(Integer childQuantity) {
        this.childQuantity = childQuantity;
    }

    public Personal citizenship(String citizenship) {
        this.citizenship = citizenship;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the (self-professed) country that is clamided for citizenship.")
    @JsonProperty(value="citizenship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCitizenship() {
        return this.citizenship;
    }

    @JsonProperty(value="citizenship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCitizenship(String citizenship) {
        this.citizenship = citizenship;
    }

    public Personal address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Address line 1")
    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress1() {
        return this.address1;
    }

    @JsonProperty(value="address1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public Personal address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Address line 2")
    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress2() {
        return this.address2;
    }

    @JsonProperty(value="address2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public Personal city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="City")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public Personal postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Postal code")
    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postalCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Personal country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Country")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public Personal preferredCurrency(String preferredCurrency) {
        this.preferredCurrency = preferredCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Type of funds preferred for reviewing monetary values, in ISO 4217 codes")
    @JsonProperty(value="preferredCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPreferredCurrency() {
        return this.preferredCurrency;
    }

    @JsonProperty(value="preferredCurrency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreferredCurrency(String preferredCurrency) {
        this.preferredCurrency = preferredCurrency;
    }

    public Personal language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The primary language of the customer")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public Personal contactPerson(List<Contact> contactPerson) {
        this.contactPerson = contactPerson;
        return this;
    }

    public Personal addContactPersonItem(Contact contactPersonItem) {
        if (this.contactPerson == null) {
            this.contactPerson = new ArrayList<Contact>();
        }
        this.contactPerson.add(contactPersonItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Array of emergency contact information for the customer")
    @JsonProperty(value="contactPerson")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Contact> getContactPerson() {
        return this.contactPerson;
    }

    @JsonProperty(value="contactPerson")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContactPerson(List<Contact> contactPerson) {
        this.contactPerson = contactPerson;
    }

    public Personal physChallName(List<String> physChallName) {
        this.physChallName = physChallName;
        return this;
    }

    public Personal addPhysChallNameItem(String physChallNameItem) {
        if (this.physChallName == null) {
            this.physChallName = new ArrayList<String>();
        }
        this.physChallName.add(physChallNameItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of customer's physical challenges")
    @JsonProperty(value="physChallName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPhysChallName() {
        return this.physChallName;
    }

    @JsonProperty(value="physChallName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhysChallName(List<String> physChallName) {
        this.physChallName = physChallName;
    }

    public Personal petInfo(List<PetInfoDto> petInfo) {
        this.petInfo = petInfo;
        return this;
    }

    public Personal addPetInfoItem(PetInfoDto petInfoItem) {
        if (this.petInfo == null) {
            this.petInfo = new ArrayList<PetInfoDto>();
        }
        this.petInfo.add(petInfoItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Array of customer's pets")
    @JsonProperty(value="petInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PetInfoDto> getPetInfo() {
        return this.petInfo;
    }

    @JsonProperty(value="petInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPetInfo(List<PetInfoDto> petInfo) {
        this.petInfo = petInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Personal personal = (Personal)o;
        return Objects.equals((Object)this.gender, (Object)personal.gender) && Objects.equals(this.birthDate, personal.birthDate) && Objects.equals((Object)this.maritalStatus, (Object)personal.maritalStatus) && Objects.equals(this.childQuantity, personal.childQuantity) && Objects.equals(this.citizenship, personal.citizenship) && Objects.equals(this.address1, personal.address1) && Objects.equals(this.address2, personal.address2) && Objects.equals(this.city, personal.city) && Objects.equals(this.postalCode, personal.postalCode) && Objects.equals(this.country, personal.country) && Objects.equals(this.preferredCurrency, personal.preferredCurrency) && Objects.equals(this.language, personal.language) && Objects.equals(this.contactPerson, personal.contactPerson) && Objects.equals(this.physChallName, personal.physChallName) && Objects.equals(this.petInfo, personal.petInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gender, this.birthDate, this.maritalStatus, this.childQuantity, this.citizenship, this.address1, this.address2, this.city, this.postalCode, this.country, this.preferredCurrency, this.language, this.contactPerson, this.physChallName, this.petInfo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Personal {\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    birthDate: ").append(this.toIndentedString(this.birthDate)).append("\n");
        sb.append("    maritalStatus: ").append(this.toIndentedString((Object)this.maritalStatus)).append("\n");
        sb.append("    childQuantity: ").append(this.toIndentedString(this.childQuantity)).append("\n");
        sb.append("    citizenship: ").append(this.toIndentedString(this.citizenship)).append("\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    preferredCurrency: ").append(this.toIndentedString(this.preferredCurrency)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    contactPerson: ").append(this.toIndentedString(this.contactPerson)).append("\n");
        sb.append("    physChallName: ").append(this.toIndentedString(this.physChallName)).append("\n");
        sb.append("    petInfo: ").append(this.toIndentedString(this.petInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        MALE("MALE"),
        FEMALE("FEMALE"),
        OTHER("OTHER");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String value) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MaritalStatusEnum {
        ANNULLED("ANNULLED"),
        COHABITATING("COHABITATING"),
        DIVORCED("DIVORCED"),
        ENGAGED("ENGAGED"),
        MARRIED("MARRIED"),
        SEPARATED("SEPARATED"),
        SINGLE("SINGLE"),
        WIDOWED("WIDOWED"),
        UNKNOWN("UNKNOWN");

        private String value;

        private MaritalStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MaritalStatusEnum fromValue(String value) {
            for (MaritalStatusEnum b : MaritalStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

