/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Extranet Booking API The Booking API exposes endpoints to manage bookings. This API lets you:  1. Booking: Manage bookings including cancellations. 2. Review: Manage user reviews. 3. Sync w. Calendar: Manage calendar sync with your favorite calendar software  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.3.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The time-interval steps when &#x60;baseUnit&#x60; is set either to &#x60;fit&#x60; or &#x60;auto&#x60;. The axis will try to divide the active period into the smallest possible units that yield &#x60;maxDateGroups&#x60; or less discrete intervals.
 */
@JsonPropertyOrder({
  AutoBaseUnitStepsSupplier.JSON_PROPERTY_MILLISECONDS,
  AutoBaseUnitStepsSupplier.JSON_PROPERTY_SECONDS,
  AutoBaseUnitStepsSupplier.JSON_PROPERTY_MINUTES,
  AutoBaseUnitStepsSupplier.JSON_PROPERTY_HOURS,
  AutoBaseUnitStepsSupplier.JSON_PROPERTY_DAYS,
  AutoBaseUnitStepsSupplier.JSON_PROPERTY_WEEKS,
  AutoBaseUnitStepsSupplier.JSON_PROPERTY_MONTHS,
  AutoBaseUnitStepsSupplier.JSON_PROPERTY_YEARS
})
@JsonTypeName("AutoBaseUnitSteps_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:02:23.724204064+07:00[Asia/Bangkok]")
public class AutoBaseUnitStepsSupplier {
  public static final String JSON_PROPERTY_MILLISECONDS = "milliseconds";
  private BigDecimal milliseconds;

  public static final String JSON_PROPERTY_SECONDS = "seconds";
  private BigDecimal seconds;

  public static final String JSON_PROPERTY_MINUTES = "minutes";
  private BigDecimal minutes;

  public static final String JSON_PROPERTY_HOURS = "hours";
  private BigDecimal hours;

  public static final String JSON_PROPERTY_DAYS = "days";
  private BigDecimal days;

  public static final String JSON_PROPERTY_WEEKS = "weeks";
  private BigDecimal weeks;

  public static final String JSON_PROPERTY_MONTHS = "months";
  private BigDecimal months;

  public static final String JSON_PROPERTY_YEARS = "years";
  private BigDecimal years;

  public AutoBaseUnitStepsSupplier() {
  }

  public AutoBaseUnitStepsSupplier milliseconds(BigDecimal milliseconds) {
    
    this.milliseconds = milliseconds;
    return this;
  }

   /**
   * Get milliseconds
   * @return milliseconds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MILLISECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMilliseconds() {
    return milliseconds;
  }


  @JsonProperty(JSON_PROPERTY_MILLISECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMilliseconds(BigDecimal milliseconds) {
    this.milliseconds = milliseconds;
  }


  public AutoBaseUnitStepsSupplier seconds(BigDecimal seconds) {
    
    this.seconds = seconds;
    return this;
  }

   /**
   * Get seconds
   * @return seconds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSeconds() {
    return seconds;
  }


  @JsonProperty(JSON_PROPERTY_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeconds(BigDecimal seconds) {
    this.seconds = seconds;
  }


  public AutoBaseUnitStepsSupplier minutes(BigDecimal minutes) {
    
    this.minutes = minutes;
    return this;
  }

   /**
   * Get minutes
   * @return minutes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMinutes() {
    return minutes;
  }


  @JsonProperty(JSON_PROPERTY_MINUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinutes(BigDecimal minutes) {
    this.minutes = minutes;
  }


  public AutoBaseUnitStepsSupplier hours(BigDecimal hours) {
    
    this.hours = hours;
    return this;
  }

   /**
   * Get hours
   * @return hours
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getHours() {
    return hours;
  }


  @JsonProperty(JSON_PROPERTY_HOURS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHours(BigDecimal hours) {
    this.hours = hours;
  }


  public AutoBaseUnitStepsSupplier days(BigDecimal days) {
    
    this.days = days;
    return this;
  }

   /**
   * Get days
   * @return days
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDays() {
    return days;
  }


  @JsonProperty(JSON_PROPERTY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDays(BigDecimal days) {
    this.days = days;
  }


  public AutoBaseUnitStepsSupplier weeks(BigDecimal weeks) {
    
    this.weeks = weeks;
    return this;
  }

   /**
   * Get weeks
   * @return weeks
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_WEEKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getWeeks() {
    return weeks;
  }


  @JsonProperty(JSON_PROPERTY_WEEKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWeeks(BigDecimal weeks) {
    this.weeks = weeks;
  }


  public AutoBaseUnitStepsSupplier months(BigDecimal months) {
    
    this.months = months;
    return this;
  }

   /**
   * Get months
   * @return months
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMonths() {
    return months;
  }


  @JsonProperty(JSON_PROPERTY_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMonths(BigDecimal months) {
    this.months = months;
  }


  public AutoBaseUnitStepsSupplier years(BigDecimal years) {
    
    this.years = years;
    return this;
  }

   /**
   * Get years
   * @return years
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_YEARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getYears() {
    return years;
  }


  @JsonProperty(JSON_PROPERTY_YEARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setYears(BigDecimal years) {
    this.years = years;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AutoBaseUnitStepsSupplier autoBaseUnitStepsSupplier = (AutoBaseUnitStepsSupplier) o;
    return Objects.equals(this.milliseconds, autoBaseUnitStepsSupplier.milliseconds) &&
        Objects.equals(this.seconds, autoBaseUnitStepsSupplier.seconds) &&
        Objects.equals(this.minutes, autoBaseUnitStepsSupplier.minutes) &&
        Objects.equals(this.hours, autoBaseUnitStepsSupplier.hours) &&
        Objects.equals(this.days, autoBaseUnitStepsSupplier.days) &&
        Objects.equals(this.weeks, autoBaseUnitStepsSupplier.weeks) &&
        Objects.equals(this.months, autoBaseUnitStepsSupplier.months) &&
        Objects.equals(this.years, autoBaseUnitStepsSupplier.years);
  }

  @Override
  public int hashCode() {
    return Objects.hash(milliseconds, seconds, minutes, hours, days, weeks, months, years);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AutoBaseUnitStepsSupplier {\n");
    sb.append("    milliseconds: ").append(toIndentedString(milliseconds)).append("\n");
    sb.append("    seconds: ").append(toIndentedString(seconds)).append("\n");
    sb.append("    minutes: ").append(toIndentedString(minutes)).append("\n");
    sb.append("    hours: ").append(toIndentedString(hours)).append("\n");
    sb.append("    days: ").append(toIndentedString(days)).append("\n");
    sb.append("    weeks: ").append(toIndentedString(weeks)).append("\n");
    sb.append("    months: ").append(toIndentedString(months)).append("\n");
    sb.append("    years: ").append(toIndentedString(years)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

