/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Extranet Booking API The Booking API exposes endpoints to manage bookings. This API lets you:  1. Booking: Manage bookings including cancellations. 2. Review: Manage user reviews. 3. Sync w. Calendar: Manage calendar sync with your favorite calendar software  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.3.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.extranet.booking.model.ContactSupplierDetails;
import travel.wink.sdk.extranet.booking.model.PetInfoDtoSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Detailed customer information for this profile
 */
@JsonPropertyOrder({
  PersonalSupplierDetails.JSON_PROPERTY_GENDER,
  PersonalSupplierDetails.JSON_PROPERTY_BIRTH_DATE,
  PersonalSupplierDetails.JSON_PROPERTY_MARITAL_STATUS,
  PersonalSupplierDetails.JSON_PROPERTY_CHILD_QUANTITY,
  PersonalSupplierDetails.JSON_PROPERTY_CITIZENSHIP,
  PersonalSupplierDetails.JSON_PROPERTY_ADDRESS1,
  PersonalSupplierDetails.JSON_PROPERTY_ADDRESS2,
  PersonalSupplierDetails.JSON_PROPERTY_CITY,
  PersonalSupplierDetails.JSON_PROPERTY_STATE,
  PersonalSupplierDetails.JSON_PROPERTY_POSTAL_CODE,
  PersonalSupplierDetails.JSON_PROPERTY_COUNTRY,
  PersonalSupplierDetails.JSON_PROPERTY_PREFERRED_CURRENCY,
  PersonalSupplierDetails.JSON_PROPERTY_LANGUAGE,
  PersonalSupplierDetails.JSON_PROPERTY_CONTACT_PERSON,
  PersonalSupplierDetails.JSON_PROPERTY_PHYS_CHALL_NAME,
  PersonalSupplierDetails.JSON_PROPERTY_PET_INFO
})
@JsonTypeName("Personal_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:02:23.724204064+07:00[Asia/Bangkok]")
public class PersonalSupplierDetails {
  /**
   * Identifier the gender of the customer.
   */
  public enum GenderEnum {
    MALE("MALE"),
    
    FEMALE("FEMALE"),
    
    OTHER("OTHER");

    private String value;

    GenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GenderEnum fromValue(String value) {
      for (GenderEnum b : GenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GENDER = "gender";
  private GenderEnum gender;

  public static final String JSON_PROPERTY_BIRTH_DATE = "birthDate";
  private LocalDate birthDate;

  /**
   * Marital status of the traveler.
   */
  public enum MaritalStatusEnum {
    ANNULLED("ANNULLED"),
    
    COHABITATING("COHABITATING"),
    
    DIVORCED("DIVORCED"),
    
    ENGAGED("ENGAGED"),
    
    MARRIED("MARRIED"),
    
    SEPARATED("SEPARATED"),
    
    SINGLE("SINGLE"),
    
    WIDOWED("WIDOWED"),
    
    UNKNOWN("UNKNOWN");

    private String value;

    MaritalStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MaritalStatusEnum fromValue(String value) {
      for (MaritalStatusEnum b : MaritalStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MARITAL_STATUS = "maritalStatus";
  private MaritalStatusEnum maritalStatus;

  public static final String JSON_PROPERTY_CHILD_QUANTITY = "childQuantity";
  private Integer childQuantity;

  public static final String JSON_PROPERTY_CITIZENSHIP = "citizenship";
  private String citizenship;

  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  private String address2;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_STATE = "state";
  private String state;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  private String postalCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_PREFERRED_CURRENCY = "preferredCurrency";
  private String preferredCurrency;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_CONTACT_PERSON = "contactPerson";
  private List<ContactSupplierDetails> contactPerson;

  public static final String JSON_PROPERTY_PHYS_CHALL_NAME = "physChallName";
  private List<String> physChallName;

  public static final String JSON_PROPERTY_PET_INFO = "petInfo";
  private List<PetInfoDtoSupplierDetails> petInfo;

  public PersonalSupplierDetails() {
  }

  public PersonalSupplierDetails gender(GenderEnum gender) {
    
    this.gender = gender;
    return this;
  }

   /**
   * Identifier the gender of the customer.
   * @return gender
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenderEnum getGender() {
    return gender;
  }


  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGender(GenderEnum gender) {
    this.gender = gender;
  }


  public PersonalSupplierDetails birthDate(LocalDate birthDate) {
    
    this.birthDate = birthDate;
    return this;
  }

   /**
   * Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
   * @return birthDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getBirthDate() {
    return birthDate;
  }


  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthDate(LocalDate birthDate) {
    this.birthDate = birthDate;
  }


  public PersonalSupplierDetails maritalStatus(MaritalStatusEnum maritalStatus) {
    
    this.maritalStatus = maritalStatus;
    return this;
  }

   /**
   * Marital status of the traveler.
   * @return maritalStatus
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MaritalStatusEnum getMaritalStatus() {
    return maritalStatus;
  }


  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaritalStatus(MaritalStatusEnum maritalStatus) {
    this.maritalStatus = maritalStatus;
  }


  public PersonalSupplierDetails childQuantity(Integer childQuantity) {
    
    this.childQuantity = childQuantity;
    return this;
  }

   /**
   * The number of children of the customer.
   * @return childQuantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildQuantity() {
    return childQuantity;
  }


  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildQuantity(Integer childQuantity) {
    this.childQuantity = childQuantity;
  }


  public PersonalSupplierDetails citizenship(String citizenship) {
    
    this.citizenship = citizenship;
    return this;
  }

   /**
   * Name of the (self-professed) country that is clamided for citizenship.
   * @return citizenship
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCitizenship() {
    return citizenship;
  }


  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCitizenship(String citizenship) {
    this.citizenship = citizenship;
  }


  public PersonalSupplierDetails address1(String address1) {
    
    this.address1 = address1;
    return this;
  }

   /**
   * Address line 1
   * @return address1
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress1() {
    return address1;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress1(String address1) {
    this.address1 = address1;
  }


  public PersonalSupplierDetails address2(String address2) {
    
    this.address2 = address2;
    return this;
  }

   /**
   * Address line 2
   * @return address2
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress2(String address2) {
    this.address2 = address2;
  }


  public PersonalSupplierDetails city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * City
   * @return city
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(String city) {
    this.city = city;
  }


  public PersonalSupplierDetails state(String state) {
    
    this.state = state;
    return this;
  }

   /**
   * State
   * @return state
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(String state) {
    this.state = state;
  }


  public PersonalSupplierDetails postalCode(String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Postal code
   * @return postalCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public PersonalSupplierDetails country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Country
   * @return country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public PersonalSupplierDetails preferredCurrency(String preferredCurrency) {
    
    this.preferredCurrency = preferredCurrency;
    return this;
  }

   /**
   * Type of funds preferred for reviewing monetary values, in ISO 4217 codes
   * @return preferredCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPreferredCurrency() {
    return preferredCurrency;
  }


  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreferredCurrency(String preferredCurrency) {
    this.preferredCurrency = preferredCurrency;
  }


  public PersonalSupplierDetails language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * The primary language of the customer
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public PersonalSupplierDetails contactPerson(List<ContactSupplierDetails> contactPerson) {
    
    this.contactPerson = contactPerson;
    return this;
  }

  public PersonalSupplierDetails addContactPersonItem(ContactSupplierDetails contactPersonItem) {
    if (this.contactPerson == null) {
      this.contactPerson = new ArrayList<>();
    }
    this.contactPerson.add(contactPersonItem);
    return this;
  }

   /**
   * Get contactPerson
   * @return contactPerson
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ContactSupplierDetails> getContactPerson() {
    return contactPerson;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactPerson(List<ContactSupplierDetails> contactPerson) {
    this.contactPerson = contactPerson;
  }


  public PersonalSupplierDetails physChallName(List<String> physChallName) {
    
    this.physChallName = physChallName;
    return this;
  }

  public PersonalSupplierDetails addPhysChallNameItem(String physChallNameItem) {
    if (this.physChallName == null) {
      this.physChallName = new ArrayList<>();
    }
    this.physChallName.add(physChallNameItem);
    return this;
  }

   /**
   * Get physChallName
   * @return physChallName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPhysChallName() {
    return physChallName;
  }


  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhysChallName(List<String> physChallName) {
    this.physChallName = physChallName;
  }


  public PersonalSupplierDetails petInfo(List<PetInfoDtoSupplierDetails> petInfo) {
    
    this.petInfo = petInfo;
    return this;
  }

  public PersonalSupplierDetails addPetInfoItem(PetInfoDtoSupplierDetails petInfoItem) {
    if (this.petInfo == null) {
      this.petInfo = new ArrayList<>();
    }
    this.petInfo.add(petInfoItem);
    return this;
  }

   /**
   * Get petInfo
   * @return petInfo
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PetInfoDtoSupplierDetails> getPetInfo() {
    return petInfo;
  }


  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetInfo(List<PetInfoDtoSupplierDetails> petInfo) {
    this.petInfo = petInfo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PersonalSupplierDetails personalSupplierDetails = (PersonalSupplierDetails) o;
    return Objects.equals(this.gender, personalSupplierDetails.gender) &&
        Objects.equals(this.birthDate, personalSupplierDetails.birthDate) &&
        Objects.equals(this.maritalStatus, personalSupplierDetails.maritalStatus) &&
        Objects.equals(this.childQuantity, personalSupplierDetails.childQuantity) &&
        Objects.equals(this.citizenship, personalSupplierDetails.citizenship) &&
        Objects.equals(this.address1, personalSupplierDetails.address1) &&
        Objects.equals(this.address2, personalSupplierDetails.address2) &&
        Objects.equals(this.city, personalSupplierDetails.city) &&
        Objects.equals(this.state, personalSupplierDetails.state) &&
        Objects.equals(this.postalCode, personalSupplierDetails.postalCode) &&
        Objects.equals(this.country, personalSupplierDetails.country) &&
        Objects.equals(this.preferredCurrency, personalSupplierDetails.preferredCurrency) &&
        Objects.equals(this.language, personalSupplierDetails.language) &&
        Objects.equals(this.contactPerson, personalSupplierDetails.contactPerson) &&
        Objects.equals(this.physChallName, personalSupplierDetails.physChallName) &&
        Objects.equals(this.petInfo, personalSupplierDetails.petInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(gender, birthDate, maritalStatus, childQuantity, citizenship, address1, address2, city, state, postalCode, country, preferredCurrency, language, contactPerson, physChallName, petInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PersonalSupplierDetails {\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    birthDate: ").append(toIndentedString(birthDate)).append("\n");
    sb.append("    maritalStatus: ").append(toIndentedString(maritalStatus)).append("\n");
    sb.append("    childQuantity: ").append(toIndentedString(childQuantity)).append("\n");
    sb.append("    citizenship: ").append(toIndentedString(citizenship)).append("\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    preferredCurrency: ").append(toIndentedString(preferredCurrency)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    contactPerson: ").append(toIndentedString(contactPerson)).append("\n");
    sb.append("    physChallName: ").append(toIndentedString(physChallName)).append("\n");
    sb.append("    petInfo: ").append(toIndentedString(petInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

