/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.booking.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.booking.invoker.ApiClient;
import travel.wink.sdk.extranet.booking.model.BookingAnalyticsSupplier;
import travel.wink.sdk.extranet.booking.model.BookingCancellableSupplier;
import travel.wink.sdk.extranet.booking.model.BookingOverviewRequestSupplier;
import travel.wink.sdk.extranet.booking.model.BookingViewSupplier;
import travel.wink.sdk.extranet.booking.model.BookingViewSupplierDetails;
import travel.wink.sdk.extranet.booking.model.BooleanResponseSupplier;
import travel.wink.sdk.extranet.booking.model.CancellationDetailSupplier;
import travel.wink.sdk.extranet.booking.model.GroupedBookingSalesMetricsSupplierDetails;
import travel.wink.sdk.extranet.booking.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.booking.model.PageBookingViewSupplier;
import travel.wink.sdk.extranet.booking.model.PropertyBookingRefundRequestSupplier;
import travel.wink.sdk.extranet.booking.model.StateSupplier;

public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec cancelHotelBookingRequestCreation(String propertyIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        CancellationDetailSupplier postBody = cancellationDetailSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationDetailSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailSupplier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}/cancel", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewSupplier> cancelHotelBooking(String propertyIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(this){};
        return this.cancelHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplier>> cancelHotelBookingWithHttpInfo(String propertyIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(this){};
        return this.cancelHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec cancelHotelBookingWithResponseSpec(String propertyIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        return this.cancelHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion);
    }

    private WebClient.ResponseSpec isBookingCancellableRequestCreation(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling isBookingCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling isBookingCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}/cancellable", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingCancellableSupplier> isBookingCancellable(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>(this){};
        return this.isBookingCancellableRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingCancellableSupplier>> isBookingCancellableWithHttpInfo(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>(this){};
        return this.isBookingCancellableRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isBookingCancellableWithResponseSpec(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.isBookingCancellableRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec requestRefundRequestCreation(String propertyIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        PropertyBookingRefundRequestSupplier postBody = propertyBookingRefundRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (propertyBookingRefundRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyBookingRefundRequestSupplier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}/request-refund", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewSupplier> requestRefund(String propertyIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(this){};
        return this.requestRefundRequestCreation(propertyIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplier>> requestRefundWithHttpInfo(String propertyIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(this){};
        return this.requestRefundRequestCreation(propertyIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec requestRefundWithResponseSpec(String propertyIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.requestRefundRequestCreation(propertyIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec resendBookingConfirmationEmailRequestCreation(String propertyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        Object postBody = body;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}/resend", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseSupplier> resendBookingConfirmationEmail(String propertyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>(this){};
        return this.resendBookingConfirmationEmailRequestCreation(propertyIdentifier, bookingIdentifier, body, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseSupplier>> resendBookingConfirmationEmailWithHttpInfo(String propertyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>(this){};
        return this.resendBookingConfirmationEmailRequestCreation(propertyIdentifier, bookingIdentifier, body, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec resendBookingConfirmationEmailWithResponseSpec(String propertyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        return this.resendBookingConfirmationEmailRequestCreation(propertyIdentifier, bookingIdentifier, body, winkVersion);
    }

    private WebClient.ResponseSpec showActiveAffiliatesRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showActiveAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/owner/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showActiveAffiliates(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showActiveAffiliatesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showActiveAffiliatesWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showActiveAffiliatesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActiveAffiliatesWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showActiveAffiliatesRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showActiveMasterRatesRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showActiveMasterRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/roomrate/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showActiveMasterRates(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showActiveMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showActiveMasterRatesWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showActiveMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActiveMasterRatesWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showActiveMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showBookingAnalyticsRequestCreation(String propertyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        BookingOverviewRequestSupplier postBody = bookingOverviewRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingOverviewRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingOverviewRequestSupplier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/analytics", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingAnalyticsSupplier> showBookingAnalytics(String propertyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>(this){};
        return this.showBookingAnalyticsRequestCreation(propertyIdentifier, bookingOverviewRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingAnalyticsSupplier>> showBookingAnalyticsWithHttpInfo(String propertyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>(this){};
        return this.showBookingAnalyticsRequestCreation(propertyIdentifier, bookingOverviewRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingAnalyticsWithResponseSpec(String propertyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.showBookingAnalyticsRequestCreation(propertyIdentifier, bookingOverviewRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showBookingOverviewRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showBookingOverview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/overview", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<GroupedBookingSalesMetricsSupplierDetails> showBookingOverview(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>(this){};
        return this.showBookingOverviewRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<GroupedBookingSalesMetricsSupplierDetails>> showBookingOverviewWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>(this){};
        return this.showBookingOverviewRequestCreation(propertyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingOverviewWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showBookingOverviewRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showHotelBookingRequestCreation(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewSupplierDetails> showHotelBooking(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(this){};
        return this.showHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplierDetails>> showHotelBookingWithHttpInfo(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(this){};
        return this.showHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelBookingWithResponseSpec(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showHotelBookingsRequestCreation(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showHotelBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingViewSupplier> showHotelBookings(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(this){};
        return this.showHotelBookingsRequestCreation(propertyIdentifier, stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingViewSupplier>> showHotelBookingsWithHttpInfo(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(this){};
        return this.showHotelBookingsRequestCreation(propertyIdentifier, stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelBookingsWithResponseSpec(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return this.showHotelBookingsRequestCreation(propertyIdentifier, stateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showHotelBookings1RequestCreation(String propertyIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelBookings1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "pageNumber", pageNumber));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "maxResults", maxResults));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "search", search));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingViewSupplier> showHotelBookings1(String propertyIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(this){};
        return this.showHotelBookings1RequestCreation(propertyIdentifier, state, pageNumber, maxResults, search, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingViewSupplier>> showHotelBookings1WithHttpInfo(String propertyIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(this){};
        return this.showHotelBookings1RequestCreation(propertyIdentifier, state, pageNumber, maxResults, search, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelBookings1WithResponseSpec(String propertyIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion, String accept) throws WebClientResponseException {
        return this.showHotelBookings1RequestCreation(propertyIdentifier, state, pageNumber, maxResults, search, winkVersion, accept);
    }
}

