/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.extranet.booking.model.RoomConfigurationSupplier;

@JsonPropertyOrder(value={"startDate", "endDate", "items", "hours", "children", "guests", "rooms", "nights"})
@JsonTypeName(value="Itinerary_Supplier")
public class ItinerarySupplier {
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private LocalDate endDate;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<RoomConfigurationSupplier> items = new ArrayList<RoomConfigurationSupplier>();
    public static final String JSON_PROPERTY_HOURS = "hours";
    private Long hours;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private Integer children;
    public static final String JSON_PROPERTY_GUESTS = "guests";
    private Integer guests;
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    private Integer rooms;
    public static final String JSON_PROPERTY_NIGHTS = "nights";
    private Integer nights;

    public ItinerarySupplier() {
    }

    @JsonCreator
    public ItinerarySupplier(@JsonProperty(value="hours") Long hours) {
        this();
        this.hours = hours;
    }

    public ItinerarySupplier startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public ItinerarySupplier endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public ItinerarySupplier items(List<RoomConfigurationSupplier> items) {
        this.items = items;
        return this;
    }

    public ItinerarySupplier addItemsItem(RoomConfigurationSupplier itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<RoomConfigurationSupplier>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<RoomConfigurationSupplier> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItems(List<RoomConfigurationSupplier> items) {
        this.items = items;
    }

    @Nullable
    @JsonProperty(value="hours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHours() {
        return this.hours;
    }

    public ItinerarySupplier children(Integer children) {
        this.children = children;
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(Integer children) {
        this.children = children;
    }

    public ItinerarySupplier guests(Integer guests) {
        this.guests = guests;
        return this;
    }

    @Nullable
    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGuests() {
        return this.guests;
    }

    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuests(Integer guests) {
        this.guests = guests;
    }

    public ItinerarySupplier rooms(Integer rooms) {
        this.rooms = rooms;
        return this;
    }

    @Nullable
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRooms(Integer rooms) {
        this.rooms = rooms;
    }

    public ItinerarySupplier nights(Integer nights) {
        this.nights = nights;
        return this;
    }

    @Nullable
    @JsonProperty(value="nights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNights() {
        return this.nights;
    }

    @JsonProperty(value="nights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNights(Integer nights) {
        this.nights = nights;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItinerarySupplier itinerarySupplier = (ItinerarySupplier)o;
        return Objects.equals(this.startDate, itinerarySupplier.startDate) && Objects.equals(this.endDate, itinerarySupplier.endDate) && Objects.equals(this.items, itinerarySupplier.items) && Objects.equals(this.hours, itinerarySupplier.hours) && Objects.equals(this.children, itinerarySupplier.children) && Objects.equals(this.guests, itinerarySupplier.guests) && Objects.equals(this.rooms, itinerarySupplier.rooms) && Objects.equals(this.nights, itinerarySupplier.nights);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.items, this.hours, this.children, this.guests, this.rooms, this.nights);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItinerarySupplier {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    hours: ").append(this.toIndentedString(this.hours)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    guests: ").append(this.toIndentedString(this.guests)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    nights: ").append(this.toIndentedString(this.nights)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

