package travel.wink.sdk.extranet.booking.api;

import travel.wink.sdk.extranet.booking.invoker.ApiClient;

import travel.wink.sdk.extranet.booking.model.CountResponseSupplier;
import travel.wink.sdk.extranet.booking.model.GenericErrorMessage;
import travel.wink.sdk.extranet.booking.model.PageReviewViewSupplier;
import travel.wink.sdk.extranet.booking.model.ReviewResponseSupplier;
import travel.wink.sdk.extranet.booking.model.ReviewViewSupplier;
import travel.wink.sdk.extranet.booking.model.ShowReview400Response;
import travel.wink.sdk.extranet.booking.model.StateSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-28T11:52:32.240279117+07:00[Asia/Bangkok]")
public class ReviewApi {
    private ApiClient apiClient;

    public ReviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Respond to Review
     * Respond to a unique review for a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Respond to review given hotel with this identifier
     * @param reviewIdentifier Respond to review with this identifier
     * @param reviewResponseSupplier The reviewResponseSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ReviewViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec respondToReviewRequestCreation(String propertyIdentifier, String reviewIdentifier, ReviewResponseSupplier reviewResponseSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = reviewResponseSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'reviewIdentifier' is set
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'reviewResponseSupplier' is set
        if (reviewResponseSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewResponseSupplier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/review/{reviewIdentifier}/response", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Respond to Review
     * Respond to a unique review for a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Respond to review given hotel with this identifier
     * @param reviewIdentifier Respond to review with this identifier
     * @param reviewResponseSupplier The reviewResponseSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ReviewViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ReviewViewSupplier> respondToReview(String propertyIdentifier, String reviewIdentifier, ReviewResponseSupplier reviewResponseSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>() {};
        return respondToReviewRequestCreation(propertyIdentifier, reviewIdentifier, reviewResponseSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Respond to Review
     * Respond to a unique review for a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Respond to review given hotel with this identifier
     * @param reviewIdentifier Respond to review with this identifier
     * @param reviewResponseSupplier The reviewResponseSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ReviewViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ReviewViewSupplier>> respondToReviewWithHttpInfo(String propertyIdentifier, String reviewIdentifier, ReviewResponseSupplier reviewResponseSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>() {};
        return respondToReviewRequestCreation(propertyIdentifier, reviewIdentifier, reviewResponseSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Respond to Review
     * Respond to a unique review for a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Respond to review given hotel with this identifier
     * @param reviewIdentifier Respond to review with this identifier
     * @param reviewResponseSupplier The reviewResponseSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec respondToReviewWithResponseSpec(String propertyIdentifier, String reviewIdentifier, ReviewResponseSupplier reviewResponseSupplier, String winkVersion) throws WebClientResponseException {
        return respondToReviewRequestCreation(propertyIdentifier, reviewIdentifier, reviewResponseSupplier, winkVersion);
    }
    /**
     * Show Review
     * Retrieve a unique review of a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show review given to hotel with this identifier
     * @param reviewIdentifier Show review for this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ReviewViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showReviewRequestCreation(String propertyIdentifier, String reviewIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'reviewIdentifier' is set
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/review/{reviewIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Review
     * Retrieve a unique review of a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show review given to hotel with this identifier
     * @param reviewIdentifier Show review for this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ReviewViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ReviewViewSupplier> showReview(String propertyIdentifier, String reviewIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>() {};
        return showReviewRequestCreation(propertyIdentifier, reviewIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Review
     * Retrieve a unique review of a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show review given to hotel with this identifier
     * @param reviewIdentifier Show review for this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ReviewViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ReviewViewSupplier>> showReviewWithHttpInfo(String propertyIdentifier, String reviewIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewViewSupplier>() {};
        return showReviewRequestCreation(propertyIdentifier, reviewIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Review
     * Retrieve a unique review of a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show review given to hotel with this identifier
     * @param reviewIdentifier Show review for this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showReviewWithResponseSpec(String propertyIdentifier, String reviewIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showReviewRequestCreation(propertyIdentifier, reviewIdentifier, winkVersion, accept);
    }
    /**
     * Show Review Count
     * Retrieve a count of all reviews for a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show review count for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CountResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showReviewCountRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showReviewCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CountResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CountResponseSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/review/count", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Review Count
     * Retrieve a count of all reviews for a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show review count for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CountResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CountResponseSupplier> showReviewCount(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CountResponseSupplier>() {};
        return showReviewCountRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Review Count
     * Retrieve a count of all reviews for a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show review count for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;CountResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CountResponseSupplier>> showReviewCountWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CountResponseSupplier>() {};
        return showReviewCountRequestCreation(propertyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Review Count
     * Retrieve a count of all reviews for a hotel identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show review count for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showReviewCountWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showReviewCountRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Show Reviews
     * Retrieve a paginated list of reviews for specified property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show reviews for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PageReviewViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showReviewsRequestCreation(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = stateSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'stateSupplier' is set
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageReviewViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/review/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Reviews
     * Retrieve a paginated list of reviews for specified property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show reviews for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PageReviewViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageReviewViewSupplier> showReviews(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageReviewViewSupplier>() {};
        return showReviewsRequestCreation(propertyIdentifier, stateSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Reviews
     * Retrieve a paginated list of reviews for specified property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show reviews for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageReviewViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageReviewViewSupplier>> showReviewsWithHttpInfo(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageReviewViewSupplier>() {};
        return showReviewsRequestCreation(propertyIdentifier, stateSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Reviews
     * Retrieve a paginated list of reviews for specified property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show reviews for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showReviewsWithResponseSpec(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return showReviewsRequestCreation(propertyIdentifier, stateSupplier, winkVersion);
    }
}
