/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Extranet Booking API The Booking API exposes endpoints to manage bookings. This API lets you:  1. Booking: Manage bookings including cancellations. 2. Review: Manage user reviews. 3. Sync w. Calendar: Manage calendar sync with your favorite calendar software  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.5.13
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.booking.model.AddressSupplier;
import travel.wink.sdk.extranet.booking.model.BookingAncillarySupplier;
import travel.wink.sdk.extranet.booking.model.BookingContractSupplier;
import travel.wink.sdk.extranet.booking.model.BookingUserSessionSupplier;
import travel.wink.sdk.extranet.booking.model.BookingUserSupplier;
import travel.wink.sdk.extranet.booking.model.CommissionableEntrySupplier;
import travel.wink.sdk.extranet.booking.model.ContactSupplier;
import travel.wink.sdk.extranet.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.booking.model.EngineConfigurationBookingReportSupplier;
import travel.wink.sdk.extranet.booking.model.HotelOnMapSupplier;
import travel.wink.sdk.extranet.booking.model.ReportingAncillarySupplier;
import travel.wink.sdk.extranet.booking.model.ReportingDailyRateSupplier;
import travel.wink.sdk.extranet.booking.model.ReportingExtraChargeSupplier;
import travel.wink.sdk.extranet.booking.model.ReviewSupplier;
import travel.wink.sdk.extranet.booking.model.RoomStaySupplier;
import travel.wink.sdk.extranet.booking.model.SocialSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Booking data object
 */
@JsonPropertyOrder({
  BookingSupplier.JSON_PROPERTY_CREATION,
  BookingSupplier.JSON_PROPERTY_DATE,
  BookingSupplier.JSON_PROPERTY_GROUP_IDENTIFIER,
  BookingSupplier.JSON_PROPERTY_IDENTIFIER,
  BookingSupplier.JSON_PROPERTY_ENGINE_CONFIGURATION,
  BookingSupplier.JSON_PROPERTY_BOOKING_CODE,
  BookingSupplier.JSON_PROPERTY_USER,
  BookingSupplier.JSON_PROPERTY_USER_SESSION,
  BookingSupplier.JSON_PROPERTY_SERVER_URL,
  BookingSupplier.JSON_PROPERTY_CONTACT_INFO,
  BookingSupplier.JSON_PROPERTY_ADDRESS,
  BookingSupplier.JSON_PROPERTY_SOCIALS,
  BookingSupplier.JSON_PROPERTY_REVIEW,
  BookingSupplier.JSON_PROPERTY_EMAIL_HEADER_LOGO_URL,
  BookingSupplier.JSON_PROPERTY_LOGO_IDENTIFIER,
  BookingSupplier.JSON_PROPERTY_HOTEL,
  BookingSupplier.JSON_PROPERTY_ROOM_STAY,
  BookingSupplier.JSON_PROPERTY_SPECIAL_REQUESTS,
  BookingSupplier.JSON_PROPERTY_COMMENT,
  BookingSupplier.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE,
  BookingSupplier.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE,
  BookingSupplier.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT,
  BookingSupplier.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT,
  BookingSupplier.JSON_PROPERTY_HOTEL_IMAGE_URL,
  BookingSupplier.JSON_PROPERTY_ROOM_IMAGE_URL,
  BookingSupplier.JSON_PROPERTY_COMMISSION_LIST,
  BookingSupplier.JSON_PROPERTY_ANCILLARY_LIST,
  BookingSupplier.JSON_PROPERTY_BOOKING_CONTRACT,
  BookingSupplier.JSON_PROPERTY_STATIC_MAP_IMAGE_URL,
  BookingSupplier.JSON_PROPERTY_STATIC_MAP_URL,
  BookingSupplier.JSON_PROPERTY_STATUS,
  BookingSupplier.JSON_PROPERTY_RESTAURANTS,
  BookingSupplier.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingSupplier.JSON_PROPERTY_SPAS,
  BookingSupplier.JSON_PROPERTY_MEETING_ROOMS,
  BookingSupplier.JSON_PROPERTY_ACTIVITIES,
  BookingSupplier.JSON_PROPERTY_ATTRACTIONS,
  BookingSupplier.JSON_PROPERTY_PLACES,
  BookingSupplier.JSON_PROPERTY_ROOM_TYPE_ANCILLARIES,
  BookingSupplier.JSON_PROPERTY_ADD_ONS,
  BookingSupplier.JSON_PROPERTY_FULL_ADDRESS,
  BookingSupplier.JSON_PROPERTY_CANCELLABLE_BY_AGENT,
  BookingSupplier.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingSupplier.JSON_PROPERTY_RATE_SOURCE,
  BookingSupplier.JSON_PROPERTY_HAS_ADD_ONS,
  BookingSupplier.JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES,
  BookingSupplier.JSON_PROPERTY_HAS_FOOD,
  BookingSupplier.JSON_PROPERTY_HAS_RESTAURANTS,
  BookingSupplier.JSON_PROPERTY_HAS_MEETING_ROOMS,
  BookingSupplier.JSON_PROPERTY_HAS_SPAS,
  BookingSupplier.JSON_PROPERTY_HAS_ACTIVITIES,
  BookingSupplier.JSON_PROPERTY_HAS_ATTRACTIONS,
  BookingSupplier.JSON_PROPERTY_HAS_PLACES,
  BookingSupplier.JSON_PROPERTY_REPORTING_DAILY_RATE_LIST,
  BookingSupplier.JSON_PROPERTY_REPORTING_ANCILLARY_LIST,
  BookingSupplier.JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST,
  BookingSupplier.JSON_PROPERTY_HAS_BREAKFAST,
  BookingSupplier.JSON_PROPERTY_HAS_BRUNCH,
  BookingSupplier.JSON_PROPERTY_HAS_LUNCH,
  BookingSupplier.JSON_PROPERTY_HAS_DINNER,
  BookingSupplier.JSON_PROPERTY_HAS_ALL_INCLUSIVE,
  BookingSupplier.JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL
})
@JsonTypeName("Booking_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T20:22:08.343418683+07:00[Asia/Bangkok]")
public class BookingSupplier {
  /**
   * Communicates whether the booking was created normally or if it failed or was just for testing.
   */
  public enum CreationEnum {
    NORMAL("NORMAL"),
    
    TEST("TEST"),
    
    FAILED("FAILED");

    private String value;

    CreationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CreationEnum fromValue(String value) {
      for (CreationEnum b : CreationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CREATION = "creation";
  private CreationEnum creation = CreationEnum.NORMAL;

  public static final String JSON_PROPERTY_DATE = "date";
  private java.time.LocalDateTime date;

  public static final String JSON_PROPERTY_GROUP_IDENTIFIER = "groupIdentifier";
  private UUID groupIdentifier;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION = "engineConfiguration";
  private EngineConfigurationBookingReportSupplier engineConfiguration;

  public static final String JSON_PROPERTY_BOOKING_CODE = "bookingCode";
  private String bookingCode;

  public static final String JSON_PROPERTY_USER = "user";
  private BookingUserSupplier user;

  public static final String JSON_PROPERTY_USER_SESSION = "userSession";
  private BookingUserSessionSupplier userSession;

  public static final String JSON_PROPERTY_SERVER_URL = "serverUrl";
  private String serverUrl;

  public static final String JSON_PROPERTY_CONTACT_INFO = "contactInfo";
  private ContactSupplier contactInfo;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressSupplier address;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialSupplier> socials;

  public static final String JSON_PROPERTY_REVIEW = "review";
  private ReviewSupplier review;

  public static final String JSON_PROPERTY_EMAIL_HEADER_LOGO_URL = "emailHeaderLogoUrl";
  private String emailHeaderLogoUrl;

  public static final String JSON_PROPERTY_LOGO_IDENTIFIER = "logoIdentifier";
  private String logoIdentifier;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMapSupplier hotel;

  public static final String JSON_PROPERTY_ROOM_STAY = "roomStay";
  private RoomStaySupplier roomStay;

  public static final String JSON_PROPERTY_SPECIAL_REQUESTS = "specialRequests";
  private String specialRequests;

  public static final String JSON_PROPERTY_COMMENT = "comment";
  private String comment;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
  private CustomMonetaryAmount earlyCheckInCharge;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
  private CustomMonetaryAmount lateCheckOutCharge;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT = "earlyCheckInChargePercent";
  private Float earlyCheckInChargePercent;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT = "lateCheckOutChargePercent";
  private Float lateCheckOutChargePercent;

  public static final String JSON_PROPERTY_HOTEL_IMAGE_URL = "hotelImageUrl";
  private String hotelImageUrl;

  public static final String JSON_PROPERTY_ROOM_IMAGE_URL = "roomImageUrl";
  private String roomImageUrl;

  public static final String JSON_PROPERTY_COMMISSION_LIST = "commissionList";
  private List<CommissionableEntrySupplier> commissionList;

  public static final String JSON_PROPERTY_ANCILLARY_LIST = "ancillaryList";
  private List<BookingAncillarySupplier> ancillaryList;

  public static final String JSON_PROPERTY_BOOKING_CONTRACT = "bookingContract";
  private BookingContractSupplier bookingContract;

  public static final String JSON_PROPERTY_STATIC_MAP_IMAGE_URL = "staticMapImageUrl";
  private String staticMapImageUrl;

  public static final String JSON_PROPERTY_STATIC_MAP_URL = "staticMapUrl";
  private String staticMapUrl;

  /**
   * Convenience data point to show which status the booking currently has.
   */
  public enum StatusEnum {
    CANCELLED_BY_HOTEL("CANCELLED_BY_HOTEL"),
    
    CANCELLED_BY_GUEST("CANCELLED_BY_GUEST"),
    
    CANCELLED_BY_ADMIN("CANCELLED_BY_ADMIN"),
    
    CANCELLED_BY_SALES_CHANNEL("CANCELLED_BY_SALES_CHANNEL"),
    
    PAST("PAST"),
    
    FUTURE("FUTURE"),
    
    CANCELLED_BY_ACQUIRER("CANCELLED_BY_ACQUIRER"),
    
    ACTIVE("ACTIVE"),
    
    FAILED("FAILED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_RESTAURANTS = "restaurants";
  private List<BookingAncillarySupplier> restaurants;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_SPAS = "spas";
  private List<BookingAncillarySupplier> spas;

  public static final String JSON_PROPERTY_MEETING_ROOMS = "meetingRooms";
  private List<BookingAncillarySupplier> meetingRooms;

  public static final String JSON_PROPERTY_ACTIVITIES = "activities";
  private List<BookingAncillarySupplier> activities;

  public static final String JSON_PROPERTY_ATTRACTIONS = "attractions";
  private List<BookingAncillarySupplier> attractions;

  public static final String JSON_PROPERTY_PLACES = "places";
  private List<BookingAncillarySupplier> places;

  public static final String JSON_PROPERTY_ROOM_TYPE_ANCILLARIES = "roomTypeAncillaries";
  private List<BookingAncillarySupplier> roomTypeAncillaries;

  public static final String JSON_PROPERTY_ADD_ONS = "addOns";
  private List<BookingAncillarySupplier> addOns;

  public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
  private String fullAddress;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_AGENT = "cancellableByAgent";
  private Boolean cancellableByAgent;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private String rateSource;

  public static final String JSON_PROPERTY_HAS_ADD_ONS = "hasAddOns";
  private Boolean hasAddOns;

  public static final String JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES = "hasRoomTypeAncillaries";
  private Boolean hasRoomTypeAncillaries;

  public static final String JSON_PROPERTY_HAS_FOOD = "hasFood";
  private Boolean hasFood;

  public static final String JSON_PROPERTY_HAS_RESTAURANTS = "hasRestaurants";
  private Boolean hasRestaurants;

  public static final String JSON_PROPERTY_HAS_MEETING_ROOMS = "hasMeetingRooms";
  private Boolean hasMeetingRooms;

  public static final String JSON_PROPERTY_HAS_SPAS = "hasSpas";
  private Boolean hasSpas;

  public static final String JSON_PROPERTY_HAS_ACTIVITIES = "hasActivities";
  private Boolean hasActivities;

  public static final String JSON_PROPERTY_HAS_ATTRACTIONS = "hasAttractions";
  private Boolean hasAttractions;

  public static final String JSON_PROPERTY_HAS_PLACES = "hasPlaces";
  private Boolean hasPlaces;

  public static final String JSON_PROPERTY_REPORTING_DAILY_RATE_LIST = "reportingDailyRateList";
  private List<ReportingDailyRateSupplier> reportingDailyRateList;

  public static final String JSON_PROPERTY_REPORTING_ANCILLARY_LIST = "reportingAncillaryList";
  private List<ReportingAncillarySupplier> reportingAncillaryList;

  public static final String JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST = "reportingExtraChargeList";
  private List<ReportingExtraChargeSupplier> reportingExtraChargeList;

  public static final String JSON_PROPERTY_HAS_BREAKFAST = "hasBreakfast";
  private Boolean hasBreakfast;

  public static final String JSON_PROPERTY_HAS_BRUNCH = "hasBrunch";
  private Boolean hasBrunch;

  public static final String JSON_PROPERTY_HAS_LUNCH = "hasLunch";
  private Boolean hasLunch;

  public static final String JSON_PROPERTY_HAS_DINNER = "hasDinner";
  private Boolean hasDinner;

  public static final String JSON_PROPERTY_HAS_ALL_INCLUSIVE = "hasAllInclusive";
  private Boolean hasAllInclusive;

  public static final String JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL = "hasAllInclusivePlusAlcohol";
  private Boolean hasAllInclusivePlusAlcohol;

  public BookingSupplier() {
  }

  public BookingSupplier creation(CreationEnum creation) {
    
    this.creation = creation;
    return this;
  }

   /**
   * Communicates whether the booking was created normally or if it failed or was just for testing.
   * @return creation
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CREATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreationEnum getCreation() {
    return creation;
  }


  @JsonProperty(JSON_PROPERTY_CREATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreation(CreationEnum creation) {
    this.creation = creation;
  }


  public BookingSupplier date(java.time.LocalDateTime date) {
    
    this.date = date;
    return this;
  }

   /**
   * Date and time the booking was made.
   * @return date
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDate(java.time.LocalDateTime date) {
    this.date = date;
  }


  public BookingSupplier groupIdentifier(UUID groupIdentifier) {
    
    this.groupIdentifier = groupIdentifier;
    return this;
  }

   /**
   * Unique record identifier for the collection of bookings that were made at the same time.
   * @return groupIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_GROUP_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getGroupIdentifier() {
    return groupIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGroupIdentifier(UUID groupIdentifier) {
    this.groupIdentifier = groupIdentifier;
  }


  public BookingSupplier identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public BookingSupplier engineConfiguration(EngineConfigurationBookingReportSupplier engineConfiguration) {
    
    this.engineConfiguration = engineConfiguration;
    return this;
  }

   /**
   * Get engineConfiguration
   * @return engineConfiguration
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EngineConfigurationBookingReportSupplier getEngineConfiguration() {
    return engineConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfiguration(EngineConfigurationBookingReportSupplier engineConfiguration) {
    this.engineConfiguration = engineConfiguration;
  }


  public BookingSupplier bookingCode(String bookingCode) {
    
    this.bookingCode = bookingCode;
    return this;
  }

   /**
   * Unique user-friendly booking geoname. This code should be used when corresponding with travelers.
   * @return bookingCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBookingCode() {
    return bookingCode;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingCode(String bookingCode) {
    this.bookingCode = bookingCode;
  }


  public BookingSupplier user(BookingUserSupplier user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSupplier getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(BookingUserSupplier user) {
    this.user = user;
  }


  public BookingSupplier userSession(BookingUserSessionSupplier userSession) {
    
    this.userSession = userSession;
    return this;
  }

   /**
   * Get userSession
   * @return userSession
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingUserSessionSupplier getUserSession() {
    return userSession;
  }


  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSession(BookingUserSessionSupplier userSession) {
    this.userSession = userSession;
  }


  public BookingSupplier serverUrl(String serverUrl) {
    
    this.serverUrl = serverUrl;
    return this;
  }

   /**
   * The URL the booking occurred
   * @return serverUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getServerUrl() {
    return serverUrl;
  }


  @JsonProperty(JSON_PROPERTY_SERVER_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setServerUrl(String serverUrl) {
    this.serverUrl = serverUrl;
  }


  public BookingSupplier contactInfo(ContactSupplier contactInfo) {
    
    this.contactInfo = contactInfo;
    return this;
  }

   /**
   * Get contactInfo
   * @return contactInfo
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactSupplier getContactInfo() {
    return contactInfo;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactInfo(ContactSupplier contactInfo) {
    this.contactInfo = contactInfo;
  }


  public BookingSupplier address(AddressSupplier address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressSupplier getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressSupplier address) {
    this.address = address;
  }


  public BookingSupplier socials(List<SocialSupplier> socials) {
    
    this.socials = socials;
    return this;
  }

  public BookingSupplier addSocialsItem(SocialSupplier socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * List of all social network account property has for the traveler to get in touch.
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialSupplier> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialSupplier> socials) {
    this.socials = socials;
  }


  public BookingSupplier review(ReviewSupplier review) {
    
    this.review = review;
    return this;
  }

   /**
   * Get review
   * @return review
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ReviewSupplier getReview() {
    return review;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReview(ReviewSupplier review) {
    this.review = review;
  }


  public BookingSupplier emailHeaderLogoUrl(String emailHeaderLogoUrl) {
    
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
    return this;
  }

   /**
   * Full url of the image logo optimized for emails
   * @return emailHeaderLogoUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmailHeaderLogoUrl() {
    return emailHeaderLogoUrl;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmailHeaderLogoUrl(String emailHeaderLogoUrl) {
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
  }


  public BookingSupplier logoIdentifier(String logoIdentifier) {
    
    this.logoIdentifier = logoIdentifier;
    return this;
  }

   /**
   * Logo cloudinary identifier for potential reuse
   * @return logoIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLogoIdentifier() {
    return logoIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogoIdentifier(String logoIdentifier) {
    this.logoIdentifier = logoIdentifier;
  }


  public BookingSupplier hotel(HotelOnMapSupplier hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public HotelOnMapSupplier getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotel(HotelOnMapSupplier hotel) {
    this.hotel = hotel;
  }


  public BookingSupplier roomStay(RoomStaySupplier roomStay) {
    
    this.roomStay = roomStay;
    return this;
  }

   /**
   * Get roomStay
   * @return roomStay
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomStaySupplier getRoomStay() {
    return roomStay;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomStay(RoomStaySupplier roomStay) {
    this.roomStay = roomStay;
  }


  public BookingSupplier specialRequests(String specialRequests) {
    
    this.specialRequests = specialRequests;
    return this;
  }

   /**
   * Free text where the traveler can add a message to the property.
   * @return specialRequests
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSpecialRequests() {
    return specialRequests;
  }


  @JsonProperty(JSON_PROPERTY_SPECIAL_REQUESTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpecialRequests(String specialRequests) {
    this.specialRequests = specialRequests;
  }


  public BookingSupplier comment(String comment) {
    
    this.comment = comment;
    return this;
  }

   /**
   * Internal comment field the payment can add and make available to channel manager partners.
   * @return comment
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getComment() {
    return comment;
  }


  @JsonProperty(JSON_PROPERTY_COMMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setComment(String comment) {
    this.comment = comment;
  }


  public BookingSupplier earlyCheckInCharge(CustomMonetaryAmount earlyCheckInCharge) {
    
    this.earlyCheckInCharge = earlyCheckInCharge;
    return this;
  }

   /**
   * Get earlyCheckInCharge
   * @return earlyCheckInCharge
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getEarlyCheckInCharge() {
    return earlyCheckInCharge;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInCharge(CustomMonetaryAmount earlyCheckInCharge) {
    this.earlyCheckInCharge = earlyCheckInCharge;
  }


  public BookingSupplier lateCheckOutCharge(CustomMonetaryAmount lateCheckOutCharge) {
    
    this.lateCheckOutCharge = lateCheckOutCharge;
    return this;
  }

   /**
   * Get lateCheckOutCharge
   * @return lateCheckOutCharge
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getLateCheckOutCharge() {
    return lateCheckOutCharge;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutCharge(CustomMonetaryAmount lateCheckOutCharge) {
    this.lateCheckOutCharge = lateCheckOutCharge;
  }


  public BookingSupplier earlyCheckInChargePercent(Float earlyCheckInChargePercent) {
    
    this.earlyCheckInChargePercent = earlyCheckInChargePercent;
    return this;
  }

   /**
   * Early check-in charge calculated in percent of first room night price.
   * @return earlyCheckInChargePercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getEarlyCheckInChargePercent() {
    return earlyCheckInChargePercent;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInChargePercent(Float earlyCheckInChargePercent) {
    this.earlyCheckInChargePercent = earlyCheckInChargePercent;
  }


  public BookingSupplier lateCheckOutChargePercent(Float lateCheckOutChargePercent) {
    
    this.lateCheckOutChargePercent = lateCheckOutChargePercent;
    return this;
  }

   /**
   * Early check-in charge calculated in percent of first room night price.
   * @return lateCheckOutChargePercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getLateCheckOutChargePercent() {
    return lateCheckOutChargePercent;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutChargePercent(Float lateCheckOutChargePercent) {
    this.lateCheckOutChargePercent = lateCheckOutChargePercent;
  }


  public BookingSupplier hotelImageUrl(String hotelImageUrl) {
    
    this.hotelImageUrl = hotelImageUrl;
    return this;
  }

   /**
   * Absolute URL of hotel image that can be used as-is
   * @return hotelImageUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HOTEL_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelImageUrl() {
    return hotelImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelImageUrl(String hotelImageUrl) {
    this.hotelImageUrl = hotelImageUrl;
  }


  public BookingSupplier roomImageUrl(String roomImageUrl) {
    
    this.roomImageUrl = roomImageUrl;
    return this;
  }

   /**
   * Absolute URL of room image that can be used as-is
   * @return roomImageUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomImageUrl() {
    return roomImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomImageUrl(String roomImageUrl) {
    this.roomImageUrl = roomImageUrl;
  }


  public BookingSupplier commissionList(List<CommissionableEntrySupplier> commissionList) {
    
    this.commissionList = commissionList;
    return this;
  }

  public BookingSupplier addCommissionListItem(CommissionableEntrySupplier commissionListItem) {
    if (this.commissionList == null) {
      this.commissionList = new ArrayList<>();
    }
    this.commissionList.add(commissionListItem);
    return this;
  }

   /**
   * List of all travel inventory entries that are due a commission to the affiliate.
   * @return commissionList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CommissionableEntrySupplier> getCommissionList() {
    return commissionList;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionList(List<CommissionableEntrySupplier> commissionList) {
    this.commissionList = commissionList;
  }


  public BookingSupplier ancillaryList(List<BookingAncillarySupplier> ancillaryList) {
    
    this.ancillaryList = ancillaryList;
    return this;
  }

  public BookingSupplier addAncillaryListItem(BookingAncillarySupplier ancillaryListItem) {
    if (this.ancillaryList == null) {
      this.ancillaryList = new ArrayList<>();
    }
    this.ancillaryList.add(ancillaryListItem);
    return this;
  }

   /**
   * Get ancillaryList
   * @return ancillaryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillarySupplier> getAncillaryList() {
    return ancillaryList;
  }


  @JsonProperty(JSON_PROPERTY_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAncillaryList(List<BookingAncillarySupplier> ancillaryList) {
    this.ancillaryList = ancillaryList;
  }


  public BookingSupplier bookingContract(BookingContractSupplier bookingContract) {
    
    this.bookingContract = bookingContract;
    return this;
  }

   /**
   * Get bookingContract
   * @return bookingContract
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractSupplier getBookingContract() {
    return bookingContract;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingContract(BookingContractSupplier bookingContract) {
    this.bookingContract = bookingContract;
  }


  public BookingSupplier staticMapImageUrl(String staticMapImageUrl) {
    
    this.staticMapImageUrl = staticMapImageUrl;
    return this;
  }

   /**
   * Url of map image that can be sent via email
   * @return staticMapImageUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATIC_MAP_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStaticMapImageUrl() {
    return staticMapImageUrl;
  }


  @JsonProperty(JSON_PROPERTY_STATIC_MAP_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStaticMapImageUrl(String staticMapImageUrl) {
    this.staticMapImageUrl = staticMapImageUrl;
  }


  public BookingSupplier staticMapUrl(String staticMapUrl) {
    
    this.staticMapUrl = staticMapUrl;
    return this;
  }

   /**
   * Url of map image location on Google Maps
   * @return staticMapUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATIC_MAP_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStaticMapUrl() {
    return staticMapUrl;
  }


  @JsonProperty(JSON_PROPERTY_STATIC_MAP_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStaticMapUrl(String staticMapUrl) {
    this.staticMapUrl = staticMapUrl;
  }


  public BookingSupplier status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Convenience data point to show which status the booking currently has.
   * @return status
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public BookingSupplier restaurants(List<BookingAncillarySupplier> restaurants) {
    
    this.restaurants = restaurants;
    return this;
  }

  public BookingSupplier addRestaurantsItem(BookingAncillarySupplier restaurantsItem) {
    if (this.restaurants == null) {
      this.restaurants = new ArrayList<>();
    }
    this.restaurants.add(restaurantsItem);
    return this;
  }

   /**
   * Restaurant reservation records.
   * @return restaurants
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillarySupplier> getRestaurants() {
    return restaurants;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurants(List<BookingAncillarySupplier> restaurants) {
    this.restaurants = restaurants;
  }


  public BookingSupplier cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingSupplier spas(List<BookingAncillarySupplier> spas) {
    
    this.spas = spas;
    return this;
  }

  public BookingSupplier addSpasItem(BookingAncillarySupplier spasItem) {
    if (this.spas == null) {
      this.spas = new ArrayList<>();
    }
    this.spas.add(spasItem);
    return this;
  }

   /**
   * Spa reservation records.
   * @return spas
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillarySupplier> getSpas() {
    return spas;
  }


  @JsonProperty(JSON_PROPERTY_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpas(List<BookingAncillarySupplier> spas) {
    this.spas = spas;
  }


  public BookingSupplier meetingRooms(List<BookingAncillarySupplier> meetingRooms) {
    
    this.meetingRooms = meetingRooms;
    return this;
  }

  public BookingSupplier addMeetingRoomsItem(BookingAncillarySupplier meetingRoomsItem) {
    if (this.meetingRooms == null) {
      this.meetingRooms = new ArrayList<>();
    }
    this.meetingRooms.add(meetingRoomsItem);
    return this;
  }

   /**
   * Meeting room reservation records.
   * @return meetingRooms
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillarySupplier> getMeetingRooms() {
    return meetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRooms(List<BookingAncillarySupplier> meetingRooms) {
    this.meetingRooms = meetingRooms;
  }


  public BookingSupplier activities(List<BookingAncillarySupplier> activities) {
    
    this.activities = activities;
    return this;
  }

  public BookingSupplier addActivitiesItem(BookingAncillarySupplier activitiesItem) {
    if (this.activities == null) {
      this.activities = new ArrayList<>();
    }
    this.activities.add(activitiesItem);
    return this;
  }

   /**
   * Activity reservation records.
   * @return activities
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillarySupplier> getActivities() {
    return activities;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivities(List<BookingAncillarySupplier> activities) {
    this.activities = activities;
  }


  public BookingSupplier attractions(List<BookingAncillarySupplier> attractions) {
    
    this.attractions = attractions;
    return this;
  }

  public BookingSupplier addAttractionsItem(BookingAncillarySupplier attractionsItem) {
    if (this.attractions == null) {
      this.attractions = new ArrayList<>();
    }
    this.attractions.add(attractionsItem);
    return this;
  }

   /**
   * Attraction reservation records.
   * @return attractions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillarySupplier> getAttractions() {
    return attractions;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttractions(List<BookingAncillarySupplier> attractions) {
    this.attractions = attractions;
  }


  public BookingSupplier places(List<BookingAncillarySupplier> places) {
    
    this.places = places;
    return this;
  }

  public BookingSupplier addPlacesItem(BookingAncillarySupplier placesItem) {
    if (this.places == null) {
      this.places = new ArrayList<>();
    }
    this.places.add(placesItem);
    return this;
  }

   /**
   * Place reservation records.
   * @return places
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillarySupplier> getPlaces() {
    return places;
  }


  @JsonProperty(JSON_PROPERTY_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlaces(List<BookingAncillarySupplier> places) {
    this.places = places;
  }


  public BookingSupplier roomTypeAncillaries(List<BookingAncillarySupplier> roomTypeAncillaries) {
    
    this.roomTypeAncillaries = roomTypeAncillaries;
    return this;
  }

  public BookingSupplier addRoomTypeAncillariesItem(BookingAncillarySupplier roomTypeAncillariesItem) {
    if (this.roomTypeAncillaries == null) {
      this.roomTypeAncillaries = new ArrayList<>();
    }
    this.roomTypeAncillaries.add(roomTypeAncillariesItem);
    return this;
  }

   /**
   * Room type ancillary records.
   * @return roomTypeAncillaries
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillarySupplier> getRoomTypeAncillaries() {
    return roomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomTypeAncillaries(List<BookingAncillarySupplier> roomTypeAncillaries) {
    this.roomTypeAncillaries = roomTypeAncillaries;
  }


  public BookingSupplier addOns(List<BookingAncillarySupplier> addOns) {
    
    this.addOns = addOns;
    return this;
  }

  public BookingSupplier addAddOnsItem(BookingAncillarySupplier addOnsItem) {
    if (this.addOns == null) {
      this.addOns = new ArrayList<>();
    }
    this.addOns.add(addOnsItem);
    return this;
  }

   /**
   * Add-on records.
   * @return addOns
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingAncillarySupplier> getAddOns() {
    return addOns;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOns(List<BookingAncillarySupplier> addOns) {
    this.addOns = addOns;
  }


  public BookingSupplier fullAddress(String fullAddress) {
    
    this.fullAddress = fullAddress;
    return this;
  }

   /**
   * Convenience data point to return the full hotel address.
   * @return fullAddress
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullAddress() {
    return fullAddress;
  }


  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullAddress(String fullAddress) {
    this.fullAddress = fullAddress;
  }


  public BookingSupplier cancellableByAgent(Boolean cancellableByAgent) {
    
    this.cancellableByAgent = cancellableByAgent;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the agent.
   * @return cancellableByAgent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByAgent() {
    return cancellableByAgent;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByAgent(Boolean cancellableByAgent) {
    this.cancellableByAgent = cancellableByAgent;
  }


  public BookingSupplier cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  public BookingSupplier rateSource(String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Rate origin. This is usually the property channel manager.
   * @return rateSource
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(String rateSource) {
    this.rateSource = rateSource;
  }


  public BookingSupplier hasAddOns(Boolean hasAddOns) {
    
    this.hasAddOns = hasAddOns;
    return this;
  }

   /**
   * Convenience data point to check if any add-on offers are in this booking.
   * @return hasAddOns
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAddOns() {
    return hasAddOns;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ADD_ONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAddOns(Boolean hasAddOns) {
    this.hasAddOns = hasAddOns;
  }


  public BookingSupplier hasRoomTypeAncillaries(Boolean hasRoomTypeAncillaries) {
    
    this.hasRoomTypeAncillaries = hasRoomTypeAncillaries;
    return this;
  }

   /**
   * Convenience data point to check if any room type ancillaries are in this booking.
   * @return hasRoomTypeAncillaries
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRoomTypeAncillaries() {
    return hasRoomTypeAncillaries;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ROOM_TYPE_ANCILLARIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRoomTypeAncillaries(Boolean hasRoomTypeAncillaries) {
    this.hasRoomTypeAncillaries = hasRoomTypeAncillaries;
  }


  public BookingSupplier hasFood(Boolean hasFood) {
    
    this.hasFood = hasFood;
    return this;
  }

   /**
   * Convenience data point to check if any food is included in this booking.
   * @return hasFood
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_FOOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFood() {
    return hasFood;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FOOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFood(Boolean hasFood) {
    this.hasFood = hasFood;
  }


  public BookingSupplier hasRestaurants(Boolean hasRestaurants) {
    
    this.hasRestaurants = hasRestaurants;
    return this;
  }

   /**
   * Convenience data point to check if any restaurant reservations are included in this booking.
   * @return hasRestaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRestaurants() {
    return hasRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_HAS_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRestaurants(Boolean hasRestaurants) {
    this.hasRestaurants = hasRestaurants;
  }


  public BookingSupplier hasMeetingRooms(Boolean hasMeetingRooms) {
    
    this.hasMeetingRooms = hasMeetingRooms;
    return this;
  }

   /**
   * Convenience data point to check if any meeting room reservations are included in this booking.
   * @return hasMeetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasMeetingRooms() {
    return hasMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_HAS_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasMeetingRooms(Boolean hasMeetingRooms) {
    this.hasMeetingRooms = hasMeetingRooms;
  }


  public BookingSupplier hasSpas(Boolean hasSpas) {
    
    this.hasSpas = hasSpas;
    return this;
  }

   /**
   * Convenience data point to check if any spa reservations are included in this booking.
   * @return hasSpas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasSpas() {
    return hasSpas;
  }


  @JsonProperty(JSON_PROPERTY_HAS_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasSpas(Boolean hasSpas) {
    this.hasSpas = hasSpas;
  }


  public BookingSupplier hasActivities(Boolean hasActivities) {
    
    this.hasActivities = hasActivities;
    return this;
  }

   /**
   * Convenience data point to check if any activity reservations are included in this booking.
   * @return hasActivities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasActivities() {
    return hasActivities;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasActivities(Boolean hasActivities) {
    this.hasActivities = hasActivities;
  }


  public BookingSupplier hasAttractions(Boolean hasAttractions) {
    
    this.hasAttractions = hasAttractions;
    return this;
  }

   /**
   * Convenience data point to check if any attractions reservations are included in this booking.
   * @return hasAttractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAttractions() {
    return hasAttractions;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAttractions(Boolean hasAttractions) {
    this.hasAttractions = hasAttractions;
  }


  public BookingSupplier hasPlaces(Boolean hasPlaces) {
    
    this.hasPlaces = hasPlaces;
    return this;
  }

   /**
   * Convenience data point to check if any place reservations are included in this booking.
   * @return hasPlaces
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPlaces() {
    return hasPlaces;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPlaces(Boolean hasPlaces) {
    this.hasPlaces = hasPlaces;
  }


  public BookingSupplier reportingDailyRateList(List<ReportingDailyRateSupplier> reportingDailyRateList) {
    
    this.reportingDailyRateList = reportingDailyRateList;
    return this;
  }

  public BookingSupplier addReportingDailyRateListItem(ReportingDailyRateSupplier reportingDailyRateListItem) {
    if (this.reportingDailyRateList == null) {
      this.reportingDailyRateList = new ArrayList<>();
    }
    this.reportingDailyRateList.add(reportingDailyRateListItem);
    return this;
  }

   /**
   * Get reportingDailyRateList
   * @return reportingDailyRateList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REPORTING_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReportingDailyRateSupplier> getReportingDailyRateList() {
    return reportingDailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_REPORTING_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReportingDailyRateList(List<ReportingDailyRateSupplier> reportingDailyRateList) {
    this.reportingDailyRateList = reportingDailyRateList;
  }


  public BookingSupplier reportingAncillaryList(List<ReportingAncillarySupplier> reportingAncillaryList) {
    
    this.reportingAncillaryList = reportingAncillaryList;
    return this;
  }

  public BookingSupplier addReportingAncillaryListItem(ReportingAncillarySupplier reportingAncillaryListItem) {
    if (this.reportingAncillaryList == null) {
      this.reportingAncillaryList = new ArrayList<>();
    }
    this.reportingAncillaryList.add(reportingAncillaryListItem);
    return this;
  }

   /**
   * Get reportingAncillaryList
   * @return reportingAncillaryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REPORTING_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReportingAncillarySupplier> getReportingAncillaryList() {
    return reportingAncillaryList;
  }


  @JsonProperty(JSON_PROPERTY_REPORTING_ANCILLARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReportingAncillaryList(List<ReportingAncillarySupplier> reportingAncillaryList) {
    this.reportingAncillaryList = reportingAncillaryList;
  }


  public BookingSupplier reportingExtraChargeList(List<ReportingExtraChargeSupplier> reportingExtraChargeList) {
    
    this.reportingExtraChargeList = reportingExtraChargeList;
    return this;
  }

  public BookingSupplier addReportingExtraChargeListItem(ReportingExtraChargeSupplier reportingExtraChargeListItem) {
    if (this.reportingExtraChargeList == null) {
      this.reportingExtraChargeList = new ArrayList<>();
    }
    this.reportingExtraChargeList.add(reportingExtraChargeListItem);
    return this;
  }

   /**
   * Get reportingExtraChargeList
   * @return reportingExtraChargeList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReportingExtraChargeSupplier> getReportingExtraChargeList() {
    return reportingExtraChargeList;
  }


  @JsonProperty(JSON_PROPERTY_REPORTING_EXTRA_CHARGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReportingExtraChargeList(List<ReportingExtraChargeSupplier> reportingExtraChargeList) {
    this.reportingExtraChargeList = reportingExtraChargeList;
  }


  public BookingSupplier hasBreakfast(Boolean hasBreakfast) {
    
    this.hasBreakfast = hasBreakfast;
    return this;
  }

   /**
   * Convenience data point to get to breakfast quickly.
   * @return hasBreakfast
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasBreakfast() {
    return hasBreakfast;
  }


  @JsonProperty(JSON_PROPERTY_HAS_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasBreakfast(Boolean hasBreakfast) {
    this.hasBreakfast = hasBreakfast;
  }


  public BookingSupplier hasBrunch(Boolean hasBrunch) {
    
    this.hasBrunch = hasBrunch;
    return this;
  }

   /**
   * Convenience data point to get to brunch quickly.
   * @return hasBrunch
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasBrunch() {
    return hasBrunch;
  }


  @JsonProperty(JSON_PROPERTY_HAS_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasBrunch(Boolean hasBrunch) {
    this.hasBrunch = hasBrunch;
  }


  public BookingSupplier hasLunch(Boolean hasLunch) {
    
    this.hasLunch = hasLunch;
    return this;
  }

   /**
   * Convenience data point to get to lunch quickly.
   * @return hasLunch
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_LUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasLunch() {
    return hasLunch;
  }


  @JsonProperty(JSON_PROPERTY_HAS_LUNCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasLunch(Boolean hasLunch) {
    this.hasLunch = hasLunch;
  }


  public BookingSupplier hasDinner(Boolean hasDinner) {
    
    this.hasDinner = hasDinner;
    return this;
  }

   /**
   * Convenience data point to get to dinner quickly.
   * @return hasDinner
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_DINNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasDinner() {
    return hasDinner;
  }


  @JsonProperty(JSON_PROPERTY_HAS_DINNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasDinner(Boolean hasDinner) {
    this.hasDinner = hasDinner;
  }


  public BookingSupplier hasAllInclusive(Boolean hasAllInclusive) {
    
    this.hasAllInclusive = hasAllInclusive;
    return this;
  }

   /**
   * Convenience data point to get to all-inclusive quickly.
   * @return hasAllInclusive
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAllInclusive() {
    return hasAllInclusive;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAllInclusive(Boolean hasAllInclusive) {
    this.hasAllInclusive = hasAllInclusive;
  }


  public BookingSupplier hasAllInclusivePlusAlcohol(Boolean hasAllInclusivePlusAlcohol) {
    
    this.hasAllInclusivePlusAlcohol = hasAllInclusivePlusAlcohol;
    return this;
  }

   /**
   * Convenience data point to get to all-inclusive with alcohol quickly.
   * @return hasAllInclusivePlusAlcohol
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasAllInclusivePlusAlcohol() {
    return hasAllInclusivePlusAlcohol;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasAllInclusivePlusAlcohol(Boolean hasAllInclusivePlusAlcohol) {
    this.hasAllInclusivePlusAlcohol = hasAllInclusivePlusAlcohol;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingSupplier bookingSupplier = (BookingSupplier) o;
    return Objects.equals(this.creation, bookingSupplier.creation) &&
        Objects.equals(this.date, bookingSupplier.date) &&
        Objects.equals(this.groupIdentifier, bookingSupplier.groupIdentifier) &&
        Objects.equals(this.identifier, bookingSupplier.identifier) &&
        Objects.equals(this.engineConfiguration, bookingSupplier.engineConfiguration) &&
        Objects.equals(this.bookingCode, bookingSupplier.bookingCode) &&
        Objects.equals(this.user, bookingSupplier.user) &&
        Objects.equals(this.userSession, bookingSupplier.userSession) &&
        Objects.equals(this.serverUrl, bookingSupplier.serverUrl) &&
        Objects.equals(this.contactInfo, bookingSupplier.contactInfo) &&
        Objects.equals(this.address, bookingSupplier.address) &&
        Objects.equals(this.socials, bookingSupplier.socials) &&
        Objects.equals(this.review, bookingSupplier.review) &&
        Objects.equals(this.emailHeaderLogoUrl, bookingSupplier.emailHeaderLogoUrl) &&
        Objects.equals(this.logoIdentifier, bookingSupplier.logoIdentifier) &&
        Objects.equals(this.hotel, bookingSupplier.hotel) &&
        Objects.equals(this.roomStay, bookingSupplier.roomStay) &&
        Objects.equals(this.specialRequests, bookingSupplier.specialRequests) &&
        Objects.equals(this.comment, bookingSupplier.comment) &&
        Objects.equals(this.earlyCheckInCharge, bookingSupplier.earlyCheckInCharge) &&
        Objects.equals(this.lateCheckOutCharge, bookingSupplier.lateCheckOutCharge) &&
        Objects.equals(this.earlyCheckInChargePercent, bookingSupplier.earlyCheckInChargePercent) &&
        Objects.equals(this.lateCheckOutChargePercent, bookingSupplier.lateCheckOutChargePercent) &&
        Objects.equals(this.hotelImageUrl, bookingSupplier.hotelImageUrl) &&
        Objects.equals(this.roomImageUrl, bookingSupplier.roomImageUrl) &&
        Objects.equals(this.commissionList, bookingSupplier.commissionList) &&
        Objects.equals(this.ancillaryList, bookingSupplier.ancillaryList) &&
        Objects.equals(this.bookingContract, bookingSupplier.bookingContract) &&
        Objects.equals(this.staticMapImageUrl, bookingSupplier.staticMapImageUrl) &&
        Objects.equals(this.staticMapUrl, bookingSupplier.staticMapUrl) &&
        Objects.equals(this.status, bookingSupplier.status) &&
        Objects.equals(this.restaurants, bookingSupplier.restaurants) &&
        Objects.equals(this.cancellableBySupplier, bookingSupplier.cancellableBySupplier) &&
        Objects.equals(this.spas, bookingSupplier.spas) &&
        Objects.equals(this.meetingRooms, bookingSupplier.meetingRooms) &&
        Objects.equals(this.activities, bookingSupplier.activities) &&
        Objects.equals(this.attractions, bookingSupplier.attractions) &&
        Objects.equals(this.places, bookingSupplier.places) &&
        Objects.equals(this.roomTypeAncillaries, bookingSupplier.roomTypeAncillaries) &&
        Objects.equals(this.addOns, bookingSupplier.addOns) &&
        Objects.equals(this.fullAddress, bookingSupplier.fullAddress) &&
        Objects.equals(this.cancellableByAgent, bookingSupplier.cancellableByAgent) &&
        Objects.equals(this.cancellableByTraveler, bookingSupplier.cancellableByTraveler) &&
        Objects.equals(this.rateSource, bookingSupplier.rateSource) &&
        Objects.equals(this.hasAddOns, bookingSupplier.hasAddOns) &&
        Objects.equals(this.hasRoomTypeAncillaries, bookingSupplier.hasRoomTypeAncillaries) &&
        Objects.equals(this.hasFood, bookingSupplier.hasFood) &&
        Objects.equals(this.hasRestaurants, bookingSupplier.hasRestaurants) &&
        Objects.equals(this.hasMeetingRooms, bookingSupplier.hasMeetingRooms) &&
        Objects.equals(this.hasSpas, bookingSupplier.hasSpas) &&
        Objects.equals(this.hasActivities, bookingSupplier.hasActivities) &&
        Objects.equals(this.hasAttractions, bookingSupplier.hasAttractions) &&
        Objects.equals(this.hasPlaces, bookingSupplier.hasPlaces) &&
        Objects.equals(this.reportingDailyRateList, bookingSupplier.reportingDailyRateList) &&
        Objects.equals(this.reportingAncillaryList, bookingSupplier.reportingAncillaryList) &&
        Objects.equals(this.reportingExtraChargeList, bookingSupplier.reportingExtraChargeList) &&
        Objects.equals(this.hasBreakfast, bookingSupplier.hasBreakfast) &&
        Objects.equals(this.hasBrunch, bookingSupplier.hasBrunch) &&
        Objects.equals(this.hasLunch, bookingSupplier.hasLunch) &&
        Objects.equals(this.hasDinner, bookingSupplier.hasDinner) &&
        Objects.equals(this.hasAllInclusive, bookingSupplier.hasAllInclusive) &&
        Objects.equals(this.hasAllInclusivePlusAlcohol, bookingSupplier.hasAllInclusivePlusAlcohol);
  }

  @Override
  public int hashCode() {
    return Objects.hash(creation, date, groupIdentifier, identifier, engineConfiguration, bookingCode, user, userSession, serverUrl, contactInfo, address, socials, review, emailHeaderLogoUrl, logoIdentifier, hotel, roomStay, specialRequests, comment, earlyCheckInCharge, lateCheckOutCharge, earlyCheckInChargePercent, lateCheckOutChargePercent, hotelImageUrl, roomImageUrl, commissionList, ancillaryList, bookingContract, staticMapImageUrl, staticMapUrl, status, restaurants, cancellableBySupplier, spas, meetingRooms, activities, attractions, places, roomTypeAncillaries, addOns, fullAddress, cancellableByAgent, cancellableByTraveler, rateSource, hasAddOns, hasRoomTypeAncillaries, hasFood, hasRestaurants, hasMeetingRooms, hasSpas, hasActivities, hasAttractions, hasPlaces, reportingDailyRateList, reportingAncillaryList, reportingExtraChargeList, hasBreakfast, hasBrunch, hasLunch, hasDinner, hasAllInclusive, hasAllInclusivePlusAlcohol);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingSupplier {\n");
    sb.append("    creation: ").append(toIndentedString(creation)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    groupIdentifier: ").append(toIndentedString(groupIdentifier)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    engineConfiguration: ").append(toIndentedString(engineConfiguration)).append("\n");
    sb.append("    bookingCode: ").append(toIndentedString(bookingCode)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    userSession: ").append(toIndentedString(userSession)).append("\n");
    sb.append("    serverUrl: ").append(toIndentedString(serverUrl)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    review: ").append(toIndentedString(review)).append("\n");
    sb.append("    emailHeaderLogoUrl: ").append(toIndentedString(emailHeaderLogoUrl)).append("\n");
    sb.append("    logoIdentifier: ").append(toIndentedString(logoIdentifier)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    roomStay: ").append(toIndentedString(roomStay)).append("\n");
    sb.append("    specialRequests: ").append(toIndentedString(specialRequests)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    earlyCheckInCharge: ").append(toIndentedString(earlyCheckInCharge)).append("\n");
    sb.append("    lateCheckOutCharge: ").append(toIndentedString(lateCheckOutCharge)).append("\n");
    sb.append("    earlyCheckInChargePercent: ").append(toIndentedString(earlyCheckInChargePercent)).append("\n");
    sb.append("    lateCheckOutChargePercent: ").append(toIndentedString(lateCheckOutChargePercent)).append("\n");
    sb.append("    hotelImageUrl: ").append(toIndentedString(hotelImageUrl)).append("\n");
    sb.append("    roomImageUrl: ").append(toIndentedString(roomImageUrl)).append("\n");
    sb.append("    commissionList: ").append(toIndentedString(commissionList)).append("\n");
    sb.append("    ancillaryList: ").append(toIndentedString(ancillaryList)).append("\n");
    sb.append("    bookingContract: ").append(toIndentedString(bookingContract)).append("\n");
    sb.append("    staticMapImageUrl: ").append(toIndentedString(staticMapImageUrl)).append("\n");
    sb.append("    staticMapUrl: ").append(toIndentedString(staticMapUrl)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    restaurants: ").append(toIndentedString(restaurants)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    spas: ").append(toIndentedString(spas)).append("\n");
    sb.append("    meetingRooms: ").append(toIndentedString(meetingRooms)).append("\n");
    sb.append("    activities: ").append(toIndentedString(activities)).append("\n");
    sb.append("    attractions: ").append(toIndentedString(attractions)).append("\n");
    sb.append("    places: ").append(toIndentedString(places)).append("\n");
    sb.append("    roomTypeAncillaries: ").append(toIndentedString(roomTypeAncillaries)).append("\n");
    sb.append("    addOns: ").append(toIndentedString(addOns)).append("\n");
    sb.append("    fullAddress: ").append(toIndentedString(fullAddress)).append("\n");
    sb.append("    cancellableByAgent: ").append(toIndentedString(cancellableByAgent)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    hasAddOns: ").append(toIndentedString(hasAddOns)).append("\n");
    sb.append("    hasRoomTypeAncillaries: ").append(toIndentedString(hasRoomTypeAncillaries)).append("\n");
    sb.append("    hasFood: ").append(toIndentedString(hasFood)).append("\n");
    sb.append("    hasRestaurants: ").append(toIndentedString(hasRestaurants)).append("\n");
    sb.append("    hasMeetingRooms: ").append(toIndentedString(hasMeetingRooms)).append("\n");
    sb.append("    hasSpas: ").append(toIndentedString(hasSpas)).append("\n");
    sb.append("    hasActivities: ").append(toIndentedString(hasActivities)).append("\n");
    sb.append("    hasAttractions: ").append(toIndentedString(hasAttractions)).append("\n");
    sb.append("    hasPlaces: ").append(toIndentedString(hasPlaces)).append("\n");
    sb.append("    reportingDailyRateList: ").append(toIndentedString(reportingDailyRateList)).append("\n");
    sb.append("    reportingAncillaryList: ").append(toIndentedString(reportingAncillaryList)).append("\n");
    sb.append("    reportingExtraChargeList: ").append(toIndentedString(reportingExtraChargeList)).append("\n");
    sb.append("    hasBreakfast: ").append(toIndentedString(hasBreakfast)).append("\n");
    sb.append("    hasBrunch: ").append(toIndentedString(hasBrunch)).append("\n");
    sb.append("    hasLunch: ").append(toIndentedString(hasLunch)).append("\n");
    sb.append("    hasDinner: ").append(toIndentedString(hasDinner)).append("\n");
    sb.append("    hasAllInclusive: ").append(toIndentedString(hasAllInclusive)).append("\n");
    sb.append("    hasAllInclusivePlusAlcohol: ").append(toIndentedString(hasAllInclusivePlusAlcohol)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

