/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Extranet Booking API The Booking API exposes endpoints to manage bookings. This API lets you:  1. Booking: Manage bookings including cancellations. 2. Review: Manage user reviews. 3. Sync w. Calendar: Manage calendar sync with your favorite calendar software  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.5.13
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Choose how you want our web components to look and more closely match with your own site style.
 */
@JsonPropertyOrder({
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_PRIMARY,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_SECONDARY,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_SUCCESS,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_DANGER,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_WARNING,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_INFO,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_LIGHT,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_DARK,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_BODY,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_MUTED,
  EngineConfigurationThemeSupplierDetails.JSON_PROPERTY_WHITE
})
@JsonTypeName("EngineConfigurationTheme_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T20:22:08.343418683+07:00[Asia/Bangkok]")
public class EngineConfigurationThemeSupplierDetails {
  public static final String JSON_PROPERTY_PRIMARY = "primary";
  private String primary = "#dc3545";

  public static final String JSON_PROPERTY_SECONDARY = "secondary";
  private String secondary = "#6c757d";

  public static final String JSON_PROPERTY_SUCCESS = "success";
  private String success = "#28a745";

  public static final String JSON_PROPERTY_DANGER = "danger";
  private String danger = "#dc3545";

  public static final String JSON_PROPERTY_WARNING = "warning";
  private String warning = "#ffc107";

  public static final String JSON_PROPERTY_INFO = "info";
  private String info = "#17a2b8";

  public static final String JSON_PROPERTY_LIGHT = "light";
  private String light = "#f8f9fa";

  public static final String JSON_PROPERTY_DARK = "dark";
  private String dark = "#343a40";

  public static final String JSON_PROPERTY_BODY = "body";
  private String body = "#212529";

  public static final String JSON_PROPERTY_MUTED = "muted";
  private String muted = "#6c757d";

  public static final String JSON_PROPERTY_WHITE = "white";
  private String white = "#ffffff";

  public EngineConfigurationThemeSupplierDetails() {
  }

  public EngineConfigurationThemeSupplierDetails primary(String primary) {
    
    this.primary = primary;
    return this;
  }

   /**
   * Primary color
   * @return primary
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrimary() {
    return primary;
  }


  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrimary(String primary) {
    this.primary = primary;
  }


  public EngineConfigurationThemeSupplierDetails secondary(String secondary) {
    
    this.secondary = secondary;
    return this;
  }

   /**
   * Secondary color
   * @return secondary
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECONDARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSecondary() {
    return secondary;
  }


  @JsonProperty(JSON_PROPERTY_SECONDARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecondary(String secondary) {
    this.secondary = secondary;
  }


  public EngineConfigurationThemeSupplierDetails success(String success) {
    
    this.success = success;
    return this;
  }

   /**
   * Success color
   * @return success
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSuccess() {
    return success;
  }


  @JsonProperty(JSON_PROPERTY_SUCCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSuccess(String success) {
    this.success = success;
  }


  public EngineConfigurationThemeSupplierDetails danger(String danger) {
    
    this.danger = danger;
    return this;
  }

   /**
   * Danger color
   * @return danger
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DANGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDanger() {
    return danger;
  }


  @JsonProperty(JSON_PROPERTY_DANGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDanger(String danger) {
    this.danger = danger;
  }


  public EngineConfigurationThemeSupplierDetails warning(String warning) {
    
    this.warning = warning;
    return this;
  }

   /**
   * Warning color
   * @return warning
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WARNING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWarning() {
    return warning;
  }


  @JsonProperty(JSON_PROPERTY_WARNING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWarning(String warning) {
    this.warning = warning;
  }


  public EngineConfigurationThemeSupplierDetails info(String info) {
    
    this.info = info;
    return this;
  }

   /**
   * Info color
   * @return info
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInfo() {
    return info;
  }


  @JsonProperty(JSON_PROPERTY_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInfo(String info) {
    this.info = info;
  }


  public EngineConfigurationThemeSupplierDetails light(String light) {
    
    this.light = light;
    return this;
  }

   /**
   * Light color
   * @return light
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLight() {
    return light;
  }


  @JsonProperty(JSON_PROPERTY_LIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLight(String light) {
    this.light = light;
  }


  public EngineConfigurationThemeSupplierDetails dark(String dark) {
    
    this.dark = dark;
    return this;
  }

   /**
   * Dark color
   * @return dark
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDark() {
    return dark;
  }


  @JsonProperty(JSON_PROPERTY_DARK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDark(String dark) {
    this.dark = dark;
  }


  public EngineConfigurationThemeSupplierDetails body(String body) {
    
    this.body = body;
    return this;
  }

   /**
   * Body color
   * @return body
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBody() {
    return body;
  }


  @JsonProperty(JSON_PROPERTY_BODY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBody(String body) {
    this.body = body;
  }


  public EngineConfigurationThemeSupplierDetails muted(String muted) {
    
    this.muted = muted;
    return this;
  }

   /**
   * Muted color
   * @return muted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MUTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMuted() {
    return muted;
  }


  @JsonProperty(JSON_PROPERTY_MUTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMuted(String muted) {
    this.muted = muted;
  }


  public EngineConfigurationThemeSupplierDetails white(String white) {
    
    this.white = white;
    return this;
  }

   /**
   * White color
   * @return white
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WHITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhite() {
    return white;
  }


  @JsonProperty(JSON_PROPERTY_WHITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhite(String white) {
    this.white = white;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EngineConfigurationThemeSupplierDetails engineConfigurationThemeSupplierDetails = (EngineConfigurationThemeSupplierDetails) o;
    return Objects.equals(this.primary, engineConfigurationThemeSupplierDetails.primary) &&
        Objects.equals(this.secondary, engineConfigurationThemeSupplierDetails.secondary) &&
        Objects.equals(this.success, engineConfigurationThemeSupplierDetails.success) &&
        Objects.equals(this.danger, engineConfigurationThemeSupplierDetails.danger) &&
        Objects.equals(this.warning, engineConfigurationThemeSupplierDetails.warning) &&
        Objects.equals(this.info, engineConfigurationThemeSupplierDetails.info) &&
        Objects.equals(this.light, engineConfigurationThemeSupplierDetails.light) &&
        Objects.equals(this.dark, engineConfigurationThemeSupplierDetails.dark) &&
        Objects.equals(this.body, engineConfigurationThemeSupplierDetails.body) &&
        Objects.equals(this.muted, engineConfigurationThemeSupplierDetails.muted) &&
        Objects.equals(this.white, engineConfigurationThemeSupplierDetails.white);
  }

  @Override
  public int hashCode() {
    return Objects.hash(primary, secondary, success, danger, warning, info, light, dark, body, muted, white);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EngineConfigurationThemeSupplierDetails {\n");
    sb.append("    primary: ").append(toIndentedString(primary)).append("\n");
    sb.append("    secondary: ").append(toIndentedString(secondary)).append("\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    danger: ").append(toIndentedString(danger)).append("\n");
    sb.append("    warning: ").append(toIndentedString(warning)).append("\n");
    sb.append("    info: ").append(toIndentedString(info)).append("\n");
    sb.append("    light: ").append(toIndentedString(light)).append("\n");
    sb.append("    dark: ").append(toIndentedString(dark)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    muted: ").append(toIndentedString(muted)).append("\n");
    sb.append("    white: ").append(toIndentedString(white)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

