package travel.wink.sdk.extranet.booking.api;

import travel.wink.sdk.extranet.booking.invoker.ApiClient;

import travel.wink.sdk.extranet.booking.model.BookingAnalyticsSupplier;
import travel.wink.sdk.extranet.booking.model.BookingCancellableSupplier;
import travel.wink.sdk.extranet.booking.model.BookingOverviewRequestSupplier;
import travel.wink.sdk.extranet.booking.model.BookingViewSupplier;
import travel.wink.sdk.extranet.booking.model.BookingViewSupplierDetails;
import travel.wink.sdk.extranet.booking.model.BooleanResponseSupplier;
import travel.wink.sdk.extranet.booking.model.CancellationDetailSupplier;
import travel.wink.sdk.extranet.booking.model.GenericErrorMessage;
import travel.wink.sdk.extranet.booking.model.GroupedBookingSalesMetricsSupplierDetails;
import travel.wink.sdk.extranet.booking.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.booking.model.PageBookingViewSupplier;
import travel.wink.sdk.extranet.booking.model.PropertyBookingRefundRequestSupplier;
import travel.wink.sdk.extranet.booking.model.ShowReview400Response;
import travel.wink.sdk.extranet.booking.model.StateSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-02T16:43:04.282539165+07:00[Asia/Bangkok]")
public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Cancel Booking
     * Booking is cancelled by the property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param cancellationDetailSupplier The cancellationDetailSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec cancelHotelBookingRequestCreation(String propertyIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = cancellationDetailSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationDetailSupplier' is set
        if (cancellationDetailSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailSupplier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}/cancel", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Cancel Booking
     * Booking is cancelled by the property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param cancellationDetailSupplier The cancellationDetailSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewSupplier> cancelHotelBooking(String propertyIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return cancelHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Cancel Booking
     * Booking is cancelled by the property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param cancellationDetailSupplier The cancellationDetailSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewSupplier>> cancelHotelBookingWithHttpInfo(String propertyIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return cancelHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Cancel Booking
     * Booking is cancelled by the property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param cancellationDetailSupplier The cancellationDetailSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec cancelHotelBookingWithResponseSpec(String propertyIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        return cancelHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion);
    }
    /**
     * Is Booking Cancellable
     * Checks to see whether this booking (or group booking) can be cancelled by either the traveler or the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Check if booking can be cancelled for hotel with this identifier
     * @param bookingIdentifier Check if booking can be cancelled with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingCancellableSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isBookingCancellableRequestCreation(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling isBookingCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling isBookingCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}/cancellable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Is Booking Cancellable
     * Checks to see whether this booking (or group booking) can be cancelled by either the traveler or the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Check if booking can be cancelled for hotel with this identifier
     * @param bookingIdentifier Check if booking can be cancelled with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingCancellableSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingCancellableSupplier> isBookingCancellable(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>() {};
        return isBookingCancellableRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Is Booking Cancellable
     * Checks to see whether this booking (or group booking) can be cancelled by either the traveler or the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Check if booking can be cancelled for hotel with this identifier
     * @param bookingIdentifier Check if booking can be cancelled with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BookingCancellableSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingCancellableSupplier>> isBookingCancellableWithHttpInfo(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>() {};
        return isBookingCancellableRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Is Booking Cancellable
     * Checks to see whether this booking (or group booking) can be cancelled by either the traveler or the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Check if booking can be cancelled for hotel with this identifier
     * @param bookingIdentifier Check if booking can be cancelled with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isBookingCancellableWithResponseSpec(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return isBookingCancellableRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept);
    }
    /**
     * Request refund
     * Under certain circumstances, a property can request a partial refund of the funds that were attributed to them even after a cancellation occurred or the while the funds have not been disbursed yet.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param propertyBookingRefundRequestSupplier The propertyBookingRefundRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec requestRefundRequestCreation(String propertyIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = propertyBookingRefundRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyBookingRefundRequestSupplier' is set
        if (propertyBookingRefundRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyBookingRefundRequestSupplier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}/request-refund", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Request refund
     * Under certain circumstances, a property can request a partial refund of the funds that were attributed to them even after a cancellation occurred or the while the funds have not been disbursed yet.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param propertyBookingRefundRequestSupplier The propertyBookingRefundRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewSupplier> requestRefund(String propertyIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return requestRefundRequestCreation(propertyIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Request refund
     * Under certain circumstances, a property can request a partial refund of the funds that were attributed to them even after a cancellation occurred or the while the funds have not been disbursed yet.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param propertyBookingRefundRequestSupplier The propertyBookingRefundRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewSupplier>> requestRefundWithHttpInfo(String propertyIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>() {};
        return requestRefundRequestCreation(propertyIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Request refund
     * Under certain circumstances, a property can request a partial refund of the funds that were attributed to them even after a cancellation occurred or the while the funds have not been disbursed yet.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Cancel booking for hotel with this identifier
     * @param bookingIdentifier Cancel booking with this identifier
     * @param propertyBookingRefundRequestSupplier The propertyBookingRefundRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec requestRefundWithResponseSpec(String propertyIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        return requestRefundRequestCreation(propertyIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion);
    }
    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Booking owner
     * @param bookingIdentifier Booking identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec resendBookingConfirmationEmailRequestCreation(String propertyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        Object postBody = body;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}/resend", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Booking owner
     * @param bookingIdentifier Booking identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseSupplier> resendBookingConfirmationEmail(String propertyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>() {};
        return resendBookingConfirmationEmailRequestCreation(propertyIdentifier, bookingIdentifier, body, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Booking owner
     * @param bookingIdentifier Booking identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BooleanResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BooleanResponseSupplier>> resendBookingConfirmationEmailWithHttpInfo(String propertyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>() {};
        return resendBookingConfirmationEmailRequestCreation(propertyIdentifier, bookingIdentifier, body, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Resend Booking Confirmation
     * Resends booking confirmation email to traveler.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Booking owner
     * @param bookingIdentifier Booking identifier
     * @param body Empty request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec resendBookingConfirmationEmailWithResponseSpec(String propertyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        return resendBookingConfirmationEmailRequestCreation(propertyIdentifier, bookingIdentifier, body, winkVersion);
    }
    /**
     * Show Active Affiliates
     * Return a geo-name list of unique affiliates that have brought the property bookings. This is helpful data you can use to filter on within your dataset.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show active affiliates for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showActiveAffiliatesRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showActiveAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/owner/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Active Affiliates
     * Return a geo-name list of unique affiliates that have brought the property bookings. This is helpful data you can use to filter on within your dataset.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show active affiliates for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairSupplier> showActiveAffiliates(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showActiveAffiliatesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Active Affiliates
     * Return a geo-name list of unique affiliates that have brought the property bookings. This is helpful data you can use to filter on within your dataset.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show active affiliates for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showActiveAffiliatesWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showActiveAffiliatesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Active Affiliates
     * Return a geo-name list of unique affiliates that have brought the property bookings. This is helpful data you can use to filter on within your dataset.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show active affiliates for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showActiveAffiliatesWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showActiveAffiliatesRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Show Active Master Rates
     * Return a geoname list of unique master rates that have been booked. This is helpful data you can use to filter on within your dataset.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booked master rates for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showActiveMasterRatesRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showActiveMasterRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/roomrate/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Active Master Rates
     * Return a geoname list of unique master rates that have been booked. This is helpful data you can use to filter on within your dataset.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booked master rates for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairSupplier> showActiveMasterRates(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showActiveMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Active Master Rates
     * Return a geoname list of unique master rates that have been booked. This is helpful data you can use to filter on within your dataset.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booked master rates for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showActiveMasterRatesWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showActiveMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Active Master Rates
     * Return a geoname list of unique master rates that have been booked. This is helpful data you can use to filter on within your dataset.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booked master rates for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showActiveMasterRatesWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showActiveMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Property Booking Analytics
     * Basic booking analytics data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show active booking count for hotel with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return BookingAnalyticsSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingAnalyticsRequestCreation(String propertyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = bookingOverviewRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingOverviewRequestSupplier' is set
        if (bookingOverviewRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingOverviewRequestSupplier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/analytics", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Property Booking Analytics
     * Basic booking analytics data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show active booking count for hotel with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return BookingAnalyticsSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingAnalyticsSupplier> showBookingAnalytics(String propertyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>() {};
        return showBookingAnalyticsRequestCreation(propertyIdentifier, bookingOverviewRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Property Booking Analytics
     * Basic booking analytics data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show active booking count for hotel with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingAnalyticsSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingAnalyticsSupplier>> showBookingAnalyticsWithHttpInfo(String propertyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>() {};
        return showBookingAnalyticsRequestCreation(propertyIdentifier, bookingOverviewRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Property Booking Analytics
     * Basic booking analytics data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show active booking count for hotel with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingAnalyticsWithResponseSpec(String propertyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        return showBookingAnalyticsRequestCreation(propertyIdentifier, bookingOverviewRequestSupplier, winkVersion);
    }
    /**
     * Property Booking Overview
     * Basic booking overview data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booking owned by this hotel
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return GroupedBookingSalesMetricsSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingOverviewRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showBookingOverview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/overview", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Property Booking Overview
     * Basic booking overview data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booking owned by this hotel
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return GroupedBookingSalesMetricsSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GroupedBookingSalesMetricsSupplierDetails> showBookingOverview(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>() {};
        return showBookingOverviewRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Property Booking Overview
     * Basic booking overview data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booking owned by this hotel
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;GroupedBookingSalesMetricsSupplierDetails&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GroupedBookingSalesMetricsSupplierDetails>> showBookingOverviewWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>() {};
        return showBookingOverviewRequestCreation(propertyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Property Booking Overview
     * Basic booking overview data
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booking owned by this hotel
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingOverviewWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showBookingOverviewRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Show Booking
     * Retrieve a single booking specific by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booking owned by this hotel
     * @param bookingIdentifier Show booking with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingViewSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelBookingRequestCreation(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingIdentifier' is set
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieve a single booking specific by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booking owned by this hotel
     * @param bookingIdentifier Show booking with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return BookingViewSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewSupplierDetails> showHotelBooking(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>() {};
        return showHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieve a single booking specific by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booking owned by this hotel
     * @param bookingIdentifier Show booking with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;BookingViewSupplierDetails&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewSupplierDetails>> showHotelBookingWithHttpInfo(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>() {};
        return showHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Booking
     * Retrieve a single booking specific by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show booking owned by this hotel
     * @param bookingIdentifier Show booking with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showHotelBookingWithResponseSpec(String propertyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showHotelBookingRequestCreation(propertyIdentifier, bookingIdentifier, winkVersion, accept);
    }
    /**
     * Search Bookings
     * Retrieve page of bookings for a specific hotel with advanced filtering rules.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show bookings for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelBookingsRequestCreation(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = stateSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'stateSupplier' is set
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showHotelBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Bookings
     * Retrieve page of bookings for a specific hotel with advanced filtering rules.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show bookings for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PageBookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingViewSupplier> showHotelBookings(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return showHotelBookingsRequestCreation(propertyIdentifier, stateSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Search Bookings
     * Retrieve page of bookings for a specific hotel with advanced filtering rules.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show bookings for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageBookingViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingViewSupplier>> showHotelBookingsWithHttpInfo(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return showHotelBookingsRequestCreation(propertyIdentifier, stateSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Search Bookings
     * Retrieve page of bookings for a specific hotel with advanced filtering rules.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show bookings for hotel with this identifier
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showHotelBookingsWithResponseSpec(String propertyIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return showHotelBookingsRequestCreation(propertyIdentifier, stateSupplier, winkVersion);
    }
    /**
     * Show Bookings
     * Retrieve bookings for hotel with simple filter rules.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show bookings for hotel with this identifier
     * @param state Filter on the booking state
     * @param pageNumber Paginate booking list
     * @param maxResults Limit number of records to return
     * @param search Filter on email, first or last name to further narrow down the result set
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageBookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelBookings1RequestCreation(String propertyIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelBookings1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "pageNumber", pageNumber));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "maxResults", maxResults));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "search", search));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/booking/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Bookings
     * Retrieve bookings for hotel with simple filter rules.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show bookings for hotel with this identifier
     * @param state Filter on the booking state
     * @param pageNumber Paginate booking list
     * @param maxResults Limit number of records to return
     * @param search Filter on email, first or last name to further narrow down the result set
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageBookingViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageBookingViewSupplier> showHotelBookings1(String propertyIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return showHotelBookings1RequestCreation(propertyIdentifier, state, pageNumber, maxResults, search, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Bookings
     * Retrieve bookings for hotel with simple filter rules.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show bookings for hotel with this identifier
     * @param state Filter on the booking state
     * @param pageNumber Paginate booking list
     * @param maxResults Limit number of records to return
     * @param search Filter on email, first or last name to further narrow down the result set
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageBookingViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageBookingViewSupplier>> showHotelBookings1WithHttpInfo(String propertyIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>() {};
        return showHotelBookings1RequestCreation(propertyIdentifier, state, pageNumber, maxResults, search, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Bookings
     * Retrieve bookings for hotel with simple filter rules.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show bookings for hotel with this identifier
     * @param state Filter on the booking state
     * @param pageNumber Paginate booking list
     * @param maxResults Limit number of records to return
     * @param search Filter on email, first or last name to further narrow down the result set
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showHotelBookings1WithResponseSpec(String propertyIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion, String accept) throws WebClientResponseException {
        return showHotelBookings1RequestCreation(propertyIdentifier, state, pageNumber, maxResults, search, winkVersion, accept);
    }
}
