/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.extranet.booking.model.ItinerarySupplierDetails;

@JsonPropertyOrder(value={"itinerary", "language", "currency", "promotionalCodes", "selectedRoomConfigurationIndex", "lifestyle"})
@JsonTypeName(value="UserSession_SupplierDetails")
public class UserSessionSupplierDetails {
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    private ItinerarySupplierDetails itinerary;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes;
    public static final String JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION_INDEX = "selectedRoomConfigurationIndex";
    private Integer selectedRoomConfigurationIndex;
    public static final String JSON_PROPERTY_LIFESTYLE = "lifestyle";
    private LifestyleEnum lifestyle;

    public UserSessionSupplierDetails itinerary(ItinerarySupplierDetails itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ItinerarySupplierDetails getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(ItinerarySupplierDetails itinerary) {
        this.itinerary = itinerary;
    }

    public UserSessionSupplierDetails language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public UserSessionSupplierDetails currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public UserSessionSupplierDetails promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public UserSessionSupplierDetails addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public UserSessionSupplierDetails selectedRoomConfigurationIndex(Integer selectedRoomConfigurationIndex) {
        this.selectedRoomConfigurationIndex = selectedRoomConfigurationIndex;
        return this;
    }

    @Nullable
    @JsonProperty(value="selectedRoomConfigurationIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSelectedRoomConfigurationIndex() {
        return this.selectedRoomConfigurationIndex;
    }

    @JsonProperty(value="selectedRoomConfigurationIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRoomConfigurationIndex(Integer selectedRoomConfigurationIndex) {
        this.selectedRoomConfigurationIndex = selectedRoomConfigurationIndex;
    }

    public UserSessionSupplierDetails lifestyle(LifestyleEnum lifestyle) {
        this.lifestyle = lifestyle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleEnum getLifestyle() {
        return this.lifestyle;
    }

    @JsonProperty(value="lifestyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyle(LifestyleEnum lifestyle) {
        this.lifestyle = lifestyle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSessionSupplierDetails userSessionSupplierDetails = (UserSessionSupplierDetails)o;
        return Objects.equals(this.itinerary, userSessionSupplierDetails.itinerary) && Objects.equals(this.language, userSessionSupplierDetails.language) && Objects.equals(this.currency, userSessionSupplierDetails.currency) && Objects.equals(this.promotionalCodes, userSessionSupplierDetails.promotionalCodes) && Objects.equals(this.selectedRoomConfigurationIndex, userSessionSupplierDetails.selectedRoomConfigurationIndex) && Objects.equals((Object)this.lifestyle, (Object)userSessionSupplierDetails.lifestyle);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.itinerary, this.language, this.currency, this.promotionalCodes, this.selectedRoomConfigurationIndex, this.lifestyle});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSessionSupplierDetails {\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    selectedRoomConfigurationIndex: ").append(this.toIndentedString(this.selectedRoomConfigurationIndex)).append("\n");
        sb.append("    lifestyle: ").append(this.toIndentedString((Object)this.lifestyle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LifestyleEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleEnum fromValue(String value) {
            for (LifestyleEnum b : LifestyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

