/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Extranet Booking API The Booking API exposes endpoints to manage bookings. This API lets you:  1. Booking: Manage bookings including cancellations. 2. Review: Manage user reviews. 3. Sync w. Calendar: Manage calendar sync with your favorite calendar software  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.13.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.booking.model.ChartCategoryAxisSupplier;
import travel.wink.sdk.extranet.booking.model.ChartLegendSupplier;
import travel.wink.sdk.extranet.booking.model.ChartSeriesSupplier;
import travel.wink.sdk.extranet.booking.model.ChartTitleSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Interesting property-level chart data overview
 */
@JsonPropertyOrder({
  LineChartSupplier.JSON_PROPERTY_IDENTIFIER,
  LineChartSupplier.JSON_PROPERTY_TITLE,
  LineChartSupplier.JSON_PROPERTY_LEGEND,
  LineChartSupplier.JSON_PROPERTY_SERIES,
  LineChartSupplier.JSON_PROPERTY_X_AXIS,
  LineChartSupplier.JSON_PROPERTY_XAXIS
})
@JsonTypeName("LineChart_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-05T14:53:48.168993328+07:00[Asia/Bangkok]")
public class LineChartSupplier {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_TITLE = "title";
  private ChartTitleSupplier title;

  public static final String JSON_PROPERTY_LEGEND = "legend";
  private ChartLegendSupplier legend;

  public static final String JSON_PROPERTY_SERIES = "series";
  private List<ChartSeriesSupplier> series;

  public static final String JSON_PROPERTY_X_AXIS = "xAxis";
  private ChartCategoryAxisSupplier xAxis;

  public static final String JSON_PROPERTY_XAXIS = "xaxis";
  private ChartCategoryAxisSupplier xaxis;

  public LineChartSupplier() {
  }

  public LineChartSupplier identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique line chart identifier
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public LineChartSupplier title(ChartTitleSupplier title) {
    
    this.title = title;
    return this;
  }

   /**
   * Get title
   * @return title
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartTitleSupplier getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(ChartTitleSupplier title) {
    this.title = title;
  }


  public LineChartSupplier legend(ChartLegendSupplier legend) {
    
    this.legend = legend;
    return this;
  }

   /**
   * Get legend
   * @return legend
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LEGEND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartLegendSupplier getLegend() {
    return legend;
  }


  @JsonProperty(JSON_PROPERTY_LEGEND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegend(ChartLegendSupplier legend) {
    this.legend = legend;
  }


  public LineChartSupplier series(List<ChartSeriesSupplier> series) {
    
    this.series = series;
    return this;
  }

  public LineChartSupplier addSeriesItem(ChartSeriesSupplier seriesItem) {
    if (this.series == null) {
      this.series = new ArrayList<>();
    }
    this.series.add(seriesItem);
    return this;
  }

   /**
   * The configuration of the chart series. The series type is determined by the value of the type field. If a type value is missing, the chart renders the type that is specified in &#x60;seriesDefaults&#x60;. Some options accept functions as arguments. These arguments are evaluated for each point which is supplied as a parameter. If no value is returned, the chart uses the &#x60;theme&#x60; or &#x60;seriesDefaults&#x60; values.
   * @return series
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ChartSeriesSupplier> getSeries() {
    return series;
  }


  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeries(List<ChartSeriesSupplier> series) {
    this.series = series;
  }


  public LineChartSupplier xAxis(ChartCategoryAxisSupplier xAxis) {
    
    this.xAxis = xAxis;
    return this;
  }

   /**
   * Get xAxis
   * @return xAxis
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_X_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartCategoryAxisSupplier getxAxis() {
    return xAxis;
  }


  @JsonProperty(JSON_PROPERTY_X_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setxAxis(ChartCategoryAxisSupplier xAxis) {
    this.xAxis = xAxis;
  }


  public LineChartSupplier xaxis(ChartCategoryAxisSupplier xaxis) {
    
    this.xaxis = xaxis;
    return this;
  }

   /**
   * Get xaxis
   * @return xaxis
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_XAXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartCategoryAxisSupplier getXaxis() {
    return xaxis;
  }


  @JsonProperty(JSON_PROPERTY_XAXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setXaxis(ChartCategoryAxisSupplier xaxis) {
    this.xaxis = xaxis;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LineChartSupplier lineChartSupplier = (LineChartSupplier) o;
    return Objects.equals(this.identifier, lineChartSupplier.identifier) &&
        Objects.equals(this.title, lineChartSupplier.title) &&
        Objects.equals(this.legend, lineChartSupplier.legend) &&
        Objects.equals(this.series, lineChartSupplier.series) &&
        Objects.equals(this.xAxis, lineChartSupplier.xAxis) &&
        Objects.equals(this.xaxis, lineChartSupplier.xaxis);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, title, legend, series, xAxis, xaxis);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LineChartSupplier {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    legend: ").append(toIndentedString(legend)).append("\n");
    sb.append("    series: ").append(toIndentedString(series)).append("\n");
    sb.append("    xAxis: ").append(toIndentedString(xAxis)).append("\n");
    sb.append("    xaxis: ").append(toIndentedString(xaxis)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

