/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Extranet Booking API The Booking API exposes endpoints to manage bookings. This API lets you:  1. Booking: Manage bookings including cancellations. 2. Review: Manage user reviews. 3. Sync w. Calendar: Manage calendar sync with your favorite calendar software  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import travel.wink.sdk.extranet.booking.model.AuthenticatedUserSupplierDetails;
import travel.wink.sdk.extranet.booking.model.BeneficiarySupplierDetails;
import travel.wink.sdk.extranet.booking.model.BookingContractItemSupplierDetails;
import travel.wink.sdk.extranet.booking.model.BookingContractPaymentDetailsSupplierDetails;
import travel.wink.sdk.extranet.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.booking.model.PayoutSupplierDetails;
import travel.wink.sdk.extranet.booking.model.QuoteLightweightSupplierDetails;
import travel.wink.sdk.extranet.booking.model.RefundSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BookingContractSupplierDetails
 */
@JsonPropertyOrder({
  BookingContractSupplierDetails.JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_CREATED_DATE,
  BookingContractSupplierDetails.JSON_PROPERTY_LAST_UPDATE,
  BookingContractSupplierDetails.JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME,
  BookingContractSupplierDetails.JSON_PROPERTY_USER,
  BookingContractSupplierDetails.JSON_PROPERTY_IP_ADDRESS,
  BookingContractSupplierDetails.JSON_PROPERTY_TRACE_ID,
  BookingContractSupplierDetails.JSON_PROPERTY_SOURCE_URL,
  BookingContractSupplierDetails.JSON_PROPERTY_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_NAME,
  BookingContractSupplierDetails.JSON_PROPERTY_DISPLAY_PRICE_QUOTE,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_PRICE_QUOTE,
  BookingContractSupplierDetails.JSON_PROPERTY_INTERNAL_PRICE_QUOTE,
  BookingContractSupplierDetails.JSON_PROPERTY_CAPTURE_PRICE_QUOTE,
  BookingContractSupplierDetails.JSON_PROPERTY_ITEM_LIST,
  BookingContractSupplierDetails.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  BookingContractSupplierDetails.JSON_PROPERTY_PAYMENT,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLED,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLED_ON,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLER,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLATION_TYPE,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLER_USER_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCEL_REASON,
  BookingContractSupplierDetails.JSON_PROPERTY_FUNDS_PROCESSED,
  BookingContractSupplierDetails.JSON_PROPERTY_REFUNDS,
  BookingContractSupplierDetails.JSON_PROPERTY_PAYOUTS,
  BookingContractSupplierDetails.JSON_PROPERTY_SOURCE_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_DISPLAY_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_INTERNAL_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_CAPTURE_CURRENCY,
  BookingContractSupplierDetails.JSON_PROPERTY_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_METADATA,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_FUNDS_AVAILABLE_DATE,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_IN_PERCENT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT,
  BookingContractSupplierDetails.JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT,
  BookingContractSupplierDetails.JSON_PROPERTY_ORIGINAL_AFFILIATE_AGENCY_FEES_IN_PERCENT,
  BookingContractSupplierDetails.JSON_PROPERTY_ORIGINAL_SUPPLIER_AGENCY_FEES_IN_PERCENT,
  BookingContractSupplierDetails.JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT,
  BookingContractSupplierDetails.JSON_PROPERTY_HAS_REFUNDS,
  BookingContractSupplierDetails.JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS,
  BookingContractSupplierDetails.JSON_PROPERTY_HAS_PENDING_REFUNDS,
  BookingContractSupplierDetails.JSON_PROPERTY_HAS_FAILED_REFUNDS,
  BookingContractSupplierDetails.JSON_PROPERTY_PLATFORM_IDENTIFIER,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_FUNDS_GROUPED_BY_BENEFICIARY,
  BookingContractSupplierDetails.JSON_PROPERTY_TOTAL_TOKENS_EARNED,
  BookingContractSupplierDetails.JSON_PROPERTY_SELF_ACQUIRING,
  BookingContractSupplierDetails.JSON_PROPERTY_LODGING,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLABLE_BY_AGENT,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContractSupplierDetails.JSON_PROPERTY_FULLY_REFUNDED,
  BookingContractSupplierDetails.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractSupplierDetails.JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES
})
@JsonTypeName("BookingContract_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:17:36.846722567+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class BookingContractSupplierDetails {
  public static final String JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER = "bookingContractIdentifier";
  @jakarta.annotation.Nullable
  private UUID bookingContractIdentifier;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER = "federatedOrganizationIdentifier";
  @jakarta.annotation.Nonnull
  private String federatedOrganizationIdentifier;

  public static final String JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME = "federatedOrganizationName";
  @jakarta.annotation.Nonnull
  private String federatedOrganizationName;

  public static final String JSON_PROPERTY_USER = "user";
  @jakarta.annotation.Nonnull
  private AuthenticatedUserSupplierDetails user;

  public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
  @jakarta.annotation.Nonnull
  private String ipAddress;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  @jakarta.annotation.Nonnull
  private String traceId;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  @jakarta.annotation.Nonnull
  private String sourceUrl;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  @jakarta.annotation.Nonnull
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  @jakarta.annotation.Nonnull
  private String supplierName;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
  @jakarta.annotation.Nonnull
  private QuoteLightweightSupplierDetails displayPriceQuote;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
  @jakarta.annotation.Nonnull
  private QuoteLightweightSupplierDetails supplierPriceQuote;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
  @jakarta.annotation.Nonnull
  private QuoteLightweightSupplierDetails internalPriceQuote;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
  @jakarta.annotation.Nonnull
  private QuoteLightweightSupplierDetails capturePriceQuote;

  public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
  @jakarta.annotation.Nonnull
  private List<@Valid BookingContractItemSupplierDetails> itemList = new ArrayList<>();

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  @jakarta.annotation.Nullable
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  @jakarta.annotation.Nullable
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_PAYMENT = "payment";
  @jakarta.annotation.Nonnull
  private BookingContractPaymentDetailsSupplierDetails payment;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  @jakarta.annotation.Nonnull
  private Boolean cancelled = false;

  public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
  @jakarta.annotation.Nullable
  private java.time.LocalDateTime cancelledOn;

  /**
   * Type of entity that cancelled the booking.
   */
  public enum CancellerEnum {
    SALES_CHANNEL(String.valueOf("SALES_CHANNEL")),
    
    SUPPLIER(String.valueOf("SUPPLIER")),
    
    TRAVELER(String.valueOf("TRAVELER")),
    
    ACQUIRER(String.valueOf("ACQUIRER")),
    
    ADMINISTRATOR(String.valueOf("ADMINISTRATOR"));

    private String value;

    CancellerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellerEnum fromValue(String value) {
      for (CancellerEnum b : CancellerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLER = "canceller";
  @jakarta.annotation.Nullable
  private CancellerEnum canceller;

  /**
   * Reason type.
   */
  public enum CancellationTypeEnum {
    DUPLICATE(String.valueOf("DUPLICATE")),
    
    CANCELLATION(String.valueOf("CANCELLATION")),
    
    NO_SHOW(String.valueOf("NO_SHOW")),
    
    CC_INVALID(String.valueOf("CC_INVALID")),
    
    CC_INSUFFICIENT(String.valueOf("CC_INSUFFICIENT")),
    
    DISCRETIONARY(String.valueOf("DISCRETIONARY"));

    private String value;

    CancellationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellationTypeEnum fromValue(String value) {
      for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
  @jakarta.annotation.Nullable
  private CancellationTypeEnum cancellationType;

  public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
  @jakarta.annotation.Nullable
  private String cancellerUserIdentifier;

  public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
  @jakarta.annotation.Nullable
  private String cancelReason;

  public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
  @jakarta.annotation.Nullable
  private Boolean fundsProcessed;

  public static final String JSON_PROPERTY_REFUNDS = "refunds";
  @jakarta.annotation.Nullable
  private List<@Valid RefundSupplierDetails> refunds = new ArrayList<>();

  public static final String JSON_PROPERTY_PAYOUTS = "payouts";
  @jakarta.annotation.Nullable
  private List<@Valid PayoutSupplierDetails> payouts = new ArrayList<>();

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  @jakarta.annotation.Nonnull
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  @jakarta.annotation.Nonnull
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  @jakarta.annotation.Nonnull
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  @jakarta.annotation.Nonnull
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  @jakarta.annotation.Nonnull
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  @jakarta.annotation.Nonnull
  private BigDecimal captureAmount;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal sourceAmountRefundModifier;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal displayAmountRefundModifier;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal supplierAmountRefundModifier;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal internalAmountRefundModifier;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
  @jakarta.annotation.Nullable
  private BigDecimal captureAmountRefundModifier;

  public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netSourceAmount;

  public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netDisplayAmount;

  public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netSupplierAmount;

  public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netInternalAmount;

  public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
  @jakarta.annotation.Nullable
  private BigDecimal netCaptureAmount;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  @jakarta.annotation.Nullable
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "netCommissionableTotalSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "netCommissionableTotalCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "netCommissionableTotalDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "netCommissionableTotalSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "netCommissionableTotalInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netCommissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "netTotalFeesAndCommissionsSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "netTotalFeesAndCommissionsCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "netTotalFeesAndCommissionsDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "netTotalFeesAndCommissionsSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "netTotalFeesAndCommissionsInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT = "netTotalFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT = "netTotalFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT = "netTotalFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT = "netTotalFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT = "netTotalFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalFeesInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "netTotalTripPayFeeSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "netTotalTripPayFeeCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "netTotalTripPayFeeDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "netTotalTripPayFeeSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "netTotalTripPayFeeInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalTripPayFeeInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT = "netTotalSalesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT = "netTotalSalesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT = "netTotalSalesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT = "netTotalSalesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT = "netTotalSalesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSalesInternalAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount commissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "totalFeesAndCommissionsSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "totalFeesAndCommissionsCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "totalFeesAndCommissionsDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "totalFeesAndCommissionsSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "totalFeesAndCommissionsInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesAndCommissionsInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT = "totalFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT = "totalFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT = "totalFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT = "totalFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT = "totalFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalFeesInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "totalTripPayFeeSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "totalTripPayFeeCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "totalTripPayFeeDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "totalTripPayFeeSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "totalTripPayFeeInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalTripPayFeeInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT = "totalSalesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT = "totalSalesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT = "totalSalesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT = "totalSalesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT = "totalSalesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSalesInternalAmount;

  public static final String JSON_PROPERTY_FUNDS_AVAILABLE_DATE = "fundsAvailableDate";
  @jakarta.annotation.Nullable
  private LocalDate fundsAvailableDate;

  public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND = "totalFeesInPercentWithRefund";
  @jakarta.annotation.Nullable
  private Float totalFeesInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT = "totalFeesInPercent";
  @jakarta.annotation.Nullable
  private Float totalFeesInPercent;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND = "totalTripPayFeeInPercentWithRefund";
  @jakarta.annotation.Nullable
  private Float totalTripPayFeeInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT = "totalTripPayFeeInPercent";
  @jakarta.annotation.Nullable
  private Float totalTripPayFeeInPercent;

  public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalCommissionsInPercentWithRefund";
  @jakarta.annotation.Nullable
  private Float totalCommissionsInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT = "totalCommissionsInPercent";
  @jakarta.annotation.Nullable
  private Float totalCommissionsInPercent;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalFeesAndCommissionsInPercentWithRefund";
  @jakarta.annotation.Nullable
  private Float totalFeesAndCommissionsInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT = "totalFeesAndCommissionsInPercent";
  @jakarta.annotation.Nullable
  private Float totalFeesAndCommissionsInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT = "originalFeesInPercent";
  @jakarta.annotation.Nullable
  private BigDecimal originalFeesInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_AFFILIATE_AGENCY_FEES_IN_PERCENT = "originalAffiliateAgencyFeesInPercent";
  @jakarta.annotation.Nullable
  private BigDecimal originalAffiliateAgencyFeesInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_SUPPLIER_AGENCY_FEES_IN_PERCENT = "originalSupplierAgencyFeesInPercent";
  @jakarta.annotation.Nullable
  private BigDecimal originalSupplierAgencyFeesInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT = "originalCommissionsInPercent";
  @jakarta.annotation.Nullable
  private BigDecimal originalCommissionsInPercent;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT = "netTotalCustomersSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT = "netTotalCustomersCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT = "netTotalCustomersDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT = "netTotalCustomersSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT = "netTotalCustomersInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalCustomersInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT = "totalAffiliateAgencyFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT = "totalAffiliateAgencyFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT = "totalAffiliateAgencyFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT = "totalAffiliateAgencyFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT = "totalAffiliateAgencyFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalAffiliateAgencyFeesInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT = "totalSupplierAgencyFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT = "totalSupplierAgencyFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT = "totalSupplierAgencyFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT = "totalSupplierAgencyFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT = "totalSupplierAgencyFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount totalSupplierAgencyFeesInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT = "netTotalAffiliateAgencyFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT = "netTotalAffiliateAgencyFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT = "netTotalAffiliateAgencyFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT = "netTotalAffiliateAgencyFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT = "netTotalAffiliateAgencyFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalAffiliateAgencyFeesInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT = "netTotalSupplierAgencyFeesSourceAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT = "netTotalSupplierAgencyFeesCaptureAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT = "netTotalSupplierAgencyFeesDisplayAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT = "netTotalSupplierAgencyFeesSupplierAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT = "netTotalSupplierAgencyFeesInternalAmount";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount netTotalSupplierAgencyFeesInternalAmount;

  public static final String JSON_PROPERTY_HAS_REFUNDS = "hasRefunds";
  @jakarta.annotation.Nullable
  private Boolean hasRefunds;

  public static final String JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS = "hasSuccessfulRefunds";
  @jakarta.annotation.Nullable
  private Boolean hasSuccessfulRefunds;

  public static final String JSON_PROPERTY_HAS_PENDING_REFUNDS = "hasPendingRefunds";
  @jakarta.annotation.Nullable
  private Boolean hasPendingRefunds;

  public static final String JSON_PROPERTY_HAS_FAILED_REFUNDS = "hasFailedRefunds";
  @jakarta.annotation.Nullable
  private Boolean hasFailedRefunds;

  public static final String JSON_PROPERTY_PLATFORM_IDENTIFIER = "platformIdentifier";
  @jakarta.annotation.Nullable
  private String platformIdentifier;

  public static final String JSON_PROPERTY_TOTAL_FUNDS_GROUPED_BY_BENEFICIARY = "totalFundsGroupedByBeneficiary";
  @jakarta.annotation.Nullable
  private List<@Valid BeneficiarySupplierDetails> totalFundsGroupedByBeneficiary = new ArrayList<>();

  public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
  @jakarta.annotation.Nullable
  private Long totalTokensEarned;

  public static final String JSON_PROPERTY_SELF_ACQUIRING = "selfAcquiring";
  @jakarta.annotation.Nullable
  private Boolean selfAcquiring;

  public static final String JSON_PROPERTY_LODGING = "lodging";
  @jakarta.annotation.Nullable
  private BookingContractItemSupplierDetails lodging;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_AGENT = "cancellableByAgent";
  @jakarta.annotation.Nullable
  private Boolean cancellableByAgent;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  @jakarta.annotation.Nullable
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  @jakarta.annotation.Nullable
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_FULLY_REFUNDED = "fullyRefunded";
  @jakarta.annotation.Nullable
  private Boolean fullyRefunded;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  @jakarta.annotation.Nullable
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES = "isCancellableWithPotentialCharges";
  @jakarta.annotation.Nullable
  private Boolean isCancellableWithPotentialCharges;

  public BookingContractSupplierDetails() {
  }

  public BookingContractSupplierDetails bookingContractIdentifier(@jakarta.annotation.Nullable UUID bookingContractIdentifier) {
    
    this.bookingContractIdentifier = bookingContractIdentifier;
    return this;
  }

  /**
   * Document UUID
   * @return bookingContractIdentifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingContractIdentifier() {
    return bookingContractIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingContractIdentifier(@jakarta.annotation.Nullable UUID bookingContractIdentifier) {
    this.bookingContractIdentifier = bookingContractIdentifier;
  }

  public BookingContractSupplierDetails createdDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Datetime this record was first created
   * @return createdDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(@jakarta.annotation.Nullable java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public BookingContractSupplierDetails lastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

  /**
   * Datetime this record was last updated
   * @return lastUpdate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(@jakarta.annotation.Nullable java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }

  public BookingContractSupplierDetails federatedOrganizationIdentifier(@jakarta.annotation.Nonnull String federatedOrganizationIdentifier) {
    
    this.federatedOrganizationIdentifier = federatedOrganizationIdentifier;
    return this;
  }

  /**
   * The auth realm owner ID
   * @return federatedOrganizationIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFederatedOrganizationIdentifier() {
    return federatedOrganizationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFederatedOrganizationIdentifier(@jakarta.annotation.Nonnull String federatedOrganizationIdentifier) {
    this.federatedOrganizationIdentifier = federatedOrganizationIdentifier;
  }

  public BookingContractSupplierDetails federatedOrganizationName(@jakarta.annotation.Nonnull String federatedOrganizationName) {
    
    this.federatedOrganizationName = federatedOrganizationName;
    return this;
  }

  /**
   * The auth realm owner name
   * @return federatedOrganizationName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFederatedOrganizationName() {
    return federatedOrganizationName;
  }


  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFederatedOrganizationName(@jakarta.annotation.Nonnull String federatedOrganizationName) {
    this.federatedOrganizationName = federatedOrganizationName;
  }

  public BookingContractSupplierDetails user(@jakarta.annotation.Nonnull AuthenticatedUserSupplierDetails user) {
    
    this.user = user;
    return this;
  }

  /**
   * The authenticated user ID that made the request
   * @return user
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AuthenticatedUserSupplierDetails getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(@jakarta.annotation.Nonnull AuthenticatedUserSupplierDetails user) {
    this.user = user;
  }

  public BookingContractSupplierDetails ipAddress(@jakarta.annotation.Nonnull String ipAddress) {
    
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * Caller&#39;s IP address
   * @return ipAddress
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIpAddress() {
    return ipAddress;
  }


  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIpAddress(@jakarta.annotation.Nonnull String ipAddress) {
    this.ipAddress = ipAddress;
  }

  public BookingContractSupplierDetails traceId(@jakarta.annotation.Nonnull String traceId) {
    
    this.traceId = traceId;
    return this;
  }

  /**
   * Way to track which booking contracts were made together
   * @return traceId
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTraceId(@jakarta.annotation.Nonnull String traceId) {
    this.traceId = traceId;
  }

  public BookingContractSupplierDetails sourceUrl(@jakarta.annotation.Nonnull String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

  /**
   * Where did the booking occur
   * @return sourceUrl
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceUrl(@jakarta.annotation.Nonnull String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }

  public BookingContractSupplierDetails identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique identifier used to track the contract. Create a UUID for this purpose.
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public BookingContractSupplierDetails supplierIdentifier(@jakarta.annotation.Nonnull UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

  /**
   * Supplier identifier
   * @return supplierIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(@jakarta.annotation.Nonnull UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }

  public BookingContractSupplierDetails supplierName(@jakarta.annotation.Nonnull String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

  /**
   * Supplier name
   * @return supplierName
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierName(@jakarta.annotation.Nonnull String supplierName) {
    this.supplierName = supplierName;
  }

  public BookingContractSupplierDetails displayPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightSupplierDetails displayPriceQuote) {
    
    this.displayPriceQuote = displayPriceQuote;
    return this;
  }

  /**
   * The quote used to create totalDisplayPrice.
   * @return displayPriceQuote
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteLightweightSupplierDetails getDisplayPriceQuote() {
    return displayPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightSupplierDetails displayPriceQuote) {
    this.displayPriceQuote = displayPriceQuote;
  }

  public BookingContractSupplierDetails supplierPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightSupplierDetails supplierPriceQuote) {
    
    this.supplierPriceQuote = supplierPriceQuote;
    return this;
  }

  /**
   * The quote used to create totalSupplierPrice.
   * @return supplierPriceQuote
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteLightweightSupplierDetails getSupplierPriceQuote() {
    return supplierPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightSupplierDetails supplierPriceQuote) {
    this.supplierPriceQuote = supplierPriceQuote;
  }

  public BookingContractSupplierDetails internalPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightSupplierDetails internalPriceQuote) {
    
    this.internalPriceQuote = internalPriceQuote;
    return this;
  }

  /**
   * The quote used to create totalInternalPrice.
   * @return internalPriceQuote
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteLightweightSupplierDetails getInternalPriceQuote() {
    return internalPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalPriceQuote(@jakarta.annotation.Nonnull QuoteLightweightSupplierDetails internalPriceQuote) {
    this.internalPriceQuote = internalPriceQuote;
  }

  public BookingContractSupplierDetails capturePriceQuote(@jakarta.annotation.Nonnull QuoteLightweightSupplierDetails capturePriceQuote) {
    
    this.capturePriceQuote = capturePriceQuote;
    return this;
  }

  /**
   * The quote used to create totalCapturePrice.
   * @return capturePriceQuote
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteLightweightSupplierDetails getCapturePriceQuote() {
    return capturePriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCapturePriceQuote(@jakarta.annotation.Nonnull QuoteLightweightSupplierDetails capturePriceQuote) {
    this.capturePriceQuote = capturePriceQuote;
  }

  public BookingContractSupplierDetails itemList(@jakarta.annotation.Nonnull List<@Valid BookingContractItemSupplierDetails> itemList) {
    
    this.itemList = itemList;
    return this;
  }

  public BookingContractSupplierDetails addItemListItem(BookingContractItemSupplierDetails itemListItem) {
    if (this.itemList == null) {
      this.itemList = new ArrayList<>();
    }
    this.itemList.add(itemListItem);
    return this;
  }

  /**
   * Holds one booking line item for a specific supplier.
   * @return itemList
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<@Valid BookingContractItemSupplierDetails> getItemList() {
    return itemList;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItemList(@jakarta.annotation.Nonnull List<@Valid BookingContractItemSupplierDetails> itemList) {
    this.itemList = itemList;
  }

  public BookingContractSupplierDetails externalSupplierIdentifier(@jakarta.annotation.Nullable String externalSupplierIdentifier) {
    
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    return this;
  }

  /**
   * Contract creator can choose to geoname this record with her own identifier
   * @return externalSupplierIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierIdentifier(@jakarta.annotation.Nullable String externalSupplierIdentifier) {
    this.externalSupplierIdentifier = externalSupplierIdentifier;
  }

  public BookingContractSupplierDetails externalSupplierBookingCode(@jakarta.annotation.Nullable String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

  /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(@jakarta.annotation.Nullable String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }

  public BookingContractSupplierDetails payment(@jakarta.annotation.Nonnull BookingContractPaymentDetailsSupplierDetails payment) {
    
    this.payment = payment;
    return this;
  }

  /**
   * Payment details the merchant provided us at the time of payment.
   * @return payment
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BookingContractPaymentDetailsSupplierDetails getPayment() {
    return payment;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPayment(@jakarta.annotation.Nonnull BookingContractPaymentDetailsSupplierDetails payment) {
    this.payment = payment;
  }

  public BookingContractSupplierDetails cancelled(@jakarta.annotation.Nonnull Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

  /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelled(@jakarta.annotation.Nonnull Boolean cancelled) {
    this.cancelled = cancelled;
  }

  public BookingContractSupplierDetails cancelledOn(@jakarta.annotation.Nullable java.time.LocalDateTime cancelledOn) {
    
    this.cancelledOn = cancelledOn;
    return this;
  }

  /**
   * When the booking was cancelled.
   * @return cancelledOn
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCancelledOn() {
    return cancelledOn;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledOn(@jakarta.annotation.Nullable java.time.LocalDateTime cancelledOn) {
    this.cancelledOn = cancelledOn;
  }

  public BookingContractSupplierDetails canceller(@jakarta.annotation.Nullable CancellerEnum canceller) {
    
    this.canceller = canceller;
    return this;
  }

  /**
   * Type of entity that cancelled the booking.
   * @return canceller
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellerEnum getCanceller() {
    return canceller;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanceller(@jakarta.annotation.Nullable CancellerEnum canceller) {
    this.canceller = canceller;
  }

  public BookingContractSupplierDetails cancellationType(@jakarta.annotation.Nullable CancellationTypeEnum cancellationType) {
    
    this.cancellationType = cancellationType;
    return this;
  }

  /**
   * Reason type.
   * @return cancellationType
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationTypeEnum getCancellationType() {
    return cancellationType;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationType(@jakarta.annotation.Nullable CancellationTypeEnum cancellationType) {
    this.cancellationType = cancellationType;
  }

  public BookingContractSupplierDetails cancellerUserIdentifier(@jakarta.annotation.Nullable String cancellerUserIdentifier) {
    
    this.cancellerUserIdentifier = cancellerUserIdentifier;
    return this;
  }

  /**
   * User identifier that cancelled the entity.
   * @return cancellerUserIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellerUserIdentifier() {
    return cancellerUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellerUserIdentifier(@jakarta.annotation.Nullable String cancellerUserIdentifier) {
    this.cancellerUserIdentifier = cancellerUserIdentifier;
  }

  public BookingContractSupplierDetails cancelReason(@jakarta.annotation.Nullable String cancelReason) {
    
    this.cancelReason = cancelReason;
    return this;
  }

  /**
   * Reason for cancellation.
   * @return cancelReason
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancelReason() {
    return cancelReason;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelReason(@jakarta.annotation.Nullable String cancelReason) {
    this.cancelReason = cancelReason;
  }

  public BookingContractSupplierDetails fundsProcessed(@jakarta.annotation.Nullable Boolean fundsProcessed) {
    
    this.fundsProcessed = fundsProcessed;
    return this;
  }

  /**
   * Whether a funds transfer request has been created for this booking.
   * @return fundsProcessed
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFundsProcessed() {
    return fundsProcessed;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsProcessed(@jakarta.annotation.Nullable Boolean fundsProcessed) {
    this.fundsProcessed = fundsProcessed;
  }

  public BookingContractSupplierDetails refunds(@jakarta.annotation.Nullable List<@Valid RefundSupplierDetails> refunds) {
    
    this.refunds = refunds;
    return this;
  }

  public BookingContractSupplierDetails addRefundsItem(RefundSupplierDetails refundsItem) {
    if (this.refunds == null) {
      this.refunds = new ArrayList<>();
    }
    this.refunds.add(refundsItem);
    return this;
  }

  /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return refunds
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid RefundSupplierDetails> getRefunds() {
    return refunds;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefunds(@jakarta.annotation.Nullable List<@Valid RefundSupplierDetails> refunds) {
    this.refunds = refunds;
  }

  public BookingContractSupplierDetails payouts(@jakarta.annotation.Nullable List<@Valid PayoutSupplierDetails> payouts) {
    
    this.payouts = payouts;
    return this;
  }

  public BookingContractSupplierDetails addPayoutsItem(PayoutSupplierDetails payoutsItem) {
    if (this.payouts == null) {
      this.payouts = new ArrayList<>();
    }
    this.payouts.add(payoutsItem);
    return this;
  }

  /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return payouts
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYOUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid PayoutSupplierDetails> getPayouts() {
    return payouts;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayouts(@jakarta.annotation.Nullable List<@Valid PayoutSupplierDetails> payouts) {
    this.payouts = payouts;
  }

  public BookingContractSupplierDetails sourceCurrency(@jakarta.annotation.Nonnull String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

  /**
   * The source currency
   * @return sourceCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceCurrency(@jakarta.annotation.Nonnull String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }

  public BookingContractSupplierDetails displayCurrency(@jakarta.annotation.Nonnull String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

  /**
   * The display currency
   * @return displayCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayCurrency(@jakarta.annotation.Nonnull String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }

  public BookingContractSupplierDetails supplierCurrency(@jakarta.annotation.Nonnull String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

  /**
   * The supplier currency
   * @return supplierCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierCurrency(@jakarta.annotation.Nonnull String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }

  public BookingContractSupplierDetails internalCurrency(@jakarta.annotation.Nonnull String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

  /**
   * The internal currency
   * @return internalCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalCurrency(@jakarta.annotation.Nonnull String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }

  public BookingContractSupplierDetails captureCurrency(@jakarta.annotation.Nonnull String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

  /**
   * The capture currency
   * @return captureCurrency
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureCurrency(@jakarta.annotation.Nonnull String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }

  public BookingContractSupplierDetails sourceAmount(@jakarta.annotation.Nonnull BigDecimal sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

  /**
   * The total initial price as quoted in the original TripPay contract.
   * minimum: 0
   * @return sourceAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceAmount(@jakarta.annotation.Nonnull BigDecimal sourceAmount) {
    this.sourceAmount = sourceAmount;
  }

  public BookingContractSupplierDetails displayAmount(@jakarta.annotation.Nonnull BigDecimal displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

  /**
   * The total display price.
   * minimum: 0
   * @return displayAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayAmount(@jakarta.annotation.Nonnull BigDecimal displayAmount) {
    this.displayAmount = displayAmount;
  }

  public BookingContractSupplierDetails supplierAmount(@jakarta.annotation.Nonnull BigDecimal supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

  /**
   * The total supplier price.
   * minimum: 0
   * @return supplierAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierAmount(@jakarta.annotation.Nonnull BigDecimal supplierAmount) {
    this.supplierAmount = supplierAmount;
  }

  public BookingContractSupplierDetails internalAmount(@jakarta.annotation.Nonnull BigDecimal internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

  /**
   * Get internalAmount
   * minimum: 0
   * @return internalAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalAmount(@jakarta.annotation.Nonnull BigDecimal internalAmount) {
    this.internalAmount = internalAmount;
  }

  public BookingContractSupplierDetails captureAmount(@jakarta.annotation.Nonnull BigDecimal captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

  /**
   * The total capture price.
   * minimum: 0
   * @return captureAmount
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @DecimalMin("0")
  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCaptureAmount(@jakarta.annotation.Nonnull BigDecimal captureAmount) {
    this.captureAmount = captureAmount;
  }

  public BookingContractSupplierDetails sourceAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal sourceAmountRefundModifier) {
    
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    return this;
  }

  /**
   * The source amount still due after a partial refund occurs.
   * @return sourceAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceAmountRefundModifier() {
    return sourceAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal sourceAmountRefundModifier) {
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
  }

  public BookingContractSupplierDetails displayAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal displayAmountRefundModifier) {
    
    this.displayAmountRefundModifier = displayAmountRefundModifier;
    return this;
  }

  /**
   * The display amount still due after a partial refund occurs.
   * @return displayAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDisplayAmountRefundModifier() {
    return displayAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal displayAmountRefundModifier) {
    this.displayAmountRefundModifier = displayAmountRefundModifier;
  }

  public BookingContractSupplierDetails supplierAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal supplierAmountRefundModifier) {
    
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    return this;
  }

  /**
   * The supplier amount still due after a partial refund occurs.
   * @return supplierAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSupplierAmountRefundModifier() {
    return supplierAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal supplierAmountRefundModifier) {
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
  }

  public BookingContractSupplierDetails internalAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal internalAmountRefundModifier) {
    
    this.internalAmountRefundModifier = internalAmountRefundModifier;
    return this;
  }

  /**
   * The internal amount still due after a partial refund occurs.
   * @return internalAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmountRefundModifier() {
    return internalAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal internalAmountRefundModifier) {
    this.internalAmountRefundModifier = internalAmountRefundModifier;
  }

  public BookingContractSupplierDetails captureAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal captureAmountRefundModifier) {
    
    this.captureAmountRefundModifier = captureAmountRefundModifier;
    return this;
  }

  /**
   * The capture amount still due after a partial refund occurs.
   * @return captureAmountRefundModifier
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getCaptureAmountRefundModifier() {
    return captureAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmountRefundModifier(@jakarta.annotation.Nullable BigDecimal captureAmountRefundModifier) {
    this.captureAmountRefundModifier = captureAmountRefundModifier;
  }

  public BookingContractSupplierDetails netSourceAmount(@jakarta.annotation.Nullable BigDecimal netSourceAmount) {
    
    this.netSourceAmount = netSourceAmount;
    return this;
  }

  /**
   * The total initial price as quoted in the original TripPay contract.
   * @return netSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetSourceAmount() {
    return netSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetSourceAmount(@jakarta.annotation.Nullable BigDecimal netSourceAmount) {
    this.netSourceAmount = netSourceAmount;
  }

  public BookingContractSupplierDetails netDisplayAmount(@jakarta.annotation.Nullable BigDecimal netDisplayAmount) {
    
    this.netDisplayAmount = netDisplayAmount;
    return this;
  }

  /**
   * The total display price.
   * @return netDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetDisplayAmount() {
    return netDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetDisplayAmount(@jakarta.annotation.Nullable BigDecimal netDisplayAmount) {
    this.netDisplayAmount = netDisplayAmount;
  }

  public BookingContractSupplierDetails netSupplierAmount(@jakarta.annotation.Nullable BigDecimal netSupplierAmount) {
    
    this.netSupplierAmount = netSupplierAmount;
    return this;
  }

  /**
   * The total supplier price.
   * @return netSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetSupplierAmount() {
    return netSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetSupplierAmount(@jakarta.annotation.Nullable BigDecimal netSupplierAmount) {
    this.netSupplierAmount = netSupplierAmount;
  }

  public BookingContractSupplierDetails netInternalAmount(@jakarta.annotation.Nullable BigDecimal netInternalAmount) {
    
    this.netInternalAmount = netInternalAmount;
    return this;
  }

  /**
   * Get netInternalAmount
   * @return netInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetInternalAmount() {
    return netInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetInternalAmount(@jakarta.annotation.Nullable BigDecimal netInternalAmount) {
    this.netInternalAmount = netInternalAmount;
  }

  public BookingContractSupplierDetails netCaptureAmount(@jakarta.annotation.Nullable BigDecimal netCaptureAmount) {
    
    this.netCaptureAmount = netCaptureAmount;
    return this;
  }

  /**
   * The total capture price.
   * @return netCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetCaptureAmount() {
    return netCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCaptureAmount(@jakarta.annotation.Nullable BigDecimal netCaptureAmount) {
    this.netCaptureAmount = netCaptureAmount;
  }

  public BookingContractSupplierDetails metadata(@jakarta.annotation.Nullable Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public BookingContractSupplierDetails putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * Place to add more data related to the booking contract.
   * @return metadata
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(@jakarta.annotation.Nullable Map<String, String> metadata) {
    this.metadata = metadata;
  }

  public BookingContractSupplierDetails netCommissionableTotalSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalSourceAmount) {
    
    this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency the affiliate is owed.
   * @return netCommissionableTotalSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalSourceAmount() {
    return netCommissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalSourceAmount) {
    this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
  }

  public BookingContractSupplierDetails netCommissionableTotalCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
    
    this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netCommissionableTotalCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalCaptureAmount() {
    return netCommissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
    this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
  }

  public BookingContractSupplierDetails netCommissionableTotalDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
    
    this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netCommissionableTotalDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalDisplayAmount() {
    return netCommissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
    this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
  }

  public BookingContractSupplierDetails netCommissionableTotalSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
    
    this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netCommissionableTotalSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalSupplierAmount() {
    return netCommissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
    this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
  }

  public BookingContractSupplierDetails netCommissionableTotalInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalInternalAmount) {
    
    this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netCommissionableTotalInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalInternalAmount() {
    return netCommissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netCommissionableTotalInternalAmount) {
    this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
  }

  public BookingContractSupplierDetails netTotalFeesAndCommissionsSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
    
    this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalFeesAndCommissionsSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsSourceAmount() {
    return netTotalFeesAndCommissionsSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
    this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
  }

  public BookingContractSupplierDetails netTotalFeesAndCommissionsCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
    
    this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalFeesAndCommissionsCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsCaptureAmount() {
    return netTotalFeesAndCommissionsCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
    this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
  }

  public BookingContractSupplierDetails netTotalFeesAndCommissionsDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
    
    this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalFeesAndCommissionsDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsDisplayAmount() {
    return netTotalFeesAndCommissionsDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
    this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
  }

  public BookingContractSupplierDetails netTotalFeesAndCommissionsSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
    
    this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalFeesAndCommissionsSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsSupplierAmount() {
    return netTotalFeesAndCommissionsSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
    this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
  }

  public BookingContractSupplierDetails netTotalFeesAndCommissionsInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
    
    this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalFeesAndCommissionsInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsInternalAmount() {
    return netTotalFeesAndCommissionsInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
    this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
  }

  public BookingContractSupplierDetails netTotalFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesSourceAmount) {
    
    this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesSourceAmount() {
    return netTotalFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesSourceAmount) {
    this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
  }

  public BookingContractSupplierDetails netTotalFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesCaptureAmount) {
    
    this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesCaptureAmount() {
    return netTotalFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesCaptureAmount) {
    this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
  }

  public BookingContractSupplierDetails netTotalFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesDisplayAmount) {
    
    this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesDisplayAmount() {
    return netTotalFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesDisplayAmount) {
    this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
  }

  public BookingContractSupplierDetails netTotalFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesSupplierAmount) {
    
    this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesSupplierAmount() {
    return netTotalFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesSupplierAmount) {
    this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
  }

  public BookingContractSupplierDetails netTotalFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesInternalAmount) {
    
    this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesInternalAmount() {
    return netTotalFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalFeesInternalAmount) {
    this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
  }

  public BookingContractSupplierDetails netTotalTripPayFeeSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
    
    this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalTripPayFeeSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeSourceAmount() {
    return netTotalTripPayFeeSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
    this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
  }

  public BookingContractSupplierDetails netTotalTripPayFeeCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
    
    this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalTripPayFeeCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeCaptureAmount() {
    return netTotalTripPayFeeCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
    this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
  }

  public BookingContractSupplierDetails netTotalTripPayFeeDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
    
    this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalTripPayFeeDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeDisplayAmount() {
    return netTotalTripPayFeeDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
    this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
  }

  public BookingContractSupplierDetails netTotalTripPayFeeSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
    
    this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalTripPayFeeSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeSupplierAmount() {
    return netTotalTripPayFeeSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
    this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
  }

  public BookingContractSupplierDetails netTotalTripPayFeeInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
    
    this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalTripPayFeeInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeInternalAmount() {
    return netTotalTripPayFeeInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
    this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
  }

  public BookingContractSupplierDetails netTotalSalesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesSourceAmount) {
    
    this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalSalesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesSourceAmount() {
    return netTotalSalesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesSourceAmount) {
    this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
  }

  public BookingContractSupplierDetails netTotalSalesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesCaptureAmount) {
    
    this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalSalesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesCaptureAmount() {
    return netTotalSalesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesCaptureAmount) {
    this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
  }

  public BookingContractSupplierDetails netTotalSalesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesDisplayAmount) {
    
    this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalSalesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesDisplayAmount() {
    return netTotalSalesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesDisplayAmount) {
    this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
  }

  public BookingContractSupplierDetails netTotalSalesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesSupplierAmount) {
    
    this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalSalesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesSupplierAmount() {
    return netTotalSalesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesSupplierAmount) {
    this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
  }

  public BookingContractSupplierDetails netTotalSalesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesInternalAmount) {
    
    this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalSalesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesInternalAmount() {
    return netTotalSalesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSalesInternalAmount) {
    this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
  }

  public BookingContractSupplierDetails commissionableTotalSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalSourceAmount) {
    
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency the affiliate is owed.
   * @return commissionableTotalSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalSourceAmount() {
    return commissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalSourceAmount) {
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
  }

  public BookingContractSupplierDetails commissionableTotalCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalCaptureAmount) {
    
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return commissionableTotalCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalCaptureAmount() {
    return commissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalCaptureAmount) {
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
  }

  public BookingContractSupplierDetails commissionableTotalDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalDisplayAmount) {
    
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return commissionableTotalDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalDisplayAmount() {
    return commissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalDisplayAmount) {
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
  }

  public BookingContractSupplierDetails commissionableTotalSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalSupplierAmount) {
    
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return commissionableTotalSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalSupplierAmount() {
    return commissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalSupplierAmount) {
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
  }

  public BookingContractSupplierDetails commissionableTotalInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalInternalAmount) {
    
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return commissionableTotalInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalInternalAmount() {
    return commissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount commissionableTotalInternalAmount) {
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
  }

  public BookingContractSupplierDetails totalFeesAndCommissionsSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
    
    this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return totalFeesAndCommissionsSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsSourceAmount() {
    return totalFeesAndCommissionsSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
    this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
  }

  public BookingContractSupplierDetails totalFeesAndCommissionsCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
    
    this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return totalFeesAndCommissionsCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsCaptureAmount() {
    return totalFeesAndCommissionsCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
    this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
  }

  public BookingContractSupplierDetails totalFeesAndCommissionsDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
    
    this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return totalFeesAndCommissionsDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsDisplayAmount() {
    return totalFeesAndCommissionsDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
    this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
  }

  public BookingContractSupplierDetails totalFeesAndCommissionsSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
    
    this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return totalFeesAndCommissionsSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsSupplierAmount() {
    return totalFeesAndCommissionsSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
    this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
  }

  public BookingContractSupplierDetails totalFeesAndCommissionsInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
    
    this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return totalFeesAndCommissionsInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsInternalAmount() {
    return totalFeesAndCommissionsInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
    this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
  }

  public BookingContractSupplierDetails totalFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesSourceAmount) {
    
    this.totalFeesSourceAmount = totalFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return totalFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesSourceAmount() {
    return totalFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesSourceAmount) {
    this.totalFeesSourceAmount = totalFeesSourceAmount;
  }

  public BookingContractSupplierDetails totalFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesCaptureAmount) {
    
    this.totalFeesCaptureAmount = totalFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return totalFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesCaptureAmount() {
    return totalFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesCaptureAmount) {
    this.totalFeesCaptureAmount = totalFeesCaptureAmount;
  }

  public BookingContractSupplierDetails totalFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesDisplayAmount) {
    
    this.totalFeesDisplayAmount = totalFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return totalFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesDisplayAmount() {
    return totalFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesDisplayAmount) {
    this.totalFeesDisplayAmount = totalFeesDisplayAmount;
  }

  public BookingContractSupplierDetails totalFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesSupplierAmount) {
    
    this.totalFeesSupplierAmount = totalFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return totalFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesSupplierAmount() {
    return totalFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesSupplierAmount) {
    this.totalFeesSupplierAmount = totalFeesSupplierAmount;
  }

  public BookingContractSupplierDetails totalFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesInternalAmount) {
    
    this.totalFeesInternalAmount = totalFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return totalFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesInternalAmount() {
    return totalFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalFeesInternalAmount) {
    this.totalFeesInternalAmount = totalFeesInternalAmount;
  }

  public BookingContractSupplierDetails totalTripPayFeeSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeSourceAmount) {
    
    this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return totalTripPayFeeSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeSourceAmount() {
    return totalTripPayFeeSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeSourceAmount) {
    this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
  }

  public BookingContractSupplierDetails totalTripPayFeeCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
    
    this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return totalTripPayFeeCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeCaptureAmount() {
    return totalTripPayFeeCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
    this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
  }

  public BookingContractSupplierDetails totalTripPayFeeDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
    
    this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return totalTripPayFeeDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeDisplayAmount() {
    return totalTripPayFeeDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
    this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
  }

  public BookingContractSupplierDetails totalTripPayFeeSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
    
    this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return totalTripPayFeeSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeSupplierAmount() {
    return totalTripPayFeeSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
    this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
  }

  public BookingContractSupplierDetails totalTripPayFeeInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeInternalAmount) {
    
    this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return totalTripPayFeeInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeInternalAmount() {
    return totalTripPayFeeInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalTripPayFeeInternalAmount) {
    this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
  }

  public BookingContractSupplierDetails totalSalesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesSourceAmount) {
    
    this.totalSalesSourceAmount = totalSalesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return totalSalesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesSourceAmount() {
    return totalSalesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesSourceAmount) {
    this.totalSalesSourceAmount = totalSalesSourceAmount;
  }

  public BookingContractSupplierDetails totalSalesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesCaptureAmount) {
    
    this.totalSalesCaptureAmount = totalSalesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return totalSalesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesCaptureAmount() {
    return totalSalesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesCaptureAmount) {
    this.totalSalesCaptureAmount = totalSalesCaptureAmount;
  }

  public BookingContractSupplierDetails totalSalesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesDisplayAmount) {
    
    this.totalSalesDisplayAmount = totalSalesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return totalSalesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesDisplayAmount() {
    return totalSalesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesDisplayAmount) {
    this.totalSalesDisplayAmount = totalSalesDisplayAmount;
  }

  public BookingContractSupplierDetails totalSalesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesSupplierAmount) {
    
    this.totalSalesSupplierAmount = totalSalesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return totalSalesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesSupplierAmount() {
    return totalSalesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesSupplierAmount) {
    this.totalSalesSupplierAmount = totalSalesSupplierAmount;
  }

  public BookingContractSupplierDetails totalSalesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesInternalAmount) {
    
    this.totalSalesInternalAmount = totalSalesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return totalSalesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesInternalAmount() {
    return totalSalesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSalesInternalAmount) {
    this.totalSalesInternalAmount = totalSalesInternalAmount;
  }

  public BookingContractSupplierDetails fundsAvailableDate(@jakarta.annotation.Nullable LocalDate fundsAvailableDate) {
    
    this.fundsAvailableDate = fundsAvailableDate;
    return this;
  }

  /**
   * Returns the date the funds will be released to the customer.
   * @return fundsAvailableDate
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABLE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getFundsAvailableDate() {
    return fundsAvailableDate;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABLE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsAvailableDate(@jakarta.annotation.Nullable LocalDate fundsAvailableDate) {
    this.fundsAvailableDate = fundsAvailableDate;
  }

  public BookingContractSupplierDetails totalFeesInPercentWithRefund(@jakarta.annotation.Nullable Float totalFeesInPercentWithRefund) {
    
    this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
    return this;
  }

  /**
   * All amounts that are not of type SALE
   * @return totalFeesInPercentWithRefund
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesInPercentWithRefund() {
    return totalFeesInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInPercentWithRefund(@jakarta.annotation.Nullable Float totalFeesInPercentWithRefund) {
    this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
  }

  public BookingContractSupplierDetails totalFeesInPercent(@jakarta.annotation.Nullable Float totalFeesInPercent) {
    
    this.totalFeesInPercent = totalFeesInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalFeesInPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesInPercent() {
    return totalFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInPercent(@jakarta.annotation.Nullable Float totalFeesInPercent) {
    this.totalFeesInPercent = totalFeesInPercent;
  }

  public BookingContractSupplierDetails totalTripPayFeeInPercentWithRefund(@jakarta.annotation.Nullable Float totalTripPayFeeInPercentWithRefund) {
    
    this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
    return this;
  }

  /**
   * All amounts that are not of type SALE
   * @return totalTripPayFeeInPercentWithRefund
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalTripPayFeeInPercentWithRefund() {
    return totalTripPayFeeInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInPercentWithRefund(@jakarta.annotation.Nullable Float totalTripPayFeeInPercentWithRefund) {
    this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
  }

  public BookingContractSupplierDetails totalTripPayFeeInPercent(@jakarta.annotation.Nullable Float totalTripPayFeeInPercent) {
    
    this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalTripPayFeeInPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalTripPayFeeInPercent() {
    return totalTripPayFeeInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInPercent(@jakarta.annotation.Nullable Float totalTripPayFeeInPercent) {
    this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
  }

  public BookingContractSupplierDetails totalCommissionsInPercentWithRefund(@jakarta.annotation.Nullable Float totalCommissionsInPercentWithRefund) {
    
    this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
    return this;
  }

  /**
   * All amounts that are not of type SALE
   * @return totalCommissionsInPercentWithRefund
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalCommissionsInPercentWithRefund() {
    return totalCommissionsInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCommissionsInPercentWithRefund(@jakarta.annotation.Nullable Float totalCommissionsInPercentWithRefund) {
    this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
  }

  public BookingContractSupplierDetails totalCommissionsInPercent(@jakarta.annotation.Nullable Float totalCommissionsInPercent) {
    
    this.totalCommissionsInPercent = totalCommissionsInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalCommissionsInPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalCommissionsInPercent() {
    return totalCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCommissionsInPercent(@jakarta.annotation.Nullable Float totalCommissionsInPercent) {
    this.totalCommissionsInPercent = totalCommissionsInPercent;
  }

  public BookingContractSupplierDetails totalFeesAndCommissionsInPercentWithRefund(@jakarta.annotation.Nullable Float totalFeesAndCommissionsInPercentWithRefund) {
    
    this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
    return this;
  }

  /**
   * All amounts that are not of type SALE
   * @return totalFeesAndCommissionsInPercentWithRefund
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesAndCommissionsInPercentWithRefund() {
    return totalFeesAndCommissionsInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInPercentWithRefund(@jakarta.annotation.Nullable Float totalFeesAndCommissionsInPercentWithRefund) {
    this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
  }

  public BookingContractSupplierDetails totalFeesAndCommissionsInPercent(@jakarta.annotation.Nullable Float totalFeesAndCommissionsInPercent) {
    
    this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalFeesAndCommissionsInPercent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesAndCommissionsInPercent() {
    return totalFeesAndCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInPercent(@jakarta.annotation.Nullable Float totalFeesAndCommissionsInPercent) {
    this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
  }

  public BookingContractSupplierDetails originalFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalFeesInPercent) {
    
    this.originalFeesInPercent = originalFeesInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return originalFeesInPercent
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalFeesInPercent() {
    return originalFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalFeesInPercent) {
    this.originalFeesInPercent = originalFeesInPercent;
  }

  public BookingContractSupplierDetails originalAffiliateAgencyFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalAffiliateAgencyFeesInPercent) {
    
    this.originalAffiliateAgencyFeesInPercent = originalAffiliateAgencyFeesInPercent;
    return this;
  }

  /**
   * Affiliate agent fee in percent
   * @return originalAffiliateAgencyFeesInPercent
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_AFFILIATE_AGENCY_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalAffiliateAgencyFeesInPercent() {
    return originalAffiliateAgencyFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_AFFILIATE_AGENCY_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalAffiliateAgencyFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalAffiliateAgencyFeesInPercent) {
    this.originalAffiliateAgencyFeesInPercent = originalAffiliateAgencyFeesInPercent;
  }

  public BookingContractSupplierDetails originalSupplierAgencyFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalSupplierAgencyFeesInPercent) {
    
    this.originalSupplierAgencyFeesInPercent = originalSupplierAgencyFeesInPercent;
    return this;
  }

  /**
   * Supplier agent fee in percent
   * @return originalSupplierAgencyFeesInPercent
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_SUPPLIER_AGENCY_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalSupplierAgencyFeesInPercent() {
    return originalSupplierAgencyFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_SUPPLIER_AGENCY_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalSupplierAgencyFeesInPercent(@jakarta.annotation.Nullable BigDecimal originalSupplierAgencyFeesInPercent) {
    this.originalSupplierAgencyFeesInPercent = originalSupplierAgencyFeesInPercent;
  }

  public BookingContractSupplierDetails originalCommissionsInPercent(@jakarta.annotation.Nullable BigDecimal originalCommissionsInPercent) {
    
    this.originalCommissionsInPercent = originalCommissionsInPercent;
    return this;
  }

  /**
   * All amounts that are not of type SALE before a refund was applied
   * @return originalCommissionsInPercent
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalCommissionsInPercent() {
    return originalCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalCommissionsInPercent(@jakarta.annotation.Nullable BigDecimal originalCommissionsInPercent) {
    this.originalCommissionsInPercent = originalCommissionsInPercent;
  }

  public BookingContractSupplierDetails netTotalCustomersSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersSourceAmount) {
    
    this.netTotalCustomersSourceAmount = netTotalCustomersSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency that is fees and commission.
   * @return netTotalCustomersSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersSourceAmount() {
    return netTotalCustomersSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersSourceAmount) {
    this.netTotalCustomersSourceAmount = netTotalCustomersSourceAmount;
  }

  public BookingContractSupplierDetails netTotalCustomersCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersCaptureAmount) {
    
    this.netTotalCustomersCaptureAmount = netTotalCustomersCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency the affiliate is owed.
   * @return netTotalCustomersCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersCaptureAmount() {
    return netTotalCustomersCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersCaptureAmount) {
    this.netTotalCustomersCaptureAmount = netTotalCustomersCaptureAmount;
  }

  public BookingContractSupplierDetails netTotalCustomersDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersDisplayAmount) {
    
    this.netTotalCustomersDisplayAmount = netTotalCustomersDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency the affiliate is owed.
   * @return netTotalCustomersDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersDisplayAmount() {
    return netTotalCustomersDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersDisplayAmount) {
    this.netTotalCustomersDisplayAmount = netTotalCustomersDisplayAmount;
  }

  public BookingContractSupplierDetails netTotalCustomersSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersSupplierAmount) {
    
    this.netTotalCustomersSupplierAmount = netTotalCustomersSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency the affiliate is owed.
   * @return netTotalCustomersSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersSupplierAmount() {
    return netTotalCustomersSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersSupplierAmount) {
    this.netTotalCustomersSupplierAmount = netTotalCustomersSupplierAmount;
  }

  public BookingContractSupplierDetails netTotalCustomersInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersInternalAmount) {
    
    this.netTotalCustomersInternalAmount = netTotalCustomersInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency the affiliate is owed.
   * @return netTotalCustomersInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersInternalAmount() {
    return netTotalCustomersInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalCustomersInternalAmount) {
    this.netTotalCustomersInternalAmount = netTotalCustomersInternalAmount;
  }

  public BookingContractSupplierDetails totalAffiliateAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesSourceAmount) {
    
    this.totalAffiliateAgencyFeesSourceAmount = totalAffiliateAgencyFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesSourceAmount() {
    return totalAffiliateAgencyFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesSourceAmount) {
    this.totalAffiliateAgencyFeesSourceAmount = totalAffiliateAgencyFeesSourceAmount;
  }

  public BookingContractSupplierDetails totalAffiliateAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesCaptureAmount) {
    
    this.totalAffiliateAgencyFeesCaptureAmount = totalAffiliateAgencyFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesCaptureAmount() {
    return totalAffiliateAgencyFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesCaptureAmount) {
    this.totalAffiliateAgencyFeesCaptureAmount = totalAffiliateAgencyFeesCaptureAmount;
  }

  public BookingContractSupplierDetails totalAffiliateAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesDisplayAmount) {
    
    this.totalAffiliateAgencyFeesDisplayAmount = totalAffiliateAgencyFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesDisplayAmount() {
    return totalAffiliateAgencyFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesDisplayAmount) {
    this.totalAffiliateAgencyFeesDisplayAmount = totalAffiliateAgencyFeesDisplayAmount;
  }

  public BookingContractSupplierDetails totalAffiliateAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesSupplierAmount) {
    
    this.totalAffiliateAgencyFeesSupplierAmount = totalAffiliateAgencyFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesSupplierAmount() {
    return totalAffiliateAgencyFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesSupplierAmount) {
    this.totalAffiliateAgencyFeesSupplierAmount = totalAffiliateAgencyFeesSupplierAmount;
  }

  public BookingContractSupplierDetails totalAffiliateAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesInternalAmount) {
    
    this.totalAffiliateAgencyFeesInternalAmount = totalAffiliateAgencyFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency owed affiliate agency.
   * @return totalAffiliateAgencyFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalAffiliateAgencyFeesInternalAmount() {
    return totalAffiliateAgencyFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAffiliateAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalAffiliateAgencyFeesInternalAmount) {
    this.totalAffiliateAgencyFeesInternalAmount = totalAffiliateAgencyFeesInternalAmount;
  }

  public BookingContractSupplierDetails totalSupplierAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesSourceAmount) {
    
    this.totalSupplierAgencyFeesSourceAmount = totalSupplierAgencyFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency owed supplier agency.
   * @return totalSupplierAgencyFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesSourceAmount() {
    return totalSupplierAgencyFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesSourceAmount) {
    this.totalSupplierAgencyFeesSourceAmount = totalSupplierAgencyFeesSourceAmount;
  }

  public BookingContractSupplierDetails totalSupplierAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesCaptureAmount) {
    
    this.totalSupplierAgencyFeesCaptureAmount = totalSupplierAgencyFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency owed supplier agency.
   * @return totalSupplierAgencyFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesCaptureAmount() {
    return totalSupplierAgencyFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesCaptureAmount) {
    this.totalSupplierAgencyFeesCaptureAmount = totalSupplierAgencyFeesCaptureAmount;
  }

  public BookingContractSupplierDetails totalSupplierAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesDisplayAmount) {
    
    this.totalSupplierAgencyFeesDisplayAmount = totalSupplierAgencyFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency owed supplier agency.
   * @return totalSupplierAgencyFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesDisplayAmount() {
    return totalSupplierAgencyFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesDisplayAmount) {
    this.totalSupplierAgencyFeesDisplayAmount = totalSupplierAgencyFeesDisplayAmount;
  }

  public BookingContractSupplierDetails totalSupplierAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesSupplierAmount) {
    
    this.totalSupplierAgencyFeesSupplierAmount = totalSupplierAgencyFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency owed supplier agency.
   * @return totalSupplierAgencyFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesSupplierAmount() {
    return totalSupplierAgencyFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesSupplierAmount) {
    this.totalSupplierAgencyFeesSupplierAmount = totalSupplierAgencyFeesSupplierAmount;
  }

  public BookingContractSupplierDetails totalSupplierAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesInternalAmount) {
    
    this.totalSupplierAgencyFeesInternalAmount = totalSupplierAgencyFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency owed supplier agency.
   * @return totalSupplierAgencyFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSupplierAgencyFeesInternalAmount() {
    return totalSupplierAgencyFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSupplierAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount totalSupplierAgencyFeesInternalAmount) {
    this.totalSupplierAgencyFeesInternalAmount = totalSupplierAgencyFeesInternalAmount;
  }

  public BookingContractSupplierDetails netTotalAffiliateAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesSourceAmount) {
    
    this.netTotalAffiliateAgencyFeesSourceAmount = netTotalAffiliateAgencyFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesSourceAmount() {
    return netTotalAffiliateAgencyFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesSourceAmount) {
    this.netTotalAffiliateAgencyFeesSourceAmount = netTotalAffiliateAgencyFeesSourceAmount;
  }

  public BookingContractSupplierDetails netTotalAffiliateAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesCaptureAmount) {
    
    this.netTotalAffiliateAgencyFeesCaptureAmount = netTotalAffiliateAgencyFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesCaptureAmount() {
    return netTotalAffiliateAgencyFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesCaptureAmount) {
    this.netTotalAffiliateAgencyFeesCaptureAmount = netTotalAffiliateAgencyFeesCaptureAmount;
  }

  public BookingContractSupplierDetails netTotalAffiliateAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesDisplayAmount) {
    
    this.netTotalAffiliateAgencyFeesDisplayAmount = netTotalAffiliateAgencyFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesDisplayAmount() {
    return netTotalAffiliateAgencyFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesDisplayAmount) {
    this.netTotalAffiliateAgencyFeesDisplayAmount = netTotalAffiliateAgencyFeesDisplayAmount;
  }

  public BookingContractSupplierDetails netTotalAffiliateAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesSupplierAmount) {
    
    this.netTotalAffiliateAgencyFeesSupplierAmount = netTotalAffiliateAgencyFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesSupplierAmount() {
    return netTotalAffiliateAgencyFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesSupplierAmount) {
    this.netTotalAffiliateAgencyFeesSupplierAmount = netTotalAffiliateAgencyFeesSupplierAmount;
  }

  public BookingContractSupplierDetails netTotalAffiliateAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesInternalAmount) {
    
    this.netTotalAffiliateAgencyFeesInternalAmount = netTotalAffiliateAgencyFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency owed affiliate agency.
   * @return netTotalAffiliateAgencyFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalAffiliateAgencyFeesInternalAmount() {
    return netTotalAffiliateAgencyFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_AFFILIATE_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalAffiliateAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalAffiliateAgencyFeesInternalAmount) {
    this.netTotalAffiliateAgencyFeesInternalAmount = netTotalAffiliateAgencyFeesInternalAmount;
  }

  public BookingContractSupplierDetails netTotalSupplierAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesSourceAmount) {
    
    this.netTotalSupplierAgencyFeesSourceAmount = netTotalSupplierAgencyFeesSourceAmount;
    return this;
  }

  /**
   * Returns the total amount in source currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesSourceAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesSourceAmount() {
    return netTotalSupplierAgencyFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesSourceAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesSourceAmount) {
    this.netTotalSupplierAgencyFeesSourceAmount = netTotalSupplierAgencyFeesSourceAmount;
  }

  public BookingContractSupplierDetails netTotalSupplierAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesCaptureAmount) {
    
    this.netTotalSupplierAgencyFeesCaptureAmount = netTotalSupplierAgencyFeesCaptureAmount;
    return this;
  }

  /**
   * Returns the total amount in capture currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesCaptureAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesCaptureAmount() {
    return netTotalSupplierAgencyFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesCaptureAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesCaptureAmount) {
    this.netTotalSupplierAgencyFeesCaptureAmount = netTotalSupplierAgencyFeesCaptureAmount;
  }

  public BookingContractSupplierDetails netTotalSupplierAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesDisplayAmount) {
    
    this.netTotalSupplierAgencyFeesDisplayAmount = netTotalSupplierAgencyFeesDisplayAmount;
    return this;
  }

  /**
   * Returns the total amount in display currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesDisplayAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesDisplayAmount() {
    return netTotalSupplierAgencyFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesDisplayAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesDisplayAmount) {
    this.netTotalSupplierAgencyFeesDisplayAmount = netTotalSupplierAgencyFeesDisplayAmount;
  }

  public BookingContractSupplierDetails netTotalSupplierAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesSupplierAmount) {
    
    this.netTotalSupplierAgencyFeesSupplierAmount = netTotalSupplierAgencyFeesSupplierAmount;
    return this;
  }

  /**
   * Returns the total amount in supplier currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesSupplierAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesSupplierAmount() {
    return netTotalSupplierAgencyFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesSupplierAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesSupplierAmount) {
    this.netTotalSupplierAgencyFeesSupplierAmount = netTotalSupplierAgencyFeesSupplierAmount;
  }

  public BookingContractSupplierDetails netTotalSupplierAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesInternalAmount) {
    
    this.netTotalSupplierAgencyFeesInternalAmount = netTotalSupplierAgencyFeesInternalAmount;
    return this;
  }

  /**
   * Returns the total amount in internal currency owed supplier agency.
   * @return netTotalSupplierAgencyFeesInternalAmount
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSupplierAgencyFeesInternalAmount() {
    return netTotalSupplierAgencyFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SUPPLIER_AGENCY_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSupplierAgencyFeesInternalAmount(@jakarta.annotation.Nullable CustomMonetaryAmount netTotalSupplierAgencyFeesInternalAmount) {
    this.netTotalSupplierAgencyFeesInternalAmount = netTotalSupplierAgencyFeesInternalAmount;
  }

  public BookingContractSupplierDetails hasRefunds(@jakarta.annotation.Nullable Boolean hasRefunds) {
    
    this.hasRefunds = hasRefunds;
    return this;
  }

  /**
   * Indicates whether any refund in any state is present.
   * @return hasRefunds
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRefunds() {
    return hasRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRefunds(@jakarta.annotation.Nullable Boolean hasRefunds) {
    this.hasRefunds = hasRefunds;
  }

  public BookingContractSupplierDetails hasSuccessfulRefunds(@jakarta.annotation.Nullable Boolean hasSuccessfulRefunds) {
    
    this.hasSuccessfulRefunds = hasSuccessfulRefunds;
    return this;
  }

  /**
   * Indicates whether a successful refund is present.
   * @return hasSuccessfulRefunds
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasSuccessfulRefunds() {
    return hasSuccessfulRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasSuccessfulRefunds(@jakarta.annotation.Nullable Boolean hasSuccessfulRefunds) {
    this.hasSuccessfulRefunds = hasSuccessfulRefunds;
  }

  public BookingContractSupplierDetails hasPendingRefunds(@jakarta.annotation.Nullable Boolean hasPendingRefunds) {
    
    this.hasPendingRefunds = hasPendingRefunds;
    return this;
  }

  /**
   * Indicates whether a pending refund is present.
   * @return hasPendingRefunds
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PENDING_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPendingRefunds() {
    return hasPendingRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PENDING_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPendingRefunds(@jakarta.annotation.Nullable Boolean hasPendingRefunds) {
    this.hasPendingRefunds = hasPendingRefunds;
  }

  public BookingContractSupplierDetails hasFailedRefunds(@jakarta.annotation.Nullable Boolean hasFailedRefunds) {
    
    this.hasFailedRefunds = hasFailedRefunds;
    return this;
  }

  /**
   * Indicates whether a failed refund is present.
   * @return hasFailedRefunds
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_FAILED_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFailedRefunds() {
    return hasFailedRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FAILED_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFailedRefunds(@jakarta.annotation.Nullable Boolean hasFailedRefunds) {
    this.hasFailedRefunds = hasFailedRefunds;
  }

  public BookingContractSupplierDetails platformIdentifier(@jakarta.annotation.Nullable String platformIdentifier) {
    
    this.platformIdentifier = platformIdentifier;
    return this;
  }

  /**
   * Returns the account identifier for the beneficiary taking a platform fee
   * @return platformIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PLATFORM_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPlatformIdentifier() {
    return platformIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_PLATFORM_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlatformIdentifier(@jakarta.annotation.Nullable String platformIdentifier) {
    this.platformIdentifier = platformIdentifier;
  }

  public BookingContractSupplierDetails totalFundsGroupedByBeneficiary(@jakarta.annotation.Nullable List<@Valid BeneficiarySupplierDetails> totalFundsGroupedByBeneficiary) {
    
    this.totalFundsGroupedByBeneficiary = totalFundsGroupedByBeneficiary;
    return this;
  }

  public BookingContractSupplierDetails addTotalFundsGroupedByBeneficiaryItem(BeneficiarySupplierDetails totalFundsGroupedByBeneficiaryItem) {
    if (this.totalFundsGroupedByBeneficiary == null) {
      this.totalFundsGroupedByBeneficiary = new ArrayList<>();
    }
    this.totalFundsGroupedByBeneficiary.add(totalFundsGroupedByBeneficiaryItem);
    return this;
  }

  /**
   * Returns all the beneficiaries in this contract with their total amounts
   * @return totalFundsGroupedByBeneficiary
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FUNDS_GROUPED_BY_BENEFICIARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid BeneficiarySupplierDetails> getTotalFundsGroupedByBeneficiary() {
    return totalFundsGroupedByBeneficiary;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FUNDS_GROUPED_BY_BENEFICIARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFundsGroupedByBeneficiary(@jakarta.annotation.Nullable List<@Valid BeneficiarySupplierDetails> totalFundsGroupedByBeneficiary) {
    this.totalFundsGroupedByBeneficiary = totalFundsGroupedByBeneficiary;
  }

  public BookingContractSupplierDetails totalTokensEarned(@jakarta.annotation.Nullable Long totalTokensEarned) {
    
    this.totalTokensEarned = totalTokensEarned;
    return this;
  }

  /**
   * Total amount of tokens minted on this contract.
   * @return totalTokensEarned
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalTokensEarned() {
    return totalTokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTokensEarned(@jakarta.annotation.Nullable Long totalTokensEarned) {
    this.totalTokensEarned = totalTokensEarned;
  }

  public BookingContractSupplierDetails selfAcquiring(@jakarta.annotation.Nullable Boolean selfAcquiring) {
    
    this.selfAcquiring = selfAcquiring;
    return this;
  }

  /**
   * Get selfAcquiring
   * @return selfAcquiring
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELF_ACQUIRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSelfAcquiring() {
    return selfAcquiring;
  }


  @JsonProperty(JSON_PROPERTY_SELF_ACQUIRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelfAcquiring(@jakarta.annotation.Nullable Boolean selfAcquiring) {
    this.selfAcquiring = selfAcquiring;
  }

  public BookingContractSupplierDetails lodging(@jakarta.annotation.Nullable BookingContractItemSupplierDetails lodging) {
    
    this.lodging = lodging;
    return this;
  }

  /**
   * Returns the lodging item only.
   * @return lodging
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractItemSupplierDetails getLodging() {
    return lodging;
  }


  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLodging(@jakarta.annotation.Nullable BookingContractItemSupplierDetails lodging) {
    this.lodging = lodging;
  }

  public BookingContractSupplierDetails cancellableByAgent(@jakarta.annotation.Nullable Boolean cancellableByAgent) {
    
    this.cancellableByAgent = cancellableByAgent;
    return this;
  }

  /**
   * Whether the booking can still be cancelled completely by an agent.
   * @return cancellableByAgent
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByAgent() {
    return cancellableByAgent;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByAgent(@jakarta.annotation.Nullable Boolean cancellableByAgent) {
    this.cancellableByAgent = cancellableByAgent;
  }

  public BookingContractSupplierDetails cancellableBySupplier(@jakarta.annotation.Nullable Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

  /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(@jakarta.annotation.Nullable Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }

  public BookingContractSupplierDetails cancellableByTraveler(@jakarta.annotation.Nullable Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

  /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(@jakarta.annotation.Nullable Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }

  public BookingContractSupplierDetails fullyRefunded(@jakarta.annotation.Nullable Boolean fullyRefunded) {
    
    this.fullyRefunded = fullyRefunded;
    return this;
  }

  /**
   * Get fullyRefunded
   * @return fullyRefunded
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULLY_REFUNDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFullyRefunded() {
    return fullyRefunded;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_REFUNDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyRefunded(@jakarta.annotation.Nullable Boolean fullyRefunded) {
    this.fullyRefunded = fullyRefunded;
  }

  public BookingContractSupplierDetails cancellableWithNoCharges(@jakarta.annotation.Nullable Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

  /**
   * Whether the cancellation comes at no cost to the traveler.
   * @return cancellableWithNoCharges
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(@jakarta.annotation.Nullable Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }

  public BookingContractSupplierDetails isCancellableWithPotentialCharges(@jakarta.annotation.Nullable Boolean isCancellableWithPotentialCharges) {
    
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
    return this;
  }

  /**
   * Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.
   * @return isCancellableWithPotentialCharges
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancellableWithPotentialCharges() {
    return isCancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancellableWithPotentialCharges(@jakarta.annotation.Nullable Boolean isCancellableWithPotentialCharges) {
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractSupplierDetails bookingContractSupplierDetails = (BookingContractSupplierDetails) o;
    return Objects.equals(this.bookingContractIdentifier, bookingContractSupplierDetails.bookingContractIdentifier) &&
        Objects.equals(this.createdDate, bookingContractSupplierDetails.createdDate) &&
        Objects.equals(this.lastUpdate, bookingContractSupplierDetails.lastUpdate) &&
        Objects.equals(this.federatedOrganizationIdentifier, bookingContractSupplierDetails.federatedOrganizationIdentifier) &&
        Objects.equals(this.federatedOrganizationName, bookingContractSupplierDetails.federatedOrganizationName) &&
        Objects.equals(this.user, bookingContractSupplierDetails.user) &&
        Objects.equals(this.ipAddress, bookingContractSupplierDetails.ipAddress) &&
        Objects.equals(this.traceId, bookingContractSupplierDetails.traceId) &&
        Objects.equals(this.sourceUrl, bookingContractSupplierDetails.sourceUrl) &&
        Objects.equals(this.identifier, bookingContractSupplierDetails.identifier) &&
        Objects.equals(this.supplierIdentifier, bookingContractSupplierDetails.supplierIdentifier) &&
        Objects.equals(this.supplierName, bookingContractSupplierDetails.supplierName) &&
        Objects.equals(this.displayPriceQuote, bookingContractSupplierDetails.displayPriceQuote) &&
        Objects.equals(this.supplierPriceQuote, bookingContractSupplierDetails.supplierPriceQuote) &&
        Objects.equals(this.internalPriceQuote, bookingContractSupplierDetails.internalPriceQuote) &&
        Objects.equals(this.capturePriceQuote, bookingContractSupplierDetails.capturePriceQuote) &&
        Objects.equals(this.itemList, bookingContractSupplierDetails.itemList) &&
        Objects.equals(this.externalSupplierIdentifier, bookingContractSupplierDetails.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, bookingContractSupplierDetails.externalSupplierBookingCode) &&
        Objects.equals(this.payment, bookingContractSupplierDetails.payment) &&
        Objects.equals(this.cancelled, bookingContractSupplierDetails.cancelled) &&
        Objects.equals(this.cancelledOn, bookingContractSupplierDetails.cancelledOn) &&
        Objects.equals(this.canceller, bookingContractSupplierDetails.canceller) &&
        Objects.equals(this.cancellationType, bookingContractSupplierDetails.cancellationType) &&
        Objects.equals(this.cancellerUserIdentifier, bookingContractSupplierDetails.cancellerUserIdentifier) &&
        Objects.equals(this.cancelReason, bookingContractSupplierDetails.cancelReason) &&
        Objects.equals(this.fundsProcessed, bookingContractSupplierDetails.fundsProcessed) &&
        Objects.equals(this.refunds, bookingContractSupplierDetails.refunds) &&
        Objects.equals(this.payouts, bookingContractSupplierDetails.payouts) &&
        Objects.equals(this.sourceCurrency, bookingContractSupplierDetails.sourceCurrency) &&
        Objects.equals(this.displayCurrency, bookingContractSupplierDetails.displayCurrency) &&
        Objects.equals(this.supplierCurrency, bookingContractSupplierDetails.supplierCurrency) &&
        Objects.equals(this.internalCurrency, bookingContractSupplierDetails.internalCurrency) &&
        Objects.equals(this.captureCurrency, bookingContractSupplierDetails.captureCurrency) &&
        Objects.equals(this.sourceAmount, bookingContractSupplierDetails.sourceAmount) &&
        Objects.equals(this.displayAmount, bookingContractSupplierDetails.displayAmount) &&
        Objects.equals(this.supplierAmount, bookingContractSupplierDetails.supplierAmount) &&
        Objects.equals(this.internalAmount, bookingContractSupplierDetails.internalAmount) &&
        Objects.equals(this.captureAmount, bookingContractSupplierDetails.captureAmount) &&
        Objects.equals(this.sourceAmountRefundModifier, bookingContractSupplierDetails.sourceAmountRefundModifier) &&
        Objects.equals(this.displayAmountRefundModifier, bookingContractSupplierDetails.displayAmountRefundModifier) &&
        Objects.equals(this.supplierAmountRefundModifier, bookingContractSupplierDetails.supplierAmountRefundModifier) &&
        Objects.equals(this.internalAmountRefundModifier, bookingContractSupplierDetails.internalAmountRefundModifier) &&
        Objects.equals(this.captureAmountRefundModifier, bookingContractSupplierDetails.captureAmountRefundModifier) &&
        Objects.equals(this.netSourceAmount, bookingContractSupplierDetails.netSourceAmount) &&
        Objects.equals(this.netDisplayAmount, bookingContractSupplierDetails.netDisplayAmount) &&
        Objects.equals(this.netSupplierAmount, bookingContractSupplierDetails.netSupplierAmount) &&
        Objects.equals(this.netInternalAmount, bookingContractSupplierDetails.netInternalAmount) &&
        Objects.equals(this.netCaptureAmount, bookingContractSupplierDetails.netCaptureAmount) &&
        Objects.equals(this.metadata, bookingContractSupplierDetails.metadata) &&
        Objects.equals(this.netCommissionableTotalSourceAmount, bookingContractSupplierDetails.netCommissionableTotalSourceAmount) &&
        Objects.equals(this.netCommissionableTotalCaptureAmount, bookingContractSupplierDetails.netCommissionableTotalCaptureAmount) &&
        Objects.equals(this.netCommissionableTotalDisplayAmount, bookingContractSupplierDetails.netCommissionableTotalDisplayAmount) &&
        Objects.equals(this.netCommissionableTotalSupplierAmount, bookingContractSupplierDetails.netCommissionableTotalSupplierAmount) &&
        Objects.equals(this.netCommissionableTotalInternalAmount, bookingContractSupplierDetails.netCommissionableTotalInternalAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsSourceAmount, bookingContractSupplierDetails.netTotalFeesAndCommissionsSourceAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsCaptureAmount, bookingContractSupplierDetails.netTotalFeesAndCommissionsCaptureAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsDisplayAmount, bookingContractSupplierDetails.netTotalFeesAndCommissionsDisplayAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsSupplierAmount, bookingContractSupplierDetails.netTotalFeesAndCommissionsSupplierAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsInternalAmount, bookingContractSupplierDetails.netTotalFeesAndCommissionsInternalAmount) &&
        Objects.equals(this.netTotalFeesSourceAmount, bookingContractSupplierDetails.netTotalFeesSourceAmount) &&
        Objects.equals(this.netTotalFeesCaptureAmount, bookingContractSupplierDetails.netTotalFeesCaptureAmount) &&
        Objects.equals(this.netTotalFeesDisplayAmount, bookingContractSupplierDetails.netTotalFeesDisplayAmount) &&
        Objects.equals(this.netTotalFeesSupplierAmount, bookingContractSupplierDetails.netTotalFeesSupplierAmount) &&
        Objects.equals(this.netTotalFeesInternalAmount, bookingContractSupplierDetails.netTotalFeesInternalAmount) &&
        Objects.equals(this.netTotalTripPayFeeSourceAmount, bookingContractSupplierDetails.netTotalTripPayFeeSourceAmount) &&
        Objects.equals(this.netTotalTripPayFeeCaptureAmount, bookingContractSupplierDetails.netTotalTripPayFeeCaptureAmount) &&
        Objects.equals(this.netTotalTripPayFeeDisplayAmount, bookingContractSupplierDetails.netTotalTripPayFeeDisplayAmount) &&
        Objects.equals(this.netTotalTripPayFeeSupplierAmount, bookingContractSupplierDetails.netTotalTripPayFeeSupplierAmount) &&
        Objects.equals(this.netTotalTripPayFeeInternalAmount, bookingContractSupplierDetails.netTotalTripPayFeeInternalAmount) &&
        Objects.equals(this.netTotalSalesSourceAmount, bookingContractSupplierDetails.netTotalSalesSourceAmount) &&
        Objects.equals(this.netTotalSalesCaptureAmount, bookingContractSupplierDetails.netTotalSalesCaptureAmount) &&
        Objects.equals(this.netTotalSalesDisplayAmount, bookingContractSupplierDetails.netTotalSalesDisplayAmount) &&
        Objects.equals(this.netTotalSalesSupplierAmount, bookingContractSupplierDetails.netTotalSalesSupplierAmount) &&
        Objects.equals(this.netTotalSalesInternalAmount, bookingContractSupplierDetails.netTotalSalesInternalAmount) &&
        Objects.equals(this.commissionableTotalSourceAmount, bookingContractSupplierDetails.commissionableTotalSourceAmount) &&
        Objects.equals(this.commissionableTotalCaptureAmount, bookingContractSupplierDetails.commissionableTotalCaptureAmount) &&
        Objects.equals(this.commissionableTotalDisplayAmount, bookingContractSupplierDetails.commissionableTotalDisplayAmount) &&
        Objects.equals(this.commissionableTotalSupplierAmount, bookingContractSupplierDetails.commissionableTotalSupplierAmount) &&
        Objects.equals(this.commissionableTotalInternalAmount, bookingContractSupplierDetails.commissionableTotalInternalAmount) &&
        Objects.equals(this.totalFeesAndCommissionsSourceAmount, bookingContractSupplierDetails.totalFeesAndCommissionsSourceAmount) &&
        Objects.equals(this.totalFeesAndCommissionsCaptureAmount, bookingContractSupplierDetails.totalFeesAndCommissionsCaptureAmount) &&
        Objects.equals(this.totalFeesAndCommissionsDisplayAmount, bookingContractSupplierDetails.totalFeesAndCommissionsDisplayAmount) &&
        Objects.equals(this.totalFeesAndCommissionsSupplierAmount, bookingContractSupplierDetails.totalFeesAndCommissionsSupplierAmount) &&
        Objects.equals(this.totalFeesAndCommissionsInternalAmount, bookingContractSupplierDetails.totalFeesAndCommissionsInternalAmount) &&
        Objects.equals(this.totalFeesSourceAmount, bookingContractSupplierDetails.totalFeesSourceAmount) &&
        Objects.equals(this.totalFeesCaptureAmount, bookingContractSupplierDetails.totalFeesCaptureAmount) &&
        Objects.equals(this.totalFeesDisplayAmount, bookingContractSupplierDetails.totalFeesDisplayAmount) &&
        Objects.equals(this.totalFeesSupplierAmount, bookingContractSupplierDetails.totalFeesSupplierAmount) &&
        Objects.equals(this.totalFeesInternalAmount, bookingContractSupplierDetails.totalFeesInternalAmount) &&
        Objects.equals(this.totalTripPayFeeSourceAmount, bookingContractSupplierDetails.totalTripPayFeeSourceAmount) &&
        Objects.equals(this.totalTripPayFeeCaptureAmount, bookingContractSupplierDetails.totalTripPayFeeCaptureAmount) &&
        Objects.equals(this.totalTripPayFeeDisplayAmount, bookingContractSupplierDetails.totalTripPayFeeDisplayAmount) &&
        Objects.equals(this.totalTripPayFeeSupplierAmount, bookingContractSupplierDetails.totalTripPayFeeSupplierAmount) &&
        Objects.equals(this.totalTripPayFeeInternalAmount, bookingContractSupplierDetails.totalTripPayFeeInternalAmount) &&
        Objects.equals(this.totalSalesSourceAmount, bookingContractSupplierDetails.totalSalesSourceAmount) &&
        Objects.equals(this.totalSalesCaptureAmount, bookingContractSupplierDetails.totalSalesCaptureAmount) &&
        Objects.equals(this.totalSalesDisplayAmount, bookingContractSupplierDetails.totalSalesDisplayAmount) &&
        Objects.equals(this.totalSalesSupplierAmount, bookingContractSupplierDetails.totalSalesSupplierAmount) &&
        Objects.equals(this.totalSalesInternalAmount, bookingContractSupplierDetails.totalSalesInternalAmount) &&
        Objects.equals(this.fundsAvailableDate, bookingContractSupplierDetails.fundsAvailableDate) &&
        Objects.equals(this.totalFeesInPercentWithRefund, bookingContractSupplierDetails.totalFeesInPercentWithRefund) &&
        Objects.equals(this.totalFeesInPercent, bookingContractSupplierDetails.totalFeesInPercent) &&
        Objects.equals(this.totalTripPayFeeInPercentWithRefund, bookingContractSupplierDetails.totalTripPayFeeInPercentWithRefund) &&
        Objects.equals(this.totalTripPayFeeInPercent, bookingContractSupplierDetails.totalTripPayFeeInPercent) &&
        Objects.equals(this.totalCommissionsInPercentWithRefund, bookingContractSupplierDetails.totalCommissionsInPercentWithRefund) &&
        Objects.equals(this.totalCommissionsInPercent, bookingContractSupplierDetails.totalCommissionsInPercent) &&
        Objects.equals(this.totalFeesAndCommissionsInPercentWithRefund, bookingContractSupplierDetails.totalFeesAndCommissionsInPercentWithRefund) &&
        Objects.equals(this.totalFeesAndCommissionsInPercent, bookingContractSupplierDetails.totalFeesAndCommissionsInPercent) &&
        Objects.equals(this.originalFeesInPercent, bookingContractSupplierDetails.originalFeesInPercent) &&
        Objects.equals(this.originalAffiliateAgencyFeesInPercent, bookingContractSupplierDetails.originalAffiliateAgencyFeesInPercent) &&
        Objects.equals(this.originalSupplierAgencyFeesInPercent, bookingContractSupplierDetails.originalSupplierAgencyFeesInPercent) &&
        Objects.equals(this.originalCommissionsInPercent, bookingContractSupplierDetails.originalCommissionsInPercent) &&
        Objects.equals(this.netTotalCustomersSourceAmount, bookingContractSupplierDetails.netTotalCustomersSourceAmount) &&
        Objects.equals(this.netTotalCustomersCaptureAmount, bookingContractSupplierDetails.netTotalCustomersCaptureAmount) &&
        Objects.equals(this.netTotalCustomersDisplayAmount, bookingContractSupplierDetails.netTotalCustomersDisplayAmount) &&
        Objects.equals(this.netTotalCustomersSupplierAmount, bookingContractSupplierDetails.netTotalCustomersSupplierAmount) &&
        Objects.equals(this.netTotalCustomersInternalAmount, bookingContractSupplierDetails.netTotalCustomersInternalAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesSourceAmount, bookingContractSupplierDetails.totalAffiliateAgencyFeesSourceAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesCaptureAmount, bookingContractSupplierDetails.totalAffiliateAgencyFeesCaptureAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesDisplayAmount, bookingContractSupplierDetails.totalAffiliateAgencyFeesDisplayAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesSupplierAmount, bookingContractSupplierDetails.totalAffiliateAgencyFeesSupplierAmount) &&
        Objects.equals(this.totalAffiliateAgencyFeesInternalAmount, bookingContractSupplierDetails.totalAffiliateAgencyFeesInternalAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesSourceAmount, bookingContractSupplierDetails.totalSupplierAgencyFeesSourceAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesCaptureAmount, bookingContractSupplierDetails.totalSupplierAgencyFeesCaptureAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesDisplayAmount, bookingContractSupplierDetails.totalSupplierAgencyFeesDisplayAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesSupplierAmount, bookingContractSupplierDetails.totalSupplierAgencyFeesSupplierAmount) &&
        Objects.equals(this.totalSupplierAgencyFeesInternalAmount, bookingContractSupplierDetails.totalSupplierAgencyFeesInternalAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesSourceAmount, bookingContractSupplierDetails.netTotalAffiliateAgencyFeesSourceAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesCaptureAmount, bookingContractSupplierDetails.netTotalAffiliateAgencyFeesCaptureAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesDisplayAmount, bookingContractSupplierDetails.netTotalAffiliateAgencyFeesDisplayAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesSupplierAmount, bookingContractSupplierDetails.netTotalAffiliateAgencyFeesSupplierAmount) &&
        Objects.equals(this.netTotalAffiliateAgencyFeesInternalAmount, bookingContractSupplierDetails.netTotalAffiliateAgencyFeesInternalAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesSourceAmount, bookingContractSupplierDetails.netTotalSupplierAgencyFeesSourceAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesCaptureAmount, bookingContractSupplierDetails.netTotalSupplierAgencyFeesCaptureAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesDisplayAmount, bookingContractSupplierDetails.netTotalSupplierAgencyFeesDisplayAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesSupplierAmount, bookingContractSupplierDetails.netTotalSupplierAgencyFeesSupplierAmount) &&
        Objects.equals(this.netTotalSupplierAgencyFeesInternalAmount, bookingContractSupplierDetails.netTotalSupplierAgencyFeesInternalAmount) &&
        Objects.equals(this.hasRefunds, bookingContractSupplierDetails.hasRefunds) &&
        Objects.equals(this.hasSuccessfulRefunds, bookingContractSupplierDetails.hasSuccessfulRefunds) &&
        Objects.equals(this.hasPendingRefunds, bookingContractSupplierDetails.hasPendingRefunds) &&
        Objects.equals(this.hasFailedRefunds, bookingContractSupplierDetails.hasFailedRefunds) &&
        Objects.equals(this.platformIdentifier, bookingContractSupplierDetails.platformIdentifier) &&
        Objects.equals(this.totalFundsGroupedByBeneficiary, bookingContractSupplierDetails.totalFundsGroupedByBeneficiary) &&
        Objects.equals(this.totalTokensEarned, bookingContractSupplierDetails.totalTokensEarned) &&
        Objects.equals(this.selfAcquiring, bookingContractSupplierDetails.selfAcquiring) &&
        Objects.equals(this.lodging, bookingContractSupplierDetails.lodging) &&
        Objects.equals(this.cancellableByAgent, bookingContractSupplierDetails.cancellableByAgent) &&
        Objects.equals(this.cancellableBySupplier, bookingContractSupplierDetails.cancellableBySupplier) &&
        Objects.equals(this.cancellableByTraveler, bookingContractSupplierDetails.cancellableByTraveler) &&
        Objects.equals(this.fullyRefunded, bookingContractSupplierDetails.fullyRefunded) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractSupplierDetails.cancellableWithNoCharges) &&
        Objects.equals(this.isCancellableWithPotentialCharges, bookingContractSupplierDetails.isCancellableWithPotentialCharges);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookingContractIdentifier, createdDate, lastUpdate, federatedOrganizationIdentifier, federatedOrganizationName, user, ipAddress, traceId, sourceUrl, identifier, supplierIdentifier, supplierName, displayPriceQuote, supplierPriceQuote, internalPriceQuote, capturePriceQuote, itemList, externalSupplierIdentifier, externalSupplierBookingCode, payment, cancelled, cancelledOn, canceller, cancellationType, cancellerUserIdentifier, cancelReason, fundsProcessed, refunds, payouts, sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount, sourceAmountRefundModifier, displayAmountRefundModifier, supplierAmountRefundModifier, internalAmountRefundModifier, captureAmountRefundModifier, netSourceAmount, netDisplayAmount, netSupplierAmount, netInternalAmount, netCaptureAmount, metadata, netCommissionableTotalSourceAmount, netCommissionableTotalCaptureAmount, netCommissionableTotalDisplayAmount, netCommissionableTotalSupplierAmount, netCommissionableTotalInternalAmount, netTotalFeesAndCommissionsSourceAmount, netTotalFeesAndCommissionsCaptureAmount, netTotalFeesAndCommissionsDisplayAmount, netTotalFeesAndCommissionsSupplierAmount, netTotalFeesAndCommissionsInternalAmount, netTotalFeesSourceAmount, netTotalFeesCaptureAmount, netTotalFeesDisplayAmount, netTotalFeesSupplierAmount, netTotalFeesInternalAmount, netTotalTripPayFeeSourceAmount, netTotalTripPayFeeCaptureAmount, netTotalTripPayFeeDisplayAmount, netTotalTripPayFeeSupplierAmount, netTotalTripPayFeeInternalAmount, netTotalSalesSourceAmount, netTotalSalesCaptureAmount, netTotalSalesDisplayAmount, netTotalSalesSupplierAmount, netTotalSalesInternalAmount, commissionableTotalSourceAmount, commissionableTotalCaptureAmount, commissionableTotalDisplayAmount, commissionableTotalSupplierAmount, commissionableTotalInternalAmount, totalFeesAndCommissionsSourceAmount, totalFeesAndCommissionsCaptureAmount, totalFeesAndCommissionsDisplayAmount, totalFeesAndCommissionsSupplierAmount, totalFeesAndCommissionsInternalAmount, totalFeesSourceAmount, totalFeesCaptureAmount, totalFeesDisplayAmount, totalFeesSupplierAmount, totalFeesInternalAmount, totalTripPayFeeSourceAmount, totalTripPayFeeCaptureAmount, totalTripPayFeeDisplayAmount, totalTripPayFeeSupplierAmount, totalTripPayFeeInternalAmount, totalSalesSourceAmount, totalSalesCaptureAmount, totalSalesDisplayAmount, totalSalesSupplierAmount, totalSalesInternalAmount, fundsAvailableDate, totalFeesInPercentWithRefund, totalFeesInPercent, totalTripPayFeeInPercentWithRefund, totalTripPayFeeInPercent, totalCommissionsInPercentWithRefund, totalCommissionsInPercent, totalFeesAndCommissionsInPercentWithRefund, totalFeesAndCommissionsInPercent, originalFeesInPercent, originalAffiliateAgencyFeesInPercent, originalSupplierAgencyFeesInPercent, originalCommissionsInPercent, netTotalCustomersSourceAmount, netTotalCustomersCaptureAmount, netTotalCustomersDisplayAmount, netTotalCustomersSupplierAmount, netTotalCustomersInternalAmount, totalAffiliateAgencyFeesSourceAmount, totalAffiliateAgencyFeesCaptureAmount, totalAffiliateAgencyFeesDisplayAmount, totalAffiliateAgencyFeesSupplierAmount, totalAffiliateAgencyFeesInternalAmount, totalSupplierAgencyFeesSourceAmount, totalSupplierAgencyFeesCaptureAmount, totalSupplierAgencyFeesDisplayAmount, totalSupplierAgencyFeesSupplierAmount, totalSupplierAgencyFeesInternalAmount, netTotalAffiliateAgencyFeesSourceAmount, netTotalAffiliateAgencyFeesCaptureAmount, netTotalAffiliateAgencyFeesDisplayAmount, netTotalAffiliateAgencyFeesSupplierAmount, netTotalAffiliateAgencyFeesInternalAmount, netTotalSupplierAgencyFeesSourceAmount, netTotalSupplierAgencyFeesCaptureAmount, netTotalSupplierAgencyFeesDisplayAmount, netTotalSupplierAgencyFeesSupplierAmount, netTotalSupplierAgencyFeesInternalAmount, hasRefunds, hasSuccessfulRefunds, hasPendingRefunds, hasFailedRefunds, platformIdentifier, totalFundsGroupedByBeneficiary, totalTokensEarned, selfAcquiring, lodging, cancellableByAgent, cancellableBySupplier, cancellableByTraveler, fullyRefunded, cancellableWithNoCharges, isCancellableWithPotentialCharges);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractSupplierDetails {\n");
    sb.append("    bookingContractIdentifier: ").append(toIndentedString(bookingContractIdentifier)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    federatedOrganizationIdentifier: ").append(toIndentedString(federatedOrganizationIdentifier)).append("\n");
    sb.append("    federatedOrganizationName: ").append(toIndentedString(federatedOrganizationName)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    displayPriceQuote: ").append(toIndentedString(displayPriceQuote)).append("\n");
    sb.append("    supplierPriceQuote: ").append(toIndentedString(supplierPriceQuote)).append("\n");
    sb.append("    internalPriceQuote: ").append(toIndentedString(internalPriceQuote)).append("\n");
    sb.append("    capturePriceQuote: ").append(toIndentedString(capturePriceQuote)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelledOn: ").append(toIndentedString(cancelledOn)).append("\n");
    sb.append("    canceller: ").append(toIndentedString(canceller)).append("\n");
    sb.append("    cancellationType: ").append(toIndentedString(cancellationType)).append("\n");
    sb.append("    cancellerUserIdentifier: ").append(toIndentedString(cancellerUserIdentifier)).append("\n");
    sb.append("    cancelReason: ").append(toIndentedString(cancelReason)).append("\n");
    sb.append("    fundsProcessed: ").append(toIndentedString(fundsProcessed)).append("\n");
    sb.append("    refunds: ").append(toIndentedString(refunds)).append("\n");
    sb.append("    payouts: ").append(toIndentedString(payouts)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("    sourceAmountRefundModifier: ").append(toIndentedString(sourceAmountRefundModifier)).append("\n");
    sb.append("    displayAmountRefundModifier: ").append(toIndentedString(displayAmountRefundModifier)).append("\n");
    sb.append("    supplierAmountRefundModifier: ").append(toIndentedString(supplierAmountRefundModifier)).append("\n");
    sb.append("    internalAmountRefundModifier: ").append(toIndentedString(internalAmountRefundModifier)).append("\n");
    sb.append("    captureAmountRefundModifier: ").append(toIndentedString(captureAmountRefundModifier)).append("\n");
    sb.append("    netSourceAmount: ").append(toIndentedString(netSourceAmount)).append("\n");
    sb.append("    netDisplayAmount: ").append(toIndentedString(netDisplayAmount)).append("\n");
    sb.append("    netSupplierAmount: ").append(toIndentedString(netSupplierAmount)).append("\n");
    sb.append("    netInternalAmount: ").append(toIndentedString(netInternalAmount)).append("\n");
    sb.append("    netCaptureAmount: ").append(toIndentedString(netCaptureAmount)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    netCommissionableTotalSourceAmount: ").append(toIndentedString(netCommissionableTotalSourceAmount)).append("\n");
    sb.append("    netCommissionableTotalCaptureAmount: ").append(toIndentedString(netCommissionableTotalCaptureAmount)).append("\n");
    sb.append("    netCommissionableTotalDisplayAmount: ").append(toIndentedString(netCommissionableTotalDisplayAmount)).append("\n");
    sb.append("    netCommissionableTotalSupplierAmount: ").append(toIndentedString(netCommissionableTotalSupplierAmount)).append("\n");
    sb.append("    netCommissionableTotalInternalAmount: ").append(toIndentedString(netCommissionableTotalInternalAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsSourceAmount: ").append(toIndentedString(netTotalFeesAndCommissionsSourceAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsCaptureAmount: ").append(toIndentedString(netTotalFeesAndCommissionsCaptureAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsDisplayAmount: ").append(toIndentedString(netTotalFeesAndCommissionsDisplayAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsSupplierAmount: ").append(toIndentedString(netTotalFeesAndCommissionsSupplierAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsInternalAmount: ").append(toIndentedString(netTotalFeesAndCommissionsInternalAmount)).append("\n");
    sb.append("    netTotalFeesSourceAmount: ").append(toIndentedString(netTotalFeesSourceAmount)).append("\n");
    sb.append("    netTotalFeesCaptureAmount: ").append(toIndentedString(netTotalFeesCaptureAmount)).append("\n");
    sb.append("    netTotalFeesDisplayAmount: ").append(toIndentedString(netTotalFeesDisplayAmount)).append("\n");
    sb.append("    netTotalFeesSupplierAmount: ").append(toIndentedString(netTotalFeesSupplierAmount)).append("\n");
    sb.append("    netTotalFeesInternalAmount: ").append(toIndentedString(netTotalFeesInternalAmount)).append("\n");
    sb.append("    netTotalTripPayFeeSourceAmount: ").append(toIndentedString(netTotalTripPayFeeSourceAmount)).append("\n");
    sb.append("    netTotalTripPayFeeCaptureAmount: ").append(toIndentedString(netTotalTripPayFeeCaptureAmount)).append("\n");
    sb.append("    netTotalTripPayFeeDisplayAmount: ").append(toIndentedString(netTotalTripPayFeeDisplayAmount)).append("\n");
    sb.append("    netTotalTripPayFeeSupplierAmount: ").append(toIndentedString(netTotalTripPayFeeSupplierAmount)).append("\n");
    sb.append("    netTotalTripPayFeeInternalAmount: ").append(toIndentedString(netTotalTripPayFeeInternalAmount)).append("\n");
    sb.append("    netTotalSalesSourceAmount: ").append(toIndentedString(netTotalSalesSourceAmount)).append("\n");
    sb.append("    netTotalSalesCaptureAmount: ").append(toIndentedString(netTotalSalesCaptureAmount)).append("\n");
    sb.append("    netTotalSalesDisplayAmount: ").append(toIndentedString(netTotalSalesDisplayAmount)).append("\n");
    sb.append("    netTotalSalesSupplierAmount: ").append(toIndentedString(netTotalSalesSupplierAmount)).append("\n");
    sb.append("    netTotalSalesInternalAmount: ").append(toIndentedString(netTotalSalesInternalAmount)).append("\n");
    sb.append("    commissionableTotalSourceAmount: ").append(toIndentedString(commissionableTotalSourceAmount)).append("\n");
    sb.append("    commissionableTotalCaptureAmount: ").append(toIndentedString(commissionableTotalCaptureAmount)).append("\n");
    sb.append("    commissionableTotalDisplayAmount: ").append(toIndentedString(commissionableTotalDisplayAmount)).append("\n");
    sb.append("    commissionableTotalSupplierAmount: ").append(toIndentedString(commissionableTotalSupplierAmount)).append("\n");
    sb.append("    commissionableTotalInternalAmount: ").append(toIndentedString(commissionableTotalInternalAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsSourceAmount: ").append(toIndentedString(totalFeesAndCommissionsSourceAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsCaptureAmount: ").append(toIndentedString(totalFeesAndCommissionsCaptureAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsDisplayAmount: ").append(toIndentedString(totalFeesAndCommissionsDisplayAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsSupplierAmount: ").append(toIndentedString(totalFeesAndCommissionsSupplierAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsInternalAmount: ").append(toIndentedString(totalFeesAndCommissionsInternalAmount)).append("\n");
    sb.append("    totalFeesSourceAmount: ").append(toIndentedString(totalFeesSourceAmount)).append("\n");
    sb.append("    totalFeesCaptureAmount: ").append(toIndentedString(totalFeesCaptureAmount)).append("\n");
    sb.append("    totalFeesDisplayAmount: ").append(toIndentedString(totalFeesDisplayAmount)).append("\n");
    sb.append("    totalFeesSupplierAmount: ").append(toIndentedString(totalFeesSupplierAmount)).append("\n");
    sb.append("    totalFeesInternalAmount: ").append(toIndentedString(totalFeesInternalAmount)).append("\n");
    sb.append("    totalTripPayFeeSourceAmount: ").append(toIndentedString(totalTripPayFeeSourceAmount)).append("\n");
    sb.append("    totalTripPayFeeCaptureAmount: ").append(toIndentedString(totalTripPayFeeCaptureAmount)).append("\n");
    sb.append("    totalTripPayFeeDisplayAmount: ").append(toIndentedString(totalTripPayFeeDisplayAmount)).append("\n");
    sb.append("    totalTripPayFeeSupplierAmount: ").append(toIndentedString(totalTripPayFeeSupplierAmount)).append("\n");
    sb.append("    totalTripPayFeeInternalAmount: ").append(toIndentedString(totalTripPayFeeInternalAmount)).append("\n");
    sb.append("    totalSalesSourceAmount: ").append(toIndentedString(totalSalesSourceAmount)).append("\n");
    sb.append("    totalSalesCaptureAmount: ").append(toIndentedString(totalSalesCaptureAmount)).append("\n");
    sb.append("    totalSalesDisplayAmount: ").append(toIndentedString(totalSalesDisplayAmount)).append("\n");
    sb.append("    totalSalesSupplierAmount: ").append(toIndentedString(totalSalesSupplierAmount)).append("\n");
    sb.append("    totalSalesInternalAmount: ").append(toIndentedString(totalSalesInternalAmount)).append("\n");
    sb.append("    fundsAvailableDate: ").append(toIndentedString(fundsAvailableDate)).append("\n");
    sb.append("    totalFeesInPercentWithRefund: ").append(toIndentedString(totalFeesInPercentWithRefund)).append("\n");
    sb.append("    totalFeesInPercent: ").append(toIndentedString(totalFeesInPercent)).append("\n");
    sb.append("    totalTripPayFeeInPercentWithRefund: ").append(toIndentedString(totalTripPayFeeInPercentWithRefund)).append("\n");
    sb.append("    totalTripPayFeeInPercent: ").append(toIndentedString(totalTripPayFeeInPercent)).append("\n");
    sb.append("    totalCommissionsInPercentWithRefund: ").append(toIndentedString(totalCommissionsInPercentWithRefund)).append("\n");
    sb.append("    totalCommissionsInPercent: ").append(toIndentedString(totalCommissionsInPercent)).append("\n");
    sb.append("    totalFeesAndCommissionsInPercentWithRefund: ").append(toIndentedString(totalFeesAndCommissionsInPercentWithRefund)).append("\n");
    sb.append("    totalFeesAndCommissionsInPercent: ").append(toIndentedString(totalFeesAndCommissionsInPercent)).append("\n");
    sb.append("    originalFeesInPercent: ").append(toIndentedString(originalFeesInPercent)).append("\n");
    sb.append("    originalAffiliateAgencyFeesInPercent: ").append(toIndentedString(originalAffiliateAgencyFeesInPercent)).append("\n");
    sb.append("    originalSupplierAgencyFeesInPercent: ").append(toIndentedString(originalSupplierAgencyFeesInPercent)).append("\n");
    sb.append("    originalCommissionsInPercent: ").append(toIndentedString(originalCommissionsInPercent)).append("\n");
    sb.append("    netTotalCustomersSourceAmount: ").append(toIndentedString(netTotalCustomersSourceAmount)).append("\n");
    sb.append("    netTotalCustomersCaptureAmount: ").append(toIndentedString(netTotalCustomersCaptureAmount)).append("\n");
    sb.append("    netTotalCustomersDisplayAmount: ").append(toIndentedString(netTotalCustomersDisplayAmount)).append("\n");
    sb.append("    netTotalCustomersSupplierAmount: ").append(toIndentedString(netTotalCustomersSupplierAmount)).append("\n");
    sb.append("    netTotalCustomersInternalAmount: ").append(toIndentedString(netTotalCustomersInternalAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesSourceAmount: ").append(toIndentedString(totalAffiliateAgencyFeesSourceAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesCaptureAmount: ").append(toIndentedString(totalAffiliateAgencyFeesCaptureAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesDisplayAmount: ").append(toIndentedString(totalAffiliateAgencyFeesDisplayAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesSupplierAmount: ").append(toIndentedString(totalAffiliateAgencyFeesSupplierAmount)).append("\n");
    sb.append("    totalAffiliateAgencyFeesInternalAmount: ").append(toIndentedString(totalAffiliateAgencyFeesInternalAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesSourceAmount: ").append(toIndentedString(totalSupplierAgencyFeesSourceAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesCaptureAmount: ").append(toIndentedString(totalSupplierAgencyFeesCaptureAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesDisplayAmount: ").append(toIndentedString(totalSupplierAgencyFeesDisplayAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesSupplierAmount: ").append(toIndentedString(totalSupplierAgencyFeesSupplierAmount)).append("\n");
    sb.append("    totalSupplierAgencyFeesInternalAmount: ").append(toIndentedString(totalSupplierAgencyFeesInternalAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesSourceAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesSourceAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesCaptureAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesCaptureAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesDisplayAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesDisplayAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesSupplierAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesSupplierAmount)).append("\n");
    sb.append("    netTotalAffiliateAgencyFeesInternalAmount: ").append(toIndentedString(netTotalAffiliateAgencyFeesInternalAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesSourceAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesSourceAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesCaptureAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesCaptureAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesDisplayAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesDisplayAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesSupplierAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesSupplierAmount)).append("\n");
    sb.append("    netTotalSupplierAgencyFeesInternalAmount: ").append(toIndentedString(netTotalSupplierAgencyFeesInternalAmount)).append("\n");
    sb.append("    hasRefunds: ").append(toIndentedString(hasRefunds)).append("\n");
    sb.append("    hasSuccessfulRefunds: ").append(toIndentedString(hasSuccessfulRefunds)).append("\n");
    sb.append("    hasPendingRefunds: ").append(toIndentedString(hasPendingRefunds)).append("\n");
    sb.append("    hasFailedRefunds: ").append(toIndentedString(hasFailedRefunds)).append("\n");
    sb.append("    platformIdentifier: ").append(toIndentedString(platformIdentifier)).append("\n");
    sb.append("    totalFundsGroupedByBeneficiary: ").append(toIndentedString(totalFundsGroupedByBeneficiary)).append("\n");
    sb.append("    totalTokensEarned: ").append(toIndentedString(totalTokensEarned)).append("\n");
    sb.append("    selfAcquiring: ").append(toIndentedString(selfAcquiring)).append("\n");
    sb.append("    lodging: ").append(toIndentedString(lodging)).append("\n");
    sb.append("    cancellableByAgent: ").append(toIndentedString(cancellableByAgent)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    fullyRefunded: ").append(toIndentedString(fullyRefunded)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    isCancellableWithPotentialCharges: ").append(toIndentedString(isCancellableWithPotentialCharges)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

